/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.apt.immutable.generator;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.util.Arrays;
import javax.lang.model.element.Modifier;
import org.babyfish.jimmer.JimmerVersionsKt;
import org.babyfish.jimmer.apt.immutable.generator.Constants;
import org.babyfish.jimmer.apt.immutable.generator.DraftImplGenerator;
import org.babyfish.jimmer.apt.immutable.generator.ImplGenerator;
import org.babyfish.jimmer.apt.immutable.generator.ImplementorGenerator;
import org.babyfish.jimmer.apt.immutable.meta.ImmutableProp;
import org.babyfish.jimmer.apt.immutable.meta.ImmutableType;
import org.babyfish.jimmer.apt.util.GeneratedAnnotation;
import org.babyfish.jimmer.meta.ImmutablePropCategory;
import org.babyfish.jimmer.runtime.Internal;
import org.babyfish.jimmer.sql.Key;
import org.babyfish.jimmer.sql.ManyToOne;
import org.babyfish.jimmer.sql.OneToOne;

public class ProducerGenerator {
    private final ImmutableType type;
    private TypeSpec.Builder typeBuilder;

    ProducerGenerator(ImmutableType type) {
        this.type = type;
    }

    public void generate(TypeSpec.Builder parentBuilder) {
        this.typeBuilder = TypeSpec.classBuilder((String)"Producer");
        this.typeBuilder.modifiers.add(Modifier.PUBLIC);
        this.typeBuilder.modifiers.add(Modifier.STATIC);
        this.typeBuilder.addAnnotation(GeneratedAnnotation.generatedAnnotation(this.type));
        this.addInstance();
        if (!this.type.isMappedSuperClass()) {
            this.addSlots();
        }
        this.addType();
        this.addConstructor();
        if (!this.type.isMappedSuperClass()) {
            this.addProduce(false);
            this.addProduce(true);
            new ImplementorGenerator(this.type).generate(this.typeBuilder);
            new ImplGenerator(this.type).generate(this.typeBuilder);
            new DraftImplGenerator(this.type).generate(this.typeBuilder);
        }
        parentBuilder.addType(this.typeBuilder.build());
    }

    private void addProduce(Boolean base) {
        ClassName baseType = this.type.getClassName();
        ClassName draftType = this.type.getDraftClassName();
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)"produce");
        builder.modifiers.add(Modifier.PUBLIC);
        if (base.booleanValue()) {
            builder.addParameter((TypeName)baseType, "base", new Modifier[0]);
        }
        builder.addParameter((TypeName)ParameterizedTypeName.get((ClassName)Constants.DRAFT_CONSUMER_CLASS_NAME, (TypeName[])new TypeName[]{draftType}), "block", new Modifier[0]);
        builder.returns((TypeName)baseType);
        if (base.booleanValue()) {
            builder.addCode("return ($T)$T.produce(TYPE, base, block);", new Object[]{baseType, Internal.class});
        } else {
            builder.addCode("return produce(null, block);", new Object[0]);
        }
        this.typeBuilder.addMethod(builder.build());
    }

    private void addInstance() {
        FieldSpec.Builder builder = FieldSpec.builder((TypeName)this.type.getProducerClassName(), (String)"INSTANCE", (Modifier[])new Modifier[]{Modifier.STATIC, Modifier.FINAL});
        builder.initializer("new $T()", new Object[]{this.type.getProducerClassName()});
        this.typeBuilder.addField(builder.build());
    }

    private void addSlots() {
        for (ImmutableProp prop : this.type.getProps().values()) {
            FieldSpec.Builder builder = FieldSpec.builder((TypeName)TypeName.INT, (String)prop.getSlotName(), (Modifier[])new Modifier[]{Modifier.PUBLIC, Modifier.STATIC, Modifier.FINAL});
            if (prop.getDeclaringType() == this.type || prop.getDeclaringType().isMappedSuperClass()) {
                builder.initializer(Integer.toString(prop.getId()), new Object[0]);
            } else {
                builder.initializer("$T.$L", new Object[]{prop.getDeclaringType().getProducerClassName(), prop.getSlotName()});
            }
            this.typeBuilder.addField(builder.build());
        }
    }

    private void addType() {
        CodeBlock.Builder builder = CodeBlock.builder().add("$T\n", new Object[]{Constants.RUNTIME_TYPE_CLASS_NAME}).indent().add(".newBuilder(\n", new Object[0]).indent().add("$S,\n", new Object[]{JimmerVersionsKt.currentVersion()}).add("$T.class,\n", new Object[]{this.type.getClassName()});
        switch (this.type.getSuperTypes().size()) {
            case 0: {
                builder.add("$T.emptyList(),\n", new Object[]{Constants.COLLECTIONS_CLASS_NAME});
                break;
            }
            case 1: {
                builder.add("$T.singleton($T.Producer.TYPE),\n", new Object[]{Constants.COLLECTIONS_CLASS_NAME, this.type.getSuperTypes().iterator().next().getDraftClassName()});
                break;
            }
            default: {
                builder.add("$T.asList(\n$>", new Object[]{Arrays.class});
                boolean addComma = false;
                for (ImmutableType superType : this.type.getSuperTypes()) {
                    if (addComma) {
                        builder.add(",\n", new Object[0]);
                    } else {
                        addComma = true;
                    }
                    builder.add("$T.Producer.TYPE", new Object[]{superType.getDraftClassName()});
                }
                builder.add("\n$<)\n,", new Object[0]);
            }
        }
        if (this.type.isMappedSuperClass()) {
            builder.add("null\n", new Object[0]);
        } else {
            builder.add("(ctx, base) -> new $T(ctx, ($T)base)\n", new Object[]{this.type.getDraftImplClassName(), this.type.getClassName()});
        }
        builder.unindent().add(")\n", new Object[0]);
        if (!this.type.isMappedSuperClass()) {
            for (ImmutableProp prop : this.type.getRedefinedProps().values()) {
                builder.add(".redefine($S, $L)\n", new Object[]{prop.getName(), prop.getSlotName()});
            }
        }
        for (ImmutableProp prop : this.type.getDeclaredProps().values()) {
            String slotName;
            if (this.type.getPrimarySuperType() != null && this.type.getPrimarySuperType().getProps().containsKey(prop.getName())) continue;
            ImmutablePropCategory category = prop.isList() ? (prop.isAssociation(false) ? ImmutablePropCategory.REFERENCE_LIST : ImmutablePropCategory.SCALAR_LIST) : (prop.isAssociation(false) ? ImmutablePropCategory.REFERENCE : ImmutablePropCategory.SCALAR);
            String string = slotName = this.type.isMappedSuperClass() ? "-1" : prop.getSlotName();
            if (prop == this.type.getIdProp()) {
                builder.add(".id($L, $S, $T.class)\n", new Object[]{slotName, prop.getName(), prop.getRawElementTypeName()});
                continue;
            }
            if (prop == this.type.getVersionProp()) {
                builder.add(".version($L, $S)\n", new Object[]{slotName, prop.getName()});
                continue;
            }
            if (prop == this.type.getLogicalDeletedProp()) {
                builder.add(".logicalDeleted($L, $S, $T.class, $L)\n", new Object[]{slotName, prop.getName(), prop.getRawElementTypeName(), prop.isNullable()});
                continue;
            }
            if (prop.getAnnotation(Key.class) != null && !prop.isAssociation(false)) {
                builder.add(".key($L, $S, $T.class, $L)\n", new Object[]{slotName, prop.getName(), prop.getRawElementTypeName(), prop.isNullable()});
                continue;
            }
            if (prop.getAnnotation(Key.class) != null && prop.isAssociation(false)) {
                builder.add(".keyReference($L, $S, $T.class, $T.class, $L)\n", new Object[]{slotName, prop.getName(), prop.getAnnotation(OneToOne.class) != null ? OneToOne.class : ManyToOne.class, prop.getRawElementTypeName(), prop.isNullable() ? "true" : "false"});
                continue;
            }
            if (prop.getAssociationAnnotation() != null) {
                builder.add(".add($L, $S, $T.class, $T.class, $L)\n", new Object[]{slotName, prop.getName(), prop.getAssociationAnnotation().annotationType(), prop.getRawElementTypeName(), prop.isNullable()});
                continue;
            }
            builder.add(".add($L, $S, $T.$L, $T.class, $L)\n", new Object[]{slotName, prop.getName(), ImmutablePropCategory.class, category.name(), prop.getRawElementTypeName(), prop.isNullable()});
        }
        builder.add(".build()", new Object[0]).unindent();
        this.typeBuilder.addField(FieldSpec.builder((TypeName)Constants.RUNTIME_TYPE_CLASS_NAME, (String)"TYPE", (Modifier[])new Modifier[]{Modifier.PUBLIC, Modifier.STATIC, Modifier.FINAL}).initializer(builder.build()).build());
    }

    private void addConstructor() {
        MethodSpec.Builder builder = MethodSpec.constructorBuilder();
        builder.modifiers.add(Modifier.PRIVATE);
        this.typeBuilder.addMethod(builder.build());
    }
}

