/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.apt.immutable.generator;

import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import javax.lang.model.element.Modifier;
import org.babyfish.jimmer.apt.immutable.generator.Annotations;
import org.babyfish.jimmer.apt.immutable.generator.CaseAppender;
import org.babyfish.jimmer.apt.immutable.generator.Constants;
import org.babyfish.jimmer.apt.immutable.meta.ImmutableProp;
import org.babyfish.jimmer.apt.immutable.meta.ImmutableType;
import org.babyfish.jimmer.apt.util.GeneratedAnnotation;
import org.babyfish.jimmer.impl.util.StringUtil;
import org.babyfish.jimmer.jackson.ImmutableModuleRequiredException;
import org.babyfish.jimmer.meta.PropId;
import org.babyfish.jimmer.runtime.ImmutableSpi;

public class ImplementorGenerator {
    private final ImmutableType type;
    private final ClassName spiClassName;
    private TypeSpec.Builder typeBuilder;

    ImplementorGenerator(ImmutableType type) {
        this.type = type;
        this.spiClassName = ClassName.get(ImmutableSpi.class);
    }

    public void generate(TypeSpec.Builder parentBuilder) {
        this.typeBuilder = TypeSpec.interfaceBuilder((String)"Implementor").addAnnotation(GeneratedAnnotation.generatedAnnotation(this.type)).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.ABSTRACT}).addSuperinterface((TypeName)this.type.getClassName()).addSuperinterface((TypeName)this.spiClassName);
        this.addPropertyOrderAnnotation();
        this.addStaticFields();
        this.addGet(PropId.class);
        this.addGet(String.class);
        for (ImmutableProp prop : this.type.getProps().values()) {
            this.addGetterIfNecessary(prop);
        }
        this.addType();
        this.addDummyProp();
        parentBuilder.addType(this.typeBuilder.build());
    }

    private void addPropertyOrderAnnotation() {
        CodeBlock.Builder builder = CodeBlock.builder();
        builder.add("{$S", new Object[]{"dummyPropForJacksonError__"});
        for (ImmutableProp prop : this.type.getPropsOrderById()) {
            builder.add(", $S", new Object[]{prop.getName()});
        }
        builder.add("}", new Object[0]);
        this.typeBuilder.addAnnotation(AnnotationSpec.builder((ClassName)Constants.JSON_PROPERTY_ORDER_CLASS_NAME).addMember("value", builder.build()).build());
    }

    private void addStaticFields() {
        for (ImmutableProp prop : this.type.getProps().values()) {
            if (prop.getDeeperPropIdName() == null) continue;
            FieldSpec.Builder builder = FieldSpec.builder((TypeName)Constants.PROP_ID_CLASS_NAME, (String)prop.getDeeperPropIdName(), (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC, Modifier.FINAL}).initializer("$T.TYPE.getProp($S).getManyToManyViewBaseDeeperProp().getId()", new Object[]{this.type.getProducerClassName(), prop.getName()});
            this.typeBuilder.addField(builder.build());
        }
    }

    private void addGet(Class<?> argType) {
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)"__get").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.DEFAULT}).addAnnotation(Override.class).addParameter(argType, "prop", new Modifier[0]).returns(Object.class);
        CaseAppender appender = new CaseAppender(builder, this.type, argType);
        if (argType == PropId.class) {
            builder.addStatement("int __propIndex = prop.asIndex()", new Object[0]);
            builder.beginControlFlow("switch (__propIndex)", new Object[0]);
            appender.addIllegalCase();
            builder.addStatement("return __get(prop.asName())", new Object[0]);
        } else {
            builder.beginControlFlow("switch (prop)", new Object[0]);
        }
        for (ImmutableProp prop : this.type.getPropsOrderById()) {
            appender.addCase(prop);
            if (prop.getBoxType() != null) {
                builder.addStatement("return ($T)$L()", new Object[]{prop.getBoxType(), prop.getGetterName()});
                continue;
            }
            builder.addStatement("return $L()", new Object[]{prop.getGetterName()});
        }
        builder.addStatement("default: throw new IllegalArgumentException($S + prop + $S)", new Object[]{"Illegal property " + (argType == Integer.TYPE ? "id" : "name") + " for \"" + this.type + "\": \"", "\""});
        builder.endControlFlow();
        this.typeBuilder.addMethod(builder.build());
    }

    private void addType() {
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)"__type").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.DEFAULT}).addAnnotation(Override.class).returns((TypeName)Constants.RUNTIME_TYPE_CLASS_NAME).addStatement("return TYPE", new Object[0]);
        this.typeBuilder.addMethod(builder.build());
    }

    private void addGetterIfNecessary(ImmutableProp prop) {
        ImmutableProp manyToManyViewBaseProp = prop.getManyToManyViewBaseProp();
        if (manyToManyViewBaseProp != null) {
            this.typeBuilder.addMethod(MethodSpec.methodBuilder((String)prop.getGetterName()).addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.DEFAULT}).returns(prop.getTypeName()).addStatement("return new $T<>(\n$>$L, $L()$<\n)", new Object[]{Constants.MANY_TO_MANY_VIEW_LIST_CLASS_NAME, prop.getDeeperPropIdName(), manyToManyViewBaseProp.getGetterName()}).build());
        }
        if (!prop.isBeanStyle()) {
            String name = prop.getGetterName();
            boolean isBoolean = prop.getTypeName().equals((Object)TypeName.BOOLEAN);
            MethodSpec.Builder builder = MethodSpec.methodBuilder((String)StringUtil.identifier((String[])new String[]{isBoolean ? "is" : "get", name})).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.DEFAULT}).returns(prop.getTypeName()).addStatement("return $L()", new Object[]{name});
            Annotations.copyNonJimmerAnnotations(builder, prop.getAnnotations());
            this.typeBuilder.addMethod(builder.build());
        }
    }

    private void addDummyProp() {
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)"getDummyPropForJacksonError__").returns(TypeName.INT).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.DEFAULT}).addStatement("throw new $T()", new Object[]{ImmutableModuleRequiredException.class});
        this.typeBuilder.addMethod(builder.build());
    }
}

