/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.apt.immutable.generator;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import com.squareup.javapoet.WildcardTypeName;
import java.io.IOException;
import javax.annotation.processing.Filer;
import javax.lang.model.element.Modifier;
import org.babyfish.jimmer.apt.Context;
import org.babyfish.jimmer.apt.GeneratorException;
import org.babyfish.jimmer.apt.immutable.generator.Constants;
import org.babyfish.jimmer.apt.immutable.meta.ImmutableType;
import org.babyfish.jimmer.apt.util.GeneratedAnnotation;
import org.babyfish.jimmer.impl.util.StringUtil;
import org.babyfish.jimmer.lang.NewChain;
import org.babyfish.jimmer.meta.ImmutableProp;
import org.babyfish.jimmer.sql.Id;
import org.babyfish.jimmer.sql.JoinTable;
import org.babyfish.jimmer.sql.ManyToMany;

public class FetcherGenerator {
    private final Context context;
    private final ImmutableType type;
    private final Filer filer;
    private TypeSpec.Builder typeBuilder;

    public FetcherGenerator(Context context, ImmutableType type, Filer filer) {
        this.context = context;
        this.type = type;
        this.filer = filer;
    }

    public void generate() {
        try {
            JavaFile.builder((String)this.type.getPackageName(), (TypeSpec)this.generateFetcher()).indent("    ").build().writeTo(this.filer);
        }
        catch (IOException ex) {
            throw new GeneratorException(String.format("Cannot generate fetcher class for '%s'", this.type.getQualifiedName()), ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TypeSpec generateFetcher() {
        TypeSpec.Builder builder = TypeSpec.classBuilder((String)this.type.getFetcherClassName().simpleName()).addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(GeneratedAnnotation.generatedAnnotation(this.type)).superclass((TypeName)ParameterizedTypeName.get((ClassName)Constants.ABSTRACT_TYPED_FETCHER_CLASS_NAME, (TypeName[])new TypeName[]{this.type.getClassName(), this.type.getFetcherClassName()}));
        TypeSpec.Builder oldBuilder = this.typeBuilder;
        this.typeBuilder = builder;
        try {
            this.add$();
            this.add$from();
            this.addConstructor();
            for (org.babyfish.jimmer.apt.immutable.meta.ImmutableProp prop : this.type.getProps().values()) {
                if (prop.getAnnotation(Id.class) != null || !this.isFetchProp(prop)) continue;
                this.addProp(prop);
                this.addPropByBoolean(prop);
                if (prop.isAssociation(true)) {
                    this.addPropWithChild(prop);
                    if (!prop.isRemote()) {
                        this.addAssociationPropByFieldConfig(prop);
                        this.addRecursiveProp(prop, false);
                        this.addRecursiveProp(prop, true);
                    }
                } else if (prop.getTargetType() != null && prop.getTargetType().isEmbeddable()) {
                    this.addPropWithChild(prop);
                }
                this.addPropByIdOnlyFetchType(prop);
            }
            this.addConstructorByNegativeAndReferenceType();
            this.addConstructorByFieldConfig();
            this.addCreatorByBoolean();
            this.addCreatorByFieldConfig();
        }
        finally {
            this.typeBuilder = oldBuilder;
        }
        return builder.build();
    }

    private void add$() {
        FieldSpec.Builder builder = FieldSpec.builder((TypeName)this.type.getFetcherClassName(), (String)"$", (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC, Modifier.FINAL}).initializer("new $T(null)", new Object[]{this.type.getFetcherClassName()});
        this.typeBuilder.addField(builder.build());
    }

    private void add$from() {
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)"$from").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC}).addParameter((TypeName)ParameterizedTypeName.get((ClassName)Constants.FETCHER_CLASS_NAME, (TypeName[])new TypeName[]{this.type.getClassName()}), "base", new Modifier[0]).returns((TypeName)this.type.getFetcherClassName()).addCode("return base instanceof $T ? \n", new Object[]{this.type.getFetcherClassName()}).addCode("\t($T)base : \n", new Object[]{this.type.getFetcherClassName()}).addCode("\tnew $T(($T)base);\n", new Object[]{this.type.getFetcherClassName(), ParameterizedTypeName.get((ClassName)Constants.FETCHER_IMPL_CLASS_NAME, (TypeName[])new TypeName[]{this.type.getClassName()})});
        this.typeBuilder.addMethod(builder.build());
    }

    private void addConstructor() {
        MethodSpec.Builder builder = MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PRIVATE}).addParameter((TypeName)ParameterizedTypeName.get((ClassName)Constants.FETCHER_IMPL_CLASS_NAME, (TypeName[])new TypeName[]{this.type.getClassName()}), "base", new Modifier[0]).addStatement("super($T.class, base)", new Object[]{this.type.getClassName()});
        this.typeBuilder.addMethod(builder.build());
    }

    private boolean isFetchProp(org.babyfish.jimmer.apt.immutable.meta.ImmutableProp prop) {
        if (prop.isTransient()) {
            return prop.hasTransientResolver();
        }
        return true;
    }

    private void addProp(org.babyfish.jimmer.apt.immutable.meta.ImmutableProp prop) {
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)prop.getName()).addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(NewChain.class).returns((TypeName)this.type.getFetcherClassName()).addStatement("return add($S)", new Object[]{prop.getName()});
        this.typeBuilder.addMethod(builder.build());
    }

    private void addPropByBoolean(org.babyfish.jimmer.apt.immutable.meta.ImmutableProp prop) {
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)prop.getName()).addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(NewChain.class).addParameter(Boolean.TYPE, "enabled", new Modifier[0]).returns((TypeName)this.type.getFetcherClassName()).addStatement("return enabled ? add($S) : remove($S)", new Object[]{prop.getName(), prop.getName()});
        this.typeBuilder.addMethod(builder.build());
    }

    private void addPropWithChild(org.babyfish.jimmer.apt.immutable.meta.ImmutableProp prop) {
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)prop.getName()).addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(NewChain.class).addParameter((TypeName)ParameterizedTypeName.get((ClassName)Constants.FETCHER_CLASS_NAME, (TypeName[])new TypeName[]{prop.getElementTypeName()}), "childFetcher", new Modifier[0]).returns((TypeName)this.type.getFetcherClassName()).addStatement("return add($S, childFetcher)", new Object[]{prop.getName()});
        this.typeBuilder.addMethod(builder.build());
    }

    private void addAssociationPropByFieldConfig(org.babyfish.jimmer.apt.immutable.meta.ImmutableProp prop) {
        ClassName fieldConfigClassName = prop.isList() ? Constants.LIST_FIELD_CONFIG_CLASS_NAME : Constants.FIELD_CONFIG_CLASS_NAME;
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)prop.getName()).addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(NewChain.class).addParameter((TypeName)ParameterizedTypeName.get((ClassName)Constants.FETCHER_CLASS_NAME, (TypeName[])new TypeName[]{prop.getElementTypeName()}), "childFetcher", new Modifier[0]).addParameter((TypeName)ParameterizedTypeName.get((ClassName)Constants.CONSUMER_CLASS_NAME, (TypeName[])new TypeName[]{ParameterizedTypeName.get((ClassName)fieldConfigClassName, (TypeName[])new TypeName[]{prop.getElementTypeName(), this.context.getImmutableType(prop.getElementType()).getTableClassName()})}), "fieldConfig", new Modifier[0]).returns((TypeName)this.type.getFetcherClassName()).addStatement("return add($S, childFetcher, fieldConfig)", new Object[]{prop.getName()});
        this.typeBuilder.addMethod(builder.build());
    }

    private void addRecursiveProp(org.babyfish.jimmer.apt.immutable.meta.ImmutableProp prop, boolean withLambda) {
        if (!prop.isRecursive()) {
            return;
        }
        ClassName fieldConfigClassName = prop.isList() ? Constants.RECURSIVE_LIST_FIELD_CONFIG_CLASS_NAME : Constants.RECURSIVE_FIELD_CONFIG_CLASS_NAME;
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)StringUtil.identifier((String[])new String[]{"recursive", prop.getName()})).addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(NewChain.class);
        if (withLambda) {
            builder.addParameter((TypeName)ParameterizedTypeName.get((ClassName)Constants.CONSUMER_CLASS_NAME, (TypeName[])new TypeName[]{ParameterizedTypeName.get((ClassName)fieldConfigClassName, (TypeName[])new TypeName[]{prop.getElementTypeName(), this.context.getImmutableType(prop.getElementType()).getTableClassName()})}), "fieldConfig", new Modifier[0]);
        }
        builder.returns((TypeName)this.type.getFetcherClassName()).addStatement("return addRecursion($S, $L)", new Object[]{prop.getName(), withLambda ? "fieldConfig" : "null"});
        this.typeBuilder.addMethod(builder.build());
    }

    private void addPropByIdOnlyFetchType(org.babyfish.jimmer.apt.immutable.meta.ImmutableProp prop) {
        org.babyfish.jimmer.apt.immutable.meta.ImmutableProp associationProp = prop.getIdViewBaseProp();
        if (associationProp == null) {
            associationProp = prop;
        }
        if (associationProp.isTransient() || !associationProp.isAssociation(true)) {
            return;
        }
        if (prop.isReverse() && prop.getAnnotation(ManyToMany.class) == null && prop.getAnnotation(JoinTable.class) == null) {
            return;
        }
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)prop.getName()).addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(NewChain.class).addParameter((TypeName)Constants.ID_ONLY_FETCH_TYPE, "idOnlyFetchType", new Modifier[0]).returns((TypeName)this.type.getFetcherClassName()).addStatement("return add($S, idOnlyFetchType)", new Object[]{prop.getName()});
        this.typeBuilder.addMethod(builder.build());
    }

    private void addConstructorByNegativeAndReferenceType() {
        MethodSpec.Builder builder = MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PRIVATE}).addParameter((TypeName)this.type.getFetcherClassName(), "prev", new Modifier[0]).addParameter(ImmutableProp.class, "prop", new Modifier[0]).addParameter(Boolean.TYPE, "negative", new Modifier[0]).addParameter((TypeName)Constants.ID_ONLY_FETCH_TYPE, "idOnlyFetchType", new Modifier[0]).addStatement("super(prev, prop, negative, idOnlyFetchType)", new Object[0]);
        this.typeBuilder.addMethod(builder.build());
    }

    private void addConstructorByFieldConfig() {
        MethodSpec.Builder builder = MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PRIVATE}).addParameter((TypeName)this.type.getFetcherClassName(), "prev", new Modifier[0]).addParameter(ImmutableProp.class, "prop", new Modifier[0]).addParameter((TypeName)ParameterizedTypeName.get((ClassName)Constants.FIELD_CONFIG_CLASS_NAME, (TypeName[])new TypeName[]{WildcardTypeName.subtypeOf(Object.class), WildcardTypeName.subtypeOf((TypeName)ParameterizedTypeName.get((ClassName)Constants.TABLE_CLASS_NAME, (TypeName[])new TypeName[]{WildcardTypeName.subtypeOf(Object.class)}))}), "fieldConfig", new Modifier[0]).addStatement("super(prev, prop, fieldConfig)", new Object[0]);
        this.typeBuilder.addMethod(builder.build());
    }

    private void addCreatorByBoolean() {
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)"createFetcher").addModifiers(new Modifier[]{Modifier.PROTECTED}).addParameter(ImmutableProp.class, "prop", new Modifier[0]).addParameter(Boolean.TYPE, "negative", new Modifier[0]).addParameter((TypeName)Constants.ID_ONLY_FETCH_TYPE, "idOnlyFetchType", new Modifier[0]).returns((TypeName)this.type.getFetcherClassName()).addAnnotation(Override.class).addStatement("return new $T(this, prop, negative, idOnlyFetchType)", new Object[]{this.type.getFetcherClassName()});
        this.typeBuilder.addMethod(builder.build());
    }

    private void addCreatorByFieldConfig() {
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)"createFetcher").addModifiers(new Modifier[]{Modifier.PROTECTED}).addParameter(ImmutableProp.class, "prop", new Modifier[0]).addParameter((TypeName)ParameterizedTypeName.get((ClassName)Constants.FIELD_CONFIG_CLASS_NAME, (TypeName[])new TypeName[]{WildcardTypeName.subtypeOf(Object.class), WildcardTypeName.subtypeOf((TypeName)ParameterizedTypeName.get((ClassName)Constants.TABLE_CLASS_NAME, (TypeName[])new TypeName[]{WildcardTypeName.subtypeOf(Object.class)}))}), "fieldConfig", new Modifier[0]).returns((TypeName)this.type.getFetcherClassName()).addAnnotation(Override.class).addStatement("return new $T(this, prop, fieldConfig)", new Object[]{this.type.getFetcherClassName()});
        this.typeBuilder.addMethod(builder.build());
    }
}

