/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.apt.dto;

import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import javax.lang.model.element.Modifier;
import org.babyfish.jimmer.apt.dto.DtoGenerator;
import org.babyfish.jimmer.apt.immutable.generator.Constants;
import org.babyfish.jimmer.apt.immutable.meta.ImmutableProp;
import org.babyfish.jimmer.apt.immutable.meta.ImmutableType;
import org.babyfish.jimmer.dto.compiler.AbstractProp;
import org.babyfish.jimmer.dto.compiler.DtoProp;
import org.babyfish.jimmer.dto.compiler.DtoType;
import org.babyfish.jimmer.impl.util.StringUtil;

public class InputBuilderGenerator {
    private final DtoGenerator parentGenerator;
    private final DtoType<ImmutableType, ImmutableProp> dtoType;
    private TypeSpec.Builder typeBuilder;

    public InputBuilderGenerator(DtoGenerator parentGenerator) {
        this.parentGenerator = parentGenerator;
        this.dtoType = parentGenerator.dtoType;
    }

    public void generate() {
        this.typeBuilder = TypeSpec.classBuilder((String)"Builder").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC}).addAnnotation(AnnotationSpec.builder((ClassName)Constants.JSON_POJO_BUILDER_CLASS_NAME).addMember("withPrefix", "$S", new Object[]{""}).build());
        try {
            this.addMembers();
            this.parentGenerator.getTypeBuilder().addType(this.typeBuilder.build());
        }
        finally {
            this.typeBuilder = null;
        }
    }

    private void addMembers() {
        for (DtoProp prop : this.dtoType.getDtoProps()) {
            this.addField((AbstractProp)prop);
            this.addStateField((AbstractProp)prop);
        }
        for (DtoProp prop : this.dtoType.getUserProps()) {
            this.addField((AbstractProp)prop);
        }
        for (DtoProp prop : this.dtoType.getDtoProps()) {
            this.addSetter((AbstractProp)prop);
        }
        for (DtoProp prop : this.dtoType.getUserProps()) {
            this.addSetter((AbstractProp)prop);
        }
        this.addBuild();
    }

    private void addField(AbstractProp prop) {
        TypeName typeName = this.parentGenerator.getPropTypeName(prop);
        if (InputBuilderGenerator.isFieldNullable(prop)) {
            typeName = typeName.box();
        }
        FieldSpec.Builder builder = FieldSpec.builder((TypeName)typeName, (String)prop.getName(), (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PRIVATE});
        this.typeBuilder.addField(builder.build());
    }

    private void addStateField(AbstractProp prop) {
        String stateFieldName = this.parentGenerator.stateFieldName(prop, true);
        if (stateFieldName == null) {
            return;
        }
        FieldSpec.Builder builder = FieldSpec.builder((TypeName)TypeName.BOOLEAN, (String)stateFieldName, (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PRIVATE});
        this.typeBuilder.addField(builder.build());
    }

    private void addSetter(AbstractProp prop) {
        String stateFieldName = this.parentGenerator.stateFieldName(prop, true);
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)prop.getName()).addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(this.parentGenerator.getPropTypeName(prop), prop.getName(), new Modifier[0]).returns((TypeName)this.parentGenerator.getDtoClassName("Builder"));
        if (prop.isNullable()) {
            builder.addStatement("this.$L = $L", new Object[]{prop.getName(), prop.getName()});
            if (stateFieldName != null) {
                builder.addStatement("this.$L = true", new Object[]{stateFieldName});
            }
        } else {
            builder.addStatement("this.$L = $T.requireNonNull($L, $S)", new Object[]{prop.getName(), Constants.OBJECTS_CLASS_NAME, prop.getName(), "The property \"" + prop.getName() + "\" cannot be null"});
        }
        builder.addStatement("return this", new Object[0]);
        this.typeBuilder.addMethod(builder.build());
    }

    private void addBuild() {
        ClassName dtoClassName = this.parentGenerator.getDtoClassName(null);
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)"build").addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)dtoClassName);
        builder.addStatement("$T _input = new $T()", new Object[]{dtoClassName, dtoClassName});
        for (DtoProp prop : this.dtoType.getDtoProps()) {
            if (!prop.isNullable()) {
                builder.beginControlFlow("if ($L == null)", new Object[]{prop.getName()});
                builder.addStatement("throw $T.$L($T.class, $S)", new Object[]{Constants.INPUT_CLASS_NAME, "unknownNonNullProperty", dtoClassName, prop.getName()});
                builder.endControlFlow();
                builder.addStatement("_input.$L($L)", new Object[]{StringUtil.identifier((String[])new String[]{"set", prop.getName()}), prop.getName()});
                continue;
            }
            String stateFieldName = this.parentGenerator.stateFieldName((AbstractProp)prop, true);
            switch (prop.getInputModifier()) {
                case FIXED: {
                    builder.beginControlFlow("if (!$L)", new Object[]{stateFieldName});
                    builder.addStatement("throw $T.$L($T.class, $S)", new Object[]{Constants.INPUT_CLASS_NAME, "unknownNullableProperty", dtoClassName, prop.getName()});
                    builder.endControlFlow();
                }
                case STATIC: {
                    builder.addStatement("_input.$L($L)", new Object[]{StringUtil.identifier((String[])new String[]{"set", prop.getName()}), prop.getName()});
                    break;
                }
                case DYNAMIC: {
                    builder.beginControlFlow("if ($L)", new Object[]{stateFieldName});
                    builder.addStatement("_input.$L($L)", new Object[]{StringUtil.identifier((String[])new String[]{"set", prop.getName()}), prop.getName()});
                    builder.endControlFlow();
                    break;
                }
                case FUZZY: {
                    builder.beginControlFlow("if ($L != null)", new Object[]{prop.getName()});
                    builder.addStatement("_input.$L($L)", new Object[]{StringUtil.identifier((String[])new String[]{"set", prop.getName()}), prop.getName()});
                    builder.endControlFlow();
                }
            }
        }
        for (DtoProp prop : this.dtoType.getUserProps()) {
            builder.addStatement("_input.$L($L)", new Object[]{StringUtil.identifier((String[])new String[]{"set", prop.getName()}), prop.getName()});
        }
        builder.addStatement("return _input", new Object[0]);
        this.typeBuilder.addMethod(builder.build());
    }

    private static boolean isFieldNullable(AbstractProp prop) {
        if (prop instanceof DtoProp) {
            String funcName = ((DtoProp)prop).getFuncName();
            return !"null".equals(funcName) && !"notNull".equals(funcName);
        }
        return true;
    }
}

