/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.apt;

import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeKind;
import org.babyfish.jimmer.Immutable;
import org.babyfish.jimmer.sql.Embeddable;
import org.babyfish.jimmer.sql.Entity;
import org.babyfish.jimmer.sql.MappedSuperclass;

public class MetaException
extends RuntimeException {
    private final Element element;

    public MetaException(Element element, String reason) {
        super(MetaException.message(element, reason));
        this.element = element;
    }

    public MetaException(Element element, Element childElement, String reason) {
        super(MetaException.message(element, childElement == element ? reason : MetaException.message(childElement, reason)));
        this.element = element;
    }

    public MetaException(Element element, String reason, Throwable cause) {
        super(MetaException.message(element, reason), cause);
        this.element = element;
    }

    public Element getElement() {
        return this.element;
    }

    private static String message(Element element, String reason) {
        if (element instanceof TypeElement) {
            return "Illegal type \"" + MetaException.longName(element) + "\", " + MetaException.lowerFirstChar(reason);
        }
        if (element instanceof ExecutableElement) {
            TypeElement type = (TypeElement)element.getEnclosingElement();
            return "Illegal " + (MetaException.isProperty((ExecutableElement)element) ? "property" : "method") + " \"" + MetaException.longName(element) + "\", " + MetaException.lowerFirstChar(reason);
        }
        if (element instanceof VariableElement) {
            return "Illegal parameter \"" + MetaException.longName(element) + "\", " + MetaException.lowerFirstChar(reason);
        }
        return reason;
    }

    private static String longName(Element element) {
        if (element instanceof TypeElement) {
            return ((TypeElement)element).getQualifiedName().toString();
        }
        return MetaException.longName(element.getEnclosingElement()) + (element.getKind() == ElementKind.PARAMETER ? (char)':' : '.') + element.getSimpleName().toString();
    }

    private static boolean isProperty(ExecutableElement element) {
        TypeElement typeElement = (TypeElement)element.getEnclosingElement();
        if (typeElement.getAnnotation(Immutable.class) != null || typeElement.getAnnotation(Entity.class) != null || typeElement.getAnnotation(MappedSuperclass.class) != null || typeElement.getAnnotation(Embeddable.class) != null) {
            return true;
        }
        if (element.getParameters().isEmpty() && element.getTypeParameters().isEmpty()) {
            String simpleName = element.getSimpleName().toString();
            if (simpleName.startsWith("get") && !Character.isLowerCase(simpleName.charAt(3))) {
                return true;
            }
            if (simpleName.startsWith("is") && !Character.isLowerCase(simpleName.charAt(2)) && element.getReturnType().getKind() == TypeKind.BOOLEAN) {
                return true;
            }
        }
        return false;
    }

    private static String lowerFirstChar(String reason) {
        int whitespaceCount;
        for (whitespaceCount = 0; whitespaceCount < reason.length() && Character.isWhitespace(reason.charAt(whitespaceCount)); ++whitespaceCount) {
        }
        if (whitespaceCount != 0) {
            reason = reason.substring(whitespaceCount);
        }
        if (reason.isEmpty()) {
            return reason;
        }
        if (Character.isUpperCase(reason.charAt(0))) {
            return Character.toLowerCase(reason.charAt(0)) + reason.substring(1);
        }
        return reason;
    }
}

