/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.apt.generator;

import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import javax.annotation.processing.Filer;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import org.babyfish.jimmer.apt.GeneratorException;
import org.babyfish.jimmer.apt.MetaException;
import org.babyfish.jimmer.apt.generator.Constants;
import org.babyfish.jimmer.error.CodeBasedException;
import org.babyfish.jimmer.error.ErrorFamily;
import org.babyfish.jimmer.error.ErrorField;
import org.babyfish.jimmer.error.ErrorFields;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ErrorGenerator {
    private static final Pattern DOT_PATTERN = Pattern.compile("\\.");
    private static final String ERROR_FIELDS_NAME = ErrorFields.class.getName();
    private static final String ERROR_FIELD_NAME = ErrorField.class.getName();
    private static final String[] EMPTY_STR_ARR = new String[0];
    private static final Map<String, TypeName> PRIMITIVE_TYPE_MAP;
    private final TypeElement typeElement;
    private final Filer filer;
    private final String packageName;
    private final ClassName className;
    private final String exceptionName;
    private final ClassName exceptionClassName;
    private TypeSpec.Builder typeBuilder;

    public ErrorGenerator(TypeElement typeElement, Filer filer) {
        this.typeElement = typeElement;
        this.filer = filer;
        this.packageName = this.packageName();
        CharSequence[] simpleNames = this.simpleNames();
        this.className = ClassName.get((String)this.packageName, (String)simpleNames[0], (String[])Arrays.copyOfRange(simpleNames, 1, simpleNames.length));
        String exceptionName = String.join((CharSequence)"_", simpleNames);
        exceptionName = exceptionName.endsWith("_ErrorCode") ? exceptionName.substring(0, exceptionName.length() - 10) + "Exception" : (exceptionName.endsWith("ErrorCode") ? exceptionName.substring(0, exceptionName.length() - 9) + "Exception" : (exceptionName.endsWith("_Error") ? exceptionName.substring(0, exceptionName.length() - 6) + "Exception" : (exceptionName.endsWith("Error") ? exceptionName.substring(0, exceptionName.length() - 5) + "Exception" : exceptionName + "Exception")));
        this.exceptionName = exceptionName;
        this.exceptionClassName = ClassName.get((String)this.packageName, (String)exceptionName, (String[])new String[0]);
    }

    public void generate() {
        this.typeBuilder = TypeSpec.classBuilder((String)this.exceptionName).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.ABSTRACT}).superclass(CodeBasedException.class).addAnnotation(AnnotationSpec.builder((ClassName)Constants.GENERATED_BY_CLASS_NAME).addMember("type", "$T.class", new Object[]{this.className}).build());
        this.addMembers();
        try {
            JavaFile.builder((String)this.packageName, (TypeSpec)this.typeBuilder.build()).indent("    ").build().writeTo(this.filer);
        }
        catch (IOException ex) {
            throw new GeneratorException(String.format("Cannot generate code based exception for enum type '%s'", this.typeElement.getQualifiedName().toString()), ex);
        }
    }

    private String packageName() {
        for (Element element = this.typeElement.getEnclosingElement(); element != null; element = element.getEnclosingElement()) {
            if (!(element instanceof PackageElement)) continue;
            return ((PackageElement)element).getQualifiedName().toString();
        }
        return "";
    }

    private String[] simpleNames() {
        String qualifiedName = this.typeElement.getQualifiedName().toString();
        if (this.packageName.isEmpty()) {
            return DOT_PATTERN.split(qualifiedName);
        }
        return DOT_PATTERN.split(qualifiedName.substring(this.packageName.length() + 1));
    }

    private void addMembers() {
        this.addConstructor();
        this.typeBuilder.addMethod(MethodSpec.methodBuilder((String)"getCode").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.ABSTRACT}).addAnnotation(Override.class).returns((TypeName)this.className).build());
        for (Element element : this.typeElement.getEnclosedElements()) {
            if (element.getKind() != ElementKind.ENUM_CONSTANT) continue;
            this.addCreator(element, false);
            this.addCreator(element, true);
        }
        for (Element element : this.typeElement.getEnclosedElements()) {
            if (element.getKind() != ElementKind.ENUM_CONSTANT) continue;
            this.addType(element);
        }
    }

    private void addConstructor() {
        this.typeBuilder.addMethod(MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PRIVATE}).addParameter(String.class, "message", new Modifier[0]).addParameter(Throwable.class, "cause", new Modifier[0]).addStatement("super(message, cause)", new Object[0]).build());
    }

    private void addCreator(Element element, boolean withCause) {
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)ErrorGenerator.javaName(element, false)).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC}).returns((TypeName)this.exceptionClassName).addParameter(ParameterSpec.builder((TypeName)Constants.STRING_CLASS_NAME, (String)"message", (Modifier[])new Modifier[0]).addAnnotation(NotNull.class).build());
        if (withCause) {
            builder.addParameter(ParameterSpec.builder(Throwable.class, (String)"cause", (Modifier[])new Modifier[0]).addAnnotation(Nullable.class).build());
        }
        List<Field> fields = ErrorGenerator.fieldsOf(element);
        for (Field field : fields) {
            builder.addParameter(ParameterSpec.builder((TypeName)field.type, (String)field.name, (Modifier[])new Modifier[0]).addAnnotation(field.isNullable ? Nullable.class : NotNull.class).build());
        }
        builder.addCode("return new $L(\n$>", new Object[]{ErrorGenerator.javaName(element, true)});
        builder.addCode("message,\n", new Object[0]).addCode(withCause ? "cause" : "null", new Object[0]);
        for (Field field : fields) {
            builder.addCode(",\n$L", new Object[]{field.name});
        }
        builder.addCode("\n$<);\n", new Object[0]);
        this.typeBuilder.addMethod(builder.build());
    }

    private void addType(Element element) {
        TypeSpec.Builder builder = TypeSpec.classBuilder((String)ErrorGenerator.javaName(element, true)).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC}).superclass((TypeName)this.exceptionClassName);
        List<Field> fields = ErrorGenerator.fieldsOf(element);
        for (Field field : fields) {
            FieldSpec.Builder fieldBuilder = FieldSpec.builder((TypeName)field.type, (String)field.name, (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PRIVATE, Modifier.FINAL}).addAnnotation(field.isNullable ? Nullable.class : NotNull.class);
            builder.addField(fieldBuilder.build());
        }
        MethodSpec.Builder initBuilder = MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter((TypeName)Constants.STRING_CLASS_NAME, "message", new Modifier[0]).addParameter((TypeName)Constants.THROWABLE_CLASS_NAME, "cause", new Modifier[0]);
        for (Field field : fields) {
            ParameterSpec.Builder parameterBuilder = ParameterSpec.builder((TypeName)field.type, (String)field.name, (Modifier[])new Modifier[0]).addAnnotation(field.isNullable ? Nullable.class : NotNull.class);
            initBuilder.addParameter(parameterBuilder.build());
        }
        initBuilder.addStatement("super(message, cause)", new Object[0]);
        for (Field field : fields) {
            initBuilder.addStatement("this.$L = $L", new Object[]{field.name, field.name});
        }
        builder.addMethod(initBuilder.build());
        builder.addMethod(MethodSpec.methodBuilder((String)"getCode").addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Override.class).returns((TypeName)this.className).addStatement("return $T.$L", new Object[]{this.className, element.getSimpleName().toString()}).build());
        MethodSpec.Builder builder2 = MethodSpec.methodBuilder((String)"getFields").addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Override.class).returns((TypeName)ParameterizedTypeName.get((ClassName)Constants.MAP_CLASS_NAME, (TypeName[])new TypeName[]{Constants.STRING_CLASS_NAME, TypeName.OBJECT}));
        if (fields.isEmpty()) {
            builder2.addStatement("return $T.emptyMap()", new Object[]{Constants.COLLECTIONS_CLASS_NAME});
        } else if (fields.size() == 1) {
            builder2.addStatement("return $T.singletonMap($S, $L)", new Object[]{Constants.COLLECTIONS_CLASS_NAME, fields.get((int)0).name, fields.get((int)0).name});
        } else {
            builder2.addStatement("$T __fields = new $T<>()", new Object[]{Constants.MAP_CLASS_NAME, Constants.LINKED_HASH_MAP_CLASS_NAME});
            for (Field field : fields) {
                builder2.addStatement("__fields.put($S, $L)", new Object[]{field.name, field.name});
            }
            builder2.addStatement("return __fields", new Object[0]);
        }
        builder.addMethod(builder2.build());
        for (Field field : fields) {
            builder.addMethod(MethodSpec.methodBuilder((String)((field.type.equals((Object)TypeName.BOOLEAN) ? "is" : "get") + Character.toUpperCase(field.name.charAt(0)) + field.name.substring(1))).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(field.type).addAnnotation(field.isNullable ? Nullable.class : NotNull.class).addStatement("return $L", new Object[]{field.name}).build());
        }
        this.typeBuilder.addType(builder.build());
    }

    private static String javaName(Element element, boolean upperHead) {
        String simpleName = element.getSimpleName().toString();
        int size = simpleName.length();
        boolean toUpper = upperHead;
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < size; ++i) {
            char c = simpleName.charAt(i);
            if (c == '_') {
                toUpper = true;
                continue;
            }
            if (toUpper) {
                builder.append(Character.toUpperCase(c));
            } else {
                builder.append(Character.toLowerCase(c));
            }
            toUpper = false;
        }
        return builder.toString();
    }

    private static List<Field> fieldsOf(Element element) {
        List<Field> fields = new ArrayList<Field>();
        for (AnnotationMirror annotationMirror : element.getAnnotationMirrors()) {
            String qualifiedName = ((TypeElement)annotationMirror.getAnnotationType().asElement()).getQualifiedName().toString();
            if (qualifiedName.equals(ERROR_FIELDS_NAME)) {
                Iterator<? extends AnnotationValue> itr = annotationMirror.getElementValues().values().iterator();
                if (!itr.hasNext()) break;
                AnnotationValue annotationValue = itr.next();
                for (AnnotationMirror childMirror : (List)annotationValue.getValue()) {
                    fields.add(Field.of(childMirror, element));
                }
                break;
            }
            if (!qualifiedName.equals(ERROR_FIELD_NAME)) continue;
            fields = Collections.singletonList(Field.of(annotationMirror, element));
            break;
        }
        return fields;
    }

    private static TypeName typeName(String value) {
        TypeName primitiveTypeName = PRIMITIVE_TYPE_MAP.get(value);
        if (primitiveTypeName != null) {
            return primitiveTypeName;
        }
        StringBuilder packageBuilder = new StringBuilder();
        String simpleName = null;
        ArrayList<String> nestNames = new ArrayList<String>();
        for (String part : DOT_PATTERN.split(value)) {
            if (Character.isUpperCase(part.charAt(0))) {
                if (simpleName == null) {
                    simpleName = part;
                    continue;
                }
                nestNames.add(part);
                continue;
            }
            packageBuilder.append(part).append('.');
        }
        return ClassName.get((String)(packageBuilder.length() == 0 ? "" : packageBuilder.substring(0, packageBuilder.length() - 1)), simpleName, (String[])nestNames.toArray(EMPTY_STR_ARR));
    }

    static {
        HashMap<String, TypeName> map = new HashMap<String, TypeName>();
        map.put("boolean", TypeName.BOOLEAN);
        map.put("char", TypeName.CHAR);
        map.put("byte", TypeName.BYTE);
        map.put("short", TypeName.SHORT);
        map.put("int", TypeName.INT);
        map.put("long", TypeName.LONG);
        map.put("float", TypeName.FLOAT);
        map.put("double", TypeName.DOUBLE);
        PRIMITIVE_TYPE_MAP = map;
    }

    private static class Field {
        final String name;
        final TypeName type;
        final boolean isNullable;
        final boolean isList;

        private Field(String name, TypeName type, boolean isNullable, boolean isList) {
            this.name = name;
            this.type = type;
            this.isNullable = isNullable;
            this.isList = isList;
        }

        public static Field of(AnnotationMirror annotationMirror, Element constantElement) {
            String name = null;
            ParameterizedTypeName typeName = null;
            boolean isNullable = false;
            boolean isList = false;
            for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> e : annotationMirror.getElementValues().entrySet()) {
                String key = e.getKey().getSimpleName().toString();
                Object value = e.getValue().getValue();
                if (key.equals("name")) {
                    String str = (String)value;
                    if (str.equals("family") || str.equals("code")) {
                        throw new MetaException(constantElement, "The enum constant \"" + constantElement.getEnclosingElement().getSimpleName().toString() + '.' + constantElement.getSimpleName().toString() + "\" is illegal, it cannot be decorated by \"@" + ErrorFamily.class.getName() + "\" with the name \"family\" or \"code\"");
                    }
                    name = str;
                    continue;
                }
                if (key.equals("type")) {
                    typeName = ErrorGenerator.typeName(value.toString());
                    continue;
                }
                if (key.equals("nullable")) {
                    isNullable = (Boolean)value;
                    continue;
                }
                if (!key.equals("list")) continue;
                isList = (Boolean)value;
            }
            assert (typeName != null);
            if (isList) {
                if (typeName.isPrimitive()) {
                    throw new MetaException(constantElement, "The enum constant \"" + constantElement.getEnclosingElement().getSimpleName().toString() + '.' + constantElement.getSimpleName().toString() + "\" is decorated by @" + ErrorField.class.getName() + ", this annotation is illegal because its `type` is primitive but its `list` is true");
                }
                typeName = ParameterizedTypeName.get((ClassName)Constants.LIST_CLASS_NAME, (TypeName[])new TypeName[]{typeName});
            }
            return new Field(name, (TypeName)typeName, isNullable, isList);
        }
    }
}

