/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.apt.generator;

import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ArrayTypeName;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import com.squareup.javapoet.WildcardTypeName;
import java.io.IOException;
import java.lang.annotation.ElementType;
import java.lang.annotation.Target;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.processing.Filer;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Null;
import org.babyfish.jimmer.apt.GeneratorException;
import org.babyfish.jimmer.apt.generator.Constants;
import org.babyfish.jimmer.apt.generator.Strings;
import org.babyfish.jimmer.apt.meta.ImmutableProp;
import org.babyfish.jimmer.apt.meta.ImmutableType;
import org.babyfish.jimmer.dto.compiler.Anno;
import org.babyfish.jimmer.dto.compiler.DtoProp;
import org.babyfish.jimmer.dto.compiler.DtoType;
import org.babyfish.jimmer.dto.compiler.DtoTypeModifier;
import org.babyfish.jimmer.dto.compiler.TypeRef;
import org.babyfish.jimmer.dto.compiler.UserProp;
import org.babyfish.jimmer.runtime.ImmutableSpi;
import org.babyfish.jimmer.sql.Id;
import org.jetbrains.annotations.Nullable;

public class DtoGenerator {
    private static final String[] EMPTY_STR_ARR = new String[0];
    private final DtoType<ImmutableType, ImmutableProp> dtoType;
    private final Filer filer;
    private final DtoGenerator parent;
    private final DtoGenerator root;
    private final String innerClassName;
    private TypeSpec.Builder typeBuilder;

    public DtoGenerator(DtoType<ImmutableType, ImmutableProp> dtoType, Filer filer) {
        this(dtoType, filer, null, null);
    }

    private DtoGenerator(DtoType<ImmutableType, ImmutableProp> dtoType, Filer filer, DtoGenerator parent, String innerClassName) {
        if (filer == null == (parent == null)) {
            throw new IllegalArgumentException("The nullity values of `filer` and `parent` cannot be same");
        }
        if (parent == null != (innerClassName == null)) {
            throw new IllegalArgumentException("The nullity values of `parent` and `innerClassName` must be same");
        }
        this.dtoType = dtoType;
        this.filer = filer;
        this.parent = parent;
        this.root = parent != null ? parent.root : this;
        this.innerClassName = innerClassName;
    }

    public void generate() {
        String simpleName = this.getSimpleName();
        this.typeBuilder = TypeSpec.classBuilder((String)simpleName).addModifiers(new Modifier[]{Modifier.PUBLIC}).addSuperinterface((TypeName)ParameterizedTypeName.get((ClassName)(this.dtoType.getModifiers().contains(DtoTypeModifier.INPUT_ONLY) ? Constants.INPUT_CLASS_NAME : (this.dtoType.getModifiers().contains(DtoTypeModifier.INPUT) ? Constants.VIEWABLE_INPUT_CLASS_NAME : Constants.VIEW_CLASS_NAME)), (TypeName[])new TypeName[]{((ImmutableType)this.dtoType.getBaseType()).getClassName()}));
        if (this.parent == null) {
            this.typeBuilder.addAnnotation(AnnotationSpec.builder((ClassName)Constants.GENERATED_BY_CLASS_NAME).addMember("file", "$S", new Object[]{this.dtoType.getPath()}).build());
        }
        this.typeBuilder.addAnnotation(Constants.LOMBOK_DATA_CLASS_NAME);
        for (Anno anno : this.dtoType.getAnnotations()) {
            this.typeBuilder.addAnnotation(DtoGenerator.annotationOf(anno));
        }
        if (this.innerClassName != null) {
            this.typeBuilder.addModifiers(new Modifier[]{Modifier.STATIC});
            this.addMembers();
        } else {
            this.addMembers();
        }
        if (this.innerClassName != null) {
            this.parent.typeBuilder.addType(this.typeBuilder.build());
        } else {
            try {
                JavaFile.builder((String)this.getPackageName(), (TypeSpec)this.typeBuilder.build()).indent("    ").build().writeTo(this.filer);
            }
            catch (IOException ex) {
                throw new GeneratorException(String.format("Cannot generate dto type '%s' for '%s'", this.dtoType.getName(), ((ImmutableType)this.dtoType.getBaseType()).getQualifiedName()), ex);
            }
        }
    }

    public String getPackageName() {
        String pkg = ((ImmutableType)this.dtoType.getBaseType()).getPackageName();
        return pkg.isEmpty() ? "dto" : pkg + ".dto";
    }

    public String getSimpleName() {
        return this.innerClassName != null ? this.innerClassName : this.dtoType.getName();
    }

    public ClassName getDtoClassName(String ... nestedNames) {
        if (this.innerClassName != null) {
            ArrayList<String> list = new ArrayList<String>();
            this.collectNames(list);
            list.addAll(Arrays.asList(nestedNames));
            return ClassName.get((String)this.root.getPackageName(), (String)((String)list.get(0)), (String[])list.subList(1, list.size()).toArray(EMPTY_STR_ARR));
        }
        return ClassName.get((String)this.root.getPackageName(), (String)this.dtoType.getName(), (String[])nestedNames);
    }

    private void addMembers() {
        boolean inputOnly = this.dtoType.getModifiers().contains(DtoTypeModifier.INPUT_ONLY);
        if (!inputOnly) {
            this.addMetadata();
        }
        for (DtoProp prop : this.dtoType.getDtoProps()) {
            this.addField((DtoProp<ImmutableType, ImmutableProp>)prop);
        }
        for (DtoProp prop : this.dtoType.getUserProps()) {
            this.addField((UserProp)prop);
        }
        this.addDefaultConstructor();
        if (!inputOnly) {
            this.addConverterConstructor();
            this.addOf();
        }
        this.addToEntity();
        for (DtoProp prop : this.dtoType.getDtoProps()) {
            if (!prop.isNewTarget() || prop.getTargetType() == null || prop.getTargetType().getName() != null) continue;
            new DtoGenerator((DtoType<ImmutableType, ImmutableProp>)prop.getTargetType(), null, this, DtoGenerator.targetSimpleName((DtoProp<ImmutableType, ImmutableProp>)prop)).generate();
        }
    }

    private void addMetadata() {
        FieldSpec.Builder builder = FieldSpec.builder((TypeName)ParameterizedTypeName.get((ClassName)Constants.VIEW_METADATA_CLASS_NAME, (TypeName[])new TypeName[]{((ImmutableType)this.dtoType.getBaseType()).getClassName(), this.getDtoClassName(new String[0])}), (String)"METADATA", (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC, Modifier.FINAL});
        CodeBlock.Builder cb = CodeBlock.builder().indent().add("\n", new Object[0]).add("new $T<$T, $T>(\n", new Object[]{Constants.VIEW_METADATA_CLASS_NAME, ((ImmutableType)this.dtoType.getBaseType()).getClassName(), this.getDtoClassName(new String[0])}).indent().add("$T.$L", new Object[]{((ImmutableType)this.dtoType.getBaseType()).getFetcherClassName(), "$"}).indent();
        for (DtoProp prop : this.dtoType.getDtoProps()) {
            if (prop.getNextProp() != null) continue;
            this.addFetcherField((DtoProp<ImmutableType, ImmutableProp>)prop, cb);
        }
        for (DtoProp hiddenProp : this.dtoType.getHiddenFlatProps()) {
            this.addHiddenFetcherField((DtoProp<ImmutableType, ImmutableProp>)hiddenProp, cb);
        }
        cb.add(",\n", new Object[0]).unindent().add("$T::new\n", new Object[]{this.getDtoClassName(new String[0])}).unindent().unindent().add(")", new Object[0]);
        builder.initializer(cb.build());
        this.typeBuilder.addField(builder.build());
    }

    private void addFetcherField(DtoProp<ImmutableType, ImmutableProp> prop, CodeBlock.Builder cb) {
        if (((ImmutableProp)prop.getBaseProp()).getAnnotation(Id.class) == null) {
            if (prop.getTargetType() != null) {
                if (prop.isNewTarget()) {
                    cb.add("\n.$N($T.METADATA.getFetcher()", new Object[]{((ImmutableProp)prop.getBaseProp()).getName(), this.getPropElementName(prop)});
                    if (prop.isRecursive()) {
                        cb.add(", $T::recursive", new Object[]{Constants.RECURSIVE_FIELD_CONFIG_CLASS_NAME});
                    }
                    cb.add(")", new Object[0]);
                }
            } else {
                cb.add("\n.$N()", new Object[]{((ImmutableProp)prop.getBaseProp()).getName()});
            }
        }
    }

    private void addHiddenFetcherField(DtoProp<ImmutableType, ImmutableProp> prop, CodeBlock.Builder cb) {
        if (!"flat".equals(prop.getFuncName())) {
            this.addFetcherField(prop, cb);
            return;
        }
        DtoType targetDtoType = prop.getTargetType();
        assert (targetDtoType != null);
        cb.add("\n.$N($>", new Object[]{((ImmutableProp)prop.getBaseProp()).getName()});
        cb.add("$T.$L$>", new Object[]{((ImmutableProp)prop.getBaseProp()).getTargetType().getFetcherClassName(), "$"});
        for (DtoProp childProp : targetDtoType.getDtoProps()) {
            this.addHiddenFetcherField((DtoProp<ImmutableType, ImmutableProp>)childProp, cb);
        }
        cb.add("$<$<\n)", new Object[0]);
    }

    private void addField(DtoProp<ImmutableType, ImmutableProp> prop) {
        TypeName typeName = this.getPropTypeName(prop);
        FieldSpec.Builder builder = FieldSpec.builder((TypeName)typeName, (String)prop.getName(), (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PRIVATE});
        if (!typeName.isPrimitive()) {
            if (prop.isNullable()) {
                builder.addAnnotation(Nullable.class);
            } else {
                builder.addAnnotation(org.jetbrains.annotations.NotNull.class);
            }
        }
        if (prop.getAnnotations().isEmpty()) {
            for (AnnotationMirror annotationMirror : ((ImmutableProp)prop.getBaseProp()).getAnnotations()) {
                if (!DtoGenerator.isCopyableAnnotation(annotationMirror, false)) continue;
                builder.addAnnotation(AnnotationSpec.get((AnnotationMirror)annotationMirror));
            }
        } else {
            for (Anno anno : prop.getAnnotations()) {
                builder.addAnnotation(DtoGenerator.annotationOf(anno));
            }
        }
        this.typeBuilder.addField(builder.build());
    }

    private void addField(UserProp prop) {
        TypeName typeName = this.getTypeName(prop.getTypeRef());
        FieldSpec.Builder builder = FieldSpec.builder((TypeName)typeName, (String)prop.getAlias(), (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PRIVATE});
        for (Anno anno : prop.getAnnotations()) {
            builder.addAnnotation(DtoGenerator.annotationOf(anno));
        }
        if (!typeName.isPrimitive()) {
            if (prop.getTypeRef().isNullable()) {
                builder.addAnnotation(Nullable.class);
            } else {
                builder.addAnnotation(org.jetbrains.annotations.NotNull.class);
            }
        }
        this.typeBuilder.addField(builder.build());
    }

    private void addOf() {
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)"of").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC}).addParameter(ParameterSpec.builder((TypeName)((ImmutableType)this.dtoType.getBaseType()).getClassName(), (String)"base", (Modifier[])new Modifier[0]).addAnnotation(org.jetbrains.annotations.NotNull.class).build()).returns((TypeName)this.getDtoClassName(new String[0])).addCode("return new $T(base);", new Object[]{this.getDtoClassName(new String[0])});
        this.typeBuilder.addMethod(builder.build());
    }

    private void addDefaultConstructor() {
        MethodSpec.Builder builder = MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC});
        this.typeBuilder.addMethod(builder.build());
    }

    private void addConverterConstructor() {
        MethodSpec.Builder builder = MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(ParameterSpec.builder((TypeName)((ImmutableType)this.dtoType.getBaseType()).getClassName(), (String)"base", (Modifier[])new Modifier[0]).addAnnotation(org.jetbrains.annotations.NotNull.class).build());
        if (this.dtoType.getDtoProps().stream().anyMatch(it -> it.isNullable() || it.getNextProp() != null)) {
            builder.addStatement("$T spi = ($T)base", new Object[]{ImmutableSpi.class, ImmutableSpi.class});
        }
        for (DtoProp prop : this.dtoType.getDtoProps()) {
            if (prop.getNextProp() != null) {
                builder.addCode("this.$L = $T.get(\n$>spi,\n", new Object[]{prop.getName(), Constants.FLAT_UTILS_CLASS_NAME});
                builder.addCode("new int[] {$>\n", new Object[0]);
                for (DtoProp p = prop; p != null; p = p.getNextProp()) {
                    builder.addCode("$T.$N", new Object[]{((ImmutableProp)p.getBaseProp()).getDeclaringType().getProducerClassName(), ((ImmutableProp)p.getBaseProp()).getSlotName()});
                    if (p.getNextProp() != null) {
                        builder.addCode(",\n", new Object[0]);
                        continue;
                    }
                    builder.addCode("\n", new Object[0]);
                }
                builder.addCode("$<},\n", new Object[0]);
                if (prop.getTargetType() != null) {
                    builder.addCode("it -> new $T(($T)it)\n", new Object[]{this.getPropTypeName((DtoProp<ImmutableType, ImmutableProp>)prop), ((ImmutableProp)prop.toTailProp().getBaseProp()).getTypeName()});
                } else {
                    builder.addCode("null\n", new Object[0]);
                }
                builder.addCode("$<);\n", new Object[0]);
                continue;
            }
            if (prop.isIdOnly()) {
                if (((ImmutableProp)prop.getBaseProp()).isList()) {
                    if (prop.isNullable()) {
                        builder.addStatement("this.$L = spi.__isLoaded($T.$L.unwrap().getId()) ? base.$L().stream().map($T::$L).collect($T.toList()) : $L", new Object[]{prop.getName(), ((ImmutableType)this.dtoType.getBaseType()).getPropsClassName(), Strings.upper(((ImmutableProp)prop.getBaseProp()).getName()), ((ImmutableProp)prop.getBaseProp()).getGetterName(), ((ImmutableProp)prop.getBaseProp()).getTargetType().getClassName(), ((ImmutableProp)prop.getBaseProp()).getTargetType().getIdProp().getName(), Collectors.class, DtoGenerator.defaultValue(prop)});
                        continue;
                    }
                    if (((ImmutableProp)prop.getBaseProp()).isNullable()) {
                        builder.addStatement("this.$L = $T.requireNonNull(base.$L(), $S).stream().map($T::$L).collect($T.toList())", new Object[]{Objects.class, prop.getName(), "\"`base." + ((ImmutableProp)prop.getBaseProp()).getGetterName() + "()` cannot be null\"", ((ImmutableProp)prop.getBaseProp()).getGetterName(), ((ImmutableProp)prop.getBaseProp()).getTargetType().getClassName(), ((ImmutableProp)prop.getBaseProp()).getTargetType().getIdProp().getName(), Collectors.class});
                        continue;
                    }
                    builder.addStatement("this.$L = base.$L().stream().map($T::$L).collect($T.toList())", new Object[]{prop.getName(), ((ImmutableProp)prop.getBaseProp()).getGetterName(), ((ImmutableProp)prop.getBaseProp()).getTargetType().getClassName(), ((ImmutableProp)prop.getBaseProp()).getTargetType().getIdProp().getName(), Collectors.class});
                    continue;
                }
                if (prop.isNullable()) {
                    builder.addStatement("$T _tmp_$L = spi.__isLoaded($T.$L.unwrap().getId()) ? base.$L() : null", new Object[]{((ImmutableProp)prop.getBaseProp()).getTypeName(), ((ImmutableProp)prop.getBaseProp()).getName(), ((ImmutableType)this.dtoType.getBaseType()).getPropsClassName(), Strings.upper(((ImmutableProp)prop.getBaseProp()).getName()), ((ImmutableProp)prop.getBaseProp()).getGetterName()});
                } else if (((ImmutableProp)prop.getBaseProp()).isNullable()) {
                    builder.addStatement("$T _tmp_$L = $T.requireNonNull(base.$L(), $S)", new Object[]{((ImmutableProp)prop.getBaseProp()).getTypeName(), ((ImmutableProp)prop.getBaseProp()).getName(), Objects.class, ((ImmutableProp)prop.getBaseProp()).getGetterName(), "\"`base." + ((ImmutableProp)prop.getBaseProp()).getGetterName() + "()` cannot be null\""});
                } else {
                    builder.addStatement("$T _tmp_$L = base.$L()", new Object[]{((ImmutableProp)prop.getBaseProp()).getTypeName(), ((ImmutableProp)prop.getBaseProp()).getName(), ((ImmutableProp)prop.getBaseProp()).getGetterName()});
                }
                if (prop.isNullable()) {
                    builder.addStatement("this.$L = _tmp_$L != null ? _tmp_$L.$L() : null", new Object[]{prop.getName(), ((ImmutableProp)prop.getBaseProp()).getName(), ((ImmutableProp)prop.getBaseProp()).getName(), ((ImmutableProp)prop.getBaseProp()).getTargetType().getIdProp().getGetterName()});
                    continue;
                }
                builder.addStatement("this.$L = _tmp_$L.$L()", new Object[]{prop.getName(), ((ImmutableProp)prop.getBaseProp()).getName(), ((ImmutableProp)prop.getBaseProp()).getTargetType().getIdProp().getGetterName()});
                continue;
            }
            if (prop.getTargetType() != null) {
                if (((ImmutableProp)prop.getBaseProp()).isList()) {
                    if (prop.isNullable()) {
                        builder.addStatement("this.$L = spi.__isLoaded($T.$L.unwrap().getId()) ? base.$L().stream().map($T::new).collect($T.toList()) : $L", new Object[]{prop.getName(), ((ImmutableType)this.dtoType.getBaseType()).getPropsClassName(), Strings.upper(((ImmutableProp)prop.getBaseProp()).getName()), ((ImmutableProp)prop.getBaseProp()).getGetterName(), this.getPropElementName((DtoProp<ImmutableType, ImmutableProp>)prop), Collectors.class, DtoGenerator.defaultValue(prop)});
                        continue;
                    }
                    if (((ImmutableProp)prop.getBaseProp()).isNullable()) {
                        builder.addStatement("this.$L = $T.requireNonNull(base.$L(), $S).stream().map($T::new).collect($T.toList())", new Object[]{prop.getName(), Objects.class, ((ImmutableProp)prop.getBaseProp()).getGetterName(), "\"`base." + ((ImmutableProp)prop.getBaseProp()).getGetterName() + "()` cannot be null\"", this.getPropElementName((DtoProp<ImmutableType, ImmutableProp>)prop), Collectors.class});
                        continue;
                    }
                    builder.addStatement("this.$L = base.$L().stream().map($T::new).collect($T.toList())", new Object[]{prop.getName(), ((ImmutableProp)prop.getBaseProp()).getGetterName(), this.getPropElementName((DtoProp<ImmutableType, ImmutableProp>)prop), Collectors.class});
                    continue;
                }
                if (prop.isNullable()) {
                    builder.addStatement("$T _tmp_$L = spi.__isLoaded($T.$L.unwrap().getId()) ? base.$L() : null", new Object[]{((ImmutableProp)prop.getBaseProp()).getTypeName(), ((ImmutableProp)prop.getBaseProp()).getName(), ((ImmutableType)this.dtoType.getBaseType()).getPropsClassName(), Strings.upper(((ImmutableProp)prop.getBaseProp()).getName()), ((ImmutableProp)prop.getBaseProp()).getGetterName()});
                } else if (((ImmutableProp)prop.getBaseProp()).isNullable()) {
                    builder.addStatement("$T _tmp_$L = $T.requireNonNull(base.$L(), $L)", new Object[]{((ImmutableProp)prop.getBaseProp()).getTypeName(), ((ImmutableProp)prop.getBaseProp()).getName(), Objects.class, ((ImmutableProp)prop.getBaseProp()).getGetterName(), "\"`base." + ((ImmutableProp)prop.getBaseProp()).getGetterName() + "()` cannot be null\""});
                } else {
                    builder.addStatement("$T _tmp_$L = base.$L()", new Object[]{((ImmutableProp)prop.getBaseProp()).getTypeName(), ((ImmutableProp)prop.getBaseProp()).getName(), ((ImmutableProp)prop.getBaseProp()).getGetterName()});
                }
                if (prop.isNullable()) {
                    builder.addStatement("this.$L = _tmp_$L != null ? new $T(_tmp_$L) : null", new Object[]{prop.getName(), ((ImmutableProp)prop.getBaseProp()).getName(), this.getPropElementName((DtoProp<ImmutableType, ImmutableProp>)prop), ((ImmutableProp)prop.getBaseProp()).getName()});
                    continue;
                }
                builder.addStatement("this.$L = new $T(_tmp_$L)", new Object[]{prop.getName(), this.getPropElementName((DtoProp<ImmutableType, ImmutableProp>)prop), ((ImmutableProp)prop.getBaseProp()).getName()});
                continue;
            }
            if (prop.isNullable()) {
                builder.addStatement("this.$L = spi.__isLoaded($T.$L.unwrap().getId()) ? base.$L() : $L", new Object[]{prop.getName(), ((ImmutableType)this.dtoType.getBaseType()).getPropsClassName(), Strings.upper(((ImmutableProp)prop.getBaseProp()).getName()), ((ImmutableProp)prop.getBaseProp()).getGetterName(), DtoGenerator.defaultValue(prop)});
                continue;
            }
            builder.addStatement("this.$L = base.$L()", new Object[]{prop.getName(), ((ImmutableProp)prop.getBaseProp()).getGetterName()});
        }
        this.typeBuilder.addMethod(builder.build());
    }

    private void addToEntity() {
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)"toEntity").addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Override.class).returns((TypeName)((ImmutableType)this.dtoType.getBaseType()).getClassName());
        builder.addCode("return $T.$L.produce(draft -> {$>\n", new Object[]{((ImmutableType)this.dtoType.getBaseType()).getDraftClassName(), "$"});
        for (DtoProp prop : this.dtoType.getDtoProps()) {
            if (prop.getNextProp() != null) {
                builder.addCode("$T.set(\n$>", new Object[]{Constants.FLAT_UTILS_CLASS_NAME});
                builder.addCode("draft,\n", new Object[0]);
                builder.addCode("new int[] {\n$>", new Object[0]);
                for (DtoProp p = prop; p != null; p = p.getNextProp()) {
                    builder.addCode("$T.$N", new Object[]{((ImmutableProp)p.getBaseProp()).getDeclaringType().getProducerClassName(), ((ImmutableProp)p.getBaseProp()).getSlotName()});
                    if (p.getNextProp() != null) {
                        builder.addCode(",\n", new Object[0]);
                        continue;
                    }
                    builder.addCode("\n", new Object[0]);
                }
                builder.addCode("$<},\n", new Object[0]);
                if (prop.getTargetType() == null) {
                    builder.addCode("this.$L\n", new Object[]{prop.getName()});
                } else {
                    builder.addCode("this.$L != null ? this.$L.toEntity() : null", new Object[]{prop.getName(), prop.getName()});
                }
                builder.addCode("$<);\n", new Object[0]);
                continue;
            }
            if (prop.isNullable() && (((ImmutableProp)prop.getBaseProp()).isAssociation(false) || !((ImmutableProp)prop.getBaseProp()).isNullable())) {
                builder.beginControlFlow("if ($L != null)", new Object[]{prop.getName()});
                this.addAssignment((DtoProp<ImmutableType, ImmutableProp>)prop, builder);
                if (((ImmutableProp)prop.getBaseProp()).isAssociation(true)) {
                    if (((ImmutableProp)prop.getBaseProp()).isList()) {
                        builder.nextControlFlow("else", new Object[0]);
                        builder.addStatement("draft.$L($T.emptyList())", new Object[]{((ImmutableProp)prop.getBaseProp()).getSetterName(), Constants.COLLECTIONS_CLASS_NAME});
                    } else if (((ImmutableProp)prop.getBaseProp()).isNullable()) {
                        builder.nextControlFlow("else", new Object[0]);
                        builder.addStatement("draft.$L(($T)null)", new Object[]{((ImmutableProp)prop.getBaseProp()).getSetterName(), ((ImmutableProp)prop.getBaseProp()).getTargetType().getClassName()});
                    }
                }
                builder.endControlFlow();
                continue;
            }
            this.addAssignment((DtoProp<ImmutableType, ImmutableProp>)prop, builder);
        }
        builder.addCode("$<});\n", new Object[0]);
        this.typeBuilder.addMethod(builder.build());
    }

    private void addAssignment(DtoProp<ImmutableType, ImmutableProp> prop, MethodSpec.Builder builder) {
        ImmutableProp immutableProp = (ImmutableProp)prop.getBaseProp();
        if (prop.isIdOnly()) {
            if (immutableProp.isList()) {
                builder.beginControlFlow("if ($L.isEmpty())", new Object[]{prop.getName()});
                builder.addStatement("draft.$L($T.emptyList())", new Object[]{immutableProp.getSetterName(), Collections.class});
                builder.nextControlFlow("else", new Object[0]);
                builder.beginControlFlow("for ($T __e : $L)", new Object[]{this.getPropElementName(prop), prop.getName()});
                builder.addStatement("draft.$L(targetDraft -> targetDraft.$L($L))", new Object[]{immutableProp.getAdderByName(), immutableProp.getTargetType().getIdProp().getSetterName(), "__e"});
                builder.endControlFlow();
                builder.endControlFlow();
            } else {
                builder.addStatement("draft.$L(targetDraft -> targetDraft.$L($L))", new Object[]{immutableProp.getApplierName(), immutableProp.getTargetType().getIdProp().getSetterName(), prop.getName()});
            }
        } else if (prop.getTargetType() != null) {
            if (immutableProp.isList()) {
                builder.beginControlFlow("if ($L.isEmpty())", new Object[]{prop.getName()});
                builder.addStatement("draft.$L($T.emptyList())", new Object[]{immutableProp.getSetterName(), Collections.class});
                builder.nextControlFlow("else", new Object[0]);
                builder.beginControlFlow("for ($T __e : $L)", new Object[]{this.getPropElementName(prop), prop.getName()});
                builder.addStatement("draft.$L(true).add(($T)__e.toEntity())", new Object[]{immutableProp.getGetterName(), immutableProp.getTargetType().getDraftClassName()});
                builder.endControlFlow();
                builder.endControlFlow();
            } else {
                builder.addStatement("draft.$L($L.toEntity())", new Object[]{immutableProp.getSetterName(), prop.getName()});
            }
        } else {
            builder.addStatement("draft.$L($L)", new Object[]{((ImmutableProp)prop.getBaseProp()).getSetterName(), prop.getName()});
        }
    }

    public TypeName getPropTypeName(DtoProp<ImmutableType, ImmutableProp> prop) {
        TypeName elementTypeName = this.getPropElementName(prop);
        return ((ImmutableProp)prop.toTailProp().getBaseProp()).isList() ? ParameterizedTypeName.get((ClassName)Constants.LIST_CLASS_NAME, (TypeName[])new TypeName[]{elementTypeName.isPrimitive() ? elementTypeName.box() : elementTypeName}) : elementTypeName;
    }

    public TypeName getTypeName(@Nullable TypeRef typeRef) {
        ClassName typeName;
        if (typeRef == null) {
            return WildcardTypeName.subtypeOf((TypeName)TypeName.OBJECT);
        }
        switch (typeRef.getTypeName()) {
            case "Boolean": {
                typeName = typeRef.isNullable() ? TypeName.BOOLEAN.box() : TypeName.BOOLEAN;
                break;
            }
            case "Char": {
                typeName = typeRef.isNullable() ? TypeName.CHAR.box() : TypeName.CHAR;
                break;
            }
            case "Byte": {
                typeName = typeRef.isNullable() ? TypeName.BYTE.box() : TypeName.BYTE;
                break;
            }
            case "Short": {
                typeName = typeRef.isNullable() ? TypeName.SHORT.box() : TypeName.SHORT;
                break;
            }
            case "Int": {
                typeName = typeRef.isNullable() ? TypeName.INT.box() : TypeName.INT;
                break;
            }
            case "Long": {
                typeName = typeRef.isNullable() ? TypeName.LONG.box() : TypeName.LONG;
                break;
            }
            case "Float": {
                typeName = typeRef.isNullable() ? TypeName.FLOAT.box() : TypeName.FLOAT;
                break;
            }
            case "Double": {
                typeName = typeRef.isNullable() ? TypeName.DOUBLE.box() : TypeName.DOUBLE;
                break;
            }
            case "Any": {
                typeName = TypeName.OBJECT;
                break;
            }
            case "String": {
                typeName = Constants.STRING_CLASS_NAME;
                break;
            }
            case "Array": {
                typeName = ArrayTypeName.of((TypeName)(((TypeRef.Argument)typeRef.getArguments().get(0)).getTypeRef() == null ? TypeName.OBJECT : this.getTypeName(((TypeRef.Argument)typeRef.getArguments().get(0)).getTypeRef())));
                break;
            }
            case "Iterable": 
            case "MutableIterable": {
                typeName = ClassName.get(Iterable.class);
                break;
            }
            case "Collection": 
            case "MutableCollection": {
                typeName = ClassName.get(Collection.class);
                break;
            }
            case "List": 
            case "MutableList": {
                typeName = ClassName.get(List.class);
                break;
            }
            case "Set": 
            case "MutableSet": {
                typeName = ClassName.get(Set.class);
                break;
            }
            case "Map": 
            case "MutableMap": {
                typeName = ClassName.get(Map.class);
                break;
            }
            default: {
                typeName = ClassName.bestGuess((String)typeRef.getTypeName());
            }
        }
        int argCount = typeRef.getArguments().size();
        if (argCount == 0 || typeName instanceof ArrayTypeName) {
            return typeName;
        }
        TypeName[] argTypeNames = new TypeName[argCount];
        for (int i = 0; i < argCount; ++i) {
            TypeRef.Argument arg = (TypeRef.Argument)typeRef.getArguments().get(i);
            TypeName argTypeName = this.getTypeName(arg.getTypeRef());
            if (arg.isIn()) {
                argTypeName = WildcardTypeName.supertypeOf((TypeName)argTypeName);
            } else if (arg.getTypeRef() != null && (arg.isOut() || DtoGenerator.isForceOut(typeRef.getTypeName()))) {
                argTypeName = WildcardTypeName.subtypeOf((TypeName)argTypeName);
            }
            argTypeNames[i] = argTypeName;
        }
        return ParameterizedTypeName.get((ClassName)typeName, (TypeName[])argTypeNames);
    }

    public TypeName getPropElementName(DtoProp<ImmutableType, ImmutableProp> prop) {
        TypeName typeName;
        DtoProp tailProp = prop.toTailProp();
        DtoType targetType = tailProp.getTargetType();
        if (targetType != null) {
            if (targetType.getName() == null) {
                ArrayList<String> list = new ArrayList<String>();
                this.collectNames(list);
                if (tailProp.isNewTarget()) {
                    list.add(DtoGenerator.targetSimpleName((DtoProp<ImmutableType, ImmutableProp>)tailProp));
                }
                return ClassName.get((String)this.getPackageName(), (String)((String)list.get(0)), (String[])list.subList(1, list.size()).toArray(EMPTY_STR_ARR));
            }
            return ClassName.get((String)this.getPackageName(), (String)targetType.getName(), (String[])new String[0]);
        }
        TypeName typeName2 = typeName = tailProp.isIdOnly() ? ((ImmutableProp)tailProp.getBaseProp()).getTargetType().getIdProp().getTypeName() : ((ImmutableProp)tailProp.getBaseProp()).getTypeName();
        if (typeName.isPrimitive() && prop.isNullable()) {
            return typeName.box();
        }
        return typeName;
    }

    private void collectNames(List<String> list) {
        if (this.parent == null) {
            list.add(this.dtoType.getName());
        } else {
            this.parent.collectNames(list);
            list.add(this.innerClassName);
        }
    }

    private static String targetSimpleName(DtoProp<ImmutableType, ImmutableProp> prop) {
        DtoType targetType = prop.getTargetType();
        if (targetType == null) {
            throw new IllegalArgumentException("prop is not association");
        }
        if (targetType.getName() != null) {
            return targetType.getName();
        }
        return "TargetOf_" + prop.getName();
    }

    private static boolean isCopyableAnnotation(AnnotationMirror annotationMirror, boolean forMethod) {
        Target target = annotationMirror.getAnnotationType().asElement().getAnnotation(Target.class);
        if (target != null) {
            boolean acceptField = Arrays.stream(target.value()).anyMatch(it -> it == ElementType.FIELD);
            boolean acceptMethod = Arrays.stream(target.value()).anyMatch(it -> it == ElementType.METHOD);
            if (forMethod ? acceptMethod && !acceptField : acceptField) {
                String qualifiedName = ((TypeElement)annotationMirror.getAnnotationType().asElement()).getQualifiedName().toString();
                return !qualifiedName.equals(org.jetbrains.annotations.NotNull.class.getName()) && !qualifiedName.equals(NotNull.class.getName()) && !qualifiedName.equals(Nullable.class.getName()) && !qualifiedName.equals(Null.class.getName()) && (!qualifiedName.startsWith("org.babyfish.jimmer.") || qualifiedName.startsWith("org.babyfish.jimmer.client."));
            }
        }
        return false;
    }

    private static AnnotationSpec annotationOf(Anno anno) {
        AnnotationSpec.Builder builder = AnnotationSpec.builder((ClassName)ClassName.bestGuess((String)anno.getQualifiedName()));
        for (Map.Entry e : anno.getValueMap().entrySet()) {
            String name = (String)e.getKey();
            Anno.Value value = (Anno.Value)e.getValue();
            builder.addMember(name, DtoGenerator.codeBlockOf(value));
        }
        return builder.build();
    }

    private static CodeBlock codeBlockOf(Anno.Value value) {
        CodeBlock.Builder builder = CodeBlock.builder();
        if (value instanceof Anno.ArrayValue) {
            builder.add("{\n$>", new Object[0]);
            boolean addSeparator = false;
            for (Anno.Value element : ((Anno.ArrayValue)value).elements) {
                if (addSeparator) {
                    builder.add(", \n", new Object[0]);
                } else {
                    addSeparator = true;
                }
                builder.add("$L", new Object[]{DtoGenerator.codeBlockOf(element)});
            }
            builder.add("$<\n}", new Object[0]);
        } else if (value instanceof Anno.AnnoValue) {
            builder.add("$L", new Object[]{DtoGenerator.annotationOf(((Anno.AnnoValue)value).anno)});
        } else if (value instanceof Anno.EnumValue) {
            builder.add("$T.$L", new Object[]{ClassName.bestGuess((String)((Anno.EnumValue)value).qualifiedName), ((Anno.EnumValue)value).constant});
        } else if (value instanceof Anno.LiteralValue) {
            builder.add(((Anno.LiteralValue)value).value, new Object[0]);
        }
        return builder.build();
    }

    private static boolean isForceOut(String typeName) {
        switch (typeName) {
            case "Iterable": 
            case "Collection": 
            case "List": 
            case "Set": 
            case "Map": {
                return true;
            }
        }
        return false;
    }

    private static String defaultValue(DtoProp<?, ImmutableProp> prop) {
        TypeName typeName = ((ImmutableProp)prop.getBaseProp()).getTypeName();
        return DtoGenerator.defaultValue(typeName);
    }

    private static String defaultValue(TypeName typeName) {
        if (typeName.isPrimitive()) {
            if (typeName.equals((Object)TypeName.BOOLEAN)) {
                return "false";
            }
            if (typeName.equals((Object)TypeName.CHAR)) {
                return "'\u0000'";
            }
            return "0";
        }
        return "null";
    }
}

