/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.apt;

import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;

public class MetaException
extends RuntimeException {
    private final Element element;

    public MetaException(Element element, String reason) {
        super(MetaException.message(element, reason));
        this.element = element;
    }

    public MetaException(Element element, String reason, Throwable cause) {
        super(MetaException.message(element, reason), cause);
        this.element = element;
    }

    public Element getElement() {
        return this.element;
    }

    private static String message(Element element, String reason) {
        if (element instanceof TypeElement) {
            return "Illegal type \"" + ((TypeElement)element).getQualifiedName().toString() + "\", " + MetaException.lowerFirstChar(reason);
        }
        if (element instanceof ExecutableElement) {
            return "Illegal property \"" + ((TypeElement)element.getEnclosingElement()).getQualifiedName() + '.' + element.getSimpleName().toString() + "\", " + MetaException.lowerFirstChar(reason);
        }
        return reason;
    }

    private static String lowerFirstChar(String reason) {
        int whitespaceCount;
        for (whitespaceCount = 0; whitespaceCount < reason.length() && Character.isWhitespace(reason.charAt(whitespaceCount)); ++whitespaceCount) {
        }
        if (whitespaceCount != 0) {
            reason = reason.substring(whitespaceCount);
        }
        if (reason.isEmpty()) {
            return reason;
        }
        if (Character.isUpperCase(reason.charAt(0))) {
            return Character.toLowerCase(reason.charAt(0)) + reason.substring(1);
        }
        return reason;
    }
}

