/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.apt.immutable.generator;

import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.io.IOException;
import java.util.Iterator;
import javax.annotation.processing.Filer;
import javax.lang.model.element.Modifier;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import org.babyfish.jimmer.apt.Context;
import org.babyfish.jimmer.apt.GeneratorException;
import org.babyfish.jimmer.apt.immutable.generator.Constants;
import org.babyfish.jimmer.apt.immutable.generator.Strings;
import org.babyfish.jimmer.apt.immutable.meta.ImmutableProp;
import org.babyfish.jimmer.apt.immutable.meta.ImmutableType;
import org.babyfish.jimmer.impl.util.StringUtil;

public class PropsGenerator {
    private final Context context;
    private final ImmutableType type;
    private final Filer filer;
    private TypeSpec.Builder typeBuilder;

    public PropsGenerator(Context context, ImmutableType type, Filer filer) {
        this.context = context;
        this.type = type;
        this.filer = filer;
    }

    public void generate() {
        try {
            JavaFile.builder((String)this.type.getPackageName(), (TypeSpec)this.generateImpl()).indent("    ").build().writeTo(this.filer);
        }
        catch (IOException ex) {
            throw new GeneratorException(String.format("Cannot generate props class for '%s'", this.type.getName()), ex);
        }
    }

    private TypeSpec generateImpl() {
        this.typeBuilder = TypeSpec.interfaceBuilder((String)(this.type.getName() + "Props")).addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(AnnotationSpec.builder((ClassName)Constants.GENERATED_BY_CLASS_NAME).addMember("type", "$T.class", new Object[]{this.type.getClassName()}).build());
        if (this.type.isEntity() || this.type.isMappedSuperClass()) {
            this.typeBuilder.addAnnotation(AnnotationSpec.builder((ClassName)Constants.PROPS_FOR_CLASS_NAME).addMember("value", "$T.class", new Object[]{this.type.getClassName()}).build());
        }
        if (this.type.getSuperTypes().isEmpty()) {
            if (this.type.isEntity() || this.type.isMappedSuperClass()) {
                this.typeBuilder.addSuperinterface((TypeName)Constants.PROPS_CLASS_NAME);
            }
        } else {
            for (ImmutableType superType : this.type.getSuperTypes()) {
                this.typeBuilder.addSuperinterface((TypeName)superType.getPropsClassName());
            }
        }
        try {
            for (ImmutableProp prop : this.type.getProps().values()) {
                this.addStaticProp(prop);
            }
            if (this.type.isEntity() || this.type.isMappedSuperClass()) {
                for (ImmutableProp prop : this.type.getDeclaredProps().values()) {
                    if (prop.isDsl(false)) {
                        this.addProp(prop, false);
                        this.addProp(prop, true);
                    }
                    this.addExists(prop);
                    this.addIdProp(prop, this.type.getIdPropName(prop.getName()));
                }
            }
            Iterator<Object> iterator = this.typeBuilder.build();
            return iterator;
        }
        finally {
            this.typeBuilder = null;
        }
    }

    private void addStaticProp(ImmutableProp prop) {
        String action;
        ClassName rawClassName;
        if (prop.isList()) {
            rawClassName = prop.isAssociation(false) ? Constants.REFERENCE_LIST_CLASS_NAME : Constants.SCALAR_LIST_CLASS_NAME;
            action = prop.isAssociation(false) ? "referenceList" : "scalarList";
        } else {
            rawClassName = prop.isAssociation(false) ? Constants.REFERENCE_CLASS_NAME : Constants.SCALAR_CLASS_NAME;
            action = prop.isAssociation(false) ? "reference" : "scalar";
        }
        String fieldName = Strings.upper(prop.getName());
        FieldSpec.Builder builder = FieldSpec.builder((TypeName)ParameterizedTypeName.get((ClassName)rawClassName, (TypeName[])new TypeName[]{this.type.getClassName(), prop.getElementTypeName().box()}), (String)fieldName, (Modifier[])new Modifier[]{Modifier.PUBLIC, Modifier.STATIC, Modifier.FINAL}).initializer("\n    $T.$L($T.get($T.class).getProp($S))", new Object[]{Constants.TYPED_PROP_CLASS_NAME, action, Constants.RUNTIME_TYPE_CLASS_NAME, this.type.getClassName(), prop.getName()});
        this.typeBuilder.addField(builder.build());
    }

    private void addProp(ImmutableProp prop, boolean withJoinType) {
        MethodSpec propertyMethod = PropsGenerator.property(this.context, false, prop, withJoinType, false);
        if (propertyMethod != null) {
            this.typeBuilder.addMethod(propertyMethod);
        }
    }

    private void addExists(ImmutableProp prop) {
        MethodSpec existsMethod = PropsGenerator.exists(prop, false);
        if (existsMethod != null) {
            this.typeBuilder.addMethod(existsMethod);
        }
    }

    private void addIdProp(ImmutableProp prop, String idPropName) {
        MethodSpec method = PropsGenerator.associatedIdProperty(this.context, false, prop, idPropName, false);
        if (method != null) {
            this.typeBuilder.addMethod(method);
        }
    }

    static MethodSpec property(Context context, boolean isTableEx, ImmutableProp prop, boolean withJoinType, boolean withImplementation) {
        return PropsGenerator.property(context, isTableEx, prop, withJoinType, withImplementation, false);
    }

    static MethodSpec property(Context context, boolean isTableEx, ImmutableProp prop, boolean withJoinType, boolean withImplementation, boolean ignoreOverride) {
        if (withJoinType && !prop.isAssociation(true)) {
            return null;
        }
        TypeName returnType = PropsGenerator.returnTypeName(context, isTableEx, prop);
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)prop.getName()).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(returnType);
        if (withImplementation) {
            if (!isTableEx && !ignoreOverride) {
                builder.addAnnotation(Override.class);
            }
        } else {
            builder.addModifiers(new Modifier[]{Modifier.ABSTRACT});
        }
        if (withJoinType) {
            builder.addParameter((TypeName)Constants.JOIN_TYPE_CLASS_NAME, "joinType", new Modifier[0]);
        }
        if (withImplementation) {
            if (prop.isAssociation(true)) {
                builder.addStatement("__beforeJoin()", new Object[0]);
                if (withJoinType) {
                    builder.beginControlFlow("if (raw != null)", new Object[0]).addStatement("return new $T(raw.joinImplementor($T.$L.unwrap(), joinType))", new Object[]{returnType, prop.getDeclaringType().getPropsClassName(), Strings.upper(prop.getName())}).endControlFlow().addStatement("return new $T(joinOperation($T.$L.unwrap(), joinType))", new Object[]{returnType, prop.getDeclaringType().getPropsClassName(), Strings.upper(prop.getName())});
                } else {
                    builder.beginControlFlow("if (raw != null)", new Object[0]).addStatement("return new $T(raw.joinImplementor($T.$L.unwrap()))", new Object[]{returnType, prop.getDeclaringType().getPropsClassName(), Strings.upper(prop.getName())}).endControlFlow().addStatement("return new $T(joinOperation($T.$L.unwrap()))", new Object[]{returnType, prop.getDeclaringType().getPropsClassName(), Strings.upper(prop.getName())});
                }
            } else if (prop.isAssociation(false)) {
                builder.addStatement("return new $T(__get($T.$L.unwrap()))", new Object[]{returnType, prop.getDeclaringType().getPropsClassName(), Strings.upper(prop.getName())});
            } else {
                builder.addStatement("return __get($T.$L.unwrap())", new Object[]{prop.getDeclaringType().getPropsClassName(), Strings.upper(prop.getName())});
            }
        }
        return builder.build();
    }

    static TypeName returnTypeName(Context context, boolean isTableEx, ImmutableProp prop) {
        ClassName returnType;
        if (prop.isAssociation(true)) {
            returnType = prop.isRemote() ? context.getImmutableType(prop.getElementType()).getRemoteTableClassName() : (isTableEx ? context.getImmutableType(prop.getElementType()).getTableExClassName() : context.getImmutableType(prop.getElementType()).getTableClassName());
        } else if (prop.isAssociation(false)) {
            ClassName className = (ClassName)prop.getTypeName();
            returnType = ClassName.get((String)className.packageName(), (String)(className.simpleName() + "PropExpression"), (String[])new String[0]);
        } else {
            returnType = PropsGenerator.propExpressionTypeName(prop.getReturnType(), context);
        }
        return returnType;
    }

    static MethodSpec associatedIdProperty(Context context, boolean isTableEx, ImmutableProp prop, String idPropName, boolean withImplementation) {
        if (idPropName == null) {
            return null;
        }
        if (prop.isTransient() || !prop.isAssociation(true) || prop.isList() != isTableEx) {
            return null;
        }
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)idPropName).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(PropsGenerator.propExpressionTypeName(prop.getTargetType().getIdProp().getReturnType(), context));
        if (withImplementation) {
            if (!isTableEx) {
                builder.addAnnotation(Override.class);
            }
        } else {
            builder.addModifiers(new Modifier[]{Modifier.ABSTRACT});
        }
        if (withImplementation) {
            builder.addStatement("return __getAssociatedId($T.$L.unwrap())", new Object[]{prop.getDeclaringType().getPropsClassName(), Strings.upper(prop.getName())});
        }
        return builder.build();
    }

    private static TypeName propExpressionTypeName(TypeMirror typeMirror, Context context) {
        TypeName typeName = TypeName.get((TypeMirror)typeMirror);
        if (typeMirror.getKind().isPrimitive() && typeMirror.getKind() != TypeKind.BOOLEAN) {
            return ParameterizedTypeName.get((ClassName)Constants.PROP_NUMERIC_EXPRESSION_CLASS_NAME, (TypeName[])new TypeName[]{typeName.box()});
        }
        if (typeName.equals((Object)Constants.STRING_CLASS_NAME)) {
            return Constants.PROP_STRING_EXPRESSION_CLASS_NAME;
        }
        if (context.isNumber(typeMirror)) {
            return ParameterizedTypeName.get((ClassName)Constants.PROP_NUMERIC_EXPRESSION_CLASS_NAME, (TypeName[])new TypeName[]{typeName.box()});
        }
        if (context.isComparable(typeMirror)) {
            return ParameterizedTypeName.get((ClassName)Constants.PROP_COMPARABLE_EXPRESSION_CLASS_NAME, (TypeName[])new TypeName[]{typeName.box()});
        }
        return ParameterizedTypeName.get((ClassName)Constants.PROP_EXPRESSION_CLASS_NAME, (TypeName[])new TypeName[]{typeName.box()});
    }

    static MethodSpec exists(ImmutableProp prop, boolean withImplementation) {
        if (!prop.isAssociation(true) || !prop.isList()) {
            return null;
        }
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)prop.getName()).addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter((TypeName)ParameterizedTypeName.get((ClassName)Constants.FUNCTION_CLASS_NAME, (TypeName[])new TypeName[]{prop.getTargetType().getTableExClassName(), Constants.PREDICATE_CLASS_NAME}), "block", new Modifier[0]).returns((TypeName)Constants.PREDICATE_CLASS_NAME);
        if (withImplementation) {
            builder.addAnnotation(Override.class);
        } else {
            builder.addModifiers(new Modifier[]{Modifier.ABSTRACT});
        }
        if (withImplementation) {
            builder.addStatement("return exists($T.$L.unwrap(), block)", new Object[]{prop.getDeclaringType().getPropsClassName(), StringUtil.snake((String)prop.getName(), (StringUtil.SnakeCase)StringUtil.SnakeCase.UPPER)});
        }
        return builder.build();
    }
}

