/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.apt.entry;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.io.IOException;
import java.util.Collection;
import javax.annotation.processing.Filer;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import org.babyfish.jimmer.apt.GeneratorException;
import org.babyfish.jimmer.apt.entry.AbstractSummaryGenerator;
import org.babyfish.jimmer.apt.util.ClassNames;
import org.babyfish.jimmer.impl.util.StringUtil;

public class FetchersGenerator
extends AbstractSummaryGenerator {
    private final String packageName;
    private final String simpleName;
    private final Collection<TypeElement> typeElements;
    private final Filer filer;

    public FetchersGenerator(String packageName, String simpleName, Collection<TypeElement> typeElements, Filer filer) {
        this.packageName = packageName;
        this.simpleName = simpleName;
        this.typeElements = typeElements;
        this.filer = filer;
    }

    public void generate() {
        TypeSpec typeSpec = this.typeSpec();
        try {
            JavaFile.builder((String)this.packageName, (TypeSpec)typeSpec).indent("    ").build().writeTo(this.filer);
        }
        catch (IOException ex) {
            throw new GeneratorException(String.format("Cannot generate draft interface for '%s'", this.packageName + '.' + this.simpleName), ex);
        }
    }

    private TypeSpec typeSpec() {
        TypeSpec.Builder builder = TypeSpec.interfaceBuilder((ClassName)ClassName.get((String)this.packageName, (String)this.simpleName, (String[])new String[0])).addModifiers(new Modifier[]{Modifier.PUBLIC});
        for (TypeElement typeElement : this.typeElements) {
            builder.addField(this.field(typeElement));
        }
        return builder.build();
    }

    private FieldSpec field(TypeElement typeElement) {
        ClassName fetcherClassName = ClassNames.of(typeElement, name -> name + "Fetcher");
        return FieldSpec.builder((TypeName)fetcherClassName, (String)this.distinctName(StringUtil.snake((String)(typeElement.getSimpleName().toString() + "Fetcher"), (StringUtil.SnakeCase)StringUtil.SnakeCase.UPPER)), (Modifier[])new Modifier[]{Modifier.PUBLIC, Modifier.STATIC, Modifier.FINAL}).initializer("$T.$$", new Object[]{fetcherClassName}).build();
    }
}

