/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.apt.dto;

import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ArrayTypeName;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import com.squareup.javapoet.WildcardTypeName;
import java.io.IOException;
import java.lang.annotation.ElementType;
import java.lang.annotation.Target;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.processing.Filer;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import org.babyfish.jimmer.apt.Context;
import org.babyfish.jimmer.apt.GeneratorException;
import org.babyfish.jimmer.apt.dto.DtoException;
import org.babyfish.jimmer.apt.dto.DtoInterfaces;
import org.babyfish.jimmer.apt.immutable.generator.Annotations;
import org.babyfish.jimmer.apt.immutable.generator.Constants;
import org.babyfish.jimmer.apt.immutable.meta.ImmutableProp;
import org.babyfish.jimmer.apt.immutable.meta.ImmutableType;
import org.babyfish.jimmer.apt.util.ConverterMetadata;
import org.babyfish.jimmer.client.meta.Doc;
import org.babyfish.jimmer.dto.compiler.AbstractProp;
import org.babyfish.jimmer.dto.compiler.Anno;
import org.babyfish.jimmer.dto.compiler.DtoProp;
import org.babyfish.jimmer.dto.compiler.DtoType;
import org.babyfish.jimmer.dto.compiler.DtoTypeModifier;
import org.babyfish.jimmer.dto.compiler.EnumType;
import org.babyfish.jimmer.dto.compiler.LikeOption;
import org.babyfish.jimmer.dto.compiler.TypeRef;
import org.babyfish.jimmer.dto.compiler.UserProp;
import org.babyfish.jimmer.impl.util.StringUtil;
import org.babyfish.jimmer.runtime.ImmutableSpi;
import org.babyfish.jimmer.sql.Id;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DtoGenerator {
    private static final String[] EMPTY_STR_ARR = new String[0];
    private final Context ctx;
    private final DtoType<ImmutableType, ImmutableProp> dtoType;
    private final Document document;
    private final Filer filer;
    private final DtoGenerator parent;
    private final DtoGenerator root;
    private final String innerClassName;
    private final Set<String> interfaceMethodNames;
    private TypeSpec.Builder typeBuilder;

    public DtoGenerator(Context ctx, DtoType<ImmutableType, ImmutableProp> dtoType, Filer filer) {
        this(ctx, dtoType, filer, null, null);
    }

    private DtoGenerator(Context ctx, DtoType<ImmutableType, ImmutableProp> dtoType, Filer filer, DtoGenerator parent, String innerClassName) {
        if (filer == null == (parent == null)) {
            throw new IllegalArgumentException("The nullity values of `filer` and `parent` cannot be same");
        }
        if (parent == null != (innerClassName == null)) {
            throw new IllegalArgumentException("The nullity values of `parent` and `innerClassName` must be same");
        }
        this.ctx = ctx;
        this.dtoType = dtoType;
        this.document = new Document(ctx, dtoType);
        this.filer = filer;
        this.parent = parent;
        this.root = parent != null ? parent.root : this;
        this.innerClassName = innerClassName;
        this.interfaceMethodNames = DtoInterfaces.abstractMethodNames(ctx, dtoType);
    }

    public void generate() {
        String doc;
        String simpleName = this.getSimpleName();
        this.typeBuilder = TypeSpec.classBuilder((String)simpleName).addModifiers(new Modifier[]{Modifier.PUBLIC});
        if (this.isImpl()) {
            this.typeBuilder.addSuperinterface((TypeName)(this.dtoType.getModifiers().contains(DtoTypeModifier.SPECIFICATION) ? ParameterizedTypeName.get((ClassName)Constants.JSPECIFICATION_CLASS_NAME, (TypeName[])new TypeName[]{((ImmutableType)this.dtoType.getBaseType()).getClassName(), ((ImmutableType)this.dtoType.getBaseType()).getTableClassName()}) : ParameterizedTypeName.get((ClassName)(this.dtoType.getModifiers().contains(DtoTypeModifier.INPUT) ? Constants.INPUT_CLASS_NAME : Constants.VIEW_CLASS_NAME), (TypeName[])new TypeName[]{((ImmutableType)this.dtoType.getBaseType()).getClassName()})));
        }
        for (Object typeRef : this.dtoType.getSuperInterfaces()) {
            this.typeBuilder.addSuperinterface(DtoGenerator.getTypeName((TypeRef)typeRef));
        }
        if (this.parent == null) {
            this.typeBuilder.addAnnotation(AnnotationSpec.builder((ClassName)Constants.GENERATED_BY_CLASS_NAME).addMember("file", "$S", new Object[]{this.dtoType.getDtoFile().getPath()}).build());
        }
        if ((doc = this.document.get()) == null) {
            doc = this.ctx.getElements().getDocComment(((ImmutableType)this.dtoType.getBaseType()).getTypeElement());
        }
        if (doc != null) {
            this.typeBuilder.addJavadoc(doc.replace("$", "$$"), new Object[0]);
        }
        for (Anno anno : this.dtoType.getAnnotations()) {
            this.typeBuilder.addAnnotation(DtoGenerator.annotationOf(anno));
        }
        if (this.innerClassName != null) {
            this.typeBuilder.addModifiers(new Modifier[]{Modifier.STATIC});
            this.addMembers();
        } else {
            this.addMembers();
        }
        if (this.innerClassName != null) {
            assert (this.parent != null);
            this.parent.typeBuilder.addType(this.typeBuilder.build());
        } else {
            try {
                JavaFile.builder((String)this.root.dtoType.getPackageName(), (TypeSpec)this.typeBuilder.build()).indent("    ").build().writeTo(this.filer);
            }
            catch (IOException ex) {
                throw new GeneratorException(String.format("Cannot generate dto type '%s' for '%s'", this.dtoType.getName(), ((ImmutableType)this.dtoType.getBaseType()).getQualifiedName()), ex);
            }
        }
    }

    public String getSimpleName() {
        return this.innerClassName != null ? this.innerClassName : this.dtoType.getName();
    }

    private ClassName getDtoClassName() {
        if (this.innerClassName != null) {
            ArrayList<String> list = new ArrayList<String>();
            this.collectNames(list);
            return ClassName.get((String)this.root.dtoType.getPackageName(), (String)((String)list.get(0)), (String[])list.subList(1, list.size()).toArray(EMPTY_STR_ARR));
        }
        return ClassName.get((String)this.root.dtoType.getPackageName(), (String)this.dtoType.getName(), (String[])new String[0]);
    }

    private void addMembers() {
        boolean isSpecification = this.dtoType.getModifiers().contains(DtoTypeModifier.SPECIFICATION);
        if (!isSpecification) {
            this.addMetadata();
        }
        if (!this.dtoType.getModifiers().contains(DtoTypeModifier.SPECIFICATION)) {
            for (DtoProp prop : this.dtoType.getDtoProps()) {
                this.addAccessorField((DtoProp<ImmutableType, ImmutableProp>)prop);
            }
        }
        for (DtoProp prop : this.dtoType.getDtoProps()) {
            this.addField((DtoProp<ImmutableType, ImmutableProp>)prop);
        }
        for (DtoProp prop : this.dtoType.getUserProps()) {
            this.addField((UserProp)prop);
        }
        this.addDefaultConstructor();
        if (!isSpecification) {
            this.addConverterConstructor();
            this.addOf();
        }
        for (DtoProp prop : this.dtoType.getDtoProps()) {
            this.addAccessors((DtoProp<ImmutableType, ImmutableProp>)prop);
        }
        for (DtoProp prop : this.dtoType.getUserProps()) {
            this.addAccessors((UserProp)prop);
        }
        if (this.dtoType.getModifiers().contains(DtoTypeModifier.SPECIFICATION)) {
            this.addEntityType();
            this.addApplyTo();
        } else {
            this.addToEntity();
        }
        this.addHashCode();
        this.addEquals();
        this.addToString();
        for (DtoProp prop : this.dtoType.getDtoProps()) {
            this.addSpecificationConverter((DtoProp<ImmutableType, ImmutableProp>)prop);
        }
        for (DtoProp prop : this.dtoType.getDtoProps()) {
            DtoType targetType = prop.getTargetType();
            if (targetType == null || prop.isRecursive() && !targetType.isFocusedRecursion()) continue;
            new DtoGenerator(this.ctx, (DtoType<ImmutableType, ImmutableProp>)targetType, null, this, this.targetSimpleName((DtoProp<ImmutableType, ImmutableProp>)prop)).generate();
        }
    }

    private void addMetadata() {
        FieldSpec.Builder builder = FieldSpec.builder((TypeName)ParameterizedTypeName.get((ClassName)Constants.VIEW_METADATA_CLASS_NAME, (TypeName[])new TypeName[]{((ImmutableType)this.dtoType.getBaseType()).getClassName(), this.getDtoClassName()}), (String)"METADATA", (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC, Modifier.FINAL});
        CodeBlock.Builder cb = CodeBlock.builder().indent().add("\n", new Object[0]).add("new $T<$T, $T>(\n", new Object[]{Constants.VIEW_METADATA_CLASS_NAME, ((ImmutableType)this.dtoType.getBaseType()).getClassName(), this.getDtoClassName()}).indent().add("$T.$L", new Object[]{((ImmutableType)this.dtoType.getBaseType()).getFetcherClassName(), "$"}).indent();
        for (DtoProp prop : this.dtoType.getDtoProps()) {
            if (prop.getNextProp() != null) continue;
            this.addFetcherField((DtoProp<ImmutableType, ImmutableProp>)prop, cb);
        }
        for (DtoProp hiddenProp : this.dtoType.getHiddenFlatProps()) {
            this.addHiddenFetcherField((DtoProp<ImmutableType, ImmutableProp>)hiddenProp, cb);
        }
        cb.add(",\n", new Object[0]).unindent().add("$T::new\n", new Object[]{this.getDtoClassName()}).unindent().unindent().add(")", new Object[0]);
        builder.initializer(cb.build());
        this.typeBuilder.addField(builder.build());
    }

    private void addFetcherField(DtoProp<ImmutableType, ImmutableProp> prop, CodeBlock.Builder cb) {
        if (((ImmutableProp)prop.getBaseProp()).getAnnotation(Id.class) == null) {
            if (prop.getTargetType() != null) {
                if (prop.getTargetType() != null) {
                    if (prop.isRecursive()) {
                        cb.add("\n.$N()", new Object[]{StringUtil.identifier((String[])new String[]{"recursive", ((ImmutableProp)prop.getBaseProp()).getName()})});
                    } else {
                        cb.add("\n.$N($T.METADATA.getFetcher())", new Object[]{((ImmutableProp)prop.getBaseProp()).getName(), this.getPropElementName(prop)});
                    }
                }
            } else {
                cb.add("\n.$N()", new Object[]{((ImmutableProp)prop.getBaseProp()).getName()});
            }
        }
    }

    private void addAccessorField(DtoProp<ImmutableType, ImmutableProp> prop) {
        if (this.isSimpleProp(prop)) {
            return;
        }
        FieldSpec.Builder builder = FieldSpec.builder((TypeName)Constants.DTO_PROP_ACCESSOR_CLASS_NAME, (String)StringUtil.snake((String)(prop.getName() + "Accessor"), (StringUtil.SnakeCase)StringUtil.SnakeCase.UPPER), (Modifier[])new Modifier[]{Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL});
        CodeBlock.Builder cb = CodeBlock.builder();
        cb.add("new $T(", new Object[]{Constants.DTO_PROP_ACCESSOR_CLASS_NAME});
        cb.indent();
        DtoProp tailProp = prop.toTailProp();
        if (prop.isNullable() && (!((ImmutableProp)prop.toTailProp().getBaseProp()).isNullable() || this.dtoType.getModifiers().contains(DtoTypeModifier.SPECIFICATION) || this.dtoType.getModifiers().contains(DtoTypeModifier.DYNAMIC))) {
            cb.add("\nfalse", new Object[0]);
        } else {
            cb.add("\ntrue", new Object[0]);
        }
        if (prop.getNextProp() == null) {
            cb.add(",\nnew int[] { $T.$L }", new Object[]{((ImmutableType)this.dtoType.getBaseType()).getProducerClassName(), ((ImmutableProp)prop.getBaseProp()).getSlotName()});
        } else {
            cb.add(",\nnew int[] {", new Object[0]);
            cb.indent();
            boolean addComma = false;
            for (DtoProp p = prop; p != null; p = p.getNextProp()) {
                if (addComma) {
                    cb.add(",", new Object[0]);
                } else {
                    addComma = true;
                }
                cb.add("\n$T.$L", new Object[]{((ImmutableProp)p.getBaseProp()).getDeclaringType().getProducerClassName(), ((ImmutableProp)p.getBaseProp()).getSlotName()});
            }
            cb.unindent();
            cb.add("\n}", new Object[0]);
        }
        if (prop.isIdOnly()) {
            if (this.dtoType.getModifiers().contains(DtoTypeModifier.SPECIFICATION)) {
                cb.add(",\nnull", new Object[0]);
            } else {
                cb.add(",\n$T.$L($T.class, ", new Object[]{Constants.DTO_PROP_ACCESSOR_CLASS_NAME, ((ImmutableProp)tailProp.getBaseProp()).isList() ? "idListGetter" : "idReferenceGetter", ((ImmutableProp)tailProp.getBaseProp()).getTargetType().getClassName()});
                this.addConverterLoading(cb, (DtoProp<ImmutableType, ImmutableProp>)prop, false);
                cb.add(")", new Object[0]);
            }
            cb.add(",\n$T.$L($T.class, ", new Object[]{Constants.DTO_PROP_ACCESSOR_CLASS_NAME, ((ImmutableProp)tailProp.getBaseProp()).isList() ? "idListSetter" : "idReferenceSetter", ((ImmutableProp)tailProp.getBaseProp()).getTargetType().getClassName()});
            this.addConverterLoading(cb, (DtoProp<ImmutableType, ImmutableProp>)prop, false);
            cb.add(")", new Object[0]);
        } else if (tailProp.getTargetType() != null) {
            if (this.dtoType.getModifiers().contains(DtoTypeModifier.SPECIFICATION)) {
                cb.add(",\nnull", new Object[0]);
            } else {
                cb.add(",\n$T.<$T, $T>$L($T::new)", new Object[]{Constants.DTO_PROP_ACCESSOR_CLASS_NAME, ((ImmutableProp)tailProp.getBaseProp()).getTargetType().getClassName(), this.getPropElementName((DtoProp<ImmutableType, ImmutableProp>)tailProp), ((ImmutableProp)tailProp.getBaseProp()).isList() ? "objectListGetter" : "objectReferenceGetter", this.getPropElementName((DtoProp<ImmutableType, ImmutableProp>)tailProp)});
            }
            cb.add(",\n$T.$L($T::toEntity)", new Object[]{Constants.DTO_PROP_ACCESSOR_CLASS_NAME, ((ImmutableProp)tailProp.getBaseProp()).isList() ? "objectListSetter" : "objectReferenceSetter", this.getPropElementName((DtoProp<ImmutableType, ImmutableProp>)tailProp)});
        } else if (prop.getEnumType() != null) {
            EnumType enumType = prop.getEnumType();
            TypeName enumTypeName = ((ImmutableProp)tailProp.getBaseProp()).getTypeName();
            if (this.dtoType.getModifiers().contains(DtoTypeModifier.SPECIFICATION)) {
                cb.add(",\nnull", new Object[0]);
            } else {
                cb.add(",\narg -> {\n", new Object[0]);
                cb.indent();
                cb.beginControlFlow("switch (($T)arg)", new Object[]{enumTypeName});
                for (Map.Entry e : enumType.getValueMap().entrySet()) {
                    cb.add("case $L:\n", new Object[]{e.getKey()});
                    cb.indent();
                    cb.addStatement("return $L", new Object[]{e.getValue()});
                    cb.unindent();
                }
                cb.add("default:\n", new Object[0]);
                cb.indent();
                cb.addStatement("throw new AssertionError($S)", new Object[]{"Internal bug"});
                cb.unindent();
                cb.endControlFlow();
                cb.unindent();
                cb.add("}", new Object[0]);
            }
            cb.add(",\narg -> {\n", new Object[0]);
            cb.indent();
            this.addValueToEnum(cb, (DtoProp<ImmutableType, ImmutableProp>)prop, "arg");
            cb.unindent();
            cb.add("}", new Object[0]);
        } else if (this.converterMetadataOf(prop) != null) {
            cb.add(",\narg -> ", new Object[0]);
            this.addConverterLoading(cb, (DtoProp<ImmutableType, ImmutableProp>)prop, true);
            cb.add(".output(arg)", new Object[0]);
            cb.add(",\narg -> ", new Object[0]);
            this.addConverterLoading(cb, (DtoProp<ImmutableType, ImmutableProp>)prop, true);
            cb.add(".input(arg)", new Object[0]);
        }
        cb.unindent();
        cb.add("\n)", new Object[0]);
        builder.initializer(cb.build());
        this.typeBuilder.addField(builder.build());
    }

    private void addValueToEnum(CodeBlock.Builder cb, DtoProp<ImmutableType, ImmutableProp> prop, String variableName) {
        EnumType enumType = prop.getEnumType();
        TypeName enumTypeName = ((ImmutableProp)prop.toTailProp().getBaseProp()).getTypeName();
        cb.beginControlFlow("switch (($T)$L)", new Object[]{enumType.isNumeric() ? TypeName.INT : Constants.STRING_CLASS_NAME, variableName});
        for (Map.Entry e : enumType.getConstantMap().entrySet()) {
            cb.add("case $L:\n", new Object[]{e.getKey()});
            cb.indent();
            cb.addStatement("return $T.$L", new Object[]{enumTypeName, e.getValue()});
            cb.unindent();
        }
        cb.add("default:\n", new Object[0]);
        cb.indent();
        cb.addStatement("throw new IllegalArgumentException($S + $L + $S)", new Object[]{"Illegal value `\"", variableName, "\"`for enum type: \"" + enumTypeName + "\""});
        cb.unindent();
        cb.endControlFlow();
    }

    private void addConverterLoading(CodeBlock.Builder cb, DtoProp<ImmutableType, ImmutableProp> prop, boolean forList) {
        ImmutableProp baseProp = (ImmutableProp)prop.toTailProp().getBaseProp();
        cb.add("$T.$L.unwrap().$L", new Object[]{((ImmutableType)this.dtoType.getBaseType()).getPropsClassName(), StringUtil.snake((String)baseProp.getName(), (StringUtil.SnakeCase)StringUtil.SnakeCase.UPPER), ((ImmutableProp)prop.toTailProp().getBaseProp()).isAssociation(true) ? "getAssociatedIdConverter(" + forList + ")" : "getConverter()"});
    }

    private boolean isSimpleProp(DtoProp<ImmutableType, ImmutableProp> prop) {
        if (prop.getNextProp() != null) {
            return false;
        }
        if (prop.isNullable() && (!prop.isBaseNullable() || this.dtoType.getModifiers().contains(DtoTypeModifier.SPECIFICATION))) {
            return false;
        }
        return this.getPropTypeName(prop).equals((Object)((ImmutableProp)prop.getBaseProp()).getTypeName());
    }

    private void addHiddenFetcherField(DtoProp<ImmutableType, ImmutableProp> prop, CodeBlock.Builder cb) {
        if (!"flat".equals(prop.getFuncName())) {
            this.addFetcherField(prop, cb);
            return;
        }
        DtoType targetDtoType = prop.getTargetType();
        assert (targetDtoType != null);
        cb.add("\n.$N($>", new Object[]{((ImmutableProp)prop.getBaseProp()).getName()});
        cb.add("$T.$L$>", new Object[]{((ImmutableProp)prop.getBaseProp()).getTargetType().getFetcherClassName(), "$"});
        for (DtoProp childProp : targetDtoType.getDtoProps()) {
            this.addHiddenFetcherField((DtoProp<ImmutableType, ImmutableProp>)childProp, cb);
        }
        cb.add("$<$<\n)", new Object[0]);
    }

    private void addField(DtoProp<ImmutableType, ImmutableProp> prop) {
        TypeName typeName = this.getPropTypeName(prop);
        FieldSpec.Builder builder = FieldSpec.builder((TypeName)typeName, (String)prop.getName(), (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PRIVATE});
        for (AnnotationMirror annotationMirror : ((ImmutableProp)prop.getBaseProp()).getAnnotations()) {
            if (!DtoGenerator.isCopyableAnnotation(annotationMirror, false) || !prop.getAnnotations().stream().noneMatch(it -> it.getQualifiedName().equals(Annotations.qualifiedName(annotationMirror)))) continue;
            builder.addAnnotation(AnnotationSpec.get((AnnotationMirror)annotationMirror));
        }
        for (Anno anno : prop.getAnnotations()) {
            if (!this.hasElementType(anno, ElementType.FIELD)) continue;
            builder.addAnnotation(DtoGenerator.annotationOf(anno));
        }
        if (!typeName.isPrimitive()) {
            if (prop.isNullable()) {
                builder.addAnnotation(Nullable.class);
            } else {
                builder.addAnnotation(NotNull.class);
            }
        }
        this.typeBuilder.addField(builder.build());
    }

    private void addAccessors(DtoProp<ImmutableType, ImmutableProp> prop) {
        String doc;
        TypeName typeName = this.getPropTypeName(prop);
        String getterName = this.getterName((AbstractProp)prop);
        String setterName = this.setterName((AbstractProp)prop);
        MethodSpec.Builder getterBuilder = MethodSpec.methodBuilder((String)getterName).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(typeName);
        if (this.interfaceMethodNames.contains(getterName)) {
            getterBuilder.addAnnotation(Override.class);
        }
        if ((doc = this.document.get((AbstractProp)prop)) == null && prop.getBasePropMap().size() == 1 && prop.getFuncName() == null) {
            doc = this.ctx.getElements().getDocComment(((ImmutableProp)prop.getBaseProp()).toElement());
        }
        if (doc != null) {
            getterBuilder.addJavadoc(doc.replace("$", "$$"), new Object[0]);
        }
        if (!typeName.isPrimitive()) {
            if (prop.isNullable()) {
                getterBuilder.addAnnotation(Nullable.class);
            } else {
                getterBuilder.addAnnotation(NotNull.class);
            }
        }
        for (AnnotationMirror annotationMirror : ((ImmutableProp)prop.getBaseProp()).getAnnotations()) {
            if (!DtoGenerator.isCopyableAnnotation(annotationMirror, true) || !prop.getAnnotations().stream().noneMatch(it -> it.getQualifiedName().equals(Annotations.qualifiedName(annotationMirror)))) continue;
            getterBuilder.addAnnotation(AnnotationSpec.get((AnnotationMirror)annotationMirror));
        }
        for (Anno anno : prop.getAnnotations()) {
            if (!this.hasElementType(anno, ElementType.METHOD)) continue;
            getterBuilder.addAnnotation(DtoGenerator.annotationOf(anno));
        }
        getterBuilder.addStatement("return $L", new Object[]{prop.getName()});
        this.typeBuilder.addMethod(getterBuilder.build());
        ParameterSpec.Builder parameterBuilder = ParameterSpec.builder((TypeName)typeName, (String)prop.getName(), (Modifier[])new Modifier[0]);
        if (!typeName.isPrimitive()) {
            if (prop.isNullable()) {
                parameterBuilder.addAnnotation(Nullable.class);
            } else {
                parameterBuilder.addAnnotation(NotNull.class);
            }
        }
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)setterName).addParameter(parameterBuilder.build()).addModifiers(new Modifier[]{Modifier.PUBLIC});
        if (this.interfaceMethodNames.contains(setterName)) {
            builder.addAnnotation(Override.class);
        }
        builder.addStatement("this.$L = $L", new Object[]{prop.getName(), prop.getName()});
        this.typeBuilder.addMethod(builder.build());
    }

    private void addField(UserProp prop) {
        TypeName typeName = DtoGenerator.getTypeName(prop.getTypeRef());
        FieldSpec.Builder builder = FieldSpec.builder((TypeName)typeName, (String)prop.getAlias(), (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PRIVATE});
        for (Anno anno : prop.getAnnotations()) {
            if (!this.hasElementType(anno, ElementType.FIELD)) continue;
            builder.addAnnotation(DtoGenerator.annotationOf(anno));
        }
        if (!typeName.isPrimitive()) {
            if (prop.getTypeRef().isNullable()) {
                builder.addAnnotation(Nullable.class);
            } else {
                builder.addAnnotation(NotNull.class);
            }
        }
        this.typeBuilder.addField(builder.build());
    }

    private void addAccessors(UserProp prop) {
        String doc;
        TypeName typeName = DtoGenerator.getTypeName(prop.getTypeRef());
        String getterName = this.getterName((AbstractProp)prop);
        String setterName = this.setterName((AbstractProp)prop);
        MethodSpec.Builder getterBuilder = MethodSpec.methodBuilder((String)getterName).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(typeName);
        if (this.interfaceMethodNames.contains(getterName)) {
            getterBuilder.addAnnotation(Override.class);
        }
        if ((doc = this.document.get((AbstractProp)prop)) != null) {
            getterBuilder.addJavadoc(doc.replace("$", "$$"), new Object[0]);
        }
        if (!typeName.isPrimitive()) {
            if (prop.getTypeRef().isNullable()) {
                getterBuilder.addAnnotation(Nullable.class);
            } else {
                getterBuilder.addAnnotation(NotNull.class);
            }
        }
        for (Anno anno : prop.getAnnotations()) {
            if (!this.hasElementType(anno, ElementType.METHOD)) continue;
            getterBuilder.addAnnotation(DtoGenerator.annotationOf(anno));
        }
        getterBuilder.addStatement("return $L", new Object[]{prop.getAlias()});
        this.typeBuilder.addMethod(getterBuilder.build());
        ParameterSpec.Builder parameterBuilder = ParameterSpec.builder((TypeName)typeName, (String)prop.getAlias(), (Modifier[])new Modifier[0]);
        if (!typeName.isPrimitive()) {
            if (prop.getTypeRef().isNullable()) {
                parameterBuilder.addAnnotation(Nullable.class);
            } else {
                parameterBuilder.addAnnotation(NotNull.class);
            }
        }
        MethodSpec.Builder setterBuilder = MethodSpec.methodBuilder((String)setterName).addParameter(parameterBuilder.build()).addModifiers(new Modifier[]{Modifier.PUBLIC});
        if (this.interfaceMethodNames.contains(setterName)) {
            setterBuilder.addAnnotation(Override.class);
        }
        setterBuilder.addStatement("this.$L = $L", new Object[]{prop.getAlias(), prop.getAlias()});
        this.typeBuilder.addMethod(setterBuilder.build());
    }

    private void addOf() {
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)"of").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC}).addParameter(ParameterSpec.builder((TypeName)((ImmutableType)this.dtoType.getBaseType()).getClassName(), (String)"base", (Modifier[])new Modifier[0]).addAnnotation(NotNull.class).build()).returns((TypeName)this.getDtoClassName()).addCode("return new $T(base);", new Object[]{this.getDtoClassName()});
        this.typeBuilder.addMethod(builder.build());
    }

    private void addDefaultConstructor() {
        MethodSpec.Builder builder = MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC});
        this.typeBuilder.addMethod(builder.build());
    }

    private void addConverterConstructor() {
        MethodSpec.Builder builder = MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(ParameterSpec.builder((TypeName)((ImmutableType)this.dtoType.getBaseType()).getClassName(), (String)"base", (Modifier[])new Modifier[0]).addAnnotation(NotNull.class).build());
        for (DtoProp prop : this.dtoType.getDtoProps()) {
            if (this.isSimpleProp((DtoProp<ImmutableType, ImmutableProp>)prop)) {
                if (prop.isNullable()) {
                    builder.addStatement("this.$L = (($T)base).__isLoaded($T.byIndex($T.$L)) ? base.$L() : null", new Object[]{prop.getName(), ImmutableSpi.class, Constants.PROP_ID_CLASS_NAME, ((ImmutableType)this.dtoType.getBaseType()).getProducerClassName(), ((ImmutableProp)prop.getBaseProp()).getSlotName(), ((ImmutableProp)prop.getBaseProp()).getGetterName()});
                    continue;
                }
                builder.addStatement("this.$L = base.$L()", new Object[]{prop.getName(), ((ImmutableProp)prop.getBaseProp()).getGetterName()});
                continue;
            }
            if (!prop.isNullable() && prop.isBaseNullable()) {
                builder.addStatement("this.$L = $L.get($>\nbase,\n$S\n$<)", new Object[]{prop.getName(), StringUtil.snake((String)(prop.getName() + "Accessor"), (StringUtil.SnakeCase)StringUtil.SnakeCase.UPPER), "Cannot convert \"" + ((ImmutableType)this.dtoType.getBaseType()).getClassName() + "\" to \"" + this.getDtoClassName() + "\" because the cannot get non-null value for \"" + prop.getName() + "\""});
                continue;
            }
            builder.addStatement("this.$L = $L.get(base)", new Object[]{prop.getName(), StringUtil.snake((String)(prop.getName() + "Accessor"), (StringUtil.SnakeCase)StringUtil.SnakeCase.UPPER)});
        }
        this.typeBuilder.addMethod(builder.build());
    }

    private void addToEntity() {
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)"toEntity").addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Override.class).returns((TypeName)((ImmutableType)this.dtoType.getBaseType()).getClassName());
        builder.addCode("return $T.$L.produce(__draft -> {$>\n", new Object[]{((ImmutableType)this.dtoType.getBaseType()).getDraftClassName(), "$"});
        for (DtoProp prop : this.dtoType.getDtoProps()) {
            boolean check;
            if (((ImmutableProp)prop.getBaseProp()).isJavaFormula()) continue;
            boolean bl = check = prop.isNullable() && this.dtoType.getModifiers().contains(DtoTypeModifier.DYNAMIC);
            if (check) {
                builder.beginControlFlow("if ($L != null)", new Object[]{prop.getName()});
            }
            if (this.isSimpleProp((DtoProp<ImmutableType, ImmutableProp>)prop)) {
                builder.addStatement("__draft.$L($L)", new Object[]{((ImmutableProp)prop.getBaseProp()).getSetterName(), prop.getName()});
            } else {
                ImmutableProp tailBaseProp = (ImmutableProp)prop.toTailProp().getBaseProp();
                if (tailBaseProp.isList() && tailBaseProp.isAssociation(true)) {
                    builder.addStatement("$L.set(__draft, $L != null ? $L : $T.emptyList())", new Object[]{StringUtil.snake((String)(prop.getName() + "Accessor"), (StringUtil.SnakeCase)StringUtil.SnakeCase.UPPER), prop.getName(), prop.getName(), Constants.COLLECTIONS_CLASS_NAME});
                } else {
                    builder.addStatement("$L.set(__draft, $L)", new Object[]{StringUtil.snake((String)(prop.getName() + "Accessor"), (StringUtil.SnakeCase)StringUtil.SnakeCase.UPPER), prop.getName()});
                }
            }
            if (!check) continue;
            builder.endControlFlow();
        }
        builder.addCode("$<});\n", new Object[0]);
        this.typeBuilder.addMethod(builder.build());
    }

    private void addEntityType() {
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)"entityType").returns((TypeName)ParameterizedTypeName.get((ClassName)Constants.CLASS_CLASS_NAME, (TypeName[])new TypeName[]{((ImmutableType)this.dtoType.getBaseType()).getClassName()})).addModifiers(new Modifier[]{Modifier.PUBLIC}).addStatement("return $T.class", new Object[]{((ImmutableType)this.dtoType.getBaseType()).getClassName()});
        if (this.isImpl()) {
            builder.addAnnotation(Override.class);
        }
        this.typeBuilder.addMethod(builder.build());
    }

    private void addApplyTo() {
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)"applyTo").addModifiers(new Modifier[]{Modifier.PUBLIC});
        if (this.isImpl()) {
            builder.addAnnotation(Override.class).addParameter(ParameterSpec.builder((TypeName)ParameterizedTypeName.get((ClassName)Constants.SPECIFICATION_ARGS_CLASS_NAME, (TypeName[])new TypeName[]{((ImmutableType)this.dtoType.getBaseType()).getClassName(), ((ImmutableType)this.dtoType.getBaseType()).getTableClassName()}), (String)"args", (Modifier[])new Modifier[0]).build());
        } else {
            builder.addParameter(ParameterSpec.builder((TypeName)Constants.PREDICATE_APPLIER_CLASS_NAME, (String)"__applier", (Modifier[])new Modifier[0]).build());
        }
        List<ImmutableProp> stack = Collections.emptyList();
        if (this.isImpl()) {
            builder.addStatement("$T __applier = args.getApplier()", new Object[]{Constants.PREDICATE_APPLIER_CLASS_NAME});
        }
        for (DtoProp prop : this.dtoType.getDtoProps()) {
            ArrayList<ImmutableProp> newStack = new ArrayList<ImmutableProp>(stack.size() + 2);
            DtoProp tailProp = prop.toTailProp();
            for (DtoProp p = prop; p != null; p = p.getNextProp()) {
                if (p == tailProp && p.getTargetType() == null) continue;
                newStack.add((ImmutableProp)p.getBaseProp());
            }
            stack = this.addStackOperations(builder, stack, newStack);
            this.addPredicateOperation(builder, (DtoProp<ImmutableType, ImmutableProp>)tailProp);
        }
        this.addStackOperations(builder, stack, Collections.emptyList());
        this.typeBuilder.addMethod(builder.build());
    }

    private List<ImmutableProp> addStackOperations(MethodSpec.Builder builder, List<ImmutableProp> stack, List<ImmutableProp> newStack) {
        int i;
        int size;
        int sameCount = size = Math.min(stack.size(), newStack.size());
        for (i = 0; i < size; ++i) {
            if (stack.get(i) == newStack.get(i)) continue;
            sameCount = i;
            break;
        }
        for (i = stack.size() - sameCount; i > 0; --i) {
            builder.addStatement("__applier.pop()", new Object[0]);
        }
        for (ImmutableProp prop : newStack.subList(sameCount, newStack.size())) {
            builder.addStatement("__applier.push($T.$L.unwrap())", new Object[]{prop.getDeclaringType().getPropsClassName(), StringUtil.snake((String)prop.getName(), (StringUtil.SnakeCase)StringUtil.SnakeCase.UPPER)});
        }
        return newStack;
    }

    private void addPredicateOperation(MethodSpec.Builder builder, DtoProp<ImmutableType, ImmutableProp> prop) {
        String funcName;
        if (prop.getTargetType() != null) {
            builder.beginControlFlow("if (this.$L != null)", new Object[]{prop.getName()});
            if (((ImmutableType)prop.getTargetType().getBaseType()).isEntity()) {
                builder.addStatement("this.$L.applyTo(args.child())", new Object[]{prop.getName()});
            } else {
                builder.addStatement("this.$L.applyTo(args.getApplier())", new Object[]{prop.getName()});
            }
            builder.endControlFlow();
            return;
        }
        String javaMethodName = funcName = prop.getFuncName();
        if (funcName == null) {
            funcName = "eq";
            javaMethodName = "eq";
        } else if ("null".equals(funcName)) {
            javaMethodName = "isNull";
        } else if ("notNull".equals(funcName)) {
            javaMethodName = "isNotNull";
        } else if ("id".equals(funcName)) {
            funcName = "associatedIdEq";
            javaMethodName = "associatedIdEq";
        }
        CodeBlock.Builder cb = CodeBlock.builder();
        if (org.babyfish.jimmer.dto.compiler.Constants.MULTI_ARGS_FUNC_NAMES.contains(funcName)) {
            cb.add("__applier.$L(new $T[] { ", new Object[]{javaMethodName, Constants.IMMUTABLE_PROP_CLASS_NAME});
            boolean addComma = false;
            for (ImmutableProp baseProp : prop.getBasePropMap().values()) {
                if (addComma) {
                    cb.add(", ", new Object[0]);
                } else {
                    addComma = true;
                }
                cb.add("$T.$L.unwrap()", new Object[]{baseProp.getDeclaringType().getPropsClassName(), StringUtil.snake((String)baseProp.getName(), (StringUtil.SnakeCase)StringUtil.SnakeCase.UPPER)});
            }
            cb.add(" }, ", new Object[0]);
        } else {
            cb.add("__applier.$L($T.$L.unwrap(), ", new Object[]{funcName, ((ImmutableProp)prop.getBaseProp()).getDeclaringType().getPropsClassName(), StringUtil.snake((String)((ImmutableProp)prop.getBaseProp()).getName(), (StringUtil.SnakeCase)StringUtil.SnakeCase.UPPER)});
        }
        if (this.isSpecificationConverterRequired(prop)) {
            cb.add("$L(this.$L)", new Object[]{StringUtil.identifier((String[])new String[]{"__convert", prop.getName()}), prop.getName()});
        } else {
            cb.add("this.$L", new Object[]{prop.getName()});
        }
        if ("like".equals(funcName) || "notLike".equals(funcName)) {
            cb.add(", ", new Object[0]);
            cb.add(prop.getLikeOptions().contains(LikeOption.INSENSITIVE) ? "true" : "false", new Object[0]);
            cb.add(", ", new Object[0]);
            cb.add(prop.getLikeOptions().contains(LikeOption.MATCH_START) ? "true" : "false", new Object[0]);
            cb.add(", ", new Object[0]);
            cb.add(prop.getLikeOptions().contains(LikeOption.MATCH_END) ? "true" : "false", new Object[0]);
        }
        cb.addStatement(")", new Object[0]);
        builder.addCode(cb.build());
    }

    private void addSpecificationConverter(DtoProp<ImmutableType, ImmutableProp> prop) {
        if (!this.isSpecificationConverterRequired(prop)) {
            return;
        }
        ImmutableProp baseProp = (ImmutableProp)prop.toTailProp().getBaseProp();
        TypeName baseTypeName = null;
        String funcName = prop.getFuncName();
        if (funcName != null) {
            switch (funcName) {
                case "id": {
                    baseTypeName = baseProp.getTargetType().getIdProp().getTypeName();
                    if (!baseProp.isList() || this.dtoType.getModifiers().contains(DtoTypeModifier.SPECIFICATION)) break;
                    baseTypeName = ParameterizedTypeName.get((ClassName)Constants.LIST_CLASS_NAME, (TypeName[])new TypeName[]{baseTypeName.box()});
                    break;
                }
                case "valueIn": 
                case "valueNotIn": {
                    baseTypeName = ParameterizedTypeName.get((ClassName)Constants.LIST_CLASS_NAME, (TypeName[])new TypeName[]{baseProp.getTypeName().box()});
                    break;
                }
                case "associatedIdEq": 
                case "associatedIdNe": {
                    baseTypeName = baseProp.getTargetType().getIdProp().getTypeName();
                    break;
                }
                case "associatedIdIn": 
                case "associatedIdNotIn": {
                    baseTypeName = ParameterizedTypeName.get((ClassName)Constants.LIST_CLASS_NAME, (TypeName[])new TypeName[]{baseProp.getTargetType().getIdProp().getTypeName().box()});
                }
            }
        }
        if (baseTypeName == null) {
            baseTypeName = baseProp.getTypeName();
        }
        baseTypeName = baseTypeName.box();
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)StringUtil.identifier((String[])new String[]{"__convert", prop.getName()})).addModifiers(new Modifier[]{Modifier.PRIVATE}).addParameter(this.getPropTypeName(prop), "value", new Modifier[0]).returns(baseTypeName);
        CodeBlock.Builder cb = CodeBlock.builder();
        cb.beginControlFlow("if ($L == null)", new Object[]{prop.getName()});
        cb.addStatement("return null", new Object[0]);
        cb.endControlFlow();
        if (prop.getEnumType() != null) {
            this.addValueToEnum(cb, prop, "value");
        } else {
            cb.addStatement("return $T.$L.unwrap().<$T, $T>$L.input(value)", new Object[]{((ImmutableType)this.dtoType.getBaseType()).getPropsClassName(), StringUtil.snake((String)baseProp.getName(), (StringUtil.SnakeCase)StringUtil.SnakeCase.UPPER), baseTypeName, this.getPropTypeName(prop).box(), baseProp.isAssociation(true) ? "getAssociatedIdConverter(true)" : "getConverter(" + (prop.isFunc(new String[]{"valueIn", "valueNotIn"}) ? "true" : "") + ")"});
        }
        builder.addCode(cb.build());
        this.typeBuilder.addMethod(builder.build());
    }

    public TypeName getPropTypeName(DtoProp<ImmutableType, ImmutableProp> prop) {
        ImmutableProp baseProp = (ImmutableProp)prop.toTailProp().getBaseProp();
        EnumType enumType = prop.getEnumType();
        if (enumType != null) {
            if (enumType.isNumeric()) {
                return prop.isNullable() ? TypeName.INT.box() : TypeName.INT;
            }
            return Constants.STRING_CLASS_NAME;
        }
        ConverterMetadata metadata = this.converterMetadataOf(prop);
        if (this.dtoType.getModifiers().contains(DtoTypeModifier.SPECIFICATION)) {
            String funcName = prop.toTailProp().getFuncName();
            if (funcName != null) {
                switch (funcName) {
                    case "null": 
                    case "notNull": {
                        return TypeName.BOOLEAN;
                    }
                    case "valueIn": 
                    case "valueNotIn": {
                        return ParameterizedTypeName.get((ClassName)Constants.COLLECTION_CLASS_NAME, (TypeName[])new TypeName[]{metadata != null ? metadata.getTargetTypeName() : DtoGenerator.toListType(this.getPropElementName(prop), baseProp.isList())});
                    }
                    case "id": 
                    case "associatedIdEq": 
                    case "associatedIdNe": {
                        return baseProp.getTargetType().getIdProp().getClientTypeName();
                    }
                    case "associatedIdIn": 
                    case "associatedIdNotIn": {
                        return ParameterizedTypeName.get((ClassName)Constants.COLLECTION_CLASS_NAME, (TypeName[])new TypeName[]{baseProp.getTargetType().getIdProp().getClientTypeName().box()});
                    }
                }
            }
            if (baseProp.isAssociation(true)) {
                return this.getPropElementName(prop);
            }
        }
        if (metadata != null) {
            return metadata.getTargetTypeName();
        }
        return DtoGenerator.toListType(this.getPropElementName(prop), baseProp.isList());
    }

    private static TypeName toListType(TypeName typeName, boolean isList) {
        return isList ? ParameterizedTypeName.get((ClassName)Constants.LIST_CLASS_NAME, (TypeName[])new TypeName[]{typeName.box()}) : typeName;
    }

    public static TypeName getTypeName(@Nullable TypeRef typeRef) {
        ClassName typeName;
        if (typeRef == null) {
            return WildcardTypeName.subtypeOf((TypeName)TypeName.OBJECT);
        }
        switch (typeRef.getTypeName()) {
            case "Boolean": {
                typeName = typeRef.isNullable() ? TypeName.BOOLEAN.box() : TypeName.BOOLEAN;
                break;
            }
            case "Char": {
                typeName = typeRef.isNullable() ? TypeName.CHAR.box() : TypeName.CHAR;
                break;
            }
            case "Byte": {
                typeName = typeRef.isNullable() ? TypeName.BYTE.box() : TypeName.BYTE;
                break;
            }
            case "Short": {
                typeName = typeRef.isNullable() ? TypeName.SHORT.box() : TypeName.SHORT;
                break;
            }
            case "Int": {
                typeName = typeRef.isNullable() ? TypeName.INT.box() : TypeName.INT;
                break;
            }
            case "Long": {
                typeName = typeRef.isNullable() ? TypeName.LONG.box() : TypeName.LONG;
                break;
            }
            case "Float": {
                typeName = typeRef.isNullable() ? TypeName.FLOAT.box() : TypeName.FLOAT;
                break;
            }
            case "Double": {
                typeName = typeRef.isNullable() ? TypeName.DOUBLE.box() : TypeName.DOUBLE;
                break;
            }
            case "Any": {
                typeName = TypeName.OBJECT;
                break;
            }
            case "String": {
                typeName = Constants.STRING_CLASS_NAME;
                break;
            }
            case "Array": {
                typeName = ArrayTypeName.of((TypeName)(((TypeRef.Argument)typeRef.getArguments().get(0)).getTypeRef() == null ? TypeName.OBJECT : DtoGenerator.getTypeName(((TypeRef.Argument)typeRef.getArguments().get(0)).getTypeRef())));
                break;
            }
            case "Iterable": 
            case "MutableIterable": {
                typeName = ClassName.get(Iterable.class);
                break;
            }
            case "Collection": 
            case "MutableCollection": {
                typeName = ClassName.get(Collection.class);
                break;
            }
            case "List": 
            case "MutableList": {
                typeName = ClassName.get(List.class);
                break;
            }
            case "Set": 
            case "MutableSet": {
                typeName = ClassName.get(Set.class);
                break;
            }
            case "Map": 
            case "MutableMap": {
                typeName = ClassName.get(Map.class);
                break;
            }
            default: {
                typeName = ClassName.bestGuess((String)typeRef.getTypeName());
            }
        }
        int argCount = typeRef.getArguments().size();
        if (argCount == 0 || typeName instanceof ArrayTypeName) {
            return typeName;
        }
        TypeName[] argTypeNames = new TypeName[argCount];
        for (int i = 0; i < argCount; ++i) {
            TypeRef.Argument arg = (TypeRef.Argument)typeRef.getArguments().get(i);
            TypeName argTypeName = DtoGenerator.getTypeName(arg.getTypeRef());
            if (arg.isIn()) {
                argTypeName = WildcardTypeName.supertypeOf((TypeName)argTypeName);
            } else if (arg.getTypeRef() != null && (arg.isOut() || DtoGenerator.isForceOut(typeRef.getTypeName()))) {
                argTypeName = WildcardTypeName.subtypeOf((TypeName)argTypeName);
            }
            argTypeNames[i] = argTypeName;
        }
        return ParameterizedTypeName.get((ClassName)typeName, (TypeName[])argTypeNames);
    }

    private void addHashCode() {
        TypeName typeName;
        CodeBlock.Builder cb;
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)"hashCode").addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Override.class).returns(TypeName.INT);
        boolean first = true;
        for (DtoProp prop : this.dtoType.getDtoProps()) {
            cb = CodeBlock.builder();
            if (first) {
                cb.add("int hash = ", new Object[0]);
                first = false;
            } else {
                cb.add("hash = hash * 31 + ", new Object[0]);
            }
            typeName = this.getPropTypeName((DtoProp<ImmutableType, ImmutableProp>)prop);
            if (typeName.isPrimitive()) {
                cb.add("$T.hashCode($L)", new Object[]{typeName.box(), prop.getName().equals("hash") ? "this." + prop.getName() : prop.getName()});
            } else {
                cb.add("$T.hashCode($L)", new Object[]{Objects.class, prop.getName()});
            }
            builder.addStatement(cb.build());
        }
        for (DtoProp prop : this.dtoType.getUserProps()) {
            cb = CodeBlock.builder();
            if (first) {
                cb.add("int hash = ", new Object[0]);
                first = false;
            } else {
                cb.add("hash = hash * 31 + ", new Object[0]);
            }
            typeName = DtoGenerator.getTypeName(prop.getTypeRef());
            if (typeName.isPrimitive()) {
                cb.add("$T.hashCode($L)", new Object[]{typeName.box(), prop.getAlias().equals("hash") ? "this." + prop.getAlias() : prop.getAlias()});
            } else {
                cb.add("$T.hashCode($L)", new Object[]{Objects.class, prop.getAlias()});
            }
            builder.addStatement(cb.build());
        }
        builder.addStatement(first ? "return 0" : "return hash", new Object[0]);
        this.typeBuilder.addMethod(builder.build());
    }

    private void addEquals() {
        String thisProp;
        String propName;
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)"equals").addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter((TypeName)TypeName.OBJECT, "o", new Modifier[0]).addAnnotation(Override.class).returns(TypeName.BOOLEAN);
        builder.beginControlFlow("if (o == null || this.getClass() != o.getClass())", new Object[0]).addStatement("return false", new Object[0]).endControlFlow();
        builder.addStatement("$L other = ($L) o", new Object[]{this.getSimpleName(), this.getSimpleName()});
        for (DtoProp prop : this.dtoType.getDtoProps()) {
            propName = prop.getName();
            String string = thisProp = propName.equals("o") || propName.equals("other") ? "this" + propName : propName;
            if (this.getPropTypeName((DtoProp<ImmutableType, ImmutableProp>)prop).isPrimitive()) {
                builder.beginControlFlow("if ($L != other.$L)", new Object[]{thisProp, propName});
            } else {
                builder.beginControlFlow("if (!$T.equals($L, other.$L))", new Object[]{Objects.class, thisProp, propName});
            }
            builder.addStatement("return false", new Object[0]);
            builder.endControlFlow();
        }
        for (DtoProp prop : this.dtoType.getUserProps()) {
            propName = prop.getAlias();
            String string = thisProp = propName.equals("o") || propName.equals("other") ? "this" + propName : propName;
            if (DtoGenerator.getTypeName(prop.getTypeRef()).isPrimitive()) {
                builder.beginControlFlow("if ($L != other.$L)", new Object[]{thisProp, propName});
            } else {
                builder.beginControlFlow("if (!$T.equals($L, other.$L))", new Object[]{Objects.class, thisProp, propName});
            }
            builder.addStatement("return false", new Object[0]);
            builder.endControlFlow();
        }
        builder.addStatement("return true", new Object[0]);
        this.typeBuilder.addMethod(builder.build());
    }

    private void addToString() {
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)"toString").addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Override.class).returns((TypeName)Constants.STRING_CLASS_NAME);
        builder.addStatement("StringBuilder builder = new StringBuilder()", new Object[0]);
        builder.addStatement("builder.append($S).append('(')", new Object[]{this.simpleNamePath()});
        String separator = "";
        for (DtoProp prop : this.dtoType.getDtoProps()) {
            if (prop.getName().equals("builder")) {
                builder.addStatement("builder.append($S).append(this.$L)", new Object[]{separator + prop.getName() + '=', prop.getName()});
            } else {
                builder.addStatement("builder.append($S).append($L)", new Object[]{separator + prop.getName() + '=', prop.getName()});
            }
            separator = ", ";
        }
        for (DtoProp prop : this.dtoType.getUserProps()) {
            if (prop.getAlias().equals("builder")) {
                builder.addStatement("builder.append($S).append(this.$L)", new Object[]{separator + prop.getAlias() + '=', prop.getAlias()});
            } else {
                builder.addStatement("builder.append($S).append($L)", new Object[]{separator + prop.getAlias() + '=', prop.getAlias()});
            }
            separator = ", ";
        }
        builder.addStatement("builder.append(')')", new Object[0]);
        builder.addStatement("return builder.toString()", new Object[0]);
        this.typeBuilder.addMethod(builder.build());
    }

    private String simpleNamePath() {
        String name = this.getSimpleName();
        if (this.parent != null) {
            return this.parent.simpleNamePath() + '.' + name;
        }
        return name;
    }

    public TypeName getPropElementName(DtoProp<ImmutableType, ImmutableProp> prop) {
        DtoProp tailProp = prop.toTailProp();
        DtoType targetType = tailProp.getTargetType();
        if (targetType != null) {
            if (tailProp.isRecursive() && !targetType.isFocusedRecursion()) {
                return this.getDtoClassName();
            }
            if (targetType.getName() == null) {
                ArrayList<String> list = new ArrayList<String>();
                this.collectNames(list);
                if (!tailProp.isRecursive() || targetType.isFocusedRecursion()) {
                    list.add(this.targetSimpleName((DtoProp<ImmutableType, ImmutableProp>)tailProp));
                }
                return ClassName.get((String)this.root.dtoType.getPackageName(), (String)((String)list.get(0)), (String[])list.subList(1, list.size()).toArray(EMPTY_STR_ARR));
            }
            return ClassName.get((String)this.root.dtoType.getPackageName(), (String)targetType.getName(), (String[])new String[0]);
        }
        ImmutableProp baseProp = (ImmutableProp)tailProp.getBaseProp();
        TypeName typeName = tailProp.isIdOnly() ? ((ImmutableProp)tailProp.getBaseProp()).getTargetType().getIdProp().getTypeName() : (baseProp.getIdViewBaseProp() != null ? baseProp.getIdViewBaseProp().getTargetType().getIdProp().getClientTypeName() : ((ImmutableProp)tailProp.getBaseProp()).getClientTypeName());
        if (typeName.isPrimitive() && prop.isNullable()) {
            return typeName.box();
        }
        return typeName;
    }

    private void collectNames(List<String> list) {
        if (this.parent == null) {
            list.add(this.dtoType.getName());
        } else {
            this.parent.collectNames(list);
            list.add(this.innerClassName);
        }
    }

    private String targetSimpleName(DtoProp<ImmutableType, ImmutableProp> prop) {
        DtoType targetType = prop.getTargetType();
        if (targetType == null) {
            throw new IllegalArgumentException("prop is not association");
        }
        if (targetType.getName() != null) {
            return targetType.getName();
        }
        if (prop.isRecursive() && !targetType.isFocusedRecursion()) {
            return this.innerClassName != null ? this.innerClassName : this.dtoType.getName();
        }
        return this.standardTargetSimpleName("TargetOf_" + prop.getName());
    }

    private String standardTargetSimpleName(String targetSimpleName) {
        boolean conflict = false;
        DtoGenerator generator = this;
        while (generator != null) {
            if (generator.getSimpleName().equals(targetSimpleName)) {
                conflict = true;
                break;
            }
            generator = generator.parent;
        }
        if (!conflict) {
            return targetSimpleName;
        }
        for (int i = 2; i < 100; ++i) {
            conflict = false;
            String newTargetSimpleName = targetSimpleName + '_' + i;
            DtoGenerator generator2 = this;
            while (generator2 != null) {
                if (generator2.getSimpleName().equals(newTargetSimpleName)) {
                    conflict = true;
                    break;
                }
                generator2 = generator2.parent;
            }
            if (conflict) continue;
            return newTargetSimpleName;
        }
        throw new AssertionError((Object)"Dto is too deep");
    }

    private boolean isSpecificationConverterRequired(DtoProp<ImmutableType, ImmutableProp> prop) {
        if (!this.dtoType.getModifiers().contains(DtoTypeModifier.SPECIFICATION)) {
            return false;
        }
        return prop.getEnumType() != null || this.converterMetadataOf(prop) != null;
    }

    private ConverterMetadata converterMetadataOf(DtoProp<ImmutableType, ImmutableProp> prop) {
        ImmutableProp baseProp = (ImmutableProp)prop.toTailProp().getBaseProp();
        ConverterMetadata metadata = baseProp.getConverterMetadata();
        if (metadata != null) {
            return metadata;
        }
        String funcName = prop.getFuncName();
        if ("id".equals(funcName)) {
            metadata = baseProp.getTargetType().getIdProp().getConverterMetadata();
            if (metadata != null && baseProp.isList() && !this.dtoType.getModifiers().contains(DtoTypeModifier.SPECIFICATION)) {
                metadata = metadata.toListMetadata(baseProp.context());
            }
            return metadata;
        }
        if ("associatedInEq".equals(funcName) || "associatedInNe".equals(funcName)) {
            return baseProp.getTargetType().getIdProp().getConverterMetadata();
        }
        if (("associatedIdIn".equals(funcName) || "associatedIdNotIn".equals(funcName)) && (metadata = baseProp.getTargetType().getIdProp().getConverterMetadata()) != null) {
            return metadata.toListMetadata(baseProp.context());
        }
        if (baseProp.getIdViewBaseProp() != null && (metadata = baseProp.getIdViewBaseProp().getTargetType().getIdProp().getConverterMetadata()) != null) {
            return baseProp.isList() ? metadata.toListMetadata(baseProp.context()) : metadata;
        }
        return null;
    }

    private boolean hasElementType(Anno anno, ElementType elementType) {
        TypeElement annoElement = this.ctx.getElements().getTypeElement(anno.getQualifiedName());
        if (annoElement == null) {
            throw new DtoException("Cannot find the annotation declaration whose type is \"" + anno.getQualifiedName() + "\"");
        }
        Target target = annoElement.getAnnotation(Target.class);
        if (target != null) {
            for (ElementType et : target.value()) {
                if (et != elementType) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean isCopyableAnnotation(AnnotationMirror annotationMirror, boolean forMethod) {
        boolean acceptField;
        Target target = annotationMirror.getAnnotationType().asElement().getAnnotation(Target.class);
        if (target != null && (acceptField = Arrays.stream(target.value()).anyMatch(it -> it == (forMethod ? ElementType.METHOD : ElementType.FIELD)))) {
            String qualifiedName = ((TypeElement)annotationMirror.getAnnotationType().asElement()).getQualifiedName().toString();
            if (DtoGenerator.isNullityAnnotation(qualifiedName)) {
                return false;
            }
            return !qualifiedName.startsWith("org.babyfish.jimmer.") || qualifiedName.startsWith("org.babyfish.jimmer.client.");
        }
        return false;
    }

    private static boolean isNullityAnnotation(String qualifiedName) {
        int lastDotIndex = qualifiedName.lastIndexOf(46);
        if (lastDotIndex != -1) {
            qualifiedName = qualifiedName.substring(lastDotIndex + 1);
        }
        switch (qualifiedName) {
            case "Null": 
            case "Nullable": 
            case "NotNull": 
            case "NonNull": {
                return true;
            }
        }
        return false;
    }

    private static AnnotationSpec annotationOf(Anno anno) {
        AnnotationSpec.Builder builder = AnnotationSpec.builder((ClassName)ClassName.bestGuess((String)anno.getQualifiedName()));
        for (Map.Entry e : anno.getValueMap().entrySet()) {
            String name = (String)e.getKey();
            Anno.Value value = (Anno.Value)e.getValue();
            builder.addMember(name, DtoGenerator.codeBlockOf(value));
        }
        return builder.build();
    }

    private static CodeBlock codeBlockOf(Anno.Value value) {
        CodeBlock.Builder builder = CodeBlock.builder();
        if (value instanceof Anno.ArrayValue) {
            builder.add("{\n$>", new Object[0]);
            boolean addSeparator = false;
            for (Anno.Value element : ((Anno.ArrayValue)value).elements) {
                if (addSeparator) {
                    builder.add(", \n", new Object[0]);
                } else {
                    addSeparator = true;
                }
                builder.add("$L", new Object[]{DtoGenerator.codeBlockOf(element)});
            }
            builder.add("$<\n}", new Object[0]);
        } else if (value instanceof Anno.AnnoValue) {
            builder.add("$L", new Object[]{DtoGenerator.annotationOf(((Anno.AnnoValue)value).anno)});
        } else if (value instanceof Anno.TypeRefValue) {
            builder.add("$T.class", new Object[]{DtoGenerator.getTypeName(((Anno.TypeRefValue)value).typeRef)});
        } else if (value instanceof Anno.EnumValue) {
            builder.add("$T.$L", new Object[]{ClassName.bestGuess((String)((Anno.EnumValue)value).qualifiedName), ((Anno.EnumValue)value).constant});
        } else if (value instanceof Anno.LiteralValue) {
            builder.add(((Anno.LiteralValue)value).value, new Object[0]);
        }
        return builder.build();
    }

    private static boolean isForceOut(String typeName) {
        switch (typeName) {
            case "Iterable": 
            case "Collection": 
            case "List": 
            case "Set": 
            case "Map": {
                return true;
            }
        }
        return false;
    }

    private String getterName(AbstractProp prop) {
        String suffix;
        TypeName typeName = prop instanceof DtoProp ? this.getPropTypeName((DtoProp<ImmutableType, ImmutableProp>)((DtoProp)prop)) : DtoGenerator.getTypeName(((UserProp)prop).getTypeRef());
        String string = suffix = prop instanceof DtoProp ? ((DtoProp)prop).getName() : prop.getAlias();
        if (suffix.startsWith("is") && suffix.length() > 2 && Character.isUpperCase(suffix.charAt(2)) && typeName.equals((Object)TypeName.BOOLEAN)) {
            suffix = suffix.substring(2);
        }
        return StringUtil.identifier((String[])new String[]{typeName.equals((Object)TypeName.BOOLEAN) ? "is" : "get", suffix});
    }

    private String setterName(AbstractProp prop) {
        String suffix;
        TypeName typeName = prop instanceof DtoProp ? this.getPropTypeName((DtoProp<ImmutableType, ImmutableProp>)((DtoProp)prop)) : DtoGenerator.getTypeName(((UserProp)prop).getTypeRef());
        String string = suffix = prop instanceof DtoProp ? ((DtoProp)prop).getName() : prop.getAlias();
        if (suffix.startsWith("is") && suffix.length() > 2 && Character.isUpperCase(suffix.charAt(2)) && typeName.equals((Object)TypeName.BOOLEAN)) {
            suffix = suffix.substring(2);
        }
        return StringUtil.identifier((String[])new String[]{"set", suffix});
    }

    private boolean isImpl() {
        return this.parent == null || ((ImmutableType)this.dtoType.getBaseType()).isEntity() || !this.dtoType.getModifiers().contains(DtoTypeModifier.SPECIFICATION);
    }

    private class Document {
        private final Context ctx;
        private final Doc dtoTypeDoc;
        private final Doc baseTypeDoc;
        private String result;

        public Document(Context ctx, DtoType<ImmutableType, ImmutableProp> dtoType) {
            this.ctx = ctx;
            this.dtoTypeDoc = Doc.parse((String)dtoType.getDoc());
            this.baseTypeDoc = Doc.parse((String)ctx.getElements().getDocComment(((ImmutableType)dtoType.getBaseType()).getTypeElement()));
        }

        public String get() {
            String ret = this.result;
            if (ret == null) {
                ret = this.dtoTypeDoc != null ? this.dtoTypeDoc.toString() : (this.baseTypeDoc != null ? this.baseTypeDoc.toString() : "");
                this.result = ret = ret.replace("$", "$$");
            }
            return ret.isEmpty() ? null : ret;
        }

        public String get(AbstractProp prop) {
            String value = this.getImpl(prop);
            if (value == null) {
                return null;
            }
            return value.replace("$", "$$");
        }

        private String getImpl(AbstractProp prop) {
            Object doc;
            ImmutableProp baseProp = prop instanceof DtoProp ? (ImmutableProp)((DtoProp)prop).getBaseProp() : null;
            if (prop.getDoc() != null && (doc = Doc.parse((String)prop.getDoc())) != null) {
                return doc.toString();
            }
            if (this.dtoTypeDoc != null) {
                String doc2;
                String name = prop.getAlias();
                if (name == null) {
                    assert (baseProp != null);
                    name = baseProp.getName();
                }
                if ((doc2 = (String)this.dtoTypeDoc.getParameterValueMap().get(name)) != null) {
                    return doc2;
                }
            }
            if (baseProp != null && (doc = Doc.parse((String)this.ctx.getElements().getDocComment(baseProp.toElement()))) != null) {
                return doc.toString();
            }
            if (this.baseTypeDoc != null && baseProp != null && (doc = (String)this.baseTypeDoc.getParameterValueMap().get(baseProp.getName())) != null) {
                return doc;
            }
            return null;
        }
    }
}

