/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.apt;

import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.Map;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import kotlin.Metadata;
import org.babyfish.jimmer.Immutable;
import org.babyfish.jimmer.apt.MetaException;
import org.babyfish.jimmer.apt.immutable.meta.ImmutableType;
import org.babyfish.jimmer.sql.Embeddable;
import org.babyfish.jimmer.sql.Entity;
import org.babyfish.jimmer.sql.MappedSuperclass;

public class Context {
    private static final Class<? extends Annotation>[] SQL_TYPE_ANNOTATION_TYPES = new Class[]{Entity.class, MappedSuperclass.class, Embeddable.class};
    private final Elements elements;
    private final Types types;
    private final TypeMirror numberType;
    private final TypeMirror comparableType;
    private final TypeElement enumElement;
    private final Map<TypeElement, ImmutableType> immutableTypeMap = new HashMap<TypeElement, ImmutableType>();
    private final boolean keepIsPrefix;
    private final String[] includes;
    private final String[] excludes;

    Context(Elements elements, Types types, boolean keepIsPrefix, String[] includes, String[] excludes) {
        this.elements = elements;
        this.types = types;
        this.keepIsPrefix = keepIsPrefix;
        this.includes = includes;
        this.excludes = excludes;
        this.numberType = elements.getTypeElement(Number.class.getName()).asType();
        this.comparableType = types.getDeclaredType(elements.getTypeElement(Comparable.class.getName()), types.getWildcardType(null, null));
        this.enumElement = elements.getTypeElement(Enum.class.getName());
    }

    public Class<? extends Annotation> getImmutableAnnotationType(TypeElement typeElement) {
        if (typeElement == null) {
            return null;
        }
        Immutable annotation = typeElement.getAnnotation(Immutable.class);
        Annotation sqlAnnotation = null;
        for (Class<? extends Annotation> sqlAnnotationType : SQL_TYPE_ANNOTATION_TYPES) {
            Annotation newSqlAnnotation = typeElement.getAnnotation(sqlAnnotationType);
            if (newSqlAnnotation == null) continue;
            if (sqlAnnotation != null) {
                throw new MetaException(typeElement, "it can not be decorated by both @" + sqlAnnotation.annotationType().getName() + " and @" + newSqlAnnotation.annotationType().getName());
            }
            sqlAnnotation = newSqlAnnotation;
        }
        if (sqlAnnotation != null) {
            return sqlAnnotation.annotationType();
        }
        if (annotation != null) {
            return annotation.annotationType();
        }
        return null;
    }

    public Class<? extends Annotation> getImmutableAnnotationType(TypeMirror typeMirror) {
        Element element = this.types.asElement(typeMirror);
        return this.getImmutableAnnotationType((TypeElement)element);
    }

    public boolean isImmutable(TypeElement type) {
        return this.getImmutableAnnotationType(type) != null;
    }

    public boolean isImmutable(TypeMirror type) {
        return this.getImmutableAnnotationType(type) != null;
    }

    public boolean isEntity(TypeMirror type) {
        return this.getImmutableAnnotationType(type) == Entity.class;
    }

    public boolean isMappedSuperclass(TypeMirror type) {
        return this.getImmutableAnnotationType(type) == MappedSuperclass.class;
    }

    public boolean isEmbeddable(TypeMirror type) {
        return this.getImmutableAnnotationType(type) == Embeddable.class;
    }

    public boolean isCollection(TypeMirror type) {
        if (type.getKind() == TypeKind.DECLARED) {
            DeclaredType declaredType = (DeclaredType)type;
            TypeElement element = (TypeElement)declaredType.asElement();
            if (element.getQualifiedName().toString().equals("java.util.Collection")) {
                return true;
            }
            if (element.getSuperclass() != null && this.isCollection(element.getSuperclass())) {
                return true;
            }
            for (TypeMirror typeMirror : element.getInterfaces()) {
                if (!this.isCollection(typeMirror)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isListStrictly(TypeMirror type) {
        Element element = this.types.asElement(type);
        return element != null && element.toString().equals("java.util.List");
    }

    public boolean isEnum(TypeMirror type) {
        return this.types.isSubtype(type, this.types.getDeclaredType(this.enumElement, type));
    }

    public boolean isSubType(TypeMirror type, TypeMirror superType) {
        return this.types.isSubtype(type, superType);
    }

    public ImmutableType getImmutableType(TypeElement typeElement) {
        ImmutableType type = this.immutableTypeMap.get(typeElement);
        if (type == null && !this.immutableTypeMap.containsKey(typeElement)) {
            if (this.isImmutable(typeElement)) {
                type = new ImmutableType(this, typeElement);
            }
            this.immutableTypeMap.put(typeElement, type);
        }
        return type;
    }

    public ImmutableType getImmutableType(TypeMirror type) {
        TypeElement typeElement = (TypeElement)this.types.asElement(type);
        return this.getImmutableType(typeElement);
    }

    public boolean isNumber(TypeMirror type) {
        return this.types.isSubtype(type, this.numberType);
    }

    public boolean isComparable(TypeMirror type) {
        return this.types.isSubtype(type, this.comparableType);
    }

    public Elements getElements() {
        return this.elements;
    }

    public Types getTypes() {
        return this.types;
    }

    public boolean keepIsPrefix() {
        return this.keepIsPrefix;
    }

    public boolean include(TypeElement typeElement) {
        if (typeElement.getAnnotation(Metadata.class) != null) {
            return false;
        }
        String qualifiedName = typeElement.getQualifiedName().toString();
        if (this.includes != null) {
            for (String include : this.includes) {
                if (!qualifiedName.startsWith(include)) continue;
                return true;
            }
        }
        if (this.excludes != null) {
            for (String exclude : this.excludes) {
                if (!qualifiedName.startsWith(exclude)) continue;
                return false;
            }
        }
        return true;
    }
}

