/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.apt.generator;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import javax.lang.model.element.AnnotationMirror;
import javax.validation.ValidationException;
import org.babyfish.jimmer.apt.generator.Annotations;
import org.babyfish.jimmer.apt.generator.Constants;
import org.babyfish.jimmer.apt.meta.ImmutableProp;
import org.babyfish.jimmer.apt.meta.MetaException;

public class ValidationGenerator {
    private static final Object[] EMPTY_ARGS = new Object[0];
    private final ImmutableProp prop;
    private final String valueName;
    private final Map<String, List<AnnotationMirror>> mirrorMultiMap;
    private final MethodSpec.Builder methodBuilder;

    public ValidationGenerator(ImmutableProp prop, String valueName, MethodSpec.Builder methodBuilder) {
        this.prop = prop;
        this.valueName = valueName;
        this.mirrorMultiMap = Annotations.validateAnnotationMirrorMultiMap(prop);
        this.methodBuilder = methodBuilder;
    }

    public void generate() {
        if (!this.prop.isNullable() && !this.prop.getTypeName().isPrimitive()) {
            this.methodBuilder.beginControlFlow("if ($L == null)", new Object[]{this.valueName}).addCode("throw new IllegalArgumentException(\n", new Object[0]).addCode("    \"'$L' cannot be null, please specify non-null value or use nullable annotation to decorate this property\"\n", new Object[]{this.prop.getName()}).addCode(");\n", new Object[0]).endControlFlow();
        }
        this.generateNotEmpty();
        this.generateNotBlank();
        this.generateSize();
        this.generateBound();
        this.generateEmail();
        this.generatePattern();
        this.generateConstraints();
    }

    private void generateNotEmpty() {
        List<AnnotationMirror> mirrors = this.mirrorMultiMap.get("NotEmpty");
        if (mirrors == null) {
            return;
        }
        if (!this.isSimpleClass(String.class) && !this.isSimpleClass(List.class)) {
            throw new MetaException(this.prop.toElement(), "it's decorated by the annotation @" + Annotations.qualifiedName(mirrors.get(0)) + " but its type is neither string nor list");
        }
        this.validate("$L.isEmpty()", new Object[]{this.valueName}, Annotations.annotationValue(mirrors.get(0), "message", ""), () -> "it cannot be empty");
    }

    private void generateNotBlank() {
        List<AnnotationMirror> mirrors = this.mirrorMultiMap.get("NotBlank");
        if (mirrors == null) {
            return;
        }
        if (!this.isSimpleClass(String.class)) {
            throw new MetaException(this.prop.toElement(), "it's decorated by the annotation @" + Annotations.qualifiedName(mirrors.get(0)) + " but its type is not string");
        }
        this.validate("$L.trim().isEmpty()", new Object[]{this.valueName}, Annotations.annotationValue(mirrors.get(0), "message", ""), () -> "it cannot be empty");
    }

    private void generateSize() {
        String sizeFun;
        List<AnnotationMirror> mirrors = this.mirrorMultiMap.get("Size");
        if (mirrors == null) {
            return;
        }
        if (!this.isSimpleClass(String.class) && !this.isSimpleClass(List.class)) {
            throw new MetaException(this.prop.toElement(), "it's decorated by the annotation @" + Annotations.qualifiedName(mirrors.get(0)) + " but its type is neither string nor list");
        }
        int min = 0;
        int max = Integer.MAX_VALUE;
        String minMessage = null;
        String maxMessage = null;
        for (AnnotationMirror mirror : mirrors) {
            int mirrorMin = Annotations.annotationValue(mirror, "min", 0);
            int mirrorMax = Annotations.annotationValue(mirror, "max", Integer.MAX_VALUE);
            if (mirrorMin > min) {
                min = mirrorMin;
                minMessage = Annotations.annotationValue(mirror, "message", "");
            }
            if (mirrorMax >= max) continue;
            max = mirrorMax;
            maxMessage = Annotations.annotationValue(mirror, "message", "");
        }
        if (min > max) {
            throw new MetaException(this.prop.toElement(), "its size validation rules is illegal so that there is not valid length");
        }
        if (min == 0 && max == Integer.MAX_VALUE) {
            return;
        }
        String string = sizeFun = this.isSimpleClass(String.class) ? "length" : "size";
        if (min > 0) {
            int finalValue = min;
            this.validate("$L.$L() < $L", new Object[]{this.valueName, sizeFun, finalValue}, minMessage, () -> "it cannot be less than " + finalValue);
        }
        if (max < Integer.MAX_VALUE) {
            int finalValue = max;
            this.validate("$L.$L() > $L", new Object[]{this.valueName, sizeFun, finalValue}, maxMessage, () -> "it cannot be greater than " + finalValue);
        }
    }

    private void generateBound() {
        List<AnnotationMirror> negativeOrZeros;
        List<AnnotationMirror> negatives;
        List<AnnotationMirror> positiveOrZeros;
        List<AnnotationMirror> positives;
        List<AnnotationMirror> maxList;
        List<AnnotationMirror> minList = this.mirrorMultiMap.get("Min");
        List[] allMirrors = new List[]{minList, maxList = this.mirrorMultiMap.get("Max"), positives = this.mirrorMultiMap.get("Positive"), positiveOrZeros = this.mirrorMultiMap.get("PositiveOrZero"), negatives = this.mirrorMultiMap.get("Negative"), negativeOrZeros = this.mirrorMultiMap.get("NegativeOrZero")};
        AnnotationMirror mirror = Arrays.stream(allMirrors).filter(Objects::nonNull).flatMap(Collection::stream).findFirst().orElse(null);
        if (mirror == null) {
            return;
        }
        if (!(this.prop.getTypeName().isPrimitive() || this.prop.getTypeName().isBoxedPrimitive() || this.isSimpleClass(BigInteger.class) || this.isSimpleClass(BigDecimal.class))) {
            throw new MetaException(this.prop.toElement(), "it's decorated by the annotation @" + Annotations.qualifiedName(mirror) + " but its type is numeric");
        }
        Long minValue = null;
        Long maxValue = null;
        String message = null;
        for (AnnotationMirror min : Annotations.nonNullList(minList)) {
            long mirrorMinValue = Annotations.annotationValue(min, "value", 0L);
            if (minValue != null && mirrorMinValue <= minValue) continue;
            minValue = mirrorMinValue;
            message = Annotations.annotationValue(min, "message", "");
        }
        for (AnnotationMirror positive : Annotations.nonNullList(positives)) {
            if (minValue != null && 1L <= minValue) continue;
            minValue = 1L;
            message = Annotations.annotationValue(positive, "message", "");
        }
        for (AnnotationMirror positiveOrZero : Annotations.nonNullList(positiveOrZeros)) {
            if (minValue != null && 0L <= minValue) continue;
            minValue = 0L;
            message = Annotations.annotationValue(positiveOrZero, "message", "");
        }
        for (AnnotationMirror max : Annotations.nonNullList(maxList)) {
            long mirrorMaxValue = Annotations.annotationValue(max, "value", 0L);
            if (maxValue != null && mirrorMaxValue >= maxValue) continue;
            maxValue = mirrorMaxValue;
            message = Annotations.annotationValue(max, "message", "");
        }
        for (AnnotationMirror negative : Annotations.nonNullList(negatives)) {
            if (maxValue != null && -1L >= maxValue) continue;
            maxValue = -1L;
            message = Annotations.annotationValue(negative, "message", "");
        }
        for (AnnotationMirror negativeOrZero : Annotations.nonNullList(negativeOrZeros)) {
            if (maxValue != null && 0L >= maxValue) continue;
            maxValue = 0L;
            message = Annotations.annotationValue(negativeOrZero, "message", "");
        }
        if (minValue != null && maxValue != null && minValue > maxValue) {
            throw new MetaException(this.prop.toElement(), "its numeric range validation rules is illegal so that there is not valid number");
        }
        if (minValue != null) {
            this.validateBound(minValue, "<", message);
        }
        if (maxValue != null) {
            this.validateBound(maxValue, ">", message);
        }
    }

    private void generateEmail() {
        List<AnnotationMirror> mirrors = this.mirrorMultiMap.get("Email");
        if (mirrors == null) {
            return;
        }
        if (!this.isSimpleClass(String.class)) {
            throw new MetaException(this.prop.toElement(), "it's decorated by the annotation @" + Annotations.qualifiedName(mirrors.get(0)) + " but its type is not string");
        }
        this.validate("!$L.matcher($L).matches()", new Object[]{"__EMAIL_PATTERN__", this.valueName}, Annotations.annotationValue(mirrors.get(0), "message", ""), () -> "it is not email address");
    }

    private void generatePattern() {
        List<AnnotationMirror> mirrors = this.mirrorMultiMap.get("Pattern");
        if (mirrors == null) {
            return;
        }
        if (!this.isSimpleClass(String.class)) {
            throw new MetaException(this.prop.toElement(), "it's decorated by the annotation @" + Annotations.qualifiedName(mirrors.get(0)) + " but its type is not string");
        }
        for (int i = 0; i < mirrors.size(); ++i) {
            int index = i;
            this.validate("!$L.matcher($L).matches()", new Object[]{Constants.regexpPatternFieldName(this.prop, i), this.valueName}, Annotations.annotationValue(mirrors.get(i), "message", ""), () -> "it does not match the regexp '" + Annotations.annotationValue((AnnotationMirror)mirrors.get(index), "regexp", "").replace("\\", "\\\\") + "'");
        }
    }

    private void generateConstraints() {
        for (Map.Entry<ClassName, String> e : this.prop.getValidationMessageMap().entrySet()) {
            this.methodBuilder.addStatement("$L.validate($L)", new Object[]{Constants.validatorFieldName(this.prop, e.getKey()), this.prop.getName()});
        }
    }

    private void validate(String condition, Object[] args, String errorMessage, Supplier<String> defaultMessageSupplier) {
        if (!this.prop.isNullable() || this.prop.getTypeName().isPrimitive()) {
            this.methodBuilder.beginControlFlow("if (" + condition + ")", args != null ? args : EMPTY_ARGS);
        } else {
            this.methodBuilder.beginControlFlow("if (" + this.valueName + " != null && " + condition + ")", args != null ? args : EMPTY_ARGS);
        }
        if (errorMessage == null || errorMessage.isEmpty() || errorMessage.startsWith("{javax.validation.constraints.")) {
            errorMessage = "Illegal value '\" + " + this.valueName + " + \"' for property '" + this.prop + "', " + defaultMessageSupplier.get();
            this.methodBuilder.addStatement("throw new $T(\"$L\")", new Object[]{ValidationException.class, errorMessage});
        }
        this.methodBuilder.endControlFlow();
    }

    private boolean isSimpleClass(Class<?> type) {
        ClassName className;
        TypeName typeName = this.prop.getTypeName();
        if (typeName instanceof ClassName) {
            className = (ClassName)typeName;
        } else if (typeName instanceof ParameterizedTypeName) {
            className = ((ParameterizedTypeName)typeName).rawType;
        } else {
            return false;
        }
        return className.packageName().equals(type.getPackage().getName()) && className.simpleNames().size() == 1 && className.simpleName().equals(type.getSimpleName());
    }

    private void validateBound(long bound, String cmp, String message) {
        Object[] objectArray;
        String bigNumLiteral = this.prop.getTypeName().equals((Object)ClassName.get(BigDecimal.class)) ? (bound == 0L ? "$T.ZERO" : (bound == 1L ? "$T.ONE" : (bound == 2L ? "$T.TWO" : (bound == 10L ? "$T.TEN" : "$T.valueOf(" + bound + ")")))) : (this.prop.getTypeName().equals((Object)ClassName.get(BigInteger.class)) ? (bound == -1L ? "$T.NEGATIVE_ONE" : (bound == 0L ? "$T.ZERO" : (bound == 1L ? "$T.ONE" : (bound == 2L ? "$T.TWO" : (bound == 10L ? "$T.TEN" : "$T.valueOf(" + bound + ", 0)"))))) : null);
        String string = bigNumLiteral != null ? "$L.compareTo(" + bigNumLiteral + ") $L 0" : "$L $L $L";
        if (bigNumLiteral != null) {
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = this.valueName;
            objectArray2[1] = this.prop.getElementType();
            objectArray = objectArray2;
            objectArray2[2] = cmp;
        } else {
            Object[] objectArray3 = new Object[3];
            objectArray3[0] = this.valueName;
            objectArray3[1] = cmp;
            objectArray = objectArray3;
            objectArray3[2] = bound;
        }
        this.validate(string, objectArray, message, () -> "it cannot be " + (cmp.equals("<") ? "less than" : "greater than") + " " + bound);
    }
}

