/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.apt.generator;

import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.util.ArrayList;
import javax.lang.model.element.Modifier;
import org.babyfish.jimmer.ImmutableObjects;
import org.babyfish.jimmer.apt.generator.Constants;
import org.babyfish.jimmer.apt.meta.ImmutableProp;
import org.babyfish.jimmer.apt.meta.ImmutableType;

public class MapStructGenerator {
    private final ImmutableType type;
    private TypeSpec.Builder typeBuilder;

    public MapStructGenerator(ImmutableType type) {
        this.type = type;
    }

    public void generate(TypeSpec.Builder parentBuilder) {
        this.typeBuilder = TypeSpec.classBuilder((String)"MapStruct").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC});
        this.addMembers();
        parentBuilder.addType(this.typeBuilder.build());
    }

    private void addMembers() {
        for (ImmutableProp prop : this.type.getProps().values()) {
            this.addFields(prop);
        }
        for (ImmutableProp prop : this.type.getProps().values()) {
            this.addSetter(prop);
        }
        this.addBuild();
    }

    private void addFields(ImmutableProp prop) {
        if (prop.isJavaFormula() || prop.getIdViewBaseProp() != null) {
            return;
        }
        if (MapStructGenerator.isMapStructLoadedStateRequired(prop)) {
            this.typeBuilder.addField(FieldSpec.builder((TypeName)TypeName.BOOLEAN, (String)prop.getLoadedStateName(), (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PRIVATE}).build());
        }
        this.typeBuilder.addField(FieldSpec.builder((TypeName)prop.getTypeName().box(), (String)prop.getName(), (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PRIVATE}).build());
    }

    private void addSetter(ImmutableProp prop) {
        if (prop.isJavaFormula() || prop.getManyToManyViewBaseProp() != null) {
            return;
        }
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)prop.getName()).addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(prop.getTypeName().box(), prop.getName(), new Modifier[0]).returns((TypeName)this.type.getMapStructClassName());
        if (prop.getIdViewBaseProp() != null) {
            ImmutableProp baseProp = prop.getIdViewBaseProp();
            if (MapStructGenerator.isMapStructLoadedStateRequired(baseProp)) {
                builder.addStatement("this.$L = true", new Object[]{baseProp.getLoadedStateName()});
            }
            builder.beginControlFlow("if ($L == null)", new Object[]{prop.getName()});
            if (prop.isList()) {
                builder.addStatement("this.$L = $T.emptyList()", new Object[]{baseProp.getName(), Constants.COLLECTIONS_CLASS_NAME});
            } else {
                builder.addStatement("this.$L = null", new Object[]{baseProp.getName()});
            }
            builder.nextControlFlow("else", new Object[0]);
            if (prop.isList()) {
                builder.addStatement("$T<$T> __targets = new $T($L.size())", new Object[]{Constants.LIST_CLASS_NAME, baseProp.getElementTypeName(), ArrayList.class, prop.getName()});
                builder.beginControlFlow("for ($T __targetId : $L)", new Object[]{prop.getElementTypeName(), prop.getName()});
                builder.addStatement("__targets.add($T.makeIdOnly($T.class, __targetId))", new Object[]{ImmutableObjects.class, baseProp.getTargetType().getClassName()});
                builder.endControlFlow();
                builder.addStatement("this.$L = __targets", new Object[]{baseProp.getName()});
            } else {
                builder.addStatement("this.$L = $T.makeIdOnly($T.class, $L)", new Object[]{baseProp.getName(), ImmutableObjects.class, baseProp.getTargetType().getClassName(), prop.getName()});
            }
            builder.endControlFlow();
        } else {
            if (MapStructGenerator.isMapStructLoadedStateRequired(prop)) {
                builder.addStatement("this.$L = true", new Object[]{prop.getLoadedStateName()});
            }
            if (prop.isList()) {
                builder.addStatement("this.$L = $L != null ? $L : $T.emptyList()", new Object[]{prop.getName(), prop.getName(), prop.getName(), Constants.COLLECTIONS_CLASS_NAME});
            } else {
                builder.addStatement("this.$L = $L", new Object[]{prop.getName(), prop.getName()});
            }
        }
        builder.addStatement("return this", new Object[0]);
        this.typeBuilder.addMethod(builder.build());
    }

    private void addBuild() {
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)"build").addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)this.type.getClassName());
        builder.addCode("return $T.$L.produce(draft -> {$>\n", new Object[]{this.type.getDraftClassName(), "$"});
        for (ImmutableProp prop : this.type.getProps().values()) {
            if (!prop.isValueRequired()) continue;
            if (MapStructGenerator.isMapStructLoadedStateRequired(prop)) {
                builder.beginControlFlow("if ($L)", new Object[]{prop.getLoadedStateName()});
                builder.addStatement("draft.$L($L)", new Object[]{prop.getSetterName(), prop.getName()});
                builder.endControlFlow();
                continue;
            }
            builder.beginControlFlow("if ($L != null)", new Object[]{prop.getName()});
            builder.addStatement("draft.$L($L)", new Object[]{prop.getSetterName(), prop.getName()});
            builder.endControlFlow();
        }
        builder.addCode("$<});\n", new Object[0]);
        this.typeBuilder.addMethod(builder.build());
    }

    private static boolean isMapStructLoadedStateRequired(ImmutableProp prop) {
        return prop.isNullable();
    }
}

