/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.apt.generator;

import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.util.ArrayList;
import java.util.Map;
import javax.lang.model.element.Modifier;
import javax.validation.constraints.Email;
import javax.validation.constraints.Pattern;
import org.babyfish.jimmer.CircularReferenceException;
import org.babyfish.jimmer.ImmutableObjects;
import org.babyfish.jimmer.apt.generator.CaseAppender;
import org.babyfish.jimmer.apt.generator.Constants;
import org.babyfish.jimmer.apt.generator.ValidationGenerator;
import org.babyfish.jimmer.apt.meta.ImmutableProp;
import org.babyfish.jimmer.apt.meta.ImmutableType;
import org.babyfish.jimmer.meta.PropId;
import org.babyfish.jimmer.runtime.DraftContext;
import org.babyfish.jimmer.runtime.DraftSpi;
import org.babyfish.jimmer.runtime.ImmutableSpi;
import org.babyfish.jimmer.runtime.NonSharedList;
import org.jetbrains.annotations.Nullable;

public class DraftImplGenerator {
    private final ImmutableType type;
    private final ClassName draftSpiClassName;
    private TypeSpec.Builder typeBuilder;
    private static final String UNMODIFIED = "(__modified!= null ? __modified : __base)";

    public DraftImplGenerator(ImmutableType type) {
        this.type = type;
        this.draftSpiClassName = ClassName.get(DraftSpi.class);
    }

    public void generate(TypeSpec.Builder parentBuilder) {
        this.typeBuilder = TypeSpec.classBuilder((String)"DraftImpl").addModifiers(new Modifier[]{Modifier.PRIVATE, Modifier.STATIC}).addSuperinterface((TypeName)this.type.getImplementorClassName()).addSuperinterface((TypeName)this.draftSpiClassName).addSuperinterface((TypeName)this.type.getDraftClassName());
        this.addFields();
        this.addStaticFields();
        this.addConstructor();
        this.addReadonlyMethods();
        for (ImmutableProp prop : this.type.getProps().values()) {
            this.addGetter(prop);
            this.addCreator(prop);
            this.addSetter(prop);
            this.addUtilMethod(prop, false);
            this.addUtilMethod(prop, true);
        }
        this.addSet(PropId.class);
        this.addSet(String.class);
        this.addShow(PropId.class);
        this.addShow(String.class);
        this.addUnload(PropId.class);
        this.addUnload(String.class);
        this.addDraftContext();
        this.addResolve();
        this.addModified();
        parentBuilder.addType(this.typeBuilder.build());
    }

    private void addFields() {
        this.typeBuilder.addField(FieldSpec.builder((TypeName)Constants.DRAFT_CONTEXT_CLASS_NAME, (String)"__ctx", (Modifier[])new Modifier[]{Modifier.PRIVATE}).build());
        this.typeBuilder.addField(FieldSpec.builder((TypeName)this.type.getImplClassName(), (String)"__base", (Modifier[])new Modifier[]{Modifier.PRIVATE}).build());
        this.typeBuilder.addField(FieldSpec.builder((TypeName)this.type.getImplClassName(), (String)"__modified", (Modifier[])new Modifier[]{Modifier.PRIVATE}).build());
        this.typeBuilder.addField(FieldSpec.builder(Boolean.TYPE, (String)"__resolving", (Modifier[])new Modifier[]{Modifier.PRIVATE}).build());
    }

    private void addStaticFields() {
        boolean hasEmail = false;
        for (ImmutableProp immutableProp : this.type.getProps().values()) {
            Email[] emails = (Email[])immutableProp.getAnnotations(Email.class);
            Pattern[] patterns = (Pattern[])immutableProp.getAnnotations(Pattern.class);
            if (emails.length != 0) {
                hasEmail = true;
            }
            for (int i = 0; i < patterns.length; ++i) {
                int flags = 0;
                for (Pattern.Flag flag : patterns[i].flags()) {
                    flags |= flag.getValue();
                }
                FieldSpec.Builder builder = FieldSpec.builder(java.util.regex.Pattern.class, (String)Constants.regexpPatternFieldName(immutableProp, i), (Modifier[])new Modifier[]{Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL}).initializer("$T.compile($S, $L)", new Object[]{java.util.regex.Pattern.class, patterns[i].regexp(), flags});
                this.typeBuilder.addField(builder.build());
            }
        }
        if (hasEmail) {
            FieldSpec.Builder builder = FieldSpec.builder(java.util.regex.Pattern.class, (String)"__EMAIL_PATTERN__", (Modifier[])new Modifier[]{Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL}).initializer("$T.compile($S)", new Object[]{java.util.regex.Pattern.class, "^[^@]+@[^@]+$"});
            this.typeBuilder.addField(builder.build());
        }
        for (Map.Entry entry : this.type.getValidationMessageMap().entrySet()) {
            FieldSpec.Builder builder = FieldSpec.builder((TypeName)ParameterizedTypeName.get((ClassName)Constants.VALIDATOR_CLASS_NAME, (TypeName[])new TypeName[]{this.type.getClassName()}), (String)Constants.validatorFieldName((ClassName)entry.getKey()), (Modifier[])new Modifier[]{Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL}).initializer("\n    new $T<>($T.class, $S, $T.class, null)", new Object[]{Constants.VALIDATOR_CLASS_NAME, entry.getKey(), entry.getValue(), this.type.getClassName()});
            this.typeBuilder.addField(builder.build());
        }
        for (ImmutableProp immutableProp : this.type.getProps().values()) {
            for (Map.Entry<ClassName, String> e : immutableProp.getValidationMessageMap().entrySet()) {
                FieldSpec.Builder builder = FieldSpec.builder((TypeName)ParameterizedTypeName.get((ClassName)Constants.VALIDATOR_CLASS_NAME, (TypeName[])new TypeName[]{immutableProp.getTypeName()}), (String)Constants.validatorFieldName(immutableProp, e.getKey()), (Modifier[])new Modifier[]{Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL}).initializer("\n    new $T<>($T.class, $S, $T.class, $T.byIndex($L))", new Object[]{Constants.VALIDATOR_CLASS_NAME, e.getKey(), e.getValue(), this.type.getClassName(), Constants.PROP_ID_CLASS_NAME, immutableProp.getSlotName()});
                this.typeBuilder.addField(builder.build());
            }
        }
    }

    private void addConstructor() {
        MethodSpec.Builder builder = MethodSpec.constructorBuilder().addParameter((TypeName)Constants.DRAFT_CONTEXT_CLASS_NAME, "ctx", new Modifier[0]).addParameter((TypeName)this.type.getClassName(), "base", new Modifier[0]).addStatement("$L = ctx", new Object[]{"__ctx"}).beginControlFlow("if (base != null)", new Object[0]).addStatement("$L = ($T)base", new Object[]{"__base", this.type.getImplClassName()}).endControlFlow().beginControlFlow("else", new Object[0]).addStatement("$L = new $T()", new Object[]{"__modified", this.type.getImplClassName()}).endControlFlow();
        this.typeBuilder.addMethod(builder.build());
    }

    private void addReadonlyMethods() {
        this.typeBuilder.addMethod(MethodSpec.methodBuilder((String)"__isLoaded").addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Override.class).addParameter(PropId.class, "prop", new Modifier[0]).returns(Boolean.TYPE).addStatement("return $L.__isLoaded(prop)", new Object[]{UNMODIFIED}).build());
        this.typeBuilder.addMethod(MethodSpec.methodBuilder((String)"__isLoaded").addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Override.class).addParameter(String.class, "prop", new Modifier[0]).returns(Boolean.TYPE).addStatement("return $L.__isLoaded(prop)", new Object[]{UNMODIFIED}).build());
        this.typeBuilder.addMethod(MethodSpec.methodBuilder((String)"__isVisible").addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Override.class).addParameter(PropId.class, "prop", new Modifier[0]).returns(Boolean.TYPE).addStatement("return $L.__isVisible(prop)", new Object[]{UNMODIFIED}).build());
        this.typeBuilder.addMethod(MethodSpec.methodBuilder((String)"__isVisible").addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Override.class).addParameter(String.class, "prop", new Modifier[0]).returns(Boolean.TYPE).addStatement("return $L.__isVisible(prop)", new Object[]{UNMODIFIED}).build());
        this.typeBuilder.addMethod(MethodSpec.methodBuilder((String)"hashCode").addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Override.class).returns(Integer.TYPE).addStatement("return $L.hashCode()", new Object[]{UNMODIFIED}).build());
        this.typeBuilder.addMethod(MethodSpec.methodBuilder((String)"__hashCode").addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Override.class).addParameter(Boolean.TYPE, "shallow", new Modifier[0]).returns(Integer.TYPE).addStatement("return $L.__hashCode(shallow)", new Object[]{UNMODIFIED}).build());
        this.typeBuilder.addMethod(MethodSpec.methodBuilder((String)"equals").addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Override.class).addParameter(Object.class, "obj", new Modifier[0]).returns(Boolean.TYPE).addStatement("return $L.equals(obj)", new Object[]{UNMODIFIED}).build());
        this.typeBuilder.addMethod(MethodSpec.methodBuilder((String)"__equals").addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Override.class).addParameter(Object.class, "obj", new Modifier[0]).addParameter(Boolean.TYPE, "shallow", new Modifier[0]).returns(Boolean.TYPE).addStatement("return $L.__equals(obj, shallow)", new Object[]{UNMODIFIED}).build());
        this.typeBuilder.addMethod(MethodSpec.methodBuilder((String)"toString").addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Override.class).returns(String.class).addStatement("return $T.toString($L)", new Object[]{ImmutableObjects.class, UNMODIFIED}).build());
    }

    private void addGetter(ImmutableProp prop) {
        ImmutableProp baseProp;
        if (prop.getManyToManyViewBaseProp() != null) {
            return;
        }
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)prop.getGetterName()).addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Override.class).returns(prop.getDraftTypeName(false));
        if (prop.isBeanStyle()) {
            builder.addAnnotation(Constants.JSON_IGNORE_CLASS_NAME);
        }
        if (prop.isNullable()) {
            builder.addAnnotation(Nullable.class);
        }
        if ((baseProp = prop.getIdViewBaseProp()) != null) {
            if (baseProp.isList()) {
                builder.addStatement("$T<$T> __ids = new $T($L().size())", new Object[]{Constants.LIST_CLASS_NAME, baseProp.getTargetType().getIdProp().getTypeName().box(), ArrayList.class, baseProp.getGetterName()});
                builder.beginControlFlow("for ($T __target : $L())", new Object[]{baseProp.getElementTypeName(), baseProp.getGetterName()});
                builder.addStatement("__ids.add(__target.$L())", new Object[]{baseProp.getTargetType().getIdProp().getGetterName()});
                builder.endControlFlow();
                builder.addStatement("return __ids", new Object[0]);
            } else {
                builder.addStatement("$T __target = $L()", new Object[]{baseProp.getElementTypeName(), baseProp.getGetterName()});
                builder.addStatement(prop.isNullable() ? "return __target != null ? __target.$L() : null" : "return __target.$L()", new Object[]{baseProp.getTargetType().getIdProp().getGetterName()});
            }
        } else if (prop.isList()) {
            builder.addCode("return $L.$L($L.$L(), $T.class, $L);", new Object[]{"__ctx", "toDraftList", UNMODIFIED, prop.getGetterName(), prop.getElementTypeName(), prop.isAssociation(false)});
        } else if (prop.isAssociation(false)) {
            builder.addCode("return $L.$L($L.$L());", new Object[]{"__ctx", "toDraftObject", UNMODIFIED, prop.getGetterName()});
        } else {
            builder.addCode("return $L.$L();", new Object[]{UNMODIFIED, prop.getGetterName()});
        }
        this.typeBuilder.addMethod(builder.build());
    }

    private void addCreator(ImmutableProp prop) {
        if (prop.getManyToManyViewBaseProp() != null) {
            return;
        }
        if (!prop.isAssociation(false) && !prop.isList()) {
            return;
        }
        ImmutableProp realProp = prop.getIdViewBaseProp();
        if (realProp == null) {
            realProp = prop;
        }
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)prop.getGetterName()).addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Override.class).addParameter(Boolean.TYPE, "autoCreate", new Modifier[0]).returns(prop.getDraftTypeName(true));
        if (prop.isNullable()) {
            builder.beginControlFlow("if (autoCreate && (!__isLoaded($T.byIndex($L)) || $L() == null))", new Object[]{Constants.PROP_ID_CLASS_NAME, realProp.getSlotName(), realProp.getGetterName()});
        } else {
            builder.beginControlFlow("if (autoCreate && (!__isLoaded($T.byIndex($L))))", new Object[]{Constants.PROP_ID_CLASS_NAME, realProp.getSlotName()});
        }
        if (prop.isList()) {
            builder.addStatement("$L(new $T<>())", new Object[]{realProp.getSetterName(), ArrayList.class});
        } else {
            builder.addStatement("$L($T.$L.produce(null, null))", new Object[]{realProp.getSetterName(), realProp.getDraftElementTypeName(), "$"});
        }
        builder.endControlFlow();
        if (prop.isList()) {
            if (realProp != prop) {
                builder.addStatement("return new $T<>($T.TYPE, $L())", new Object[]{Constants.MUTABLE_ID_VIEW_LIST_CLASS_NAME, realProp.getTargetType().getProducerClassName(), realProp.getGetterName()});
            } else {
                builder.addCode("return $L.$L($L.$L(), $T.class, $L);", new Object[]{"__ctx", "toDraftList", UNMODIFIED, prop.getGetterName(), prop.getElementType(), prop.isAssociation(false)});
            }
        } else {
            builder.addCode("return $L.$L($L.$L());", new Object[]{"__ctx", "toDraftObject", UNMODIFIED, prop.getGetterName()});
        }
        this.typeBuilder.addMethod(builder.build());
    }

    private void addSetter(ImmutableProp prop) {
        if (prop.isJavaFormula() || prop.getManyToManyViewBaseProp() != null) {
            return;
        }
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)prop.getSetterName()).addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Override.class).addParameter(prop.getTypeName(), prop.getName(), new Modifier[0]).returns((TypeName)this.type.getDraftClassName());
        ImmutableProp baseProp = prop.getIdViewBaseProp();
        if (baseProp != null) {
            if (!prop.getReturnType().getKind().isPrimitive()) {
                builder.beginControlFlow("if ($L != null)", new Object[]{prop.getName()});
            }
            if (prop.isList()) {
                builder.addStatement("$T<$T> __targets = new $T($L.size())", new Object[]{Constants.LIST_CLASS_NAME, baseProp.getElementTypeName(), ArrayList.class, prop.getName()});
                builder.beginControlFlow("for ($T __id : $L)", new Object[]{baseProp.getTargetType().getIdProp().getTypeName(), prop.getName()});
                builder.addStatement("__targets.add($T.makeIdOnly($T.class, __id))", new Object[]{ImmutableObjects.class, baseProp.getElementTypeName()});
                builder.endControlFlow();
                builder.addStatement("$L(__targets)", new Object[]{baseProp.getSetterName()});
            } else {
                builder.addStatement("$L($T.makeIdOnly($T.class, $L))", new Object[]{baseProp.getSetterName(), ImmutableObjects.class, baseProp.getElementTypeName(), prop.getName()});
            }
            if (!prop.getReturnType().getKind().isPrimitive()) {
                builder.nextControlFlow("else", new Object[0]);
                if (prop.isList()) {
                    builder.addStatement("$L($T.emptyList())", new Object[]{baseProp.getSetterName(), Constants.COLLECTIONS_CLASS_NAME});
                } else {
                    builder.addStatement("$L(null)", new Object[]{baseProp.getSetterName()});
                }
                builder.endControlFlow();
            }
        } else {
            new ValidationGenerator(prop, prop.getName(), builder).generate();
            builder.addStatement("$T __tmpModified = $L()", new Object[]{this.type.getImplClassName(), "__modified"});
            if (prop.isList()) {
                builder.addStatement("__tmpModified.$L = $T.of(__tmpModified.$L, $L)", new Object[]{prop.getName(), NonSharedList.class, prop.getName(), prop.getName()});
            } else {
                builder.addStatement("__tmpModified.$L = $L", new Object[]{prop.getName(), prop.getName()});
            }
            if (prop.isLoadedStateRequired()) {
                builder.addStatement("__tmpModified.$L = true", new Object[]{prop.getLoadedStateName()});
            }
        }
        builder.addStatement("return this", new Object[0]);
        this.typeBuilder.addMethod(builder.build());
    }

    private void addUtilMethod(ImmutableProp prop, boolean withBase) {
        if (!prop.isAssociation(false) || prop.getManyToManyViewBaseProp() != null) {
            return;
        }
        String methodName = prop.isList() ? prop.getAdderByName() : prop.getApplierName();
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)methodName).addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Override.class).returns((TypeName)this.type.getDraftClassName());
        if (withBase) {
            builder.addParameter(prop.getElementTypeName(), "base", new Modifier[0]);
        }
        ParameterizedTypeName consumerTypeName = ParameterizedTypeName.get((ClassName)Constants.DRAFT_CONSUMER_CLASS_NAME, (TypeName[])new TypeName[]{prop.getDraftElementTypeName()});
        builder.addParameter((TypeName)consumerTypeName, "block", new Modifier[0]);
        if (withBase) {
            if (prop.isList()) {
                builder.addStatement("$L(true).add(($T)$T.$L.produce(base, block))", new Object[]{prop.getGetterName(), prop.getDraftElementTypeName(), prop.getDraftElementTypeName(), "$"});
            } else {
                builder.addStatement("$L($T.$L.produce(base, block))", new Object[]{prop.getSetterName(), prop.getDraftElementTypeName(), "$"});
            }
        } else {
            builder.addStatement("$L(null, $L)", new Object[]{methodName, "block"});
        }
        builder.addStatement("return this", new Object[0]);
        this.typeBuilder.addMethod(builder.build());
    }

    private void addSet(Class<?> argType) {
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)"__set").addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(AnnotationSpec.builder(SuppressWarnings.class).addMember("value", "$S", new Object[]{"unchecked"}).build()).addAnnotation(Override.class).addParameter(argType, "prop", new Modifier[0]).addParameter(Object.class, "value", new Modifier[0]);
        CaseAppender appender = new CaseAppender(builder, this.type, argType);
        if (argType == PropId.class) {
            builder.addStatement("int __propIndex = prop.asIndex()", new Object[0]);
            builder.beginControlFlow("switch (__propIndex)", new Object[0]);
            appender.addIllegalCase();
            builder.addStatement("__set(prop.asName(), value)", new Object[0]);
            builder.addStatement("return", new Object[0]);
        } else {
            builder.beginControlFlow("switch (prop)", new Object[0]);
        }
        for (ImmutableProp prop : this.type.getPropsOrderById()) {
            TypeName castTo = prop.getBoxType();
            if (castTo == null) {
                castTo = prop.getTypeName();
            }
            appender.addCase(prop);
            if (prop.isJavaFormula() || prop.getManyToManyViewBaseProp() != null) {
                builder.addStatement("break", new Object[0]);
                continue;
            }
            if (prop.getTypeName().isPrimitive()) {
                builder.addStatement("if (value == null) throw new $T($S);\n$L(($T)value);\nbreak", new Object[]{IllegalArgumentException.class, "'" + prop.getName() + "' cannot be null", prop.getSetterName(), castTo});
                continue;
            }
            builder.addStatement("$L(($T)value);break", new Object[]{prop.getSetterName(), castTo});
        }
        builder.addStatement("default: throw new IllegalArgumentException($S + prop + $S)", new Object[]{"Illegal property " + (argType == String.class ? "name" : "id") + " for \"" + this.type + "\": \"", "\""});
        builder.endControlFlow();
        this.typeBuilder.addMethod(builder.build());
    }

    private void addShow(Class<?> argType) {
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)"__show").addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Override.class).addParameter(argType, "prop", new Modifier[0]).addParameter(TypeName.BOOLEAN, "visible", new Modifier[0]);
        CaseAppender appender = new CaseAppender(builder, this.type, argType);
        if (argType == PropId.class) {
            builder.addStatement("int __propIndex = prop.asIndex()", new Object[0]);
            builder.beginControlFlow("switch (__propIndex)", new Object[0]);
            appender.addIllegalCase();
            builder.addStatement("__show(prop.asName(), visible)", new Object[0]);
            builder.addStatement("return", new Object[0]);
        } else {
            builder.beginControlFlow("switch (prop)", new Object[0]);
        }
        for (ImmutableProp prop : this.type.getPropsOrderById()) {
            appender.addCase(prop);
            builder.addStatement("$L().__visibility.show($L, visible);break", new Object[]{"__modified", prop.getSlotName()});
        }
        builder.addStatement("default: throw new IllegalArgumentException(\n$>$S + \nprop + \n$S\n$<)", new Object[]{"Illegal property " + (argType == String.class ? "name" : "id") + " for \"" + this.type + "\": \"", "\",it does not exists"});
        builder.endControlFlow();
        this.typeBuilder.addMethod(builder.build());
    }

    private void addUnload(Class<?> argType) {
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)"__unload").addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Override.class).addParameter(argType, "prop", new Modifier[0]);
        CaseAppender appender = new CaseAppender(builder, this.type, argType);
        if (argType == PropId.class) {
            builder.addStatement("int __propIndex = prop.asIndex()", new Object[0]);
            builder.beginControlFlow("switch (__propIndex)", new Object[0]);
            appender.addIllegalCase();
            builder.addStatement("__unload(prop.asName())", new Object[0]);
            builder.addStatement("return", new Object[0]);
        } else {
            builder.beginControlFlow("switch (prop)", new Object[0]);
        }
        for (ImmutableProp prop : this.type.getPropsOrderById()) {
            appender.addCase(prop);
            if (prop.getBaseProp() != null) {
                builder.addStatement("__unload($T.byIndex($L));break", new Object[]{Constants.PROP_ID_CLASS_NAME, prop.getBaseProp().getSlotName()});
                continue;
            }
            if (prop.isJavaFormula()) {
                builder.addStatement("break", new Object[0]);
                continue;
            }
            if (prop.isLoadedStateRequired()) {
                builder.addStatement("$L().$L = false;break", new Object[]{"__modified", prop.getLoadedStateName()});
                continue;
            }
            builder.addStatement("$L().$L = null;break", new Object[]{"__modified", prop.getName()});
        }
        builder.addStatement("default: throw new IllegalArgumentException($S + prop + $S)", new Object[]{"Illegal property " + (argType == String.class ? "name" : "id") + " for \"" + this.type + "\": \"", "\", it does not exist or its loaded state is not controllable"});
        builder.endControlFlow();
        this.typeBuilder.addMethod(builder.build());
    }

    private void addDraftContext() {
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)"__draftContext").addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Override.class).returns(DraftContext.class).addStatement("return $L", new Object[]{"__ctx"});
        this.typeBuilder.addMethod(builder.build());
    }

    private void addResolve() {
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)"__resolve").addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Override.class).returns(Object.class);
        builder.beginControlFlow("if ($L)", new Object[]{"__resolving"}).addStatement("throw new $T()", new Object[]{CircularReferenceException.class}).endControlFlow();
        builder.addStatement("$L = true", new Object[]{"__resolving"}).beginControlFlow("try", new Object[0]);
        this.addResolveCode(builder);
        builder.endControlFlow().beginControlFlow("finally", new Object[0]).addStatement("$L = false", new Object[]{"__resolving"}).endControlFlow();
        this.typeBuilder.addMethod(builder.build());
    }

    private void addResolveCode(MethodSpec.Builder builder) {
        builder.addStatement("Implementor base = $L", new Object[]{"__base"}).addStatement("Impl __tmpModified = $L", new Object[]{"__modified"});
        if (this.type.getProps().values().stream().anyMatch(it -> it.isAssociation(false) || it.isList())) {
            builder.beginControlFlow("if (__tmpModified == null)", new Object[0]);
            for (ImmutableProp immutableProp : this.type.getProps().values()) {
                if (!immutableProp.isValueRequired() || !immutableProp.isAssociation(false) && !immutableProp.isList()) continue;
                builder.beginControlFlow("if (base.__isLoaded($T.byIndex($L)))", new Object[]{Constants.PROP_ID_CLASS_NAME, immutableProp.getSlotName()});
                builder.addStatement("$T oldValue = base.$L()", new Object[]{immutableProp.getTypeName(), immutableProp.getGetterName()});
                builder.addStatement("$T newValue = $L.$L(oldValue)", new Object[]{immutableProp.getTypeName(), "__ctx", immutableProp.isList() ? "resolveList" : "resolveObject"});
                if (immutableProp.isList()) {
                    builder.beginControlFlow("if (oldValue != newValue)", new Object[0]);
                } else {
                    builder.beginControlFlow("if (!$T.equals(oldValue, newValue, true))", new Object[]{ImmutableSpi.class});
                }
                builder.addStatement("$L(newValue)", new Object[]{immutableProp.getSetterName()});
                builder.endControlFlow();
                builder.endControlFlow();
            }
            builder.addStatement("__tmpModified = $L", new Object[]{"__modified"});
            builder.endControlFlow();
            builder.beginControlFlow("else", new Object[0]);
            for (ImmutableProp immutableProp : this.type.getProps().values()) {
                if (!immutableProp.isValueRequired()) continue;
                if (immutableProp.isList()) {
                    builder.addStatement("__tmpModified.$L = $T.of(__tmpModified.$L, $L.$L(__tmpModified.$L))", new Object[]{immutableProp.getName(), NonSharedList.class, immutableProp.getName(), "__ctx", "resolveList", immutableProp.getName()});
                    continue;
                }
                if (!immutableProp.isAssociation(false)) continue;
                builder.addStatement("__tmpModified.$L = $L.$L(__tmpModified.$L)", new Object[]{immutableProp.getName(), "__ctx", "resolveObject", immutableProp.getName()});
            }
            builder.endControlFlow();
        }
        builder.beginControlFlow("if (__base != null && (__tmpModified == null || $T.equals(base, __tmpModified, true)))", new Object[]{ImmutableSpi.class}).addStatement("return base", new Object[0]).endControlFlow();
        for (Map.Entry entry : this.type.getValidationMessageMap().entrySet()) {
            builder.addStatement("$L.validate(__tmpModified)", new Object[]{Constants.validatorFieldName((ClassName)entry.getKey())});
        }
        builder.addStatement("return __tmpModified", new Object[0]);
    }

    private void addModified() {
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)"__modified").addModifiers(new Modifier[]{Modifier.PRIVATE}).returns((TypeName)this.type.getImplClassName()).addStatement("$T __tmpModified = $L", new Object[]{this.type.getImplClassName(), "__modified"}).beginControlFlow("if (__tmpModified == null)", new Object[0]).addStatement("__tmpModified = $L.clone()", new Object[]{"__base"}).addStatement("$L = __tmpModified", new Object[]{"__modified"}).endControlFlow().addStatement("return __tmpModified", new Object[0]);
        this.typeBuilder.addMethod(builder.build());
    }
}

