/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.apt.meta;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import org.babyfish.jimmer.Formula;
import org.babyfish.jimmer.Scalar;
import org.babyfish.jimmer.apt.Context;
import org.babyfish.jimmer.apt.meta.ImmutableType;
import org.babyfish.jimmer.apt.meta.MetaException;
import org.babyfish.jimmer.apt.meta.ValidationMessages;
import org.babyfish.jimmer.meta.impl.PropDescriptor;
import org.babyfish.jimmer.meta.impl.ViewUtils;
import org.babyfish.jimmer.sql.IdView;
import org.babyfish.jimmer.sql.JoinSql;
import org.babyfish.jimmer.sql.ManyToMany;
import org.babyfish.jimmer.sql.ManyToManyView;
import org.babyfish.jimmer.sql.ManyToOne;
import org.babyfish.jimmer.sql.MappedSuperclass;
import org.babyfish.jimmer.sql.OneToMany;
import org.babyfish.jimmer.sql.OneToOne;
import org.babyfish.jimmer.sql.Serialized;
import org.babyfish.jimmer.sql.Transient;

public class ImmutableProp {
    private final ImmutableType declaringType;
    private final ExecutableElement executableElement;
    private final String name;
    private final int id;
    private final String getterName;
    private final String setterName;
    private final String applierName;
    private final String adderByName;
    private final boolean beanStyle;
    private final String loadedStateName;
    private final String visibleName;
    private final TypeMirror returnType;
    private final TypeName typeName;
    private final TypeName draftTypeName;
    private final TypeName elementTypeName;
    private final TypeName draftElementTypeName;
    private final TypeMirror elementType;
    private final boolean isTransient;
    private final boolean hasTransientResolver;
    private final boolean isJavaFormula;
    private final boolean isList;
    private final boolean isAssociation;
    private final boolean isEntityAssociation;
    private final boolean isNullable;
    private final boolean isReverse;
    private final Map<ClassName, String> validationMessageMap;
    private Annotation associationAnnotation;
    private ImmutableType targetType;
    private Set<ImmutableProp> dependencies;
    private ImmutableProp idViewBaseProp;
    private ImmutableProp manyToManyViewBaseProp;
    private ImmutableProp manyToManyViewBaseDeeperProp;
    private boolean isVisibilityControllable;
    private Boolean remote;

    public ImmutableProp(Context context, ImmutableType declaringType, ExecutableElement executableElement, int id) {
        this.id = id;
        this.declaringType = declaringType;
        this.executableElement = executableElement;
        this.getterName = executableElement.getSimpleName().toString();
        this.returnType = executableElement.getReturnType();
        if (this.returnType.getKind() == TypeKind.VOID) {
            throw new MetaException(executableElement, "it cannot return void");
        }
        if (!executableElement.getParameters().isEmpty()) {
            throw new MetaException(executableElement, "it cannot have paremeter(s)");
        }
        if (!context.keepIsPrefix() && this.returnType.getKind() == TypeKind.BOOLEAN && this.getterName.startsWith("is") && this.getterName.length() > 2 && Character.isUpperCase(this.getterName.charAt(2))) {
            this.name = this.getterName.substring(2, 3).toLowerCase() + this.getterName.substring(3);
            this.setterName = "set" + this.getterName.substring(2);
            this.applierName = "apply" + this.getterName.substring(2);
            this.adderByName = "addInto" + this.getterName.substring(2);
            this.beanStyle = true;
        } else if (this.getterName.startsWith("get") && this.getterName.length() > 3 && Character.isUpperCase(this.getterName.charAt(3))) {
            this.name = this.getterName.substring(3, 4).toLowerCase() + this.getterName.substring(4);
            this.setterName = "set" + this.getterName.substring(3);
            this.applierName = "apply" + this.getterName.substring(3);
            this.adderByName = "addInto" + this.getterName.substring(3);
            this.beanStyle = true;
        } else {
            this.name = this.getterName;
            String suffix = this.getterName.substring(0, 1).toUpperCase() + this.getterName.substring(1);
            this.setterName = "set" + suffix;
            this.applierName = "apply" + suffix;
            this.adderByName = "addInto" + suffix;
            this.beanStyle = false;
        }
        this.loadedStateName = "__" + this.name + "Loaded";
        this.visibleName = "__" + this.name + "Visible";
        if (context.isCollection(this.returnType) && !this.isExplicitScalar()) {
            if (!context.isListStrictly(this.returnType)) {
                throw new MetaException(executableElement, "the collection property must return 'java.util.List'");
            }
            List<? extends TypeMirror> typeArguments = ((DeclaredType)this.returnType).getTypeArguments();
            if (typeArguments.isEmpty()) {
                throw new MetaException(executableElement, "its return type must be generic type");
            }
            this.isList = true;
            this.elementType = typeArguments.get(0);
            boolean isElementTypeValid = false;
            if (this.elementType.getKind().isPrimitive()) {
                isElementTypeValid = true;
            } else if (this.elementType instanceof DeclaredType) {
                isElementTypeValid = ((DeclaredType)this.elementType).getTypeArguments().isEmpty();
            }
            if (!isElementTypeValid) {
                throw new MetaException(executableElement, "its list whose elements are neither primitive type nor class/interface without generic parameters, whether to forcibly treat the current property as a non-list property (such as a JSON serialized field)?. if so, please decorate the current property with @" + Scalar.class.getName() + " or any other scalar-decorated annotations (such as @" + Serialized.class + ")");
            }
        } else {
            this.isList = false;
            this.elementType = this.returnType;
        }
        if (context.isMappedSuperclass(this.elementType)) {
            throw new MetaException(executableElement, "the target type \"" + TypeName.get((TypeMirror)this.elementType) + "\" is illegal, it cannot be type decorated by @MappedSuperclass");
        }
        Transient trans = executableElement.getAnnotation(Transient.class);
        this.isTransient = trans != null;
        boolean hasResolver = false;
        if (this.isTransient) {
            for (AnnotationMirror annotationMirror : executableElement.getAnnotationMirrors()) {
                if (!((TypeElement)annotationMirror.getAnnotationType().asElement()).getQualifiedName().toString().equals(Transient.class.getName())) continue;
                boolean hasValue = false;
                boolean bl = false;
                for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> e : annotationMirror.getElementValues().entrySet()) {
                    if (e.getKey().getSimpleName().contentEquals("value")) {
                        hasValue = !e.getValue().toString().equals("void");
                        continue;
                    }
                    if (!e.getKey().getSimpleName().contentEquals("ref")) continue;
                    bl = !e.getValue().toString().isEmpty();
                }
                if (hasValue && bl) {
                    throw new MetaException(executableElement, "it is decorated by @Transient, the `value` and `ref` are both specified, this is not allowed");
                }
                hasResolver = hasValue || bl;
            }
        }
        this.hasTransientResolver = hasResolver;
        Formula formula = executableElement.getAnnotation(Formula.class);
        this.isJavaFormula = formula != null && formula.sql().isEmpty();
        this.isAssociation = context.isImmutable(this.elementType);
        if (declaringType.isAcrossMicroServices() && this.isAssociation && context.isEntity(this.elementType) && !this.isTransient) {
            throw new MetaException(executableElement, "association property is not allowed here because the declaring type is decorated by \"@" + MappedSuperclass.class.getName() + "\" with the argument `acrossMicroServices`");
        }
        this.isEntityAssociation = context.isEntity(this.elementType);
        if (this.isList && context.isEmbeddable(this.elementType)) {
            throw new MetaException(executableElement, "the target type \"" + TypeName.get((TypeMirror)this.elementType) + "\" is embeddable so that the property type cannot be list");
        }
        this.elementTypeName = TypeName.get((TypeMirror)this.elementType);
        this.typeName = this.isList ? ParameterizedTypeName.get((ClassName)ClassName.get(List.class), (TypeName[])new TypeName[]{this.elementTypeName}) : this.elementTypeName;
        PropDescriptor.Builder builder = PropDescriptor.newBuilder((boolean)false, (String)declaringType.getTypeElement().getQualifiedName().toString(), context.getImmutableAnnotationType(declaringType.getTypeElement()), (String)this.toString(), (String)ClassName.get((TypeMirror)this.elementType).toString(), context.getImmutableAnnotationType(this.elementType), (boolean)this.isList, (Boolean)(this.typeName.isPrimitive() || this.typeName.isBoxedPrimitive() ? Boolean.valueOf(this.typeName.isBoxedPrimitive()) : null), reason -> new MetaException(executableElement, (String)reason));
        block2: for (AnnotationMirror annotationMirror : executableElement.getAnnotationMirrors()) {
            String annotationTypeName = ((TypeElement)annotationMirror.getAnnotationType().asElement()).getQualifiedName().toString();
            builder.add(annotationTypeName);
            if (!PropDescriptor.MAPPED_BY_PROVIDER_NAMES.contains(annotationTypeName)) continue;
            for (ExecutableElement executableElement2 : annotationMirror.getElementValues().keySet()) {
                if (!executableElement2.getSimpleName().contentEquals("mappedBy")) continue;
                builder.hasMappedBy();
                continue block2;
            }
        }
        PropDescriptor descriptor = builder.build();
        if (descriptor.getType().isAssociation()) {
            this.associationAnnotation = executableElement.getAnnotation(descriptor.getType().getAnnotationType());
        }
        this.isNullable = descriptor.isNullable();
        if (this.isAssociation) {
            OneToOne oneToOne = this.getAnnotation(OneToOne.class);
            OneToMany oneToMany = this.getAnnotation(OneToMany.class);
            ManyToMany manyToMany = this.getAnnotation(ManyToMany.class);
            this.isReverse = oneToOne != null && !oneToOne.mappedBy().isEmpty() || oneToMany != null && !oneToMany.mappedBy().isEmpty() || manyToMany != null && !manyToMany.mappedBy().isEmpty();
        } else {
            this.isReverse = false;
        }
        this.draftElementTypeName = this.isAssociation ? ClassName.get((String)((ClassName)this.elementTypeName).packageName(), (String)(((ClassName)this.elementTypeName).simpleName() + "Draft"), (String[])new String[0]) : this.elementTypeName;
        this.draftTypeName = this.isList ? ParameterizedTypeName.get((ClassName)ClassName.get(List.class), (TypeName[])new TypeName[]{this.draftElementTypeName}) : this.draftElementTypeName;
        this.validationMessageMap = ValidationMessages.parseMessageMap(executableElement);
    }

    public ImmutableType getDeclaringType() {
        return this.declaringType;
    }

    public int getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getGetterName() {
        return this.getterName;
    }

    public String getSetterName() {
        return this.setterName;
    }

    public String getApplierName() {
        return this.applierName;
    }

    public String getAdderByName() {
        return this.adderByName;
    }

    public boolean isBeanStyle() {
        return this.beanStyle;
    }

    public String getLoadedStateName() {
        return this.getLoadedStateName(false);
    }

    public String getVisibleName() {
        return this.visibleName;
    }

    public String getLoadedStateName(boolean force) {
        if (!force && !this.isLoadedStateRequired()) {
            throw new IllegalStateException("The property \"" + this + "\" does not has loaded state");
        }
        return this.loadedStateName;
    }

    public TypeMirror getReturnType() {
        return this.returnType;
    }

    public TypeMirror getElementType() {
        return this.elementType;
    }

    public TypeName getTypeName() {
        return this.typeName;
    }

    public TypeName getDraftTypeName(boolean autoCreate) {
        if (this.isList && !autoCreate) {
            return this.typeName;
        }
        return this.draftTypeName;
    }

    public TypeName getElementTypeName() {
        return this.elementTypeName;
    }

    public TypeName getRawElementTypeName() {
        return this.elementTypeName instanceof ParameterizedTypeName ? ((ParameterizedTypeName)this.elementTypeName).rawType : this.elementTypeName;
    }

    public TypeName getDraftElementTypeName() {
        return this.draftElementTypeName;
    }

    public boolean isTransient() {
        return this.isTransient;
    }

    public boolean hasTransientResolver() {
        return this.hasTransientResolver;
    }

    public boolean isJavaFormula() {
        return this.isJavaFormula;
    }

    public boolean isList() {
        return this.isList;
    }

    public boolean isAssociation(boolean entityLevel) {
        return entityLevel ? this.isEntityAssociation : this.isAssociation;
    }

    public boolean isNullable() {
        return this.isNullable;
    }

    public boolean isReverse() {
        return this.isReverse;
    }

    public boolean isValueRequired() {
        return this.idViewBaseProp == null && this.manyToManyViewBaseProp == null && !this.isJavaFormula;
    }

    public boolean isLoadedStateRequired() {
        return this.idViewBaseProp == null && !this.isJavaFormula && (this.isNullable || this.typeName.isPrimitive());
    }

    public boolean isDsl(boolean isTableEx) {
        if (this.idViewBaseProp != null || this.isJavaFormula || this.isTransient) {
            return false;
        }
        if (this.isRemote() && this.isReverse) {
            return false;
        }
        if (isTableEx && !this.isAssociation(true)) {
            return false;
        }
        if (this.isRemote() && !this.isList && isTableEx) {
            return false;
        }
        if (this.isList && this.isAssociation(true)) {
            return isTableEx;
        }
        return true;
    }

    public Class<?> getBoxType() {
        switch (this.returnType.getKind()) {
            case BOOLEAN: {
                return Boolean.class;
            }
            case CHAR: {
                return Character.class;
            }
            case BYTE: {
                return Byte.class;
            }
            case SHORT: {
                return Short.class;
            }
            case INT: {
                return Integer.class;
            }
            case LONG: {
                return Long.class;
            }
            case FLOAT: {
                return Float.class;
            }
            case DOUBLE: {
                return Double.class;
            }
        }
        return null;
    }

    public ImmutableType getTargetType() {
        return this.targetType;
    }

    public Set<ImmutableProp> getDependencies() {
        return this.dependencies;
    }

    public ImmutableProp getBaseProp() {
        return this.idViewBaseProp != null ? this.idViewBaseProp : this.manyToManyViewBaseProp;
    }

    public ImmutableProp getIdViewBaseProp() {
        return this.idViewBaseProp;
    }

    public ImmutableProp getManyToManyViewBaseProp() {
        return this.manyToManyViewBaseProp;
    }

    public ImmutableProp getManyToManyViewBaseDeeperProp() {
        return this.manyToManyViewBaseDeeperProp;
    }

    public boolean isVisibilityControllable() {
        return this.isVisibilityControllable;
    }

    public boolean isRemote() {
        Boolean remote = this.remote;
        if (remote == null) {
            remote = this.targetType != null && !this.declaringType.getMicroServiceName().equals(this.targetType.getMicroServiceName());
            if (remote.booleanValue() && this.getAnnotation(JoinSql.class) != null) {
                throw new MetaException(this.executableElement, "the remote association(micro-service names of declaring type and target type are different) cannot be decorated by \"@" + JoinSql.class + "\"");
            }
            this.remote = remote;
        }
        return remote;
    }

    private boolean isExplicitScalar() {
        for (AnnotationMirror annotationMirror : this.executableElement.getAnnotationMirrors()) {
            if (!ImmutableProp.isExplicitScalar(annotationMirror, new HashSet<String>())) continue;
            return true;
        }
        return false;
    }

    private static boolean isExplicitScalar(AnnotationMirror mirror, Set<String> handledQualifiedNames) {
        TypeElement element = (TypeElement)mirror.getAnnotationType().asElement();
        String qualifiedName = element.getQualifiedName().toString();
        if (!handledQualifiedNames.add(qualifiedName)) {
            return false;
        }
        if (qualifiedName.equals(Scalar.class.getName())) {
            return true;
        }
        for (AnnotationMirror annotationMirror : element.getAnnotationMirrors()) {
            if (!ImmutableProp.isExplicitScalar(annotationMirror, handledQualifiedNames)) continue;
            return true;
        }
        return false;
    }

    boolean resolve(Context context, int step) {
        switch (step) {
            case 0: {
                this.resolveTargetType(context);
                return true;
            }
            case 1: {
                this.resolveFormulaDependencies();
                return true;
            }
            case 2: {
                this.resolveIdViewBaseProp();
                return true;
            }
            case 3: {
                this.resolveManyToManyViewProp();
            }
        }
        return false;
    }

    private void resolveTargetType(Context context) {
        if (this.isAssociation) {
            this.targetType = context.getImmutableType(this.elementType);
            if ((this.targetType.isEntity() || this.targetType.isMappedSuperClass()) && this.isRemote() && (this.declaringType.getMicroServiceName().isEmpty() || this.targetType.getMicroServiceName().isEmpty())) {
                throw new MetaException(this.executableElement, "when the micro service name(`" + this.declaringType.getMicroServiceName() + "`) of source type(" + this.declaringType.getQualifiedName() + ") and the micro service name(`" + this.targetType.getMicroServiceName() + "`) of target type(" + this.targetType.getQualifiedName() + ") are not equal, neither of them must be empty");
            }
        }
    }

    private void resolveFormulaDependencies() {
        Formula formula = this.getAnnotation(Formula.class);
        if (formula == null || formula.dependencies().length == 0) {
            this.dependencies = Collections.emptySet();
        } else {
            Map<String, ImmutableProp> propMap = this.declaringType.getProps();
            LinkedHashSet<ImmutableProp> props = new LinkedHashSet<ImmutableProp>();
            for (String dependency : formula.dependencies()) {
                ImmutableProp prop = propMap.get(dependency);
                if (prop == null) {
                    throw new MetaException(this.executableElement, "it is decorated by \"@" + Formula.class.getName() + "\" but the dependency property \"" + dependency + "\" does not eixst");
                }
                props.add(prop);
                prop.isVisibilityControllable = true;
            }
            this.isVisibilityControllable = true;
            this.dependencies = Collections.unmodifiableSet(props);
        }
    }

    private void resolveIdViewBaseProp() {
        IdView idView = this.getAnnotation(IdView.class);
        if (idView == null) {
            return;
        }
        String base = idView.value();
        if (base.isEmpty() && (base = ViewUtils.defaultBasePropName((boolean)this.isList, (String)this.name)) == null) {
            throw new MetaException(this.executableElement, "it is decorated by \"@" + IdView.class.getName() + "\", the argument of that annotation is not specified by the base property name cannot be determined automatically, please specify the argument of that annotation");
        }
        if (base.equals(this.name)) {
            throw new MetaException(this.executableElement, "it is decorated by \"@" + IdView.class.getName() + "\", the argument of that annotation cannot be equal to the current property name\"" + this.name + "\"");
        }
        ImmutableProp baseProp = this.declaringType.getProps().get(base);
        if (baseProp == null) {
            throw new MetaException(this.executableElement, "it is decorated by \"@" + IdView.class.getName() + "\" but there is no base property \"" + base + "\" in the declaring type");
        }
        if (!baseProp.isAssociation(true) || baseProp.isTransient) {
            throw new MetaException(this.executableElement, "it is decorated by \"@" + IdView.class.getName() + "\" but the base property \"" + baseProp + "\" is not persistence association");
        }
        if (this.isList != baseProp.isList) {
            throw new MetaException(this.executableElement, "it " + (this.isList ? "is" : "is not") + " list and decorated by \"@" + IdView.class.getName() + "\" but the base property \"" + baseProp + "\" " + (baseProp.isList ? "is" : "is not") + " list");
        }
        if (this.isNullable != baseProp.isNullable) {
            throw new MetaException(this.executableElement, "it " + (this.isNullable ? "is" : "is not") + " nullable and decorated by \"@" + IdView.class.getName() + "\" but the base property \"" + baseProp + "\" " + (baseProp.isNullable ? "is" : "is not") + " nullable");
        }
        if (!this.elementTypeName.box().equals((Object)baseProp.targetType.getIdProp().getElementTypeName().box())) {
            throw new MetaException(this.executableElement, "it is decorated by \"@" + IdView.class.getName() + "\", the base property \"" + baseProp + "\" returns entity type whose id is \"" + baseProp.targetType.getIdProp().getElementTypeName() + "\", but the current property does not return that type");
        }
        baseProp.isVisibilityControllable = true;
        this.isVisibilityControllable = true;
        this.idViewBaseProp = baseProp;
    }

    private void resolveManyToManyViewProp() {
        ManyToManyView manyToManyView = this.getAnnotation(ManyToManyView.class);
        if (manyToManyView == null) {
            return;
        }
        String propName = manyToManyView.prop();
        ImmutableProp prop = this.declaringType.getProps().get(propName);
        if (prop == null) {
            throw new MetaException(this.executableElement, "it is decorated by \"@" + ManyToManyView.class.getName() + "\" with `prop` is \"" + propName + "\", but there is no such property in the declaring type");
        }
        if (prop.getAnnotation(OneToMany.class) == null) {
            throw new MetaException(this.executableElement, "it is decorated by \"@" + ManyToManyView.class.getName() + "\" whose `prop` is \"" + prop + "\", but that property is not an one-to-many association");
        }
        ImmutableType middleType = prop.getTargetType();
        String deeperPropName = manyToManyView.deeperProp();
        ImmutableProp deeperProp = null;
        if (deeperPropName.isEmpty()) {
            for (ImmutableProp middleProp : middleType.getProps().values()) {
                if (middleProp.getTargetType() != this.targetType || middleProp.getAnnotation(ManyToOne.class) == null) continue;
                if (deeperProp != null) {
                    throw new MetaException(this.executableElement, "it is decorated by \"@" + ManyToManyView.class.getName() + "\" whose `deeperProp` is not specified, however, two many-to-one properties pointing to target type are found: \"" + deeperProp + "\" and \"" + prop + "\", please specify its `deeperProp` explicitly");
                }
                deeperProp = prop;
            }
            if (deeperProp == null) {
                throw new MetaException(this.executableElement, "it is decorated by \"@" + ManyToManyView.class.getName() + "\" whose `deeperProp` is not specified, however, there is no many-property pointing to target type in the middle entity type \"" + middleType + "\"");
            }
        } else {
            deeperProp = middleType.getProps().get(deeperPropName);
            if (deeperProp == null) {
                throw new MetaException(this.executableElement, "it is decorated by \"@" + ManyToManyView.class.getName() + "\" whose `deeperProp` is `" + deeperPropName + "`, however, there is no many-property \"" + deeperPropName + "\" in the middle entity type \"" + middleType + "\"");
            }
            if (deeperProp.targetType != this.targetType || deeperProp.getAnnotation(ManyToOne.class) == null) {
                throw new MetaException(this.executableElement, "it is decorated by \"@" + ManyToManyView.class.getName() + "\" whose `deeperProp` is `" + deeperPropName + "`, however, there is no many-property \"" + deeperPropName + "\" in the middle entity type \"" + middleType + "\"");
            }
        }
        this.manyToManyViewBaseProp = prop;
        this.manyToManyViewBaseDeeperProp = deeperProp;
        this.isVisibilityControllable = true;
        prop.isVisibilityControllable = true;
        deeperProp.isVisibilityControllable = true;
    }

    public <A extends Annotation> A getAnnotation(Class<A> annotationType) {
        return this.executableElement.getAnnotation(annotationType);
    }

    public <A extends Annotation> A[] getAnnotations(Class<A> annotationType) {
        return this.executableElement.getAnnotationsByType(annotationType);
    }

    public List<? extends AnnotationMirror> getAnnotations() {
        return this.executableElement.getAnnotationMirrors();
    }

    public Annotation getAssociationAnnotation() {
        return this.associationAnnotation;
    }

    public Map<ClassName, String> getValidationMessageMap() {
        return this.validationMessageMap;
    }

    public ExecutableElement toElement() {
        return this.executableElement;
    }

    public String toString() {
        return this.declaringType.getTypeElement().getQualifiedName().toString() + '.' + this.name;
    }
}

