/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.apt.generator;

import com.squareup.javapoet.MethodSpec;
import org.babyfish.jimmer.apt.generator.Strings;
import org.babyfish.jimmer.apt.meta.ImmutableProp;
import org.babyfish.jimmer.apt.meta.ImmutableType;

public class CaseAppender {
    private final MethodSpec.Builder builder;
    private final ImmutableType type;
    private final Class<?> argType;

    public CaseAppender(MethodSpec.Builder builder, ImmutableType type, Class<?> argType) {
        this.builder = builder;
        this.type = type;
        this.argType = argType;
    }

    public void addCase(ImmutableProp prop) {
        if (this.argType == Integer.TYPE) {
            ImmutableType declaringType = prop.getDeclaringType();
            if (declaringType == this.type) {
                this.builder.addCode("case $L:\n\t\t", new Object[]{prop.getId()});
            } else {
                this.builder.addCode("case $T.SLOT_$L:\n\t\t", new Object[]{declaringType.getProducerClassName(), Strings.upper(prop.getName())});
            }
        } else {
            this.builder.addCode("case $S:\n\t\t", new Object[]{prop.getName()});
        }
    }
}

