/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.apt;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Filer;
import javax.annotation.processing.Messager;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import javax.tools.Diagnostic;
import org.babyfish.jimmer.apt.Context;
import org.babyfish.jimmer.apt.generator.DraftGenerator;
import org.babyfish.jimmer.apt.generator.ErrorGenerator;
import org.babyfish.jimmer.apt.generator.FetcherGenerator;
import org.babyfish.jimmer.apt.generator.JimmerModuleGenerator;
import org.babyfish.jimmer.apt.generator.PropExpressionGenerator;
import org.babyfish.jimmer.apt.generator.PropsGenerator;
import org.babyfish.jimmer.apt.generator.TableGenerator;
import org.babyfish.jimmer.apt.meta.ImmutableType;
import org.babyfish.jimmer.apt.meta.MetaException;
import org.babyfish.jimmer.error.ErrorFamily;

@SupportedAnnotationTypes(value={"org.babyfish.jimmer.Immutable", "org.babyfish.jimmer.sql.Entity", "org.babyfish.jimmer.sql.MappedSuperclass", "org.babyfish.jimmer.error.ErrorFamily"})
@SupportedSourceVersion(value=SourceVersion.RELEASE_8)
public class ImmutableProcessor
extends AbstractProcessor {
    private Context context;
    private Filer filer;
    private String[] includes = null;
    private String[] excludes = null;
    private Messager messager;
    private final Set<TypeElement> processedTypeElements = new TreeSet<TypeElement>(Comparator.comparing(it -> it.getQualifiedName().toString()));
    private boolean jimmerModuleGenerated;

    @Override
    public synchronized void init(ProcessingEnvironment processingEnv) {
        super.init(processingEnv);
        this.messager = processingEnv.getMessager();
        String includes = processingEnv.getOptions().get("jimmer.source.includes");
        String excludes = processingEnv.getOptions().get("jimmer.source.excludes");
        if (includes != null && !includes.isEmpty()) {
            this.includes = includes.trim().split("\\s*,\\s*");
        }
        if (excludes != null && !excludes.isEmpty()) {
            this.excludes = excludes.trim().split("\\s*,\\s*");
        }
        this.context = new Context(processingEnv.getElementUtils(), processingEnv.getTypeUtils(), "true".equals(processingEnv.getOptions().get("jimmer.keepIsPrefix")));
        this.filer = processingEnv.getFiler();
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        boolean go = false;
        for (Element element : roundEnv.getRootElements()) {
            if (!(element instanceof TypeElement) || !this.processedTypeElements.add((TypeElement)element)) continue;
            go = true;
        }
        if (!go) {
            return true;
        }
        try {
            Map<TypeElement, ImmutableType> immutableTypeMap = this.parseImmutableTypes(roundEnv);
            this.generateJimmerTypes(roundEnv.getRootElements().stream().filter(it -> it instanceof TypeElement).map(immutableTypeMap::get).filter(Objects::nonNull).collect(Collectors.toList()), roundEnv);
            List<TypeElement> list = this.getErrorFamilies(roundEnv);
            this.generateErrorType(list);
        }
        catch (MetaException ex) {
            this.messager.printMessage(Diagnostic.Kind.ERROR, ex.getMessage(), ex.getElement());
        }
        return true;
    }

    private Map<TypeElement, ImmutableType> parseImmutableTypes(RoundEnvironment roundEnv) {
        HashMap<TypeElement, ImmutableType> map = new HashMap<TypeElement, ImmutableType>();
        for (Element element : roundEnv.getRootElements()) {
            TypeElement typeElement;
            if (!(element instanceof TypeElement) || !this.context.isImmutable(typeElement = (TypeElement)element) || !this.include(typeElement)) continue;
            if (typeElement.getKind() != ElementKind.INTERFACE) {
                throw new MetaException(typeElement, "immutable type must be interface");
            }
            ImmutableType immutableType = this.context.getImmutableType(typeElement);
            map.put(typeElement, immutableType);
        }
        int step = 0;
        while (true) {
            int n;
            boolean bl = false;
            for (ImmutableType type : map.values()) {
                n |= type.resolve(this.context, step);
            }
            if (n == 0) break;
            ++step;
        }
        return map;
    }

    private List<TypeElement> getErrorFamilies(RoundEnvironment roundEnv) {
        ArrayList<TypeElement> typeElements = new ArrayList<TypeElement>();
        for (Element element : roundEnv.getRootElements()) {
            if (!(element instanceof TypeElement) || !this.include((TypeElement)element) || element.getAnnotation(ErrorFamily.class) == null) continue;
            if (element.getKind() != ElementKind.ENUM) {
                throw new MetaException(element, "only enum can be decorated by @" + ErrorFamily.class.getName());
            }
            typeElements.add((TypeElement)element);
        }
        return typeElements;
    }

    private boolean include(TypeElement typeElement) {
        String qualifiedName = typeElement.getQualifiedName().toString();
        if (this.includes != null) {
            boolean matched = false;
            String[] stringArray = this.includes;
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                String include = stringArray[i];
                if (!qualifiedName.startsWith(include)) continue;
                return true;
            }
        }
        if (this.excludes != null) {
            for (String exclude : this.excludes) {
                if (!qualifiedName.startsWith(exclude)) continue;
                return false;
            }
        }
        return true;
    }

    private void generateJimmerTypes(Collection<ImmutableType> immutableTypes, RoundEnvironment roundEnv) {
        for (ImmutableType immutableType : immutableTypes) {
            new DraftGenerator(immutableType, this.filer).generate();
            new PropsGenerator(this.context, immutableType, this.filer).generate();
            this.messager.printMessage(Diagnostic.Kind.NOTE, "Immutable: " + immutableType.getQualifiedName());
            if (immutableType.isEntity()) {
                this.messager.printMessage(Diagnostic.Kind.NOTE, "Entity: " + immutableType.getQualifiedName());
                new TableGenerator(this.context, immutableType, false, this.filer).generate();
                new TableGenerator(this.context, immutableType, true, this.filer).generate();
                new FetcherGenerator(this.context, immutableType, this.filer).generate();
                continue;
            }
            if (!immutableType.isEmbeddable()) continue;
            new PropExpressionGenerator(this.context, immutableType, this.filer).generate();
        }
        if (!this.jimmerModuleGenerated) {
            new JimmerModuleGenerator(this.processedTypeElements, this.filer).generate();
            this.jimmerModuleGenerated = true;
        }
    }

    private void generateErrorType(List<TypeElement> typeElements) {
        for (TypeElement typeElement : typeElements) {
            new ErrorGenerator(typeElement, this.filer).generate();
        }
    }
}

