/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.apt.generator;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import javax.lang.model.element.Modifier;
import org.babyfish.jimmer.ImmutableObjects;
import org.babyfish.jimmer.apt.generator.CaseAppender;
import org.babyfish.jimmer.apt.generator.Constants;
import org.babyfish.jimmer.apt.meta.ImmutableProp;
import org.babyfish.jimmer.apt.meta.ImmutableType;
import org.babyfish.jimmer.jackson.ImmutableModuleRequiredException;
import org.babyfish.jimmer.runtime.ImmutableSpi;

public class ImplementorGenerator {
    private ImmutableType type;
    private ClassName spiClassName;
    private TypeSpec.Builder typeBuilder;

    ImplementorGenerator(ImmutableType type) {
        this.type = type;
        this.spiClassName = ClassName.get(ImmutableSpi.class);
    }

    public void generate(TypeSpec.Builder parentBuilder) {
        this.typeBuilder = TypeSpec.classBuilder((String)"Implementor");
        this.typeBuilder.modifiers.add(Modifier.PUBLIC);
        this.typeBuilder.modifiers.add(Modifier.STATIC);
        this.typeBuilder.modifiers.add(Modifier.ABSTRACT);
        this.typeBuilder.addSuperinterface((TypeName)this.type.getClassName());
        this.typeBuilder.addSuperinterface((TypeName)this.spiClassName);
        this.addGet(Integer.TYPE);
        this.addGet(String.class);
        for (ImmutableProp prop : this.type.getProps().values()) {
            this.addGetterIfNecessary(prop);
        }
        this.addType();
        this.addToString();
        this.addDummyProp();
        parentBuilder.addType(this.typeBuilder.build());
    }

    private void addGet(Class<?> argType) {
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)"__get").addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Override.class).addParameter(argType, "prop", new Modifier[0]).returns(Object.class);
        builder.beginControlFlow("switch (prop)", new Object[0]);
        CaseAppender appender = new CaseAppender(builder, this.type, argType);
        for (ImmutableProp prop : this.type.getPropsOrderById()) {
            appender.addCase(prop);
            if (prop.getBoxType() != null) {
                builder.addStatement("return ($T)$L()", new Object[]{prop.getBoxType(), prop.getGetterName()});
                continue;
            }
            builder.addStatement("return $L()", new Object[]{prop.getGetterName()});
        }
        builder.addStatement("default: throw new IllegalArgumentException($S + prop + $S)", new Object[]{"Illegal property " + (argType == Integer.TYPE ? "id" : "name") + " for \"" + this.type + "\": \"", "\""});
        builder.endControlFlow();
        this.typeBuilder.addMethod(builder.build());
    }

    private void addType() {
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)"__type").addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Override.class).returns((TypeName)Constants.RUNTIME_TYPE_CLASS_NAME).addStatement("return TYPE", new Object[0]);
        this.typeBuilder.addMethod(builder.build());
    }

    private void addGetterIfNecessary(ImmutableProp prop) {
        ImmutableProp manyToManyViewBaseProp = prop.getManyToManyViewBaseProp();
        if (manyToManyViewBaseProp != null) {
            this.typeBuilder.addMethod(MethodSpec.methodBuilder((String)prop.getGetterName()).addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(prop.getTypeName()).addStatement("return new $T<>($L, $L())", new Object[]{Constants.MANY_TO_MANY_VIEW_LIST_CLASS_NAME, prop.getManyToManyViewBaseDeeperProp().getId(), manyToManyViewBaseProp.getGetterName()}).build());
        }
        if (!prop.isBeanStyle()) {
            String name = prop.getGetterName();
            boolean isBoolean = prop.getTypeName().equals((Object)TypeName.BOOLEAN);
            this.typeBuilder.addMethod(MethodSpec.methodBuilder((String)((isBoolean ? "is" : "get") + Character.toUpperCase(name.charAt(0)) + name.substring(1))).addAnnotation(JsonIgnore.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(prop.getTypeName()).addStatement("return $L()", new Object[]{name}).build());
        }
    }

    private void addToString() {
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)"toString").addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Override.class).returns(String.class).addStatement("return $T.toString(this)", new Object[]{ImmutableObjects.class});
        this.typeBuilder.addMethod(builder.build());
    }

    private void addDummyProp() {
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)"getDummyPropForJacksonError__").returns(TypeName.INT).addModifiers(new Modifier[]{Modifier.PUBLIC}).addStatement("throw new $T()", new Object[]{ImmutableModuleRequiredException.class});
        this.typeBuilder.addMethod(builder.build());
    }
}

