/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.apt.generator;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.io.IOException;
import java.util.List;
import javax.annotation.processing.Filer;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import org.babyfish.jimmer.apt.GeneratorException;
import org.babyfish.jimmer.apt.generator.Constants;

public class JimmerModuleGenerator {
    private final String packageName;
    private final List<TypeElement> elements;
    private final Filer filer;

    public JimmerModuleGenerator(String packageName, List<TypeElement> elements, Filer filer) {
        this.packageName = packageName;
        this.elements = elements;
        this.filer = filer;
    }

    public void generate() {
        if (this.elements.isEmpty()) {
            return;
        }
        try {
            JavaFile.builder((String)this.packageName, (TypeSpec)this.typeSpec()).indent("    ").build().writeTo(this.filer);
        }
        catch (IOException ex) {
            throw new GeneratorException("Cannot generate `EntityManagers`", ex);
        }
    }

    private TypeSpec typeSpec() {
        return TypeSpec.classBuilder((String)"JimmerModule").addModifiers(new Modifier[]{Modifier.PUBLIC}).addField(this.constantSpec()).addMethod(MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PRIVATE}).build()).build();
    }

    private FieldSpec constantSpec() {
        CodeBlock.Builder builder = CodeBlock.builder().add("new $T(\n", new Object[]{Constants.ENTITY_MANAGER_CLASS_NAME}).indent();
        int size = this.elements.size();
        for (int i = 0; i < size; ++i) {
            ClassName className = ClassName.get((TypeElement)this.elements.get(i));
            if (i + 1 == size) {
                builder.add("$T.class\n", new Object[]{className});
                continue;
            }
            builder.add("$T.class,\n", new Object[]{className});
        }
        CodeBlock block = builder.unindent().add(")", new Object[0]).build();
        return FieldSpec.builder((TypeName)Constants.ENTITY_MANAGER_CLASS_NAME, (String)"ENTITY_MANAGER", (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC, Modifier.FINAL}).initializer(block).build();
    }
}

