/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.apt.generator;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.processing.Filer;
import javax.lang.model.element.Modifier;
import org.babyfish.jimmer.apt.GeneratorException;
import org.babyfish.jimmer.apt.generator.Constants;
import org.babyfish.jimmer.apt.meta.ImmutableProp;
import org.babyfish.jimmer.apt.meta.ImmutableType;
import org.babyfish.jimmer.runtime.ImmutableSpi;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DynamicGenerator {
    private final ImmutableType type;
    private final Filer filer;
    private TypeSpec.Builder typeBuilder;

    public DynamicGenerator(ImmutableType type, Filer filer) {
        this.type = type;
        this.filer = filer;
    }

    public void generate() {
        try {
            JavaFile.builder((String)this.type.getPackageName(), (TypeSpec)this.generateDynamic()).indent("    ").build().writeTo(this.filer);
        }
        catch (IOException ex) {
            throw new GeneratorException(String.format("Cannot generate dynamic class for '%s'", this.type.getName()), ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TypeSpec generateDynamic() {
        TypeSpec.Builder oldTypeBuilder = this.typeBuilder;
        try {
            this.typeBuilder = TypeSpec.classBuilder((ClassName)this.type.getDynamicClassName()).addModifiers(new Modifier[]{Modifier.PUBLIC}).addSuperinterface((TypeName)ParameterizedTypeName.get((ClassName)Constants.DYNAMIC_CLASS_NAME, (TypeName[])new TypeName[]{this.type.getClassName()}));
            this.addField();
            this.addConstruct();
            for (ImmutableProp prop : this.type.getProps().values()) {
                this.addProp(prop);
            }
            this.addUnwrap();
            this.addHashCode();
            this.addEquals();
            this.addToString();
            TypeSpec typeSpec = this.typeBuilder.build();
            return typeSpec;
        }
        finally {
            this.typeBuilder = oldTypeBuilder;
        }
    }

    private void addField() {
        this.typeBuilder.addField(FieldSpec.builder((TypeName)this.type.getClassName(), (String)"raw", (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PRIVATE, Modifier.FINAL}).build());
    }

    private void addConstruct() {
        MethodSpec.Builder builder = MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter((TypeName)this.type.getClassName(), "raw", new Modifier[0]).addStatement("this.raw = $T.requireNonNull(raw, $S)", new Object[]{Objects.class, "The argument `raw` cannot be null"});
        this.typeBuilder.addMethod(builder.build());
    }

    private void addUnwrap() {
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)"__unwrap").addAnnotation(NotNull.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)this.type.getClassName()).addStatement("return raw", new Object[0]);
        this.typeBuilder.addMethod(builder.build());
    }

    private void addHashCode() {
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)"hashCode").addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(TypeName.INT).addStatement("return raw.hashCode()", new Object[0]);
        this.typeBuilder.addMethod(builder.build());
    }

    private void addEquals() {
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)"equals").addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter((TypeName)TypeName.OBJECT, "o", new Modifier[0]).returns(TypeName.BOOLEAN).beginControlFlow("if (this == o)", new Object[0]).addStatement("return true", new Object[0]).endControlFlow().beginControlFlow("if (this.getClass() != o.getClass())", new Object[0]).addStatement("return false", new Object[0]).endControlFlow().addStatement("return raw.equals((($T<?>)o).__unwrap())", new Object[]{Constants.DYNAMIC_CLASS_NAME});
        this.typeBuilder.addMethod(builder.build());
    }

    public void addToString() {
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)"toString").addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)Constants.STRING_CLASS_NAME).addStatement("return raw.toString()", new Object[0]);
        this.typeBuilder.addMethod(builder.build());
    }

    private void addProp(ImmutableProp prop) {
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)prop.getBeanGetterName()).addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Nullable.class).returns(prop.getDynamicClassName());
        if (this.type.isMappedSuperClass()) {
            builder.beginControlFlow("if (!(($T)raw).__isLoaded($S))", new Object[]{ImmutableSpi.class, prop.getName()});
        } else {
            builder.beginControlFlow("if (!(($T)raw).__isLoaded($T.byIndex($T.$L)))", new Object[]{ImmutableSpi.class, Constants.PROP_ID_CLASS_NAME, this.type.getProducerClassName(), prop.getSlotName()});
        }
        builder.addStatement("return null", new Object[0]).endControlFlow();
        if (!prop.isAssociation(false)) {
            builder.addStatement("return raw.$L()", new Object[]{prop.getGetterName()});
        } else {
            builder.addStatement("$T value = raw.$L()", new Object[]{prop.getTypeName(), prop.getGetterName()});
            if (prop.isList()) {
                builder.addStatement("$T newValue = new $T<>(value.size())", new Object[]{prop.getDynamicClassName(), ArrayList.class});
                builder.beginControlFlow("for ($T e : value)", new Object[]{prop.getElementTypeName()}).addStatement("newValue.add(new $T(e))", new Object[]{prop.getDynamicElementClassName()}).endControlFlow().addStatement("return newValue", new Object[0]);
            } else if (prop.isNullable()) {
                builder.addStatement("return value != null ? new $T(value) : null", new Object[]{prop.getDynamicElementClassName()});
            } else {
                builder.addStatement("return new $T(value)", new Object[]{prop.getDynamicElementClassName()});
            }
        }
        this.typeBuilder.addMethod(builder.build());
    }
}

