/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.apt;

import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import org.babyfish.jimmer.Immutable;
import org.babyfish.jimmer.apt.MetaException;
import org.babyfish.jimmer.apt.meta.ImmutableType;
import org.babyfish.jimmer.sql.Embeddable;
import org.babyfish.jimmer.sql.Entity;
import org.babyfish.jimmer.sql.MappedSuperclass;

public class Context {
    private static final Class<? extends Annotation>[] SQL_TYPE_ANNOTATION_TYPES = new Class[]{Entity.class, MappedSuperclass.class, Embeddable.class};
    private final Elements elements;
    private final Types types;
    private final TypeMirror collectionType;
    private final TypeMirror stringType;
    private final TypeMirror numberType;
    private final TypeMirror comparableType;
    private final Map<String, ImmutableType> immutableTypeMap = new HashMap<String, ImmutableType>();
    private final boolean keepIsPrefix;

    Context(Elements elements, Types types, boolean keepIsPrefix) {
        this.elements = elements;
        this.types = types;
        this.collectionType = types.erasure(elements.getTypeElement(Collection.class.getName()).asType());
        this.stringType = elements.getTypeElement(String.class.getName()).asType();
        this.numberType = elements.getTypeElement(Number.class.getName()).asType();
        this.comparableType = types.getDeclaredType(elements.getTypeElement(Comparable.class.getName()), types.getWildcardType(null, null));
        this.keepIsPrefix = keepIsPrefix;
    }

    public Class<? extends Annotation> getImmutableAnnotationType(TypeElement typeElement) {
        if (typeElement == null) {
            return null;
        }
        Immutable annotation = typeElement.getAnnotation(Immutable.class);
        Annotation sqlAnnotation = null;
        for (Class<? extends Annotation> sqlAnnotationType : SQL_TYPE_ANNOTATION_TYPES) {
            Annotation newSqlAnnotation = typeElement.getAnnotation(sqlAnnotationType);
            if (newSqlAnnotation == null) continue;
            if (sqlAnnotation != null) {
                throw new MetaException(typeElement, "it can not be decorated by both @" + sqlAnnotation.annotationType().getName() + " and @" + newSqlAnnotation.annotationType().getName());
            }
            sqlAnnotation = newSqlAnnotation;
        }
        if (sqlAnnotation != null) {
            return sqlAnnotation.annotationType();
        }
        if (annotation != null) {
            return annotation.annotationType();
        }
        return null;
    }

    public Class<? extends Annotation> getImmutableAnnotationType(TypeMirror typeMirror) {
        Element element = this.types.asElement(typeMirror);
        return this.getImmutableAnnotationType((TypeElement)element);
    }

    public boolean isImmutable(TypeElement type) {
        return this.getImmutableAnnotationType(type) != null;
    }

    public boolean isImmutable(TypeMirror type) {
        return this.getImmutableAnnotationType(type) != null;
    }

    public boolean isEntity(TypeMirror type) {
        return this.getImmutableAnnotationType(type) == Entity.class;
    }

    public boolean isMappedSuperclass(TypeMirror type) {
        return this.getImmutableAnnotationType(type) == MappedSuperclass.class;
    }

    public boolean isEmbeddable(TypeMirror type) {
        return this.getImmutableAnnotationType(type) == Embeddable.class;
    }

    public boolean isCollection(TypeMirror type) {
        return this.types.isSubtype(this.types.erasure(type), this.collectionType);
    }

    public boolean isListStrictly(TypeMirror type) {
        Element element = this.types.asElement(type);
        return element != null && element.toString().equals("java.util.List");
    }

    public boolean isSubType(TypeMirror type, TypeMirror superType) {
        return this.types.isSubtype(type, superType);
    }

    public Collection<ImmutableType> getImmutableTypes() {
        return Collections.unmodifiableCollection(this.immutableTypeMap.values());
    }

    public ImmutableType getImmutableType(TypeElement typeElement) {
        if (this.getImmutableAnnotationType(typeElement) != null) {
            String qualifiedName = typeElement.getQualifiedName().toString();
            ImmutableType type = this.immutableTypeMap.get(qualifiedName);
            if (type == null && this.immutableTypeMap.put(qualifiedName, type = new ImmutableType(this, typeElement)) != null) {
                throw new MetaException(typeElement, "Conflict qualified immutable type name \"" + qualifiedName + "\"");
            }
            return type;
        }
        return null;
    }

    public ImmutableType getImmutableType(TypeMirror type) {
        TypeElement typeElement = (TypeElement)this.types.asElement(type);
        return this.getImmutableType(typeElement);
    }

    public boolean isString(TypeMirror type) {
        return this.types.isSubtype(type, this.stringType);
    }

    public boolean isNumber(TypeMirror type) {
        return this.types.isSubtype(type, this.numberType);
    }

    public boolean isComparable(TypeMirror type) {
        return this.types.isSubtype(type, this.comparableType);
    }

    public Elements getElements() {
        return this.elements;
    }

    public Types getTypes() {
        return this.types;
    }

    public boolean keepIsPrefix() {
        return this.keepIsPrefix;
    }
}

