/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.apt.generator;

import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Pattern;
import javax.annotation.processing.Filer;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.tools.FileObject;
import javax.tools.StandardLocation;
import org.babyfish.jimmer.apt.GeneratorException;
import org.babyfish.jimmer.apt.generator.Constants;
import org.babyfish.jimmer.sql.Entity;

public class JimmerModuleGenerator {
    private static final String JIMMER_ENTITIES = "META-INF/jimmer/entities";
    private final String packageName;
    private final List<TypeElement> elements;
    private final Filer filer;
    private final File jimmerEntitiesFile;
    private final Set<String> entityQualifiedNames = new TreeSet<String>();

    public JimmerModuleGenerator(Collection<TypeElement> processedTypeElements, Filer filer) {
        FileObject fileObject;
        PackageCollector packageCollector = new PackageCollector();
        for (TypeElement typeElement : processedTypeElements) {
            if (typeElement.getKind() != ElementKind.INTERFACE || typeElement.getAnnotation(Entity.class) == null) continue;
            packageCollector.accept(typeElement);
        }
        this.elements = packageCollector.getTypeElements();
        this.filer = filer;
        try {
            fileObject = filer.getResource(StandardLocation.CLASS_OUTPUT, "", JIMMER_ENTITIES);
        }
        catch (IOException ex) {
            throw new GeneratorException("Cannot get file object \"META-INF/jimmer/entities\"", ex);
        }
        this.jimmerEntitiesFile = new File(fileObject.getName());
        if (this.jimmerEntitiesFile.exists()) {
            try (BufferedReader reader = new BufferedReader(new FileReader(this.jimmerEntitiesFile));){
                String line;
                while ((line = reader.readLine()) != null) {
                    if ((line = line.trim()).isEmpty()) continue;
                    this.entityQualifiedNames.add(line);
                    packageCollector.accept(line);
                }
            }
            catch (IOException ex) {
                throw new GeneratorException("Cannot read content of \"" + this.jimmerEntitiesFile + "\"", ex);
            }
        }
        this.packageName = packageCollector.toString();
    }

    public void generate() {
        TreeSet<String> qualifiedNames = new TreeSet<String>(this.entityQualifiedNames);
        for (TypeElement element : this.elements) {
            qualifiedNames.add(element.getQualifiedName().toString());
        }
        if (qualifiedNames.size() != this.entityQualifiedNames.size()) {
            this.jimmerEntitiesFile.getParentFile().mkdirs();
            try (FileWriter writer = new FileWriter(this.jimmerEntitiesFile);){
                for (String qualifiedName : qualifiedNames) {
                    writer.write(qualifiedName);
                    writer.write(10);
                }
            }
            catch (IOException ex) {
                throw new GeneratorException("Cannot write \"" + this.jimmerEntitiesFile + "\"", ex);
            }
            try {
                JavaFile.builder((String)this.packageName, (TypeSpec)this.typeSpec()).indent("    ").build().writeTo(this.filer);
            }
            catch (IOException ex) {
                throw new GeneratorException("Cannot generate `EntityManagers`", ex);
            }
        }
    }

    private TypeSpec typeSpec() {
        return TypeSpec.classBuilder((String)"JimmerModule").addJavadoc("Under normal circumstances, users do not need to use this code. \nThis code is for compatibility with version 0.7.47 and earlier.", new Object[0]).addModifiers(new Modifier[]{Modifier.PUBLIC}).addField(this.constantSpec()).addMethod(MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PRIVATE}).build()).build();
    }

    private FieldSpec constantSpec() {
        CodeBlock.Builder builder = CodeBlock.builder().add("\n$T.fromResources(\n", new Object[]{Constants.ENTITY_MANAGER_CLASS_NAME});
        builder.indent().add("JimmerModule.class.getClassLoader(),\n", new Object[0]);
        if (this.packageName.isEmpty()) {
            builder.add("null\n", new Object[0]);
        } else {
            builder.add("it -> it.getName().startsWith($S)\n", new Object[]{this.packageName + '.'});
        }
        builder.unindent().add(")", new Object[0]);
        CodeBlock block = builder.build();
        return FieldSpec.builder((TypeName)Constants.ENTITY_MANAGER_CLASS_NAME, (String)"ENTITY_MANAGER", (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC, Modifier.FINAL}).initializer(block).build();
    }

    private static class PackageCollector {
        private static final Pattern DOT_PATTERN = Pattern.compile("\\.");
        private List<String> pathParts;
        private String str;
        private final List<TypeElement> typeElements = new ArrayList<TypeElement>();

        private PackageCollector() {
        }

        public void accept(TypeElement typeElement) {
            this.typeElements.add(typeElement);
            if (this.pathParts != null && this.pathParts.isEmpty()) {
                return;
            }
            this.str = null;
            for (Element parent = typeElement.getEnclosingElement(); parent != null; parent = parent.getEnclosingElement()) {
                if (!(parent instanceof PackageElement)) continue;
                String packageName = ((PackageElement)parent).getQualifiedName().toString();
                this.accept(packageName);
                break;
            }
        }

        private void accept(String path) {
            ArrayList<String> parts = new ArrayList<String>(Arrays.asList(DOT_PATTERN.split(path)));
            if (this.pathParts == null) {
                this.pathParts = parts;
            } else {
                int index;
                int len = Math.min(this.pathParts.size(), parts.size());
                for (index = 0; index < len && this.pathParts.get(index).equals(parts.get(index)); ++index) {
                }
                if (index < this.pathParts.size()) {
                    this.pathParts.subList(index, this.pathParts.size()).clear();
                }
            }
        }

        public List<TypeElement> getTypeElements() {
            return Collections.unmodifiableList(this.typeElements);
        }

        public String toString() {
            String s = this.str;
            if (s == null) {
                List<String> ps = this.pathParts;
                s = ps == null || ps.isEmpty() ? "" : String.join((CharSequence)".", ps);
                this.str = s;
            }
            return s;
        }
    }
}

