/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.apt;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Filer;
import javax.annotation.processing.Messager;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.tools.Diagnostic;
import org.babyfish.jimmer.apt.TypeUtils;
import org.babyfish.jimmer.apt.generator.DraftGenerator;
import org.babyfish.jimmer.apt.generator.FetcherGenerator;
import org.babyfish.jimmer.apt.generator.JimmerModuleGenerator;
import org.babyfish.jimmer.apt.generator.PropExpressionGenerator;
import org.babyfish.jimmer.apt.generator.PropsGenerator;
import org.babyfish.jimmer.apt.generator.TableGenerator;
import org.babyfish.jimmer.apt.meta.ImmutableType;
import org.babyfish.jimmer.apt.meta.MetaException;

@SupportedAnnotationTypes(value={"org.babyfish.jimmer.Immutable", "org.babyfish.jimmer.sql.Entity", "org.babyfish.jimmer.sql.MappedSuperclass"})
@SupportedSourceVersion(value=SourceVersion.RELEASE_8)
public class ImmutableProcessor
extends AbstractProcessor {
    private TypeUtils typeUtils;
    private Filer filer;
    private String[] includes = null;
    private String[] excludes = null;
    private Messager messager;
    private boolean processed;

    @Override
    public synchronized void init(ProcessingEnvironment processingEnv) {
        super.init(processingEnv);
        this.messager = processingEnv.getMessager();
        String includes = processingEnv.getOptions().get("jimmer.source.includes");
        String excludes = processingEnv.getOptions().get("jimmer.source.excludes");
        if (includes != null && !includes.isEmpty()) {
            this.includes = includes.trim().split("\\s*,\\s*");
        }
        if (excludes != null && !excludes.isEmpty()) {
            this.excludes = excludes.trim().split("\\s*,\\s*");
        }
        this.typeUtils = new TypeUtils(processingEnv.getElementUtils(), processingEnv.getTypeUtils());
        this.filer = processingEnv.getFiler();
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        if (this.processed) {
            return true;
        }
        this.processed = true;
        PackageCollector packageCollector = new PackageCollector();
        for (Element element : roundEnv.getRootElements()) {
            boolean matched;
            if (!(element instanceof TypeElement)) continue;
            TypeElement typeElement = (TypeElement)element;
            String qualifiedName = typeElement.getQualifiedName().toString();
            if (this.includes != null) {
                matched = false;
                for (String include : this.includes) {
                    if (!qualifiedName.startsWith(include)) continue;
                    matched = true;
                    break;
                }
                if (!matched) continue;
            }
            if (this.excludes != null) {
                matched = false;
                for (String exclude : this.excludes) {
                    if (!qualifiedName.startsWith(exclude)) continue;
                    matched = true;
                    break;
                }
                if (matched) continue;
            }
            if (!this.typeUtils.isImmutable(typeElement)) continue;
            if (typeElement.getKind() != ElementKind.INTERFACE) {
                throw new MetaException("Illegal class \"" + qualifiedName + "\", immutable type must be interface");
            }
            ImmutableType immutableType = this.typeUtils.getImmutableType(typeElement);
            new DraftGenerator(immutableType, this.filer).generate();
            new PropsGenerator(this.typeUtils, immutableType, this.filer).generate();
            this.messager.printMessage(Diagnostic.Kind.NOTE, "Immutable: " + immutableType.getQualifiedName());
            if (immutableType.isEntity()) {
                this.messager.printMessage(Diagnostic.Kind.NOTE, "Entity: " + immutableType.getQualifiedName());
                packageCollector.accept(typeElement);
                new TableGenerator(this.typeUtils, immutableType, false, this.filer).generate();
                new TableGenerator(this.typeUtils, immutableType, true, this.filer).generate();
                new FetcherGenerator(this.typeUtils, immutableType, this.filer).generate();
                continue;
            }
            if (!immutableType.isEmbeddable()) continue;
            new PropExpressionGenerator(this.typeUtils, immutableType, this.filer).generate();
        }
        this.messager.printMessage(Diagnostic.Kind.NOTE, "JimmerModule");
        new JimmerModuleGenerator(packageCollector.toString(), packageCollector.getTypeElements(), this.filer).generate();
        return true;
    }

    private static class PackageCollector {
        private static final Pattern DOT_PATTERN = Pattern.compile("\\.");
        private List<String> paths;
        private String str;
        private List<TypeElement> typeElements = new ArrayList<TypeElement>();

        private PackageCollector() {
        }

        public void accept(TypeElement typeElement) {
            this.typeElements.add(typeElement);
            if (this.paths != null && this.paths.isEmpty()) {
                return;
            }
            this.str = null;
            List newPaths = Collections.emptyList();
            for (Element parent = typeElement.getEnclosingElement(); parent != null; parent = parent.getEnclosingElement()) {
                if (!(parent instanceof PackageElement)) continue;
                String packageName = ((PackageElement)parent).getQualifiedName().toString();
                newPaths = new ArrayList<String>(Arrays.asList(DOT_PATTERN.split(packageName)));
                break;
            }
            if (this.paths == null) {
                this.paths = newPaths;
            } else {
                int index;
                int len = Math.min(this.paths.size(), newPaths.size());
                for (index = 0; index < len && this.paths.get(index).equals(newPaths.get(index)); ++index) {
                }
                if (index < this.paths.size()) {
                    this.paths.subList(index, this.paths.size()).clear();
                }
            }
        }

        public List<TypeElement> getTypeElements() {
            return Collections.unmodifiableList(this.typeElements);
        }

        public String toString() {
            String s = this.str;
            if (s == null) {
                List<String> ps = this.paths;
                s = ps == null || ps.isEmpty() ? "" : String.join((CharSequence)".", ps);
                this.str = s;
            }
            return s;
        }
    }
}

