/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.apt.meta;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import org.babyfish.jimmer.Formula;
import org.babyfish.jimmer.Immutable;
import org.babyfish.jimmer.apt.TypeUtils;
import org.babyfish.jimmer.apt.meta.ImmutableType;
import org.babyfish.jimmer.apt.meta.MetaException;
import org.babyfish.jimmer.apt.meta.ValidationMessages;
import org.babyfish.jimmer.meta.impl.PropDescriptor;
import org.babyfish.jimmer.sql.Transient;

public class ImmutableProp {
    private final ImmutableType declaringType;
    private final ExecutableElement executableElement;
    private final String name;
    private final int id;
    private final String getterName;
    private final String setterName;
    private final String usingName;
    private final String applierName;
    private final String adderByName;
    private final boolean beanStyle;
    private final String loadedStateName;
    private final TypeMirror returnType;
    private final TypeName typeName;
    private final TypeName draftTypeName;
    private final TypeName elementTypeName;
    private final TypeName draftElementTypeName;
    private final TypeMirror elementType;
    private final boolean isTransient;
    private final boolean hasTransientResolver;
    private final boolean isJavaFormula;
    private final Set<String> dependencies;
    private final boolean isList;
    private final boolean isAssociation;
    private final boolean isEntityAssociation;
    private final boolean isNullable;
    private final Map<ClassName, String> validationMessageMap;
    private Annotation associationAnnotation;

    public ImmutableProp(TypeUtils typeUtils, ImmutableType declaringType, ExecutableElement executableElement, int id) {
        this.id = id;
        this.declaringType = declaringType;
        this.executableElement = executableElement;
        this.getterName = executableElement.getSimpleName().toString();
        this.returnType = executableElement.getReturnType();
        if (this.returnType.getKind() == TypeKind.VOID) {
            throw new MetaException(String.format("'%s' cannot return void", executableElement));
        }
        if (!executableElement.getParameters().isEmpty()) {
            throw new MetaException(String.format("'%s' cannot have parameters", executableElement));
        }
        if (this.returnType.getKind() == TypeKind.BOOLEAN && this.getterName.startsWith("is") && this.getterName.length() > 2 && Character.isUpperCase(this.getterName.charAt(2))) {
            this.name = this.getterName.substring(2, 3).toLowerCase() + this.getterName.substring(3);
            this.setterName = "set" + this.getterName.substring(2);
            this.usingName = "use" + this.getterName.substring(2);
            this.applierName = "apply" + this.getterName.substring(2);
            this.adderByName = "addInto" + this.getterName.substring(2);
            this.beanStyle = true;
        } else if (this.getterName.startsWith("get") && this.getterName.length() > 3 && Character.isUpperCase(this.getterName.charAt(3))) {
            this.name = this.getterName.substring(3, 4).toLowerCase() + this.getterName.substring(4);
            this.setterName = "set" + this.getterName.substring(3);
            this.usingName = "use" + this.getterName.substring(3);
            this.applierName = "apply" + this.getterName.substring(3);
            this.adderByName = "addInto" + this.getterName.substring(3);
            this.beanStyle = true;
        } else {
            this.name = this.getterName;
            String suffix = this.getterName.substring(0, 1).toUpperCase() + this.getterName.substring(1);
            this.setterName = "set" + suffix;
            this.usingName = "use" + suffix;
            this.applierName = "apply" + suffix;
            this.adderByName = "addInto" + suffix;
            this.beanStyle = false;
        }
        this.loadedStateName = this.name + "Loaded";
        if (typeUtils.isCollection(this.returnType)) {
            if (!typeUtils.isListStrictly(this.returnType)) {
                throw new MetaException(String.format("The collection property '%s' must return 'java.util.List'", executableElement));
            }
            List<? extends TypeMirror> typeArguments = ((DeclaredType)this.returnType).getTypeArguments();
            if (typeArguments.isEmpty()) {
                throw new MetaException(String.format("The return type of '%s' misses generic type", executableElement));
            }
            this.isList = true;
            this.elementType = typeArguments.get(0);
        } else {
            this.isList = false;
            this.elementType = this.returnType;
        }
        if (typeUtils.isMappedSuperclass(this.elementType)) {
            throw new MetaException("Illegal property \"" + this + "\", the target type \"" + TypeName.get((TypeMirror)this.elementType) + "\" is illegal, it cannot be type decorated by @MappedSuperclass");
        }
        Transient trans = executableElement.getAnnotation(Transient.class);
        this.isTransient = trans != null;
        boolean hasResolver = false;
        if (this.isTransient) {
            for (AnnotationMirror annotationMirror : executableElement.getAnnotationMirrors()) {
                Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry;
                Iterator<Object> iterator;
                if (!((TypeElement)annotationMirror.getAnnotationType().asElement()).getQualifiedName().toString().equals(Transient.class.getName()) || !(iterator = annotationMirror.getElementValues().entrySet().iterator()).hasNext() || !(entry = iterator.next()).getKey().getSimpleName().contentEquals("value")) continue;
                hasResolver = !entry.getValue().toString().equals("void");
            }
        }
        this.hasTransientResolver = hasResolver;
        Formula formula = executableElement.getAnnotation(Formula.class);
        this.isJavaFormula = formula != null && formula.sql().isEmpty();
        this.dependencies = formula != null ? Collections.unmodifiableSet(new LinkedHashSet<String>(Arrays.asList(formula.dependencies()))) : Collections.emptySet();
        this.isAssociation = typeUtils.isImmutable(this.elementType);
        this.isEntityAssociation = typeUtils.isEntity(this.elementType);
        if (this.isList && typeUtils.isEmbeddable(this.elementType)) {
            throw new MetaException("Illegal property \"" + this + "\", the target type \"" + TypeName.get((TypeMirror)this.elementType) + "\" is embeddable so that the property type cannot be list");
        }
        PropDescriptor.Builder builder = PropDescriptor.newBuilder((String)declaringType.getTypeElement().getQualifiedName().toString(), typeUtils.getImmutableAnnotationType(declaringType.getTypeElement()), (String)this.toString(), (String)ClassName.get((TypeMirror)this.elementType).toString(), typeUtils.getImmutableAnnotationType(this.elementType), (boolean)this.isList, null, (Immutable)declaringType.getTypeElement().getAnnotation(Immutable.class), MetaException::new);
        block1: for (AnnotationMirror annotationMirror : executableElement.getAnnotationMirrors()) {
            String annotationTypeName = ((TypeElement)annotationMirror.getAnnotationType().asElement()).getQualifiedName().toString();
            builder.add(annotationTypeName);
            if (!PropDescriptor.MAPPED_BY_PROVIDER_NAMES.contains(annotationTypeName)) continue;
            for (ExecutableElement executableElement2 : annotationMirror.getElementValues().keySet()) {
                if (!executableElement2.getSimpleName().contentEquals("mappedBy")) continue;
                builder.hasMappedBy();
                continue block1;
            }
        }
        PropDescriptor descriptor = builder.build();
        if (descriptor.getType().isAssociation()) {
            this.associationAnnotation = executableElement.getAnnotation(descriptor.getType().getAnnotationType());
        }
        this.isNullable = descriptor.isNullable();
        this.elementTypeName = TypeName.get((TypeMirror)this.elementType);
        this.typeName = this.isList ? ParameterizedTypeName.get((ClassName)ClassName.get(List.class), (TypeName[])new TypeName[]{this.elementTypeName}) : this.elementTypeName;
        this.draftElementTypeName = this.isAssociation ? ClassName.get((String)((ClassName)this.elementTypeName).packageName(), (String)(((ClassName)this.elementTypeName).simpleName() + "Draft"), (String[])new String[0]) : this.elementTypeName;
        this.draftTypeName = this.isList ? ParameterizedTypeName.get((ClassName)ClassName.get(List.class), (TypeName[])new TypeName[]{this.draftElementTypeName}) : this.draftElementTypeName;
        this.validationMessageMap = ValidationMessages.parseMessageMap(executableElement);
    }

    public ImmutableType getDeclaringType() {
        return this.declaringType;
    }

    public int getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getGetterName() {
        return this.getterName;
    }

    public String getSetterName() {
        return this.setterName;
    }

    public String getUsingName() {
        return this.usingName;
    }

    public String getApplierName() {
        return this.applierName;
    }

    public String getAdderByName() {
        return this.adderByName;
    }

    public boolean isBeanStyle() {
        return this.beanStyle;
    }

    public String getLoadedStateName() {
        return this.getLoadedStateName(false);
    }

    public String getLoadedStateName(boolean force) {
        if (!force && !this.isLoadedStateRequired()) {
            throw new IllegalStateException("The property \"" + this + "\" does not has loaded state");
        }
        return this.loadedStateName;
    }

    public TypeMirror getReturnType() {
        return this.returnType;
    }

    public TypeMirror getElementType() {
        return this.elementType;
    }

    public TypeName getTypeName() {
        return this.typeName;
    }

    public TypeName getDraftTypeName(boolean autoCreate) {
        if (this.isList && !autoCreate) {
            return this.typeName;
        }
        return this.draftTypeName;
    }

    public TypeName getElementTypeName() {
        return this.elementTypeName;
    }

    public TypeName getDraftElementTypeName() {
        return this.draftElementTypeName;
    }

    public boolean isTransient() {
        return this.isTransient;
    }

    public boolean hasTransientResolver() {
        return this.hasTransientResolver;
    }

    public boolean isJavaFormula() {
        return this.isJavaFormula;
    }

    public Set<String> getDependencies() {
        return this.dependencies;
    }

    public boolean isList() {
        return this.isList;
    }

    public boolean isAssociation(boolean entityLevel) {
        return entityLevel ? this.isEntityAssociation : this.isAssociation;
    }

    public boolean isNullable() {
        return this.isNullable;
    }

    public boolean isLoadedStateRequired() {
        return this.isJavaFormula || this.isNullable || this.typeName.isPrimitive();
    }

    public Class<?> getBoxType() {
        switch (this.returnType.getKind()) {
            case BOOLEAN: {
                return Boolean.class;
            }
            case CHAR: {
                return Character.class;
            }
            case BYTE: {
                return Byte.class;
            }
            case SHORT: {
                return Short.class;
            }
            case INT: {
                return Integer.class;
            }
            case LONG: {
                return Long.class;
            }
            case FLOAT: {
                return Float.class;
            }
            case DOUBLE: {
                return Double.class;
            }
        }
        return null;
    }

    public <A extends Annotation> A getAnnotation(Class<A> annotationType) {
        return this.executableElement.getAnnotation(annotationType);
    }

    public <A extends Annotation> A[] getAnnotations(Class<A> annotationType) {
        return this.executableElement.getAnnotationsByType(annotationType);
    }

    public List<? extends AnnotationMirror> getAnnotations() {
        return this.executableElement.getAnnotationMirrors();
    }

    public Annotation getAssociationAnnotation() {
        return this.associationAnnotation;
    }

    public String toString() {
        return this.declaringType.getTypeElement().getQualifiedName().toString() + '.' + this.name;
    }

    public Map<ClassName, String> getValidationMessageMap() {
        return this.validationMessageMap;
    }
}

