/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.apt.generator;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import com.squareup.javapoet.WildcardTypeName;
import java.io.IOException;
import javax.annotation.processing.Filer;
import javax.lang.model.element.Modifier;
import org.babyfish.jimmer.apt.GeneratorException;
import org.babyfish.jimmer.apt.TypeUtils;
import org.babyfish.jimmer.apt.generator.Constants;
import org.babyfish.jimmer.apt.meta.ImmutableProp;
import org.babyfish.jimmer.apt.meta.ImmutableType;
import org.babyfish.jimmer.lang.NewChain;
import org.babyfish.jimmer.sql.Id;

public class FetcherGenerator {
    private final TypeUtils typeUtils;
    private final ImmutableType type;
    private final Filer filer;
    private TypeSpec.Builder typeBuilder;

    public FetcherGenerator(TypeUtils typeUtils, ImmutableType type, Filer filer) {
        this.typeUtils = typeUtils;
        this.type = type;
        this.filer = filer;
    }

    public void generate() {
        try {
            JavaFile.builder((String)this.type.getPackageName(), (TypeSpec)this.generateFetcher()).indent("    ").build().writeTo(this.filer);
        }
        catch (IOException ex) {
            throw new GeneratorException(String.format("Cannot generate fetcher class for '%s'", this.type.getQualifiedName()), ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TypeSpec generateFetcher() {
        TypeSpec.Builder builder = TypeSpec.classBuilder((String)this.type.getFetcherClassName().simpleName()).addModifiers(new Modifier[]{Modifier.PUBLIC}).superclass((TypeName)ParameterizedTypeName.get((ClassName)Constants.ABSTRACT_TYPE_FETCHER_CLASS_NAME, (TypeName[])new TypeName[]{this.type.getClassName(), this.type.getFetcherClassName()}));
        TypeSpec.Builder oldBuilder = this.typeBuilder;
        this.typeBuilder = builder;
        try {
            this.add$();
            this.add$from();
            this.addConstructor();
            for (ImmutableProp prop : this.type.getProps().values()) {
                if (prop.getAnnotation(Id.class) != null || !this.isFetchProp(prop)) continue;
                this.addProp(prop);
                this.addPropByBoolean(prop);
                if (!prop.isAssociation(true)) continue;
                this.addAssociationProp(prop);
                if (prop.isTransient()) continue;
                this.addAssociationPropByFieldConfig(prop);
            }
            this.addConstructorByBoolean();
            this.addConstructorByFieldConfig();
            this.addCreatorByBoolean();
            this.addCreatorByFieldConfig();
        }
        finally {
            this.typeBuilder = oldBuilder;
        }
        return builder.build();
    }

    private void add$() {
        FieldSpec.Builder builder = FieldSpec.builder((TypeName)this.type.getFetcherClassName(), (String)"$", (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC, Modifier.FINAL}).initializer("new $T(null)", new Object[]{this.type.getFetcherClassName()});
        this.typeBuilder.addField(builder.build());
    }

    private void add$from() {
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)"$from").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC}).addParameter((TypeName)ParameterizedTypeName.get((ClassName)Constants.FETCHER_CLASS_NAME, (TypeName[])new TypeName[]{this.type.getClassName()}), "base", new Modifier[0]).returns((TypeName)this.type.getFetcherClassName()).addCode("return base instanceof $T ? \n", new Object[]{this.type.getFetcherClassName()}).addCode("\t($T)base : \n", new Object[]{this.type.getFetcherClassName()}).addCode("\tnew $T(($T)base);\n", new Object[]{this.type.getFetcherClassName(), ParameterizedTypeName.get((ClassName)Constants.FETCHER_IMPL_CLASS_NAME, (TypeName[])new TypeName[]{this.type.getClassName()})});
        this.typeBuilder.addMethod(builder.build());
    }

    private void addConstructor() {
        MethodSpec.Builder builder = MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PRIVATE}).addParameter((TypeName)ParameterizedTypeName.get((ClassName)Constants.FETCHER_IMPL_CLASS_NAME, (TypeName[])new TypeName[]{this.type.getClassName()}), "base", new Modifier[0]).addStatement("super($T.class, base)", new Object[]{this.type.getClassName()});
        this.typeBuilder.addMethod(builder.build());
    }

    private boolean isFetchProp(ImmutableProp prop) {
        if (prop.isTransient()) {
            return prop.hasTransientResolver();
        }
        return true;
    }

    private void addProp(ImmutableProp prop) {
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)prop.getName()).addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(NewChain.class).returns((TypeName)this.type.getFetcherClassName()).addStatement("return add($S)", new Object[]{prop.getName()});
        this.typeBuilder.addMethod(builder.build());
    }

    private void addPropByBoolean(ImmutableProp prop) {
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)prop.getName()).addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(NewChain.class).addParameter(Boolean.TYPE, "enabled", new Modifier[0]).returns((TypeName)this.type.getFetcherClassName()).addStatement("return enabled ? add($S) : remove($S)", new Object[]{prop.getName(), prop.getName()});
        this.typeBuilder.addMethod(builder.build());
    }

    private void addAssociationProp(ImmutableProp prop) {
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)prop.getName()).addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(NewChain.class).addParameter((TypeName)ParameterizedTypeName.get((ClassName)Constants.FETCHER_CLASS_NAME, (TypeName[])new TypeName[]{prop.getElementTypeName()}), "childFetcher", new Modifier[0]).returns((TypeName)this.type.getFetcherClassName()).addStatement("return add($S, childFetcher)", new Object[]{prop.getName()});
        this.typeBuilder.addMethod(builder.build());
    }

    private void addAssociationPropByFieldConfig(ImmutableProp prop) {
        boolean recursive = this.typeUtils.isSubType(prop.getElementType(), this.type.getTypeElement().asType());
        ClassName fieldConfigClassName = recursive && prop.isList() ? Constants.RECURSIVE_LIST_FIELD_CONFIG_CLASS_NAME : (recursive ? Constants.RECURSIVE_FIELD_CONFIG_CLASS_NAME : (prop.isList() ? Constants.LIST_FIELD_CONFIG_CLASS_NAME : Constants.FIELD_CONFIG_CLASS_NAME));
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)prop.getName()).addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(NewChain.class).addParameter((TypeName)ParameterizedTypeName.get((ClassName)Constants.FETCHER_CLASS_NAME, (TypeName[])new TypeName[]{prop.getElementTypeName()}), "childFetcher", new Modifier[0]).addParameter((TypeName)ParameterizedTypeName.get((ClassName)Constants.CONSUMER_CLASS_NAME, (TypeName[])new TypeName[]{ParameterizedTypeName.get((ClassName)fieldConfigClassName, (TypeName[])new TypeName[]{prop.getElementTypeName(), this.typeUtils.getImmutableType(prop.getElementType()).getTableClassName()})}), "fieldConfig", new Modifier[0]).returns((TypeName)this.type.getFetcherClassName()).addStatement("return add($S, childFetcher, fieldConfig)", new Object[]{prop.getName()});
        this.typeBuilder.addMethod(builder.build());
    }

    private void addConstructorByBoolean() {
        MethodSpec.Builder builder = MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PRIVATE}).addParameter((TypeName)this.type.getFetcherClassName(), "prev", new Modifier[0]).addParameter(org.babyfish.jimmer.meta.ImmutableProp.class, "prop", new Modifier[0]).addParameter(Boolean.TYPE, "negative", new Modifier[0]).addStatement("super(prev, prop, negative)", new Object[0]);
        this.typeBuilder.addMethod(builder.build());
    }

    private void addConstructorByFieldConfig() {
        MethodSpec.Builder builder = MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PRIVATE}).addParameter((TypeName)this.type.getFetcherClassName(), "prev", new Modifier[0]).addParameter(org.babyfish.jimmer.meta.ImmutableProp.class, "prop", new Modifier[0]).addParameter((TypeName)ParameterizedTypeName.get((ClassName)Constants.FIELD_CONFIG_CLASS_NAME, (TypeName[])new TypeName[]{WildcardTypeName.subtypeOf(Object.class), WildcardTypeName.subtypeOf((TypeName)ParameterizedTypeName.get((ClassName)Constants.TABLE_CLASS_NAME, (TypeName[])new TypeName[]{WildcardTypeName.subtypeOf(Object.class)}))}), "fieldConfig", new Modifier[0]).addStatement("super(prev, prop, fieldConfig)", new Object[0]);
        this.typeBuilder.addMethod(builder.build());
    }

    private void addCreatorByBoolean() {
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)"createChildFetcher").addModifiers(new Modifier[]{Modifier.PROTECTED}).addParameter(org.babyfish.jimmer.meta.ImmutableProp.class, "prop", new Modifier[0]).addParameter(Boolean.TYPE, "negative", new Modifier[0]).returns((TypeName)this.type.getFetcherClassName()).addAnnotation(Override.class).addStatement("return new $T(this, prop, negative)", new Object[]{this.type.getFetcherClassName()});
        this.typeBuilder.addMethod(builder.build());
    }

    private void addCreatorByFieldConfig() {
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)"createChildFetcher").addModifiers(new Modifier[]{Modifier.PROTECTED}).addParameter(org.babyfish.jimmer.meta.ImmutableProp.class, "prop", new Modifier[0]).addParameter((TypeName)ParameterizedTypeName.get((ClassName)Constants.FIELD_CONFIG_CLASS_NAME, (TypeName[])new TypeName[]{WildcardTypeName.subtypeOf(Object.class), WildcardTypeName.subtypeOf((TypeName)ParameterizedTypeName.get((ClassName)Constants.TABLE_CLASS_NAME, (TypeName[])new TypeName[]{WildcardTypeName.subtypeOf(Object.class)}))}), "fieldConfig", new Modifier[0]).returns((TypeName)this.type.getFetcherClassName()).addAnnotation(Override.class).addStatement("return new $T(this, prop, fieldConfig)", new Object[]{this.type.getFetcherClassName()});
        this.typeBuilder.addMethod(builder.build());
    }
}

