/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.apt;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Filer;
import javax.annotation.processing.Messager;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.tools.Diagnostic;
import org.babyfish.jimmer.apt.TypeUtils;
import org.babyfish.jimmer.apt.generator.DraftGenerator;
import org.babyfish.jimmer.apt.generator.ErrorGenerator;
import org.babyfish.jimmer.apt.generator.FetcherGenerator;
import org.babyfish.jimmer.apt.generator.JimmerModuleGenerator;
import org.babyfish.jimmer.apt.generator.PropExpressionGenerator;
import org.babyfish.jimmer.apt.generator.PropsGenerator;
import org.babyfish.jimmer.apt.generator.TableGenerator;
import org.babyfish.jimmer.apt.meta.ImmutableType;
import org.babyfish.jimmer.apt.meta.MetaException;
import org.babyfish.jimmer.error.ErrorFamily;
import org.babyfish.jimmer.sql.Entity;

@SupportedAnnotationTypes(value={"org.babyfish.jimmer.Immutable", "org.babyfish.jimmer.sql.Entity", "org.babyfish.jimmer.sql.MappedSuperclass", "org.babyfish.jimmer.error.ErrorFamily"})
@SupportedSourceVersion(value=SourceVersion.RELEASE_8)
public class ImmutableProcessor
extends AbstractProcessor {
    private TypeUtils typeUtils;
    private Filer filer;
    private String[] includes = null;
    private String[] excludes = null;
    private Messager messager;
    private boolean processed;
    private Set<String> dtoDirs;

    @Override
    public synchronized void init(ProcessingEnvironment processingEnv) {
        super.init(processingEnv);
        this.messager = processingEnv.getMessager();
        String includes = processingEnv.getOptions().get("jimmer.source.includes");
        String excludes = processingEnv.getOptions().get("jimmer.source.excludes");
        String dtoDirs = processingEnv.getOptions().get("jimmer.dtoDirs");
        if (includes != null && !includes.isEmpty()) {
            this.includes = includes.trim().split("\\s*,\\s*");
        }
        if (excludes != null && !excludes.isEmpty()) {
            this.excludes = excludes.trim().split("\\s*,\\s*");
        }
        if (dtoDirs != null && !dtoDirs.isEmpty()) {
            LinkedHashSet<String> dirs = new LinkedHashSet<String>();
            for (String path : dtoDirs.trim().split("\\*[,:;]\\s*")) {
                if (path.startsWith("/")) {
                    path = path.substring(1);
                }
                if (path.endsWith("/")) {
                    path = path.substring(0, path.length() - 1);
                }
                if (path.isEmpty()) continue;
                dirs.add(path);
            }
            this.dtoDirs = dirs;
        } else {
            LinkedHashSet<String> dirs = new LinkedHashSet<String>();
            dirs.add("src/main/dto");
            this.dtoDirs = dirs;
        }
        this.typeUtils = new TypeUtils(processingEnv.getElementUtils(), processingEnv.getTypeUtils());
        this.filer = processingEnv.getFiler();
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        if (this.processed) {
            return true;
        }
        this.processed = true;
        Map<TypeElement, ImmutableType> immutableTypeMap = this.parseImmutableTypes(roundEnv);
        this.generateJimmerTypes(roundEnv.getRootElements().stream().filter(it -> it instanceof TypeElement).map(immutableTypeMap::get).filter(Objects::nonNull).collect(Collectors.toList()), roundEnv);
        List<TypeElement> errorElements = this.getErrorFamilies(roundEnv);
        this.generateErrorType(errorElements);
        return true;
    }

    private Map<TypeElement, ImmutableType> parseImmutableTypes(RoundEnvironment roundEnv) {
        HashMap<TypeElement, ImmutableType> map = new HashMap<TypeElement, ImmutableType>();
        for (Element element : roundEnv.getRootElements()) {
            TypeElement typeElement;
            if (!(element instanceof TypeElement) || !this.typeUtils.isImmutable(typeElement = (TypeElement)element) || !this.include(typeElement)) continue;
            if (typeElement.getKind() != ElementKind.INTERFACE) {
                throw new MetaException("Illegal class \"" + typeElement.getQualifiedName().toString() + "\", immutable type must be interface");
            }
            ImmutableType immutableType = this.typeUtils.getImmutableType(typeElement);
            map.put(typeElement, immutableType);
        }
        return map;
    }

    private List<TypeElement> getErrorFamilies(RoundEnvironment roundEnv) {
        ArrayList<TypeElement> typeElements = new ArrayList<TypeElement>();
        for (Element element : roundEnv.getRootElements()) {
            if (!(element instanceof TypeElement) || !this.include((TypeElement)element) || element.getAnnotation(ErrorFamily.class) == null) continue;
            if (element.getKind() != ElementKind.ENUM) {
                throw new MetaException("Illegal type \"" + element + "\", only enum can be decorated by @" + ErrorFamily.class.getName());
            }
            typeElements.add((TypeElement)element);
        }
        return typeElements;
    }

    private boolean include(TypeElement typeElement) {
        String qualifiedName = typeElement.getQualifiedName().toString();
        if (this.includes != null) {
            boolean matched = false;
            String[] stringArray = this.includes;
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                String include = stringArray[i];
                if (!qualifiedName.startsWith(include)) continue;
                return true;
            }
        }
        if (this.excludes != null) {
            for (String exclude : this.excludes) {
                if (!qualifiedName.startsWith(exclude)) continue;
                return false;
            }
        }
        return true;
    }

    private void generateJimmerTypes(Collection<ImmutableType> immutableTypes, RoundEnvironment roundEnv) {
        for (ImmutableType immutableType : immutableTypes) {
            new DraftGenerator(immutableType, this.filer).generate();
            new PropsGenerator(this.typeUtils, immutableType, this.filer).generate();
            this.messager.printMessage(Diagnostic.Kind.NOTE, "Immutable: " + immutableType.getQualifiedName());
            if (immutableType.isEntity()) {
                this.messager.printMessage(Diagnostic.Kind.NOTE, "Entity: " + immutableType.getQualifiedName());
                new TableGenerator(this.typeUtils, immutableType, false, this.filer).generate();
                new TableGenerator(this.typeUtils, immutableType, true, this.filer).generate();
                new FetcherGenerator(this.typeUtils, immutableType, this.filer).generate();
                continue;
            }
            if (!immutableType.isEmbeddable()) continue;
            new PropExpressionGenerator(this.typeUtils, immutableType, this.filer).generate();
        }
        PackageCollector packageCollector = new PackageCollector();
        for (Element element : roundEnv.getElementsAnnotatedWith(Entity.class)) {
            packageCollector.accept((TypeElement)element);
        }
        new JimmerModuleGenerator(packageCollector.toString(), packageCollector.getTypeElements(), this.filer).generate();
    }

    private void generateErrorType(List<TypeElement> typeElements) {
        for (TypeElement typeElement : typeElements) {
            new ErrorGenerator(typeElement, this.filer).generate();
        }
    }

    private void collectActualDtoDir(File baseFile, List<String> outputFiles) {
        for (String dtoDir : this.dtoDirs) {
            File subFile = baseFile;
            for (String part : dtoDir.split("/")) {
                if ((subFile = new File(subFile, part)).isDirectory()) continue;
                subFile = null;
                break;
            }
            if (subFile == null) continue;
            String path = subFile.getAbsolutePath();
            if (path.endsWith("/")) {
                path = path.substring(0, path.length() - 1);
            }
            outputFiles.add(path);
        }
    }

    private static class PackageCollector {
        private static final Pattern DOT_PATTERN = Pattern.compile("\\.");
        private List<String> paths;
        private String str;
        private final List<TypeElement> typeElements = new ArrayList<TypeElement>();

        private PackageCollector() {
        }

        public void accept(TypeElement typeElement) {
            this.typeElements.add(typeElement);
            if (this.paths != null && this.paths.isEmpty()) {
                return;
            }
            this.str = null;
            List newPaths = Collections.emptyList();
            for (Element parent = typeElement.getEnclosingElement(); parent != null; parent = parent.getEnclosingElement()) {
                if (!(parent instanceof PackageElement)) continue;
                String packageName = ((PackageElement)parent).getQualifiedName().toString();
                newPaths = new ArrayList<String>(Arrays.asList(DOT_PATTERN.split(packageName)));
                break;
            }
            if (this.paths == null) {
                this.paths = newPaths;
            } else {
                int index;
                int len = Math.min(this.paths.size(), newPaths.size());
                for (index = 0; index < len && this.paths.get(index).equals(newPaths.get(index)); ++index) {
                }
                if (index < this.paths.size()) {
                    this.paths.subList(index, this.paths.size()).clear();
                }
            }
        }

        public List<TypeElement> getTypeElements() {
            return Collections.unmodifiableList(this.typeElements);
        }

        public String toString() {
            String s = this.str;
            if (s == null) {
                List<String> ps = this.paths;
                s = ps == null || ps.isEmpty() ? "" : String.join((CharSequence)".", ps);
                this.str = s;
            }
            return s;
        }
    }
}

