/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.apt.generator;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import javax.lang.model.element.Modifier;
import org.babyfish.jimmer.ImmutableObjects;
import org.babyfish.jimmer.apt.generator.Constants;
import org.babyfish.jimmer.apt.meta.ImmutableProp;
import org.babyfish.jimmer.apt.meta.ImmutableType;
import org.babyfish.jimmer.jackson.ImmutableModuleRequiredException;
import org.babyfish.jimmer.runtime.ImmutableSpi;

public class ImplementorGenerator {
    private ImmutableType type;
    private ClassName spiClassName;
    private TypeSpec.Builder typeBuilder;

    ImplementorGenerator(ImmutableType type) {
        this.type = type;
        this.spiClassName = ClassName.get(ImmutableSpi.class);
    }

    public void generate(TypeSpec.Builder parentBuilder) {
        this.typeBuilder = TypeSpec.classBuilder((String)"Implementor");
        this.typeBuilder.modifiers.add(Modifier.PUBLIC);
        this.typeBuilder.modifiers.add(Modifier.STATIC);
        this.typeBuilder.modifiers.add(Modifier.ABSTRACT);
        this.typeBuilder.superinterfaces.add(this.type.getClassName());
        this.typeBuilder.superinterfaces.add(this.spiClassName);
        this.addGet(Integer.TYPE);
        this.addGet(String.class);
        this.addType();
        this.addToString();
        this.addDummyProp();
        parentBuilder.addType(this.typeBuilder.build());
    }

    private void addGet(Class<?> argType) {
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)"__get").addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Override.class).addParameter(argType, "prop", new Modifier[0]).returns(Object.class);
        builder.beginControlFlow("switch (prop)", new Object[0]);
        for (ImmutableProp prop : this.type.getPropsOrderById()) {
            if (prop.getBoxType() != null) {
                builder.addStatement("case $L: return ($T)$L()", new Object[]{argType == Integer.TYPE ? Integer.valueOf(prop.getId()) : '\"' + prop.getName() + '\"', prop.getBoxType(), prop.getGetterName()});
                continue;
            }
            builder.addStatement("case $L: return $L()", new Object[]{argType == Integer.TYPE ? Integer.valueOf(prop.getId()) : '\"' + prop.getName() + '\"', prop.getGetterName()});
        }
        builder.addStatement("default: throw new IllegalArgumentException($S + prop + $S)", new Object[]{"Illegal property " + (argType == Integer.TYPE ? "id" : "name") + ": \"", "\""});
        builder.endControlFlow();
        this.typeBuilder.addMethod(builder.build());
    }

    private void addType() {
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)"__type").addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Override.class).returns((TypeName)Constants.RUNTIME_TYPE_CLASS_NAME).addStatement("return TYPE", new Object[0]);
        this.typeBuilder.addMethod(builder.build());
    }

    private void addToString() {
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)"toString").addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Override.class).returns(String.class).addStatement("return $T.toString(this)", new Object[]{ImmutableObjects.class});
        this.typeBuilder.addMethod(builder.build());
    }

    private void addDummyProp() {
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)"getDummyPropForJacksonError__").returns(TypeName.INT).addModifiers(new Modifier[]{Modifier.PUBLIC}).addStatement("throw new $T()", new Object[]{ImmutableModuleRequiredException.class});
        this.typeBuilder.addMethod(builder.build());
    }
}

