/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.apt.meta;

import com.squareup.javapoet.ClassName;
import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import org.babyfish.jimmer.Formula;
import org.babyfish.jimmer.apt.TypeUtils;
import org.babyfish.jimmer.apt.meta.ImmutableProp;
import org.babyfish.jimmer.apt.meta.MetaException;
import org.babyfish.jimmer.apt.meta.ValidationMessages;
import org.babyfish.jimmer.meta.ModelException;
import org.babyfish.jimmer.sql.Embeddable;
import org.babyfish.jimmer.sql.Entity;
import org.babyfish.jimmer.sql.Id;
import org.babyfish.jimmer.sql.MappedSuperclass;
import org.babyfish.jimmer.sql.Version;

public class ImmutableType {
    public static final String PROP_EXPRESSION_SUFFIX = "PropExpression";
    private static final String FORMULA_CLASS_NAME = Formula.class.getName();
    private final TypeElement typeElement;
    private final boolean isEntity;
    private final boolean isMappedSuperClass;
    private final boolean isEmbeddable;
    private final String packageName;
    private final String name;
    private final String qualifiedName;
    private final Set<Modifier> modifiers;
    private final ImmutableType superType;
    private final Map<String, ImmutableProp> declaredProps;
    private Map<String, ImmutableProp> props;
    private List<ImmutableProp> propsOrderById;
    private ImmutableProp idProp;
    private ImmutableProp versionProp;
    private final ClassName className;
    private final ClassName draftClassName;
    private final ClassName producerClassName;
    private final ClassName implementorClassName;
    private final ClassName implClassName;
    private final ClassName draftImplClassName;
    private final ClassName mapStructClassName;
    private final ClassName tableClassName;
    private final ClassName tableExClassName;
    private final ClassName fetcherClassName;
    private final ClassName propsClassName;
    private final ClassName propExpressionClassName;
    private final Map<ClassName, String> validationMessageMap;

    public ImmutableType(TypeUtils typeUtils, TypeElement typeElement) {
        this.typeElement = typeElement;
        Class<? extends Annotation> annotationType = typeUtils.getImmutableAnnotationType(typeElement);
        this.isEntity = annotationType == Entity.class;
        this.isMappedSuperClass = annotationType == MappedSuperclass.class;
        this.isEmbeddable = annotationType == Embeddable.class;
        this.packageName = ((PackageElement)typeElement.getEnclosingElement()).getQualifiedName().toString();
        this.name = typeElement.getSimpleName().toString();
        this.qualifiedName = typeElement.getQualifiedName().toString();
        this.modifiers = typeElement.getModifiers();
        TypeMirror superTypeMirror = null;
        for (TypeMirror typeMirror : typeElement.getInterfaces()) {
            if (!typeUtils.isImmutable(typeMirror)) continue;
            if (superTypeMirror != null) {
                throw new MetaException(String.format("'%s' inherits multiple Immutable interfaces", typeElement.getQualifiedName()));
            }
            superTypeMirror = typeMirror;
        }
        this.superType = superTypeMirror != null ? typeUtils.getImmutableType(superTypeMirror) : null;
        if (this.superType != null) {
            if (this.isEntity || this.isMappedSuperClass) {
                if (this.superType.isEntity()) {
                    throw new MetaException("Illegal type \"" + typeElement.getQualifiedName() + "\", it super type \"" + this.superType.qualifiedName + "\" is entity. Super entity is not supported temporarily, please use an interface decorated by @MappedSuperClass to be the super type");
                }
                if (!this.superType.isMappedSuperClass) {
                    throw new MetaException("Illegal type \"" + typeElement.getQualifiedName() + "\", it super type \"" + this.superType.qualifiedName + "\" is entity is not decorated by @MappedSuperClass");
                }
            } else if (this.superType.isEntity || this.superType.isMappedSuperClass) {
                throw new MetaException("Illegal type \"" + typeElement.getQualifiedName() + "\", it super type \"" + this.superType.qualifiedName + "\" cannot be decorated by @Entity or @MappedSuperClass");
            }
        }
        int propIdSequence = this.superType != null ? this.superType.getProps().size() : 0;
        LinkedHashMap<String, ImmutableProp> linkedHashMap = new LinkedHashMap<String, ImmutableProp>();
        List<ExecutableElement> executableElements = ElementFilter.methodsIn(typeElement.getEnclosedElements());
        for (ExecutableElement executableElement : executableElements) {
            if (!executableElement.isDefault()) continue;
            for (AnnotationMirror annotationMirror : executableElement.getAnnotationMirrors()) {
                String qualifiedName = ((TypeElement)annotationMirror.getAnnotationType().asElement()).getQualifiedName().toString();
                if (!qualifiedName.startsWith("org.babyfish.jimmer.") || qualifiedName.equals(FORMULA_CLASS_NAME)) continue;
                throw new MetaException("Illegal method \"" + executableElement + "\", it is default method so that it cannot be decorated by any jimmer annotations except @" + FORMULA_CLASS_NAME);
            }
        }
        for (ExecutableElement executableElement : executableElements) {
            if (executableElement.isDefault() || executableElement.getAnnotation(Id.class) == null) continue;
            ImmutableProp prop = new ImmutableProp(typeUtils, this, executableElement, ++propIdSequence);
            linkedHashMap.put(prop.getName(), prop);
        }
        for (ExecutableElement executableElement : executableElements) {
            Formula formula;
            if (executableElement.isDefault()) {
                formula = executableElement.getAnnotation(Formula.class);
                if (formula == null) continue;
                if (!formula.sql().isEmpty()) {
                    throw new ModelException("The method \"" + executableElement + "\" is non-abstract and decorated by @" + Formula.class.getName() + ", non-abstract modifier means simple calculation property based on java expression so that the `sql` of that annotation cannot be specified");
                }
                if (formula.dependencies().length == 0) {
                    throw new ModelException("The method \"" + executableElement + "\" is non-abstract and decorated by @" + Formula.class.getName() + ", non-abstract modifier means simple calculation property based on java expression so that the `dependencies` of that annotation must be specified");
                }
                ImmutableProp immutableProp = new ImmutableProp(typeUtils, this, executableElement, ++propIdSequence);
                linkedHashMap.put(immutableProp.getName(), immutableProp);
                continue;
            }
            if (executableElement.getAnnotation(Id.class) != null) continue;
            formula = executableElement.getAnnotation(Formula.class);
            if (formula != null && formula.sql().isEmpty()) {
                throw new ModelException("The method \"" + executableElement + "\" is abstract and decorated by @" + Formula.class.getName() + ", abstract modifier means simple calculation property based on SQL expression so that the `sql` of that annotation must be specified");
            }
            ImmutableProp immutableProp = new ImmutableProp(typeUtils, this, executableElement, ++propIdSequence);
            linkedHashMap.put(immutableProp.getName(), immutableProp);
        }
        if (this.superType != null) {
            for (Map.Entry entry : linkedHashMap.entrySet()) {
                if (!this.superType.getProps().containsKey(entry.getKey())) continue;
                throw new ModelException("The property \"" + entry.getValue() + "\" overrides property of super type, this is not allowed");
            }
        }
        this.declaredProps = Collections.unmodifiableMap(linkedHashMap);
        List idProps = this.declaredProps.values().stream().filter(it -> it.getAnnotation(Id.class) != null).collect(Collectors.toList());
        List list = this.declaredProps.values().stream().filter(it -> it.getAnnotation(Version.class) != null).collect(Collectors.toList());
        if (this.superType != null) {
            if (this.superType.getIdProp() != null && !idProps.isEmpty()) {
                throw new MetaException("Illegal type \"" + typeElement.getQualifiedName() + "\", " + idProps.get(0) + "\" cannot be decorated by @Id because id has been declared in super type");
            }
            if (this.superType.getVersionProp() != null && !list.isEmpty()) {
                throw new MetaException("Illegal type \"" + typeElement.getQualifiedName() + "\", " + list.get(0) + "\" cannot be decorated by @Version because version has been declared in super type");
            }
            this.idProp = this.superType.idProp;
            this.versionProp = this.superType.versionProp;
        }
        if (!this.isEntity && !this.isMappedSuperClass) {
            if (!idProps.isEmpty()) {
                throw new MetaException("Illegal type \"" + typeElement.getQualifiedName() + "\", " + idProps.get(0) + "\" cannot be decorated by @Id because current type is not entity");
            }
            if (!list.isEmpty()) {
                throw new MetaException("Illegal type \"" + typeElement.getQualifiedName() + "\", " + list.get(0) + "\" cannot be decorated by @Version because current type is not entity");
            }
        } else {
            if (idProps.size() > 1) {
                throw new MetaException("Illegal type \"" + typeElement.getQualifiedName() + "\", multiple id properties are not supported, but both \"" + idProps.get(0) + "\" and \"" + idProps.get(1) + "\" is decorated by @Id");
            }
            if (list.size() > 1) {
                throw new MetaException("Illegal type \"" + typeElement.getQualifiedName() + "\", multiple id properties are not supported, but both \"" + list.get(0) + "\" and \"" + list.get(1) + "\" is decorated by @Version");
            }
            if (this.idProp == null) {
                if (this.isEntity && idProps.isEmpty()) {
                    throw new MetaException("Illegal type \"" + typeElement.getQualifiedName() + "\", entity type must have an id property");
                }
                if (!idProps.isEmpty()) {
                    this.idProp = (ImmutableProp)idProps.get(0);
                }
            }
            if (this.idProp != null && this.idProp.isAssociation(true)) {
                throw new MetaException("Illegal property \"" + this.idProp + "\", association cannot be id property");
            }
            if (this.versionProp == null && !list.isEmpty()) {
                this.versionProp = (ImmutableProp)list.get(0);
                if (this.versionProp.isAssociation(false)) {
                    throw new MetaException("Illegal property \"" + list + "\", association cannot be version property");
                }
            }
        }
        this.className = this.toClassName(null, new String[0]);
        this.draftClassName = this.toClassName(name -> name + "Draft", new String[0]);
        this.producerClassName = this.toClassName(name -> name + "Draft", "Producer");
        this.implementorClassName = this.toClassName(name -> name + "Draft", "Producer", "Implementor");
        this.implClassName = this.toClassName(name -> name + "Draft", "Producer", "Impl");
        this.draftImplClassName = this.toClassName(name -> name + "Draft", "Producer", "DraftImpl");
        this.mapStructClassName = this.toClassName(name -> name + "Draft", "MapStruct");
        this.tableClassName = this.toClassName(name -> name + "Table", new String[0]);
        this.tableExClassName = this.toClassName(name -> name + "TableEx", new String[0]);
        this.fetcherClassName = this.toClassName(name -> name + "Fetcher", new String[0]);
        this.propsClassName = this.toClassName(name -> name + "Props", new String[0]);
        this.propExpressionClassName = this.toClassName(name -> name + PROP_EXPRESSION_SUFFIX, new String[0]);
        this.validationMessageMap = ValidationMessages.parseMessageMap(typeElement);
    }

    public TypeElement getTypeElement() {
        return this.typeElement;
    }

    public boolean isEntity() {
        return this.isEntity;
    }

    public boolean isMappedSuperClass() {
        return this.isMappedSuperClass;
    }

    public boolean isEmbeddable() {
        return this.isEmbeddable;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public String getName() {
        return this.name;
    }

    public String getQualifiedName() {
        return this.qualifiedName;
    }

    public Set<Modifier> getModifiers() {
        return this.modifiers;
    }

    public ImmutableType getSuperType() {
        return this.superType;
    }

    public Map<String, ImmutableProp> getDeclaredProps() {
        return this.declaredProps;
    }

    public Map<String, ImmutableProp> getProps() {
        Map<String, ImmutableProp> props = this.props;
        if (props == null) {
            if (this.superType == null) {
                props = this.declaredProps;
            } else {
                props = new LinkedHashMap<String, ImmutableProp>();
                for (ImmutableProp prop : this.superType.getProps().values()) {
                    if (prop.getAnnotation(Id.class) == null) continue;
                    props.put(prop.getName(), prop);
                }
                for (ImmutableProp prop : this.declaredProps.values()) {
                    if (prop.getAnnotation(Id.class) == null) continue;
                    props.put(prop.getName(), prop);
                }
                for (ImmutableProp prop : this.superType.getProps().values()) {
                    if (prop.getAnnotation(Id.class) != null) continue;
                    props.put(prop.getName(), prop);
                }
                for (ImmutableProp prop : this.declaredProps.values()) {
                    if (prop.getAnnotation(Id.class) != null) continue;
                    props.put(prop.getName(), prop);
                }
            }
            this.props = props;
        }
        return props;
    }

    public List<ImmutableProp> getPropsOrderById() {
        List<ImmutableProp> list = this.propsOrderById;
        if (list == null) {
            this.propsOrderById = list = this.getProps().values().stream().sorted(Comparator.comparing(ImmutableProp::getId)).collect(Collectors.toList());
        }
        return list;
    }

    public ImmutableProp getIdProp() {
        return this.idProp;
    }

    public ImmutableProp getVersionProp() {
        return this.versionProp;
    }

    public ClassName getClassName() {
        return this.className;
    }

    public ClassName getDraftClassName() {
        return this.draftClassName;
    }

    public ClassName getProducerClassName() {
        return this.producerClassName;
    }

    public ClassName getImplementorClassName() {
        return this.implementorClassName;
    }

    public ClassName getImplClassName() {
        return this.implClassName;
    }

    public ClassName getDraftImplClassName() {
        return this.draftImplClassName;
    }

    public ClassName getMapStructClassName() {
        return this.mapStructClassName;
    }

    public ClassName getTableClassName() {
        return this.tableClassName;
    }

    public ClassName getTableExClassName() {
        return this.tableExClassName;
    }

    public ClassName getFetcherClassName() {
        return this.fetcherClassName;
    }

    public ClassName getPropsClassName() {
        return this.propsClassName;
    }

    public ClassName getPropExpressionClassName() {
        return this.propExpressionClassName;
    }

    private ClassName toClassName(Function<String, String> transform, String ... moreSimpleNames) {
        return ClassName.get((String)this.packageName, (String)(transform != null ? transform.apply(this.name) : this.name), (String[])moreSimpleNames);
    }

    public Map<ClassName, String> getValidationMessageMap() {
        return this.validationMessageMap;
    }
}

