/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.apt.generator;

import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import javax.lang.model.element.Modifier;
import org.babyfish.jimmer.apt.generator.Constants;
import org.babyfish.jimmer.apt.meta.ImmutableProp;
import org.babyfish.jimmer.apt.meta.ImmutableType;

public class MapStructGenerator {
    private final ImmutableType type;
    private TypeSpec.Builder typeBuilder;

    public MapStructGenerator(ImmutableType type) {
        this.type = type;
    }

    public void generate(TypeSpec.Builder parentBuilder) {
        this.typeBuilder = TypeSpec.classBuilder((String)"MapStruct").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC});
        this.addMembers();
        parentBuilder.addType(this.typeBuilder.build());
    }

    private void addMembers() {
        for (ImmutableProp prop : this.type.getProps().values()) {
            this.addFields(prop);
        }
        for (ImmutableProp prop : this.type.getProps().values()) {
            this.addSetter(prop);
        }
        this.addBuild();
    }

    private void addFields(ImmutableProp prop) {
        if (prop.isLoadedStateRequired()) {
            this.typeBuilder.addField(FieldSpec.builder((TypeName)TypeName.BOOLEAN, (String)prop.getLoadedStateName(), (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PRIVATE}).build());
        }
        this.typeBuilder.addField(FieldSpec.builder((TypeName)prop.getTypeName(), (String)prop.getName(), (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PRIVATE}).build());
    }

    private void addSetter(ImmutableProp prop) {
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)prop.getName()).addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(prop.getTypeName(), prop.getName(), new Modifier[0]).returns((TypeName)this.type.getMapStructClassName());
        if (prop.isList()) {
            builder.addStatement("this.$L = $L != null ? $L : $T.emptyList()", new Object[]{prop.getName(), prop.getName(), prop.getName(), Constants.COLLECTIONS_CLASS_NAME});
        } else if (prop.isNullable() || prop.getTypeName().isPrimitive()) {
            if (prop.isLoadedStateRequired()) {
                builder.addStatement("this.$L = true", new Object[]{prop.getLoadedStateName()});
            }
            builder.addStatement("this.$L = $L", new Object[]{prop.getName(), prop.getName()});
        } else {
            builder.beginControlFlow("if ($L != null)", new Object[]{prop.getName()});
            if (prop.isLoadedStateRequired()) {
                builder.addStatement("this.$L = true", new Object[]{prop.getLoadedStateName()});
            }
            builder.addStatement("this.$L = $L", new Object[]{prop.getName(), prop.getName()});
            builder.endControlFlow();
        }
        builder.addStatement("return this", new Object[0]);
        this.typeBuilder.addMethod(builder.build());
    }

    private void addBuild() {
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)"build").addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)this.type.getClassName());
        builder.addCode("return $T.$L.produce(draft -> {$>\n", new Object[]{this.type.getDraftClassName(), "$"});
        for (ImmutableProp prop : this.type.getProps().values()) {
            if (prop.isLoadedStateRequired()) {
                builder.beginControlFlow("if ($L)", new Object[]{prop.getLoadedStateName()});
            } else {
                builder.beginControlFlow("if ($L != null)", new Object[]{prop.getName()});
            }
            builder.addStatement("draft.$L($L)", new Object[]{prop.getSetterName(), prop.getName()});
            builder.endControlFlow();
        }
        builder.addCode("$<});\n", new Object[0]);
        this.typeBuilder.addMethod(builder.build());
    }
}

