/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.apt.generator;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.io.IOException;
import javax.annotation.processing.Filer;
import javax.lang.model.element.Modifier;
import javax.lang.model.type.TypeMirror;
import org.babyfish.jimmer.Draft;
import org.babyfish.jimmer.apt.GeneratorException;
import org.babyfish.jimmer.apt.generator.Constants;
import org.babyfish.jimmer.apt.generator.MapStructGenerator;
import org.babyfish.jimmer.apt.generator.ProducerGenerator;
import org.babyfish.jimmer.apt.meta.ImmutableProp;
import org.babyfish.jimmer.apt.meta.ImmutableType;
import org.babyfish.jimmer.lang.OldChain;

public class DraftGenerator {
    private final ImmutableType type;
    private final Filer filer;
    private TypeSpec.Builder typeBuilder;

    public DraftGenerator(ImmutableType type, Filer filer) {
        this.type = type;
        this.filer = filer;
    }

    public void generate() {
        this.typeBuilder = TypeSpec.interfaceBuilder((String)(this.type.getName() + "Draft")).addSuperinterface((TypeName)this.type.getClassName());
        if (this.type.getSuperType() != null) {
            this.typeBuilder.addSuperinterface((TypeName)this.type.getSuperType().getDraftClassName());
        } else {
            this.typeBuilder.addSuperinterface(Draft.class);
        }
        this.addMembers(this.type);
        try {
            JavaFile.builder((String)this.type.getPackageName(), (TypeSpec)this.typeBuilder.build()).indent("    ").build().writeTo(this.filer);
        }
        catch (IOException ex) {
            throw new GeneratorException(String.format("Cannot generate draft interface for '%s'", this.type.getName()), ex);
        }
    }

    private void addMembers(ImmutableType type) {
        if (type.getModifiers().contains((Object)Modifier.PUBLIC)) {
            this.typeBuilder.modifiers.add(Modifier.PUBLIC);
        }
        this.add$();
        for (ImmutableProp prop : type.getProps().values()) {
            this.addGetter(prop, false);
            this.addGetter(prop, true);
            this.addSetter(prop);
            this.addUtilMethod(prop, false);
            this.addUtilMethod(prop, true);
        }
        new ProducerGenerator(type).generate(this.typeBuilder);
        new MapStructGenerator(type).generate(this.typeBuilder);
    }

    private void add$() {
        FieldSpec.Builder builder = FieldSpec.builder((TypeName)ClassName.get((String)this.type.getPackageName(), (String)(this.type.getName() + "Draft.Producer"), (String[])new String[0]), (String)"$", (Modifier[])new Modifier[0]);
        builder.modifiers.add(Modifier.PUBLIC);
        builder.modifiers.add(Modifier.STATIC);
        builder.modifiers.add(Modifier.FINAL);
        builder.initializer("Producer.INSTANCE", new Object[0]);
        this.typeBuilder.addField(builder.build());
    }

    private void addGetter(ImmutableProp prop, boolean autoCreate) {
        if (!(autoCreate || prop.isAssociation(false) && !prop.isList())) {
            return;
        }
        if (autoCreate && !prop.isAssociation(false) && !prop.isList()) {
            return;
        }
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)prop.getGetterName());
        builder.modifiers.add(Modifier.PUBLIC);
        builder.modifiers.add(Modifier.ABSTRACT);
        if (autoCreate) {
            builder.addParameter(Boolean.TYPE, "autoCreate", new Modifier[0]);
        }
        builder.returns(prop.getDraftTypeName(autoCreate));
        this.typeBuilder.addMethod(builder.build());
    }

    private void addSetter(ImmutableProp prop) {
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)prop.getSetterName()).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.ABSTRACT}).addAnnotation(OldChain.class).addParameter(TypeName.get((TypeMirror)prop.getReturnType()), prop.getName(), new Modifier[0]).returns((TypeName)this.type.getDraftClassName());
        this.typeBuilder.addMethod(builder.build());
    }

    private void addUtilMethod(ImmutableProp prop, boolean withBase) {
        if (!prop.isAssociation(false)) {
            return;
        }
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)(prop.isList() ? prop.getAdderByName() : prop.getApplierName())).addAnnotation(OldChain.class).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.ABSTRACT}).returns((TypeName)this.type.getDraftClassName());
        if (withBase) {
            builder.addParameter(prop.getElementTypeName(), "base", new Modifier[0]);
        }
        ParameterizedTypeName consumerTypeName = ParameterizedTypeName.get((ClassName)Constants.DRAFT_CONSUMER_CLASS_NAME, (TypeName[])new TypeName[]{prop.getDraftElementTypeName()});
        builder.addParameter((TypeName)consumerTypeName, "block", new Modifier[0]);
        this.typeBuilder.addMethod(builder.build());
    }
}

