/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.apt.meta;

import com.squareup.javapoet.TypeName;
import org.babyfish.jimmer.apt.meta.ImmutableProp;
import org.babyfish.jimmer.apt.meta.StaticDeclaration;

public class StaticProp {
    private final ImmutableProp immutableProp;
    private final String alias;
    private final String name;
    private final boolean enabled;
    private final boolean optional;
    private final boolean idOnly;
    private final String targetAlias;
    private final StaticDeclaration target;

    public StaticProp(ImmutableProp immutableProp, String alias, String name, boolean enabled, boolean optional, boolean idOnly, String targetAlias) {
        this.immutableProp = immutableProp;
        this.alias = alias;
        this.name = name;
        this.enabled = enabled;
        this.optional = optional;
        this.idOnly = idOnly;
        this.targetAlias = targetAlias;
        this.target = null;
    }

    private StaticProp(StaticProp base, StaticDeclaration target) {
        this.immutableProp = base.immutableProp;
        this.alias = base.alias;
        this.name = base.name;
        this.enabled = base.enabled;
        this.optional = base.optional;
        this.idOnly = base.idOnly;
        this.targetAlias = base.targetAlias;
        this.target = target;
    }

    private StaticProp(StaticProp base, boolean optional) {
        this.immutableProp = base.immutableProp;
        this.alias = base.alias;
        this.name = base.name;
        this.enabled = base.enabled;
        this.optional = optional;
        this.idOnly = base.idOnly;
        this.targetAlias = base.targetAlias;
        this.target = base.target;
    }

    public ImmutableProp getImmutableProp() {
        return this.immutableProp;
    }

    public String getAlias() {
        return this.alias;
    }

    public String getName() {
        return this.name;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean isOptional() {
        return this.optional;
    }

    public boolean isIdOnly() {
        return this.idOnly;
    }

    public String getTargetAlias() {
        return this.targetAlias;
    }

    public StaticDeclaration getTarget() {
        return this.target;
    }

    public boolean isNullable(boolean input) {
        if (this.optional) {
            return true;
        }
        if (this.immutableProp.isNullable()) {
            return !input || !this.immutableProp.isInputNotNull();
        }
        return false;
    }

    public StaticProp target(StaticDeclaration target) {
        if (this.target == target) {
            return this;
        }
        return new StaticProp(this, target);
    }

    public StaticProp optional(boolean optional) {
        if (this.optional) {
            return this;
        }
        return new StaticProp(this, optional);
    }

    public String getGetterName() {
        return (this.immutableProp.getTypeName() == TypeName.BOOLEAN ? "is" : "get") + Character.toUpperCase(this.name.charAt(0)) + this.name.substring(1);
    }

    public String getSetterName() {
        return "set" + Character.toUpperCase(this.name.charAt(0)) + this.name.substring(1);
    }

    public String getDefaultValue() {
        TypeName typeName = this.immutableProp.getTypeName();
        if (typeName.isPrimitive()) {
            if (typeName == TypeName.BOOLEAN) {
                return "false";
            }
            if (typeName == TypeName.CHAR) {
                return "'\\0'";
            }
            return "0";
        }
        return "null";
    }

    public String toString() {
        return "StaticProp{immutableProp=" + this.immutableProp + ", ownerAlias='" + this.alias + '\'' + ", name='" + this.name + '\'' + ", enabled=" + this.enabled + ", optional=" + this.optional + ", idOnly=" + this.idOnly + ", targetAlias='" + this.targetAlias + '\'' + ", target=" + this.target + '}';
    }
}

