/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.apt.generator;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import java.lang.annotation.Annotation;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import javax.validation.ValidationException;
import javax.validation.constraints.Email;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.Negative;
import javax.validation.constraints.NegativeOrZero;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Positive;
import javax.validation.constraints.PositiveOrZero;
import javax.validation.constraints.Size;
import org.babyfish.jimmer.apt.generator.Constants;
import org.babyfish.jimmer.apt.meta.ImmutableProp;
import org.babyfish.jimmer.apt.meta.MetaException;

public class ValidationGenerator {
    private static final Object[] EMPTY_ARGS = new Object[0];
    private final ImmutableProp prop;
    private final String valueName;
    private final MethodSpec.Builder methodBuilder;

    public ValidationGenerator(ImmutableProp prop, String valueName, MethodSpec.Builder methodBuilder) {
        this.prop = prop;
        this.valueName = valueName;
        this.methodBuilder = methodBuilder;
    }

    public void generate() {
        if (!this.prop.isNullable() && !this.prop.getTypeName().isPrimitive()) {
            this.methodBuilder.beginControlFlow("if ($L == null)", new Object[]{this.valueName}).addCode("throw new IllegalArgumentException(\n", new Object[0]).addCode("    \"'$L' cannot be null, please specify non-null value or use nullable annotation to decorate this property\"\n", new Object[]{this.prop.getName()}).addCode(");\n", new Object[0]).endControlFlow();
        }
        this.generateNotEmpty();
        this.generateNotBlank();
        this.generateSize();
        this.generateBound();
        this.generateEmail();
        this.generatePattern();
        this.generateConstraints();
    }

    private void generateNotEmpty() {
        NotEmpty[] notEmpties = (NotEmpty[])this.prop.getAnnotations(NotEmpty.class);
        if (notEmpties.length == 0) {
            return;
        }
        if (!this.isSimpleClass(String.class) && !this.isSimpleClass(List.class)) {
            throw new MetaException("Illegal property \"" + this.prop + "\", it's decorated by the annotation @" + notEmpties[0].annotationType().getName() + " but its type is neither string nor list");
        }
        this.validate("$L.isEmpty()", new Object[]{this.valueName}, notEmpties[0].message(), () -> "it cannot be empty");
    }

    private void generateNotBlank() {
        NotBlank[] notBlanks = (NotBlank[])this.prop.getAnnotations(NotBlank.class);
        if (notBlanks.length == 0) {
            return;
        }
        if (!this.isSimpleClass(String.class)) {
            throw new MetaException("Illegal property \"" + this.prop + "\", it's decorated by the annotation @" + notBlanks[0].annotationType().getName() + " but its type is not string");
        }
        this.validate("$L.trim().isEmpty()", new Object[]{this.valueName}, notBlanks[0].message(), () -> "it cannot be empty");
    }

    private void generateSize() {
        int finalValue;
        String sizeFun;
        Size[] sizes = (Size[])this.prop.getAnnotations(Size.class);
        if (sizes.length == 0) {
            return;
        }
        if (!this.isSimpleClass(String.class) && !this.isSimpleClass(List.class)) {
            throw new MetaException("Illegal property \"" + this.prop + "\", it's decorated by the annotation @" + sizes[0].annotationType().getName() + " but its type is neither string nor list");
        }
        int min = 0;
        int max = Integer.MAX_VALUE;
        String minMessage = null;
        String maxMessage = null;
        for (Size size : sizes) {
            if (size.min() > min) {
                min = size.min();
                minMessage = size.message();
            }
            if (size.max() >= max) continue;
            max = size.max();
            maxMessage = size.message();
        }
        if (min > max) {
            throw new MetaException("Illegal property \"" + this.prop + "\", its size validation rules is illegal so that there is not valid length");
        }
        if (min == 0 && max == Integer.MAX_VALUE) {
            return;
        }
        String string = sizeFun = this.isSimpleClass(String.class) ? "length" : "size";
        if (min > 0) {
            finalValue = min;
            this.validate("$L.$L() < $L", new Object[]{this.valueName, sizeFun, finalValue}, minMessage, () -> "it cannot be less than " + finalValue);
        }
        if (max < Integer.MAX_VALUE) {
            finalValue = max;
            this.validate("$L.$L() > $L", new Object[]{this.valueName, sizeFun, finalValue}, maxMessage, () -> "it cannot be greater than " + finalValue);
        }
    }

    private void generateBound() {
        NegativeOrZero[] negativeOrZeros;
        Negative[] negatives;
        PositiveOrZero[] positiveOrZeros;
        Positive[] positives;
        Max[] maxArr;
        Min[] minArr = (Min[])this.prop.getAnnotations(Min.class);
        Annotation annotation = Arrays.stream(new Annotation[][]{minArr, maxArr = (Max[])this.prop.getAnnotations(Max.class), positives = (Positive[])this.prop.getAnnotations(Positive.class), positiveOrZeros = (PositiveOrZero[])this.prop.getAnnotations(PositiveOrZero.class), negatives = (Negative[])this.prop.getAnnotations(Negative.class), negativeOrZeros = (NegativeOrZero[])this.prop.getAnnotations(NegativeOrZero.class)}).flatMap(Arrays::stream).filter(Objects::nonNull).findFirst().orElse(null);
        if (annotation == null) {
            return;
        }
        if (!(this.prop.getTypeName().isPrimitive() || this.prop.getTypeName().isBoxedPrimitive() || this.isSimpleClass(BigInteger.class) || this.isSimpleClass(BigDecimal.class))) {
            throw new MetaException("Illegal property \"" + this.prop + "\", it's decorated by the annotation @" + annotation.annotationType().getName() + " but its type is numeric");
        }
        Long minValue = null;
        Long maxValue = null;
        String message = null;
        for (Min min : minArr) {
            if (minValue != null && min.value() <= minValue) continue;
            minValue = min.value();
            message = min.message();
        }
        for (Min min : positives) {
            if (minValue != null && 1L <= minValue) continue;
            minValue = 1L;
            message = min.message();
        }
        for (Min min : positiveOrZeros) {
            if (minValue != null && 0L <= minValue) continue;
            minValue = 0L;
            message = min.message();
        }
        for (Min min : maxArr) {
            if (maxValue != null && min.value() >= maxValue) continue;
            maxValue = min.value();
            message = min.message();
        }
        for (Min min : negatives) {
            if (maxValue != null && -1L >= maxValue) continue;
            maxValue = -1L;
            message = min.message();
        }
        for (Min min : negativeOrZeros) {
            if (maxValue != null && 0L >= maxValue) continue;
            maxValue = 0L;
            message = min.message();
        }
        if (minValue != null && maxValue != null && minValue > maxValue) {
            throw new MetaException("Illegal property \"" + this.prop + "\", its numeric range validation rules is illegal so that there is not valid number");
        }
        if (minValue != null) {
            long finalValue = minValue;
            this.validateBound(minValue, "<", message);
        }
        if (maxValue != null) {
            this.validateBound(maxValue, ">", message);
        }
    }

    private void generateEmail() {
        Email[] emails = (Email[])this.prop.getAnnotations(Email.class);
        if (emails.length == 0) {
            return;
        }
        if (!this.isSimpleClass(String.class)) {
            throw new MetaException("Illegal property \"" + this.prop + "\", it's decorated by the annotation @" + emails[0].annotationType().getName() + " but its type is not string");
        }
        this.validate("!$L.matcher($L).matches()", new Object[]{"__EMAIL_PATTERN__", this.valueName}, emails[0].message(), () -> "it is not email address");
    }

    private void generatePattern() {
        Pattern[] patterns = (Pattern[])this.prop.getAnnotations(Pattern.class);
        if (patterns.length == 0) {
            return;
        }
        if (!this.isSimpleClass(String.class)) {
            throw new MetaException("Illegal property \"" + this.prop + "\", it's decorated by the annotation @" + patterns[0].annotationType().getName() + " but its type is not string");
        }
        for (int i = 0; i < patterns.length; ++i) {
            int index = i;
            this.validate("!$L.matcher($L).matches()", new Object[]{Constants.regexpPatternFieldName(this.prop, i), this.valueName}, patterns[index].message(), () -> "it does not match the regexp '" + patterns[index].regexp().replace("\\", "\\\\") + "'");
        }
    }

    private void generateConstraints() {
        for (Map.Entry<ClassName, String> e : this.prop.getValidationMessageMap().entrySet()) {
            this.methodBuilder.addStatement("$L.validate($L)", new Object[]{Constants.validatorFieldName(this.prop, e.getKey()), this.prop.getName()});
        }
    }

    private void validate(String condition, Object[] args, String errorMessage, Supplier<String> defaultMessageSupplier) {
        if (!this.prop.isNullable() || this.prop.getTypeName().isPrimitive()) {
            this.methodBuilder.beginControlFlow("if (" + condition + ")", args != null ? args : EMPTY_ARGS);
        } else {
            this.methodBuilder.beginControlFlow("if (" + this.valueName + " != null && " + condition + ")", args != null ? args : EMPTY_ARGS);
        }
        if (errorMessage == null || errorMessage.isEmpty() || errorMessage.startsWith("{javax.validation.constraints.")) {
            errorMessage = "Illegal value '\" + " + this.valueName + " + \"' for property '" + this.prop + "', " + defaultMessageSupplier.get();
            this.methodBuilder.addStatement("throw new $T(\"$L\")", new Object[]{ValidationException.class, errorMessage});
        }
        this.methodBuilder.endControlFlow();
    }

    private boolean isSimpleClass(Class<?> type) {
        ClassName className;
        TypeName typeName = this.prop.getTypeName();
        if (typeName instanceof ClassName) {
            className = (ClassName)typeName;
        } else if (typeName instanceof ParameterizedTypeName) {
            className = ((ParameterizedTypeName)typeName).rawType;
        } else {
            return false;
        }
        return className.packageName().equals(type.getPackage().getName()) && className.simpleNames().size() == 1 && className.simpleName().equals(type.getSimpleName());
    }

    private void validateBound(long bound, String cmp, String message) {
        Object[] objectArray;
        String bigNumLiteral = this.prop.getTypeName().equals((Object)ClassName.get(BigDecimal.class)) ? (bound == 0L ? "$T.ZERO" : (bound == 1L ? "$T.ONE" : (bound == 2L ? "$T.TWO" : (bound == 10L ? "$T.TEN" : "$T.valueOf(" + bound + ")")))) : (this.prop.getTypeName().equals((Object)ClassName.get(BigInteger.class)) ? (bound == -1L ? "$T.NEGATIVE_ONE" : (bound == 0L ? "$T.ZERO" : (bound == 1L ? "$T.ONE" : (bound == 2L ? "$T.TWO" : (bound == 10L ? "$T.TEN" : "$T.valueOf(" + bound + ", 0)"))))) : null);
        String string = bigNumLiteral != null ? "$L.compareTo(" + bigNumLiteral + ") $L 0" : "$L $L $L";
        if (bigNumLiteral != null) {
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = this.valueName;
            objectArray2[1] = this.prop.getElementType();
            objectArray = objectArray2;
            objectArray2[2] = cmp;
        } else {
            Object[] objectArray3 = new Object[3];
            objectArray3[0] = this.valueName;
            objectArray3[1] = cmp;
            objectArray = objectArray3;
            objectArray3[2] = bound;
        }
        this.validate(string, objectArray, message, () -> "it cannot be " + (cmp.equals("<") ? "less than" : "greater than") + " " + bound);
    }
}

