/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.apt.generator;

import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.io.IOException;
import java.lang.annotation.ElementType;
import java.lang.annotation.Target;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.processing.Filer;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Null;
import org.babyfish.jimmer.apt.GeneratorException;
import org.babyfish.jimmer.apt.generator.Constants;
import org.babyfish.jimmer.apt.generator.StaticDeclarationBuilderGenerator;
import org.babyfish.jimmer.apt.meta.ImmutableProp;
import org.babyfish.jimmer.apt.meta.ImmutableType;
import org.babyfish.jimmer.apt.meta.MetaException;
import org.babyfish.jimmer.apt.meta.StaticDeclaration;
import org.babyfish.jimmer.apt.meta.StaticProp;
import org.babyfish.jimmer.pojo.AutoScalarStrategy;
import org.babyfish.jimmer.runtime.ImmutableSpi;
import org.babyfish.jimmer.sql.Id;
import org.babyfish.jimmer.sql.Key;
import org.jetbrains.annotations.Nullable;

public class StaticDeclarationGenerator {
    private static final String[] EMPTY_STR_ARR = new String[0];
    private final StaticDeclaration declaration;
    private final Filer filer;
    private final List<StaticProp> props;
    private final String innerClassName;
    private final StaticDeclarationGenerator parent;
    private TypeSpec.Builder typeBuilder;

    public StaticDeclarationGenerator(StaticDeclaration declaration, Filer filer) {
        this(declaration, filer, null, null);
    }

    public StaticDeclarationGenerator(StaticDeclaration declaration, String innerClassName, StaticDeclarationGenerator parent) {
        this(declaration, null, innerClassName, parent);
    }

    private StaticDeclarationGenerator(StaticDeclaration declaration, Filer filer, String innerClassName, StaticDeclarationGenerator parent) {
        AutoScalarStrategy strategy;
        this.declaration = declaration;
        this.filer = filer;
        this.innerClassName = innerClassName;
        this.parent = parent;
        HashSet<ImmutableProp> possibleAutoScalars = new HashSet<ImmutableProp>();
        for (ImmutableType type = declaration.getImmutableType(); type != null && (strategy = type.getAutoScalarStrategy(declaration.getAlias())) != AutoScalarStrategy.NONE; type = type.getSuperType()) {
            for (ImmutableProp prop : type.getDeclaredProps().values()) {
                if (prop.isAssociation(true) || prop.isTransient()) continue;
                possibleAutoScalars.add(prop);
            }
            if (strategy == AutoScalarStrategy.DECLARED) break;
        }
        ArrayList<StaticProp> props = new ArrayList<StaticProp>();
        String alias = declaration.getAlias();
        boolean hasKey = declaration.getImmutableType().getProps().values().stream().anyMatch(it -> it.getAnnotation(Key.class) != null);
        for (ImmutableProp prop : declaration.getImmutableType().getProps().values()) {
            StaticProp staticProp = prop.getStaticProp(alias);
            if (staticProp == null) {
                if (!possibleAutoScalars.contains(prop)) continue;
                staticProp = new StaticProp(prop, alias, prop.getName(), true, declaration.isAllOptional(), false, "");
                if (!staticProp.isOptional() && prop.getAnnotation(Id.class) != null && hasKey) {
                    staticProp = staticProp.optional(true);
                }
                props.add(staticProp);
                continue;
            }
            if (!staticProp.isEnabled()) continue;
            if (prop.isTransient()) {
                if (this.isInput()) {
                    throw new MetaException("Illegal property \"" + prop + "\", the transient property of input type can not be decorated by @Static");
                }
                if (!prop.hasTransientResolver()) {
                    throw new MetaException("Illegal property \"" + prop + "\", if a property is decorated by both @Transient and @Static,its transient resolver must be specified");
                }
            }
            props.add(staticProp.optional(declaration.isAllOptional()));
        }
        this.props = Collections.unmodifiableList(props);
    }

    public List<StaticProp> getProps() {
        return this.props;
    }

    public TypeSpec.Builder getTypeBuilder() {
        return this.typeBuilder;
    }

    public String getSimpleName() {
        return this.innerClassName != null ? this.innerClassName : this.declaration.getTopLevelName();
    }

    public ClassName getClassName(String ... nestedNames) {
        if (this.innerClassName != null) {
            ArrayList<String> list = new ArrayList<String>();
            this.collectNames(list);
            list.addAll(Arrays.asList(nestedNames));
            return ClassName.get((String)this.declaration.getImmutableType().getPackageName(), (String)((String)list.get(0)), (String[])list.subList(1, list.size()).toArray(EMPTY_STR_ARR));
        }
        return ClassName.get((String)this.declaration.getImmutableType().getPackageName(), (String)this.declaration.getTopLevelName(), (String[])nestedNames);
    }

    public void generate() {
        String simpleName = this.getSimpleName();
        this.typeBuilder = TypeSpec.classBuilder((String)simpleName).addModifiers(new Modifier[]{Modifier.PUBLIC}).addSuperinterface((TypeName)ParameterizedTypeName.get((ClassName)(this.isInput() ? Constants.INPUT_CLASS_NAME : Constants.STATIC_CLASS_NAME), (TypeName[])new TypeName[]{this.declaration.getImmutableType().getClassName()}));
        if (this.innerClassName != null) {
            this.typeBuilder.addModifiers(new Modifier[]{Modifier.STATIC});
            this.addMembers();
        } else {
            this.addMembers();
        }
        if (this.innerClassName != null) {
            this.parent.typeBuilder.addType(this.typeBuilder.build());
        } else {
            try {
                JavaFile.builder((String)this.declaration.getImmutableType().getPackageName(), (TypeSpec)this.typeBuilder.build()).indent("    ").build().writeTo(this.filer);
            }
            catch (IOException ex) {
                throw new GeneratorException(String.format("Cannot generate static type for '%s'", this.declaration.getTopLevelName()), ex);
            }
        }
    }

    private void addMembers() {
        this.addMetadata();
        for (StaticProp prop : this.props) {
            this.addField(prop);
        }
        this.addJsonConstructor();
        this.addConverterConstructor();
        this.addNewBuilder(false);
        this.addNewBuilder(true);
        for (StaticProp prop : this.props) {
            this.addGetter(prop);
        }
        this.addToEntity();
        this.addToEntityWithBase();
        this.addToString();
        new StaticDeclarationBuilderGenerator(this).generate();
        for (StaticProp prop : this.props) {
            if (prop.getTarget() == null || !prop.getTarget().getTopLevelName().isEmpty()) continue;
            new StaticDeclarationGenerator(prop.getTarget(), StaticDeclarationGenerator.targetSimpleName(prop), this).generate();
        }
    }

    private void addMetadata() {
        FieldSpec.Builder builder = FieldSpec.builder((TypeName)ParameterizedTypeName.get((ClassName)Constants.STATIC_METADATA_CLASS_NAME, (TypeName[])new TypeName[]{this.declaration.getImmutableType().getClassName(), this.getClassName(new String[0])}), (String)"METADATA", (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC, Modifier.FINAL});
        CodeBlock.Builder cb = CodeBlock.builder().indent().add("\n", new Object[0]).add("new $T<$T, $T>(\n", new Object[]{Constants.STATIC_METADATA_CLASS_NAME, this.declaration.getImmutableType().getClassName(), this.getClassName(new String[0])}).indent().add("$T.$L", new Object[]{this.declaration.getImmutableType().getFetcherClassName(), "$"}).indent();
        for (StaticProp prop : this.props) {
            if (prop.getImmutableProp().getAnnotation(Id.class) != null) continue;
            if (prop.getTarget() != null) {
                cb.add("\n.$N($T.METADATA.getFetcher())", new Object[]{prop.getImmutableProp().getName(), this.getPropElementName(prop)});
                continue;
            }
            cb.add("\n.$N()", new Object[]{prop.getImmutableProp().getName()});
        }
        cb.add(",\n", new Object[0]).unindent().add("$T::new\n", new Object[]{this.getClassName(new String[0])}).unindent().unindent().add(")", new Object[0]);
        builder.initializer(cb.build());
        this.typeBuilder.addField(builder.build());
    }

    private void addField(StaticProp prop) {
        FieldSpec.Builder builder = FieldSpec.builder((TypeName)this.getPropTypeName(prop), (String)prop.getName(), (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PRIVATE, Modifier.FINAL});
        if (prop.isNullable(this.isInput())) {
            builder.addAnnotation(Nullable.class).addAnnotation(Null.class);
        } else {
            builder.addAnnotation(org.jetbrains.annotations.NotNull.class).addAnnotation(NotNull.class);
        }
        for (AnnotationMirror annotationMirror : prop.getImmutableProp().getAnnotations()) {
            if (!StaticDeclarationGenerator.isCopyableAnnotation(annotationMirror, false)) continue;
            builder.addAnnotation(AnnotationSpec.get((AnnotationMirror)annotationMirror));
        }
        this.typeBuilder.addField(builder.build());
    }

    private void addNewBuilder(boolean withBase) {
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)"newBuilder").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC}).returns((TypeName)this.getClassName("Builder"));
        if (withBase) {
            builder.addParameter(ParameterSpec.builder((TypeName)this.getClassName(new String[0]), (String)"base", (Modifier[])new Modifier[0]).addAnnotation(Nullable.class).build());
        }
        builder.addStatement("return new $T($L)", new Object[]{this.getClassName("Builder"), withBase ? "base" : null});
        this.typeBuilder.addMethod(builder.build());
    }

    private void addJsonConstructor() {
        MethodSpec.Builder builder = MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Constants.JSON_CREATOR_CLASS_NAME);
        for (StaticProp prop : this.props) {
            ParameterSpec.Builder parameterBuilder = ParameterSpec.builder((TypeName)this.getPropTypeName(prop), (String)prop.getName(), (Modifier[])new Modifier[0]);
            AnnotationSpec.Builder jsonPropertySpecBuilder = AnnotationSpec.builder((ClassName)Constants.JSON_PROPERTY_CLASS_NAME).addMember("value", "$S", new Object[]{prop.getName()});
            if (prop.isNullable(this.isInput())) {
                parameterBuilder.addAnnotation(Nullable.class).addAnnotation(Null.class);
            } else {
                parameterBuilder.addAnnotation(org.jetbrains.annotations.NotNull.class).addAnnotation(NotNull.class);
                jsonPropertySpecBuilder.addMember("required", "true", new Object[0]);
            }
            parameterBuilder.addAnnotation(jsonPropertySpecBuilder.build());
            builder.addParameter(parameterBuilder.build());
        }
        for (StaticProp prop : this.props) {
            if (prop.isNullable(this.isInput()) || prop.getImmutableProp().getTypeName().isPrimitive()) {
                builder.addStatement("this.$L = $L", new Object[]{prop.getName(), prop.getName()});
                continue;
            }
            builder.addStatement("this.$L = $T.requireNonNull($L, $S)", new Object[]{prop.getName(), Constants.OBJECTS_CLASS_NAME, prop.getName(), prop.getName()});
        }
        this.typeBuilder.addMethod(builder.build());
    }

    private void addConverterConstructor() {
        MethodSpec.Builder builder = MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(ParameterSpec.builder((TypeName)this.declaration.getImmutableType().getClassName(), (String)"base", (Modifier[])new Modifier[0]).addAnnotation(org.jetbrains.annotations.NotNull.class).build());
        builder.addStatement("$T spi = ($T)base", new Object[]{ImmutableSpi.class, ImmutableSpi.class});
        for (StaticProp prop : this.props) {
            if (prop.isIdOnly()) {
                if (prop.getImmutableProp().isList()) {
                    if (prop.isNullable(this.isInput())) {
                        builder.addStatement("this.$L = spi.__isLoaded($L) ? base.$L().stream().map($T::$L).collect($T.toList()) : $L", new Object[]{prop.getName(), prop.getImmutableProp().getId(), prop.getImmutableProp().getGetterName(), prop.getImmutableProp().getTargetType().getClassName(), prop.getImmutableProp().getTargetType().getIdProp().getName(), Collectors.class, prop.getDefaultValue()});
                        continue;
                    }
                    if (prop.isNullable(false)) {
                        builder.addStatement("this.$L = $T.requireNonNull(base.$L(), $S).stream().map($T::$L).collect($T.toList())", new Object[]{Objects.class, prop.getName(), "\"`base." + prop.getImmutableProp().getGetterName() + "()` cannot be null\"", prop.getImmutableProp().getGetterName(), prop.getImmutableProp().getTargetType().getClassName(), prop.getImmutableProp().getTargetType().getIdProp().getName(), Collectors.class});
                        continue;
                    }
                    builder.addStatement("this.$L = base.$L().stream().map($T::$L).collect($T.toList())", new Object[]{prop.getName(), prop.getImmutableProp().getGetterName(), prop.getImmutableProp().getTargetType().getClassName(), prop.getImmutableProp().getTargetType().getIdProp().getName(), Collectors.class});
                    continue;
                }
                if (prop.isNullable(this.isInput())) {
                    builder.addStatement("$T _tmp_$L = spi.__isLoaded($L) ? base.$L() : null", new Object[]{prop.getImmutableProp().getTypeName(), prop.getImmutableProp().getName(), prop.getImmutableProp().getId(), prop.getImmutableProp().getGetterName()});
                } else if (prop.isNullable(false)) {
                    builder.addStatement("$T _tmp_$L = $T.requireNonNull(base.$L(), $S)", new Object[]{prop.getImmutableProp().getTypeName(), prop.getImmutableProp().getName(), Objects.class, prop.getImmutableProp().getGetterName(), "\"`base." + prop.getImmutableProp().getGetterName() + "()` cannot be null\""});
                } else {
                    builder.addStatement("$T _tmp_$L = base.$L()", new Object[]{prop.getImmutableProp().getTypeName(), prop.getImmutableProp().getName(), prop.getImmutableProp().getGetterName()});
                }
                if (prop.isNullable(this.isInput())) {
                    builder.addStatement("this.$L = _tmp_$L != null ? _tmp_$L.$L() : null", new Object[]{prop.getName(), prop.getImmutableProp().getName(), prop.getImmutableProp().getName(), prop.getImmutableProp().getTargetType().getIdProp().getGetterName()});
                    continue;
                }
                builder.addStatement("this.$L = _tmp_$L.$L()", new Object[]{prop.getName(), prop.getImmutableProp().getName(), prop.getImmutableProp().getTargetType().getIdProp().getGetterName()});
                continue;
            }
            if (prop.getTarget() != null) {
                if (prop.getImmutableProp().isList()) {
                    if (prop.isNullable(this.isInput())) {
                        builder.addStatement("this.$L = spi.__isLoaded($L) ? base.$L().stream().map($T::new).collect($T.toList()) : $L", new Object[]{prop.getName(), prop.getImmutableProp().getId(), prop.getImmutableProp().getGetterName(), this.getPropElementName(prop), Collectors.class, prop.getDefaultValue()});
                        continue;
                    }
                    if (prop.isNullable(false)) {
                        builder.addStatement("this.$L = $T.requireNonNull(base.$L(), $S).stream().map($T::new).collect($T.toList())", new Object[]{prop.getName(), Objects.class, prop.getImmutableProp().getGetterName(), "\"`base." + prop.getImmutableProp().getGetterName() + "()` cannot be null\"", this.getPropElementName(prop), Collectors.class});
                        continue;
                    }
                    builder.addStatement("this.$L = base.$L().stream().map($T::new).collect($T.toList())", new Object[]{prop.getName(), prop.getImmutableProp().getGetterName(), this.getPropElementName(prop), Collectors.class});
                    continue;
                }
                if (prop.isNullable(this.isInput())) {
                    builder.addStatement("$T _tmp_$L = spi.__isLoaded($L) ? base.$L() : null", new Object[]{prop.getImmutableProp().getTypeName(), prop.getImmutableProp().getName(), prop.getImmutableProp().getId(), prop.getImmutableProp().getGetterName()});
                } else if (prop.isNullable(false)) {
                    builder.addStatement("$T _tmp_$L = $T.requireNonNull(base.$L(), $L)", new Object[]{prop.getImmutableProp().getTypeName(), prop.getImmutableProp().getName(), Objects.class, prop.getImmutableProp().getGetterName(), "\"`base." + prop.getImmutableProp().getGetterName() + "()` cannot be null\""});
                } else {
                    builder.addStatement("$T _tmp_$L = base.$L()", new Object[]{prop.getImmutableProp().getTypeName(), prop.getImmutableProp().getName(), prop.getImmutableProp().getGetterName()});
                }
                if (prop.isNullable(this.isInput())) {
                    builder.addStatement("this.$L = _tmp_$L != null ? new $T(_tmp_$L) : null", new Object[]{prop.getName(), prop.getImmutableProp().getName(), this.getPropElementName(prop), prop.getImmutableProp().getName()});
                    continue;
                }
                builder.addStatement("this.$L = new $T(_tmp_$L)", new Object[]{prop.getName(), this.getPropElementName(prop), prop.getImmutableProp().getName()});
                continue;
            }
            if (prop.isNullable(this.isInput())) {
                builder.addStatement("this.$L = spi.__isLoaded($L) ? base.$L() : $L", new Object[]{prop.getName(), prop.getImmutableProp().getId(), prop.getImmutableProp().getGetterName(), prop.getDefaultValue()});
                continue;
            }
            builder.addStatement("this.$L = base.$L()", new Object[]{prop.getName(), prop.getImmutableProp().getGetterName()});
        }
        this.typeBuilder.addMethod(builder.build());
    }

    private void addGetter(StaticProp prop) {
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)prop.getGetterName()).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(this.getPropTypeName(prop));
        if (prop.isNullable(this.isInput())) {
            builder.addAnnotation(Nullable.class).addAnnotation(Null.class);
        } else {
            builder.addAnnotation(org.jetbrains.annotations.NotNull.class).addAnnotation(NotNull.class);
        }
        for (AnnotationMirror annotationMirror : prop.getImmutableProp().getAnnotations()) {
            if (!StaticDeclarationGenerator.isCopyableAnnotation(annotationMirror, true)) continue;
            builder.addAnnotation(AnnotationSpec.get((AnnotationMirror)annotationMirror));
        }
        builder.addStatement("return $L", new Object[]{prop.getName()});
        this.typeBuilder.addMethod(builder.build());
    }

    private void addToEntity() {
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)"toEntity").addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)this.declaration.getImmutableType().getClassName()).addStatement("return toEntity(null)", new Object[0]).addAnnotation(Override.class);
        this.typeBuilder.addMethod(builder.build());
    }

    private void addToEntityWithBase() {
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)"toEntity").addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Override.class).addParameter(ParameterSpec.builder((TypeName)this.declaration.getImmutableType().getClassName(), (String)"base", (Modifier[])new Modifier[0]).addAnnotation(Nullable.class).build()).returns((TypeName)this.declaration.getImmutableType().getClassName());
        builder.addCode("return $T.$L.produce(base, draft -> {$>\n", new Object[]{this.declaration.getImmutableType().getDraftClassName(), "$"});
        for (StaticProp prop : this.props) {
            if (prop.isNullable(this.isInput()) && (prop.getImmutableProp().isAssociation(false) || !prop.getImmutableProp().isNullable())) {
                builder.beginControlFlow("if ($L != null)", new Object[]{prop.getName()});
                this.addAssignment(prop, builder);
                if (prop.getImmutableProp().isAssociation(true) && !prop.getImmutableProp().isList() && prop.getImmutableProp().isNullable()) {
                    builder.nextControlFlow("else", new Object[0]);
                    builder.addStatement("draft.$L(($T)null)", new Object[]{prop.getImmutableProp().getSetterName(), prop.getImmutableProp().getTargetType().getClassName()});
                }
                builder.endControlFlow();
                continue;
            }
            this.addAssignment(prop, builder);
        }
        builder.addCode("$<});\n", new Object[0]);
        this.typeBuilder.addMethod(builder.build());
    }

    private void addAssignment(StaticProp prop, MethodSpec.Builder builder) {
        ImmutableProp immutableProp = prop.getImmutableProp();
        if (prop.isIdOnly()) {
            if (immutableProp.isList()) {
                builder.beginControlFlow("if ($L.isEmpty())", new Object[]{prop.getName()});
                builder.addStatement("draft.$L($T.emptyList())", new Object[]{immutableProp.getSetterName(), Collections.class});
                builder.nextControlFlow("else", new Object[0]);
                builder.beginControlFlow("for ($T __e : $L)", new Object[]{this.getPropElementName(prop), prop.getName()});
                builder.addStatement("draft.$L(targetDraft -> targetDraft.$L($L))", new Object[]{immutableProp.getAdderByName(), immutableProp.getTargetType().getIdProp().getSetterName(), "__e"});
                builder.endControlFlow();
                builder.endControlFlow();
            } else {
                builder.addStatement("draft.$L(targetDraft -> targetDraft.$L($L))", new Object[]{immutableProp.getSetterName(), immutableProp.getTargetType().getIdProp().getSetterName(), prop.getName()});
            }
        } else if (prop.getTarget() != null) {
            if (immutableProp.isList()) {
                builder.beginControlFlow("if ($L.isEmpty())", new Object[]{prop.getName()});
                builder.addStatement("draft.$L($T.emptyList())", new Object[]{immutableProp.getSetterName(), Collections.class});
                builder.nextControlFlow("else", new Object[0]);
                builder.beginControlFlow("for ($T __e : $L)", new Object[]{this.getPropElementName(prop), prop.getName()});
                builder.addStatement("draft.$L(true).add(($T)__e.toEntity())", new Object[]{immutableProp.getGetterName(), immutableProp.getTargetType().getDraftClassName()});
                builder.endControlFlow();
                builder.endControlFlow();
            } else {
                builder.addStatement("draft.$L($L.toEntity())", new Object[]{immutableProp.getSetterName(), prop.getName()});
            }
        } else {
            builder.addStatement("draft.$L($L)", new Object[]{prop.getImmutableProp().getSetterName(), prop.getName()});
        }
    }

    private void addToString() {
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)"toString").returns(String.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Override.class);
        ArrayList<String> list = new ArrayList<String>();
        this.collectNames(list);
        builder.addCode("return new StringBuilder()\n$>", new Object[0]);
        builder.addCode(".append($S)\n", new Object[]{String.join((CharSequence)".", list) + '{'});
        boolean addComma = false;
        for (StaticProp prop : this.props) {
            if (addComma) {
                builder.addCode(".append($S)\n", new Object[]{", "});
            } else {
                addComma = true;
            }
            builder.addCode(".append($S).append('=').append($L)\n", new Object[]{prop.getName(), prop.getName()});
        }
        builder.addCode(".append('}')\n", new Object[0]).addCode(".toString();\n", new Object[0]);
        this.typeBuilder.addMethod(builder.build());
    }

    public TypeName getPropTypeName(StaticProp prop) {
        TypeName elementTypeName = this.getPropElementName(prop);
        return prop.getImmutableProp().isList() ? ParameterizedTypeName.get((ClassName)Constants.LIST_CLASS_NAME, (TypeName[])new TypeName[]{elementTypeName.isPrimitive() ? elementTypeName.box() : elementTypeName}) : elementTypeName;
    }

    public TypeName getPropElementName(StaticProp prop) {
        TypeName typeName;
        StaticDeclaration target = prop.getTarget();
        if (target != null) {
            if (target.getTopLevelName().isEmpty()) {
                ArrayList<String> list = new ArrayList<String>();
                this.collectNames(list);
                list.add(StaticDeclarationGenerator.targetSimpleName(prop));
                return ClassName.get((String)this.declaration.getImmutableType().getPackageName(), (String)((String)list.get(0)), (String[])list.subList(1, list.size()).toArray(EMPTY_STR_ARR));
            }
            return ClassName.get((String)target.getImmutableType().getPackageName(), (String)target.getTopLevelName(), (String[])new String[0]);
        }
        TypeName typeName2 = typeName = prop.isIdOnly() ? prop.getImmutableProp().getTargetType().getIdProp().getTypeName() : prop.getImmutableProp().getTypeName();
        if (typeName.isPrimitive() && prop.isNullable(this.isInput())) {
            return typeName.box();
        }
        return typeName;
    }

    public boolean isInput() {
        return this.parent != null ? this.parent.isInput() : this.declaration.getTopLevelName().endsWith("Input");
    }

    private void collectNames(List<String> list) {
        if (this.parent == null) {
            list.add(this.declaration.getTopLevelName());
        } else {
            this.parent.collectNames(list);
            list.add(this.innerClassName);
        }
    }

    private static String targetSimpleName(StaticProp prop) {
        StaticDeclaration target = prop.getTarget();
        if (target == null) {
            throw new IllegalArgumentException("prop is not association");
        }
        if (!target.getTopLevelName().isEmpty()) {
            return target.getTopLevelName();
        }
        return "TargetOf_" + prop.getName();
    }

    private static boolean isCopyableAnnotation(AnnotationMirror annotationMirror, boolean forMethod) {
        Target target = annotationMirror.getAnnotationType().asElement().getAnnotation(Target.class);
        if (target != null) {
            boolean acceptField = Arrays.stream(target.value()).anyMatch(it -> it == ElementType.FIELD);
            boolean acceptMethod = Arrays.stream(target.value()).anyMatch(it -> it == ElementType.METHOD);
            if (forMethod ? acceptMethod && !acceptField : acceptField) {
                String qualifiedName = ((TypeElement)annotationMirror.getAnnotationType().asElement()).getQualifiedName().toString();
                return !qualifiedName.equals(org.jetbrains.annotations.NotNull.class.getName()) && !qualifiedName.equals(NotNull.class.getName()) && !qualifiedName.equals(Nullable.class.getName()) && !qualifiedName.equals(Null.class.getName()) && !qualifiedName.startsWith("org.babyfish.jimmer.");
            }
        }
        return false;
    }
}

