/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.apt.generator;

import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.util.List;
import javax.lang.model.element.Modifier;
import org.babyfish.jimmer.apt.generator.StaticDeclarationGenerator;
import org.babyfish.jimmer.apt.meta.StaticProp;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StaticDeclarationBuilderGenerator {
    private final StaticDeclarationGenerator parent;
    private final List<StaticProp> props;
    private TypeSpec.Builder typeBuilder;

    public StaticDeclarationBuilderGenerator(StaticDeclarationGenerator parent) {
        this.parent = parent;
        this.props = parent.getProps();
    }

    public void generate() {
        this.typeBuilder = TypeSpec.classBuilder((String)"Builder").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC});
        this.addMembers();
        this.parent.getTypeBuilder().addType(this.typeBuilder.build());
    }

    private void addMembers() {
        for (StaticProp prop : this.props) {
            this.addField(prop);
        }
        this.addConstructor();
        for (StaticProp prop : this.props) {
            this.addSetter(prop);
        }
        this.addBuild();
    }

    private void addField(StaticProp prop) {
        FieldSpec.Builder builder = FieldSpec.builder((TypeName)this.parent.getPropTypeName(prop), (String)prop.getName(), (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PRIVATE});
        this.typeBuilder.addField(builder.build());
    }

    private void addConstructor() {
        MethodSpec.Builder builder = MethodSpec.constructorBuilder().addParameter(ParameterSpec.builder((TypeName)this.parent.getClassName(new String[0]), (String)"base", (Modifier[])new Modifier[0]).build());
        builder.beginControlFlow("if (base != null)", new Object[0]);
        for (StaticProp prop : this.props) {
            builder.addStatement("this.$L = base.$L()", new Object[]{prop.getName(), prop.getGetterName()});
        }
        builder.endControlFlow();
        this.typeBuilder.addMethod(builder.build());
    }

    private void addSetter(StaticProp prop) {
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)prop.getSetterName()).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)this.parent.getClassName("Builder")).addAnnotation(NotNull.class).addParameter(ParameterSpec.builder((TypeName)this.parent.getPropTypeName(prop), (String)prop.getName(), (Modifier[])new Modifier[0]).addAnnotation(prop.isNullable(this.parent.isInput()) ? Nullable.class : NotNull.class).build()).addStatement("this.$L = $L", new Object[]{prop.getName(), prop.getName()}).addStatement("return this", new Object[0]);
        this.typeBuilder.addMethod(builder.build());
    }

    private void addBuild() {
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)"build").addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)this.parent.getClassName(new String[0])).addAnnotation(NotNull.class);
        for (StaticProp prop : this.props) {
            if (!(prop.isNullable(this.parent.isInput()) || prop.isIdOnly() || prop.getImmutableProp().getTypeName().isPrimitive())) {
                builder.beginControlFlow("if ($L == null)", new Object[]{prop.getName()}).addStatement("throw new IllegalArgumentException($S)", new Object[]{"Property \"" + prop.getName() + "\" has not been set"}).endControlFlow();
                continue;
            }
            if (prop.isNullable(this.parent.isInput()) || !prop.isIdOnly() || prop.getImmutableProp().getTargetType().getIdProp().getTypeName().isPrimitive()) continue;
            builder.beginControlFlow("if ($L == null)", new Object[]{prop.getName()}).addStatement("throw new IllegalArgumentException($S)", new Object[]{"Property \"" + prop.getName() + "\" has not been set"}).endControlFlow();
        }
        builder.addCode("return new $T(\n$>", new Object[]{this.parent.getClassName(new String[0])});
        boolean addComma = false;
        for (StaticProp prop : this.props) {
            if (addComma) {
                builder.addCode(",\n", new Object[0]);
            } else {
                addComma = true;
            }
            builder.addCode(prop.getName(), new Object[0]);
        }
        builder.addCode("$<\n);\n", new Object[0]);
        this.typeBuilder.addMethod(builder.build());
    }
}

