/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.apt.generator;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.io.IOException;
import javax.annotation.processing.Filer;
import javax.lang.model.element.Modifier;
import org.babyfish.jimmer.apt.GeneratorException;
import org.babyfish.jimmer.apt.TypeUtils;
import org.babyfish.jimmer.apt.generator.Constants;
import org.babyfish.jimmer.apt.generator.PropsGenerator;
import org.babyfish.jimmer.apt.meta.ImmutableProp;
import org.babyfish.jimmer.apt.meta.ImmutableType;

public class TableGenerator {
    private TypeUtils typeUtils;
    private ImmutableType type;
    private boolean isTableEx;
    private Filer filer;
    private TypeSpec.Builder typeBuilder;

    public TableGenerator(TypeUtils typeUtils, ImmutableType type, boolean isTableEx, Filer filer) {
        this.typeUtils = typeUtils;
        this.type = type;
        this.isTableEx = isTableEx;
        this.filer = filer;
    }

    public void generate() {
        try {
            JavaFile.builder((String)this.type.getPackageName(), (TypeSpec)this.generateTable()).indent("    ").build().writeTo(this.filer);
        }
        catch (IOException ex) {
            throw new GeneratorException(String.format("Cannot generate " + (this.isTableEx ? "tableEx" : "table") + "class for '%s'", this.type.getName()), ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TypeSpec generateTable() {
        TypeSpec.Builder oldTypeBuilder = this.typeBuilder;
        this.typeBuilder = TypeSpec.classBuilder((String)(this.isTableEx ? this.type.getTableExClassName().simpleName() : this.type.getTableClassName().simpleName())).addModifiers(new Modifier[]{Modifier.PUBLIC});
        if (!this.isTableEx) {
            this.typeBuilder.addSuperinterface((TypeName)this.type.getPropsClassName());
        }
        if (this.isTableEx) {
            this.typeBuilder.superclass((TypeName)this.type.getTableClassName());
            this.typeBuilder.addSuperinterface((TypeName)ParameterizedTypeName.get((ClassName)Constants.TABLE_EX_CLASS_NAME, (TypeName[])new TypeName[]{this.type.getClassName()}));
        } else {
            this.typeBuilder.superclass((TypeName)ParameterizedTypeName.get((ClassName)Constants.ABSTRACT_TABLE_WRAPPER_CLASS_NAME, (TypeName[])new TypeName[]{this.type.getClassName()}));
        }
        this.addDefaultConstructor();
        this.addParameterizedConstructor();
        try {
            for (ImmutableProp prop : this.type.getProps().values()) {
                if (prop.isList() != this.isTableEx) continue;
                this.addProperty(prop, false);
                this.addProperty(prop, true);
            }
            this.addAsTableEx();
            TypeSpec typeSpec = this.typeBuilder.build();
            return typeSpec;
        }
        finally {
            this.typeBuilder = oldTypeBuilder;
        }
    }

    private void addDefaultConstructor() {
        MethodSpec.Builder builder = MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC}).addComment("For fluent-API", new Object[0]).addStatement("super(null)", new Object[0]);
        this.typeBuilder.addMethod(builder.build());
    }

    private void addParameterizedConstructor() {
        MethodSpec.Builder builder = MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC});
        ParameterizedTypeName tableTypeName = this.isTableEx ? ParameterizedTypeName.get((ClassName)Constants.TABLE_EX_CLASS_NAME, (TypeName[])new TypeName[]{this.type.getClassName()}) : ParameterizedTypeName.get((ClassName)Constants.TABLE_CLASS_NAME, (TypeName[])new TypeName[]{this.type.getClassName()});
        builder.addParameter((TypeName)tableTypeName, "table", new Modifier[0]).addStatement("super(table)", new Object[0]);
        this.typeBuilder.addMethod(builder.build());
    }

    private void addProperty(ImmutableProp prop, boolean withJoinType) {
        MethodSpec method = PropsGenerator.property(this.typeUtils, this.isTableEx, prop, withJoinType, true);
        if (method != null) {
            this.typeBuilder.addMethod(method);
        }
    }

    private void addAsTableEx() {
        if (this.isTableEx) {
            return;
        }
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)"asTableEx").addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Override.class).returns((TypeName)this.type.getTableExClassName()).addStatement("return ($T)super.asTableEx()", new Object[]{this.type.getTableExClassName()});
        this.typeBuilder.addMethod(builder.build());
    }
}

