/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.apt.generator;

import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.io.IOException;
import javax.annotation.processing.Filer;
import javax.lang.model.element.Modifier;
import org.babyfish.jimmer.apt.GeneratorException;
import org.babyfish.jimmer.apt.TypeUtils;
import org.babyfish.jimmer.apt.generator.Constants;
import org.babyfish.jimmer.apt.generator.Strings;
import org.babyfish.jimmer.apt.meta.ImmutableProp;
import org.babyfish.jimmer.apt.meta.ImmutableType;
import org.babyfish.jimmer.sql.JoinType;

public class PropsGenerator {
    private final TypeUtils typeUtils;
    private final ImmutableType type;
    private final Filer filer;
    private TypeSpec.Builder typeBuilder;

    public PropsGenerator(TypeUtils typeUtils, ImmutableType type, Filer filer) {
        this.typeUtils = typeUtils;
        this.type = type;
        this.filer = filer;
    }

    public void generate() {
        try {
            JavaFile.builder((String)this.type.getPackageName(), (TypeSpec)this.generateImpl()).indent("    ").build().writeTo(this.filer);
        }
        catch (IOException ex) {
            throw new GeneratorException(String.format("Cannot generate props class for '%s'", this.type.getName()), ex);
        }
    }

    private TypeSpec generateImpl() {
        this.typeBuilder = TypeSpec.interfaceBuilder((String)(this.type.getName() + "Props")).addModifiers(new Modifier[]{Modifier.PUBLIC});
        if (this.type.isEntity() || this.type.isMappedSuperClass()) {
            this.typeBuilder.addAnnotation(AnnotationSpec.builder((ClassName)Constants.PROPS_FOR_CLASS_NAME).addMember("value", "$T.class", new Object[]{this.type.getClassName()}).build());
        }
        if (this.type.getSuperType() != null) {
            this.typeBuilder.addSuperinterface((TypeName)this.type.getSuperType().getPropsClassName());
        } else if (this.type.isEntity() || this.type.isMappedSuperClass()) {
            this.typeBuilder.addSuperinterface((TypeName)Constants.PROPS_CLASS_NAME);
        }
        try {
            for (ImmutableProp prop : this.type.getDeclaredProps().values()) {
                this.addStaticProp(prop);
            }
            if (this.type.isEntity() || this.type.isMappedSuperClass()) {
                for (ImmutableProp prop : this.type.getDeclaredProps().values()) {
                    if (prop.isList()) continue;
                    this.addProp(prop, false);
                    this.addProp(prop, true);
                }
            }
            TypeSpec typeSpec = this.typeBuilder.build();
            return typeSpec;
        }
        finally {
            this.typeBuilder = null;
        }
    }

    private void addStaticProp(ImmutableProp prop) {
        String action;
        ClassName rawClassName;
        if (prop.isList()) {
            rawClassName = prop.isAssociation() ? Constants.REFERENCE_LIST_CLASS_NAME : Constants.SCALAR_LIST_CLASS_NAME;
            action = prop.isAssociation() ? "referenceList" : "scalarList";
        } else {
            rawClassName = prop.isAssociation() ? Constants.REFERENCE_CLASS_NAME : Constants.SCALAR_CLASS_NAME;
            action = prop.isAssociation() ? "reference" : "scalar";
        }
        FieldSpec.Builder builder = FieldSpec.builder((TypeName)ParameterizedTypeName.get((ClassName)rawClassName, (TypeName[])new TypeName[]{this.type.getClassName(), prop.getElementTypeName().box()}), (String)Strings.upper(prop.getName()), (Modifier[])new Modifier[]{Modifier.PUBLIC, Modifier.STATIC, Modifier.FINAL}).initializer("\n    $T.$L($T.get($T.class).getProp($L))", new Object[]{Constants.TYPED_PROP_CLASS_NAME, action, Constants.RUNTIME_TYPE_CLASS_NAME, this.type.getClassName(), Integer.toString(prop.getId())});
        this.typeBuilder.addField(builder.build());
    }

    private void addProp(ImmutableProp prop, boolean withJoinType) {
        MethodSpec method = PropsGenerator.property(this.typeUtils, false, prop, withJoinType, false);
        if (method != null) {
            this.typeBuilder.addMethod(method);
        }
    }

    static MethodSpec property(TypeUtils typeUtils, boolean isTableEx, ImmutableProp prop, boolean withJoinType, boolean withImplementation) {
        if (prop.isTransient()) {
            return null;
        }
        if (withJoinType && !prop.isAssociation()) {
            return null;
        }
        Object returnType = prop.isAssociation() ? (isTableEx ? typeUtils.getImmutableType(prop.getElementType()).getTableExClassName() : typeUtils.getImmutableType(prop.getElementType()).getTableClassName()) : (prop.getTypeName().isPrimitive() && !prop.getTypeName().equals((Object)TypeName.BOOLEAN) ? ParameterizedTypeName.get((ClassName)Constants.PROP_NUMERIC_EXPRESSION_CLASS_NAME, (TypeName[])new TypeName[]{prop.getTypeName().box()}) : (typeUtils.isString(prop.getReturnType()) ? Constants.PROP_STRING_EXPRESSION_CLASS_NAME : (typeUtils.isNumber(prop.getReturnType()) ? ParameterizedTypeName.get((ClassName)Constants.PROP_NUMERIC_EXPRESSION_CLASS_NAME, (TypeName[])new TypeName[]{prop.getTypeName().box()}) : (typeUtils.isComparable(prop.getReturnType()) ? ParameterizedTypeName.get((ClassName)Constants.PROP_COMPARABLE_EXPRESSION_CLASS_NAME, (TypeName[])new TypeName[]{prop.getTypeName().box()}) : ParameterizedTypeName.get((ClassName)Constants.PROP_EXPRESSION_CLASS_NAME, (TypeName[])new TypeName[]{prop.getTypeName().box()})))));
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)prop.getName()).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)returnType);
        if (withImplementation) {
            if (!isTableEx) {
                builder.addAnnotation(Override.class);
            }
        } else {
            builder.addModifiers(new Modifier[]{Modifier.ABSTRACT});
        }
        if (withJoinType) {
            builder.addParameter(JoinType.class, "joinType", new Modifier[0]);
        }
        if (withImplementation) {
            if (prop.isAssociation()) {
                if (withJoinType) {
                    builder.addStatement("return join($S, joinType)", new Object[]{prop.getName()});
                } else {
                    builder.addStatement("return join($S)", new Object[]{prop.getName()});
                }
            } else {
                builder.addStatement("return get($S)", new Object[]{prop.getName()});
            }
        }
        return builder.build();
    }
}

