/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.apt.meta;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Null;
import org.babyfish.jimmer.Immutable;
import org.babyfish.jimmer.apt.TypeUtils;
import org.babyfish.jimmer.apt.meta.MetaException;
import org.babyfish.jimmer.apt.meta.ValidationMessages;
import org.babyfish.jimmer.sql.Column;
import org.babyfish.jimmer.sql.Entity;
import org.babyfish.jimmer.sql.Id;
import org.babyfish.jimmer.sql.JoinColumn;
import org.babyfish.jimmer.sql.JoinTable;
import org.babyfish.jimmer.sql.Key;
import org.babyfish.jimmer.sql.ManyToMany;
import org.babyfish.jimmer.sql.ManyToOne;
import org.babyfish.jimmer.sql.MappedSuperclass;
import org.babyfish.jimmer.sql.OneToMany;
import org.babyfish.jimmer.sql.OneToOne;
import org.babyfish.jimmer.sql.Transient;
import org.babyfish.jimmer.sql.Version;
import org.jetbrains.annotations.Nullable;
import org.springframework.lang.NonNull;

public class ImmutableProp {
    private final TypeElement declaringElement;
    private final ExecutableElement executableElement;
    private final String name;
    private final int id;
    private final String getterName;
    private final String setterName;
    private final String adderByName;
    private final String loadedStateName;
    private final TypeMirror returnType;
    private final TypeName typeName;
    private final TypeName draftTypeName;
    private final TypeName elementTypeName;
    private final TypeName draftElementTypeName;
    private final TypeMirror elementType;
    private final boolean isTransient;
    private final boolean isList;
    private final boolean isAssociation;
    private final boolean isNullable;
    private Annotation associationAnnotation;
    private final Map<ClassName, String> validationMessageMap;

    public ImmutableProp(TypeUtils typeUtils, ExecutableElement executableElement, int id) {
        this.id = id;
        this.declaringElement = (TypeElement)executableElement.getEnclosingElement();
        this.executableElement = executableElement;
        this.getterName = executableElement.getSimpleName().toString();
        this.returnType = executableElement.getReturnType();
        if (this.returnType.getKind() == TypeKind.VOID) {
            throw new MetaException(String.format("'%s' cannot return void", executableElement));
        }
        if (!executableElement.getParameters().isEmpty()) {
            throw new MetaException(String.format("'%s' cannot have parameters", executableElement));
        }
        if (this.getterName.startsWith("is") && this.getterName.length() > 2 && Character.isUpperCase(this.getterName.charAt(2))) {
            this.name = this.getterName.substring(2, 3).toLowerCase() + this.getterName.substring(3);
            this.setterName = "set" + this.getterName.substring(2);
            this.adderByName = "addInto" + this.getterName.substring(2);
        } else if (this.getterName.startsWith("get") && this.getterName.length() > 3 && Character.isUpperCase(this.getterName.charAt(3))) {
            this.name = this.getterName.substring(3, 4).toLowerCase() + this.getterName.substring(4);
            this.setterName = "set" + this.getterName.substring(3);
            this.adderByName = "addInto" + this.getterName.substring(3);
        } else {
            this.name = this.getterName;
            this.setterName = "set" + this.getterName.substring(0, 1).toUpperCase() + this.getterName.substring(1);
            this.adderByName = "addInto" + this.getterName.substring(0, 1).toUpperCase() + this.getterName.substring(1);
        }
        this.loadedStateName = this.name + "Loaded";
        if (typeUtils.isCollection(this.returnType)) {
            if (!typeUtils.isListStrictly(this.returnType)) {
                throw new MetaException(String.format("The collection property '%s' must return 'java.util.List'", executableElement));
            }
            List<? extends TypeMirror> typeArguments = ((DeclaredType)this.returnType).getTypeArguments();
            if (typeArguments.isEmpty()) {
                throw new MetaException(String.format("The return type of '%s' misses generic type", executableElement));
            }
            this.isList = true;
            this.elementType = typeArguments.get(0);
        } else {
            this.isList = false;
            this.elementType = this.returnType;
        }
        if (typeUtils.isMappedSuperclass(this.elementType)) {
            throw new MetaException("Illegal property \"" + this + "\", the target type \"" + TypeName.get((TypeMirror)this.elementType) + "\" is illegal, it cannot be type decorated by @MappedSuperclass");
        }
        this.isTransient = executableElement.getAnnotation(Transient.class) != null;
        this.isAssociation = typeUtils.isImmutable(this.elementType);
        if (this.declaringElement.getAnnotation(Entity.class) != null && (this.isAssociation || this.isList) && !typeUtils.isEntity(this.elementType) && executableElement.getAnnotation(Transient.class) == null) {
            throw new MetaException("Illegal property \"" + this + "\", association property of entity interface must reference to entity type or decorated by @Transient");
        }
        this.initializeAssociationAnnotation();
        this.elementTypeName = TypeName.get((TypeMirror)this.elementType);
        this.typeName = this.isList ? ParameterizedTypeName.get((ClassName)ClassName.get(List.class), (TypeName[])new TypeName[]{this.elementTypeName}) : this.elementTypeName;
        this.draftElementTypeName = this.isAssociation ? ClassName.get((String)((ClassName)this.elementTypeName).packageName(), (String)(((ClassName)this.elementTypeName).simpleName() + "Draft"), (String[])new String[0]) : this.elementTypeName;
        this.draftTypeName = this.isList ? ParameterizedTypeName.get((ClassName)ClassName.get(List.class), (TypeName[])new TypeName[]{this.draftElementTypeName}) : this.draftElementTypeName;
        this.isNullable = this.determineNullable();
        this.validationMessageMap = ValidationMessages.parseMessageMap(executableElement);
    }

    public int getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getGetterName() {
        return this.getterName;
    }

    public String getSetterName() {
        return this.setterName;
    }

    public String getAdderByName() {
        return this.adderByName;
    }

    public String getLoadedStateName() {
        if (!this.isLoadedStateRequired()) {
            throw new IllegalStateException("The property \"" + this + "\" does not has loaded state");
        }
        return this.loadedStateName;
    }

    public TypeMirror getReturnType() {
        return this.returnType;
    }

    public TypeMirror getElementType() {
        return this.elementType;
    }

    public TypeName getTypeName() {
        return this.typeName;
    }

    public TypeName getDraftTypeName(boolean autoCreate) {
        if (this.isList && !autoCreate) {
            return this.typeName;
        }
        return this.draftTypeName;
    }

    public TypeName getElementTypeName() {
        return this.elementTypeName;
    }

    public TypeName getDraftElementTypeName() {
        return this.draftElementTypeName;
    }

    public boolean isTransient() {
        return this.isTransient;
    }

    public boolean isList() {
        return this.isList;
    }

    public boolean isAssociation() {
        return this.isAssociation;
    }

    public boolean isNullable() {
        return this.isNullable;
    }

    public boolean isLoadedStateRequired() {
        return this.isNullable || this.typeName.isPrimitive();
    }

    public Class<?> getBoxType() {
        switch (this.returnType.getKind()) {
            case BOOLEAN: {
                return Boolean.class;
            }
            case CHAR: {
                return Character.class;
            }
            case BYTE: {
                return Byte.class;
            }
            case SHORT: {
                return Short.class;
            }
            case INT: {
                return Integer.class;
            }
            case LONG: {
                return Long.class;
            }
            case FLOAT: {
                return Float.class;
            }
            case DOUBLE: {
                return Double.class;
            }
        }
        return null;
    }

    public <A extends Annotation> A getAnnotation(Class<A> annotationType) {
        return this.executableElement.getAnnotation(annotationType);
    }

    public <A extends Annotation> A[] getAnnotations(Class<A> annotationType) {
        return this.executableElement.getAnnotationsByType(annotationType);
    }

    public Annotation getAssociationAnnotation() {
        return this.associationAnnotation;
    }

    public String toString() {
        return this.declaringElement.getQualifiedName().toString() + '.' + this.name;
    }

    private void initializeAssociationAnnotation() {
        Annotation firstSqlAnnotation;
        Transient trans = this.getAnnotation(Transient.class);
        JoinColumn joinColumn = this.getAnnotation(JoinColumn.class);
        JoinTable joinTable = this.getAnnotation(JoinTable.class);
        Column column = this.getAnnotation(Column.class);
        Annotation[] storageAnnotations = (Annotation[])Arrays.stream(new Annotation[]{joinColumn, joinTable, column}).filter(Objects::nonNull).toArray(Annotation[]::new);
        Id id = this.getAnnotation(Id.class);
        Version version = this.getAnnotation(Version.class);
        Key key = this.getAnnotation(Key.class);
        Annotation[] scalarAnnotations = (Annotation[])Arrays.stream(new Annotation[]{id, version}).filter(Objects::nonNull).toArray(Annotation[]::new);
        OneToOne oneToOne = this.getAnnotation(OneToOne.class);
        OneToMany oneToMany = this.getAnnotation(OneToMany.class);
        ManyToOne manyToOne = this.getAnnotation(ManyToOne.class);
        ManyToMany manyToMany = this.getAnnotation(ManyToMany.class);
        Annotation[] associationAnnotations = (Annotation[])Arrays.stream(new Annotation[]{oneToOne, oneToMany, manyToOne, manyToMany}).filter(Objects::nonNull).toArray(Annotation[]::new);
        Annotation annotation = firstSqlAnnotation = storageAnnotations.length != 0 ? storageAnnotations[0] : null;
        if (firstSqlAnnotation == null) {
            Annotation annotation2 = firstSqlAnnotation = scalarAnnotations.length != 0 ? scalarAnnotations[0] : null;
            if (firstSqlAnnotation == null && associationAnnotations.length != 0) {
                firstSqlAnnotation = associationAnnotations[0];
            }
        }
        if (trans != null) {
            if (firstSqlAnnotation != null) {
                throw new MetaException("Illegal property \"" + this + "\", it is decorated by both @" + Transient.class.getName() + " and @" + firstSqlAnnotation.annotationType().getName());
            }
            return;
        }
        if (this.declaringElement.getAnnotation(Entity.class) == null && this.declaringElement.getAnnotation(MappedSuperclass.class) == null) {
            if (firstSqlAnnotation != null) {
                throw new MetaException("Illegal property \"" + this + "\", it cannot be decorated by @" + firstSqlAnnotation.annotationType().getName() + "because the current type is not entity");
            }
        } else {
            if (this.isAssociation) {
                if (associationAnnotations.length == 0) {
                    throw new MetaException("Illegal property \"" + this + "\", association property must be decorated by one of these annotations: @OneToOne, @OneToMany, @ManyToOne or @ManyToMany");
                }
                if (associationAnnotations.length > 1) {
                    throw new MetaException("Illegal property \"" + this + "\", it cannot be decorated by both @" + associationAnnotations[0].annotationType().getName() + "and @" + associationAnnotations[1].annotationType().getName());
                }
                this.associationAnnotation = associationAnnotations[0];
                if (this.isList && (this.associationAnnotation instanceof OneToOne || this.associationAnnotation instanceof ManyToOne)) {
                    throw new MetaException("Illegal property \"" + this + "\", list property cannot be decorated by both @" + this.associationAnnotation.annotationType().getName());
                }
                if (!this.isList && (this.associationAnnotation instanceof OneToMany || this.associationAnnotation instanceof ManyToMany)) {
                    throw new MetaException("Illegal property \"" + this + "\", reference property cannot be decorated by both @" + this.associationAnnotation.annotationType().getName());
                }
                if (oneToOne != null && oneToOne.mappedBy().equals("")) {
                    throw new MetaException("Illegal property \"" + this + "\", The \"mappedBy\" of one-to-one property must be specified");
                }
                if (oneToMany != null && oneToMany.mappedBy().equals("")) {
                    throw new MetaException("Illegal property \"" + this + "\", The \"mappedBy\" of one-to-many property must be specified");
                }
                if ((oneToOne != null || oneToMany != null || manyToMany != null && !manyToMany.mappedBy().equals("")) && joinColumn != null) {
                    throw new MetaException("Illegal property \"" + this + "\", it cannot be decorated by @" + JoinColumn.class.getName());
                }
                if (column != null) {
                    throw new MetaException("Illegal property \"" + this + "\", association property cannot be decorated by @" + column.annotationType().getName());
                }
                if (joinColumn != null && joinTable != null) {
                    throw new MetaException("Illegal property \"" + this + "\", it is decorated by both @JoinColumn and @JoinTable");
                }
                if (scalarAnnotations.length != 0) {
                    throw new MetaException("Illegal property \"" + this + "\", association property cannot be decorated by @" + scalarAnnotations[0].annotationType().getName());
                }
            } else {
                if (associationAnnotations.length != 0) {
                    throw new MetaException("Illegal property \"" + this + "\", scalar property cannot be decorated by @" + associationAnnotations[0].annotationType().getName());
                }
                if (joinColumn != null) {
                    throw new MetaException("Illegal property \"" + this + "\", scalar property cannot be decorated by @" + JoinColumn.class.getName());
                }
                if (joinTable != null) {
                    throw new MetaException("Illegal property \"" + this + "\", scalar property cannot be decorated by @" + JoinTable.class.getName());
                }
                if (scalarAnnotations.length > 1) {
                    throw new MetaException("Illegal property \"" + this + "\", it is decorated by both @" + storageAnnotations[0].annotationType().getName() + " @" + storageAnnotations[1].annotationType().getName());
                }
                if (scalarAnnotations.length != 0 && this.isNullable) {
                    throw new MetaException("Illegal property \"" + this + "\", nullable property cannot be decorated by @" + scalarAnnotations[0].annotationType().getName());
                }
                if (version != null && this.returnType.getKind() != TypeKind.INT) {
                    throw new MetaException("Illegal property \"" + this + "\", it is decorated by @" + Version.class.getName() + " but its type is not int");
                }
            }
            if (key != null) {
                if (scalarAnnotations.length != 0) {
                    throw new MetaException("Illegal property \"" + this + "\", it decorated by both \"@" + Key.class.getName() + "\" and \"@" + scalarAnnotations[0].annotationType().getName() + "\"");
                }
                if (this.associationAnnotation != null) {
                    if (this.associationAnnotation.annotationType() != ManyToOne.class) {
                        throw new MetaException("Illegal property \"" + this + "\", association property decorated by both \"@" + Key.class.getName() + "\" must be many-to-one association");
                    }
                    if (joinTable != null) {
                        throw new MetaException("Illegal property \"" + this + "\", many-to-one property decorated by both \"@" + Key.class.getName() + "\" must base on foreign key");
                    }
                }
            }
        }
    }

    private boolean determineNullable() {
        Annotation nullAnnotation;
        Annotation notNullAnnotation = Arrays.stream((NotNull[])this.getAnnotations(NotNull.class)).findFirst().orElse(null);
        if (notNullAnnotation == null) {
            notNullAnnotation = this.getAnnotation(NonNull.class);
        }
        if (notNullAnnotation == null) {
            notNullAnnotation = this.getAnnotation(org.jetbrains.annotations.NotNull.class);
        }
        if (notNullAnnotation == null) {
            notNullAnnotation = this.getAnnotation(Id.class);
        }
        if ((nullAnnotation = (Annotation)Arrays.stream((Null[])this.getAnnotations(Null.class)).findFirst().orElse(null)) == null) {
            nullAnnotation = this.getAnnotation(org.springframework.lang.Nullable.class);
        }
        if (nullAnnotation == null) {
            nullAnnotation = this.getAnnotation(Nullable.class);
        }
        if (notNullAnnotation != null && nullAnnotation != null) {
            throw new MetaException("Illegal property \"" + this + "\", its nullity is conflict because it is decorated by both " + notNullAnnotation + " and " + nullAnnotation);
        }
        ImplicitNullable implicitNullable = this.getImplicitNullable();
        if (notNullAnnotation != null) {
            if (implicitNullable != null && implicitNullable.nullable) {
                throw new MetaException("Illegal property \"" + this + "\", it is decorated by " + notNullAnnotation + ", but it is considered as nullable because " + implicitNullable.reason);
            }
            return false;
        }
        if (nullAnnotation != null) {
            if (implicitNullable != null && !implicitNullable.nullable) {
                throw new MetaException("Illegal property \"" + this + "\", it is decorated by " + nullAnnotation + ", but it is considered as non-null because " + implicitNullable.reason);
            }
            return true;
        }
        if (implicitNullable != null) {
            return implicitNullable.nullable;
        }
        Immutable immutable = this.declaringElement.getAnnotation(Immutable.class);
        return immutable != null && immutable.value() == Immutable.Nullity.NULLABLE;
    }

    private ImplicitNullable getImplicitNullable() {
        if (this.isList) {
            return new ImplicitNullable(false, "it is list");
        }
        if (this.isAssociation) {
            if (this.getAnnotation(JoinTable.class) != null) {
                return new ImplicitNullable(true, "it's a many-to-one association base on middle table");
            }
            if (this.getAnnotation(OneToOne.class) != null) {
                return new ImplicitNullable(true, "it's a one-to-one association");
            }
        }
        if (this.typeName.isPrimitive()) {
            return new ImplicitNullable(false, "its type is primitive");
        }
        if (this.typeName.isBoxedPrimitive()) {
            return new ImplicitNullable(true, "its type is box type");
        }
        return null;
    }

    public Map<ClassName, String> getValidationMessageMap() {
        return this.validationMessageMap;
    }

    private static class ImplicitNullable {
        final boolean nullable;
        final String reason;

        ImplicitNullable(boolean nullable, String reason) {
            this.nullable = nullable;
            this.reason = reason;
        }

        public String toString() {
            return "ImplicitNullable{nullable=" + this.nullable + ", reason='" + this.reason + '\'' + '}';
        }
    }
}

