/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.apt.generator;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.util.Objects;
import javax.lang.model.element.Modifier;
import javax.lang.model.type.PrimitiveType;
import javax.lang.model.type.TypeMirror;
import org.babyfish.jimmer.UnloadedException;
import org.babyfish.jimmer.apt.meta.ImmutableProp;
import org.babyfish.jimmer.apt.meta.ImmutableType;
import org.babyfish.jimmer.runtime.NonSharedList;
import org.babyfish.jimmer.sql.Id;

public class ImplGenerator {
    private final ImmutableType type;
    private final ClassName unloadedExceptionClassName;
    private TypeSpec.Builder typeBuilder;

    public ImplGenerator(ImmutableType type) {
        this.type = type;
        this.unloadedExceptionClassName = ClassName.get(UnloadedException.class);
    }

    public void generate(TypeSpec.Builder parentBuilder) {
        this.typeBuilder = TypeSpec.classBuilder((String)"Impl").addModifiers(new Modifier[]{Modifier.PRIVATE, Modifier.STATIC}).superclass((TypeName)this.type.getImplementorClassName());
        this.addFields();
        this.addConstructor();
        for (ImmutableProp prop : this.type.getProps().values()) {
            this.addGetter(prop);
        }
        this.addIsLoaded(Integer.TYPE);
        this.addIsLoaded(String.class);
        this.addHashCode(false);
        this.addHashCode(true);
        this.addParameterizedHashCode();
        this.addEquals(false);
        this.addEquals(true);
        this.addParameterizedEquals();
        parentBuilder.addType(this.typeBuilder.build());
    }

    private void addFields() {
        for (ImmutableProp prop : this.type.getProps().values()) {
            FieldSpec.Builder valueBuilder = FieldSpec.builder((TypeName)(prop.isList() ? ParameterizedTypeName.get((ClassName)ClassName.get(NonSharedList.class), (TypeName[])new TypeName[]{prop.getElementTypeName()}) : TypeName.get((TypeMirror)prop.getReturnType())), (String)prop.getName(), (Modifier[])new Modifier[0]);
            this.typeBuilder.addField(valueBuilder.build());
            if (!prop.isLoadedStateRequired()) continue;
            FieldSpec.Builder stateBuilder = FieldSpec.builder(Boolean.TYPE, (String)prop.getLoadedStateName(), (Modifier[])new Modifier[0]);
            this.typeBuilder.addField(stateBuilder.build());
        }
    }

    private void addConstructor() {
        MethodSpec.Builder builder = MethodSpec.constructorBuilder();
        builder.addParameter((TypeName)this.type.getClassName(), "base", new Modifier[0]);
        builder.beginControlFlow("if (base != null)", new Object[0]);
        builder.addStatement("Implementor from = (Implementor)base", new Object[0]);
        for (ImmutableProp prop : this.type.getProps().values()) {
            if (prop.isLoadedStateRequired()) {
                builder.addStatement("$L = from.__isLoaded($L)", new Object[]{prop.getLoadedStateName(), prop.getId()});
                builder.beginControlFlow("if ($L)", new Object[]{prop.getLoadedStateName()});
            } else {
                builder.beginControlFlow("if (from.__isLoaded($L))", new Object[]{prop.getId()});
            }
            if (prop.isList()) {
                builder.addStatement("$L = $T.of(null, from.$L())", new Object[]{prop.getName(), NonSharedList.class, prop.getGetterName()});
            } else {
                builder.addStatement("$L = from.$L()", new Object[]{prop.getName(), prop.getGetterName()});
            }
            builder.endControlFlow();
        }
        builder.endControlFlow();
        this.typeBuilder.addMethod(builder.build());
    }

    private void addGetter(ImmutableProp prop) {
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)prop.getGetterName()).addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Override.class).returns(TypeName.get((TypeMirror)prop.getReturnType()));
        if (prop.isLoadedStateRequired()) {
            builder.beginControlFlow("if (!$L)", new Object[]{prop.getLoadedStateName()});
        } else {
            builder.beginControlFlow("if ($L == null)", new Object[]{prop.getName()});
        }
        builder.addStatement("throw new $T($T.class, $S)", new Object[]{this.unloadedExceptionClassName, this.type.getClassName(), prop.getName()}).endControlFlow().addStatement("return $L", new Object[]{prop.getName()});
        this.typeBuilder.addMethod(builder.build());
    }

    private void addIsLoaded(Class<?> argType) {
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)"__isLoaded").addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Override.class).addParameter(argType, "prop", new Modifier[0]).returns(Boolean.TYPE);
        builder.beginControlFlow("switch (prop)", new Object[0]);
        for (ImmutableProp prop : this.type.getProps().values()) {
            Integer arg;
            Integer n = arg = argType == Integer.TYPE ? Integer.valueOf(prop.getId()) : '\"' + prop.getName() + '\"';
            if (prop.isLoadedStateRequired()) {
                builder.addStatement("case $L: return $L", new Object[]{arg, prop.getLoadedStateName()});
                continue;
            }
            builder.addStatement("case $L: return $L != null", new Object[]{arg, prop.getName()});
        }
        builder.addStatement("default: throw new IllegalArgumentException($S + prop + $S)", new Object[]{"Illegal property " + (argType == Integer.TYPE ? "id" : "name") + ": \"", "\""});
        builder.endControlFlow();
        this.typeBuilder.addMethod(builder.build());
    }

    private void addHashCode(boolean shallow) {
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)(shallow ? "__shallowHashCode" : "hashCode")).addModifiers(new Modifier[]{shallow ? Modifier.PRIVATE : Modifier.PUBLIC}).returns(Integer.TYPE).addStatement("int hash = 1", new Object[0]);
        if (!shallow) {
            builder.addAnnotation(Override.class);
        }
        for (ImmutableProp prop : this.type.getProps().values()) {
            Class<?> boxType = prop.getBoxType();
            if (boxType != null) {
                builder.beginControlFlow("if ($L)", new Object[]{prop.getLoadedStateName()});
                builder.addStatement("hash = 31 * hash + $T.hashCode($L)", new Object[]{boxType, prop.getName()});
                if (!shallow && prop.getAnnotation(Id.class) != null) {
                    builder.addComment("If entity-id is loaded, return directly", new Object[0]);
                    builder.addStatement("return hash", new Object[0]);
                }
                builder.endControlFlow();
                continue;
            }
            if (shallow) {
                if (prop.isLoadedStateRequired()) {
                    builder.beginControlFlow("if ($L)", new Object[]{prop.getLoadedStateName()});
                } else {
                    builder.beginControlFlow("if ($L != null)", new Object[]{prop.getName()});
                }
                builder.addStatement("hash = 31 * hash + $T.identityHashCode($L)", new Object[]{System.class, prop.getName()});
                builder.endControlFlow();
                continue;
            }
            if (prop.isLoadedStateRequired()) {
                builder.beginControlFlow("if ($L && $L != null)", new Object[]{prop.getLoadedStateName(), prop.getName()});
            } else {
                builder.beginControlFlow("if ($L != null)", new Object[]{prop.getName()});
            }
            builder.addStatement("hash = 31 * hash + $L.hashCode()", new Object[]{prop.getName()});
            if (prop.getAnnotation(Id.class) != null) {
                builder.addComment("If entity-id is loaded, return directly", new Object[0]);
                builder.addStatement("return hash", new Object[0]);
            }
            builder.endControlFlow();
        }
        builder.addStatement("return hash", new Object[0]);
        this.typeBuilder.addMethod(builder.build());
    }

    private void addEquals(boolean shallow) {
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)(shallow ? "__shallowEquals" : "equals")).addModifiers(new Modifier[]{shallow ? Modifier.PRIVATE : Modifier.PUBLIC}).addParameter(Object.class, "obj", new Modifier[0]).returns(Boolean.TYPE);
        if (!shallow) {
            builder.addAnnotation(Override.class);
        }
        builder.beginControlFlow("if (obj == null || getClass() != obj.getClass())", new Object[0]).addStatement("return false", new Object[0]).endControlFlow().addStatement("Implementor other = (Implementor)obj", new Object[0]);
        for (ImmutableProp prop : this.type.getProps().values()) {
            if (prop.isLoadedStateRequired()) {
                builder.addStatement("boolean __$LLoaded = $L", new Object[]{prop.getName(), prop.getLoadedStateName()});
            } else {
                builder.addStatement("boolean __$LLoaded = $L != null", new Object[]{prop.getName(), prop.getName()});
            }
            builder.beginControlFlow("if (__$LLoaded != other.__isLoaded($L))", new Object[]{prop.getName(), prop.getId()}).addStatement("return false", new Object[0]).endControlFlow();
            if (shallow || prop.getReturnType() instanceof PrimitiveType) {
                if (!shallow && prop.getAnnotation(Id.class) != null) {
                    builder.beginControlFlow("if (__$LLoaded)", new Object[]{prop.getName()}).addComment("If entity-id is loaded, return directly", new Object[0]).addStatement("return $L == other.$L()", new Object[]{prop.getName(), prop.getGetterName()}).endControlFlow();
                    continue;
                }
                builder.beginControlFlow("if (__$LLoaded && $L != other.$L())", new Object[]{prop.getName(), prop.getName(), prop.getGetterName()}).addStatement("return false", new Object[0]).endControlFlow();
                continue;
            }
            if (prop.getAnnotation(Id.class) != null) {
                builder.beginControlFlow("if (__$LLoaded)", new Object[]{prop.getName()}).addComment("If entity-id is loaded, return directly", new Object[0]).addStatement("return $T.equals($L, other.$L())", new Object[]{Objects.class, prop.getName(), prop.getGetterName()}).endControlFlow();
                continue;
            }
            builder.beginControlFlow("if (__$LLoaded && !$T.equals($L, other.$L()))", new Object[]{prop.getName(), Objects.class, prop.getName(), prop.getGetterName()}).addStatement("return false", new Object[0]).endControlFlow();
        }
        builder.addStatement("return true", new Object[0]);
        this.typeBuilder.addMethod(builder.build());
    }

    private void addParameterizedHashCode() {
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)"__hashCode").addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Override.class).addParameter(Boolean.TYPE, "shallow", new Modifier[0]).returns(Integer.TYPE).addCode("return shallow ? __shallowHashCode() : hashCode();", new Object[0]);
        this.typeBuilder.addMethod(builder.build());
    }

    private void addParameterizedEquals() {
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)"__equals").addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Override.class).addParameter(Object.class, "obj", new Modifier[0]).addParameter(Boolean.TYPE, "shallow", new Modifier[0]).returns(Boolean.TYPE).addCode("return shallow ? __shallowEquals(obj) : equals(obj);", new Object[0]);
        this.typeBuilder.addMethod(builder.build());
    }
}

