/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.apt.generator;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.io.IOException;
import javax.annotation.processing.Filer;
import javax.lang.model.element.Modifier;
import org.babyfish.jimmer.apt.GeneratorException;
import org.babyfish.jimmer.apt.TypeUtils;
import org.babyfish.jimmer.apt.generator.Constants;
import org.babyfish.jimmer.apt.generator.Strings;
import org.babyfish.jimmer.apt.meta.ImmutableProp;
import org.babyfish.jimmer.apt.meta.ImmutableType;

public class PropsGenerator {
    private final TypeUtils typeUtils;
    private final ImmutableType type;
    private final Filer filer;
    private TypeSpec.Builder typeBuilder;

    public PropsGenerator(TypeUtils typeUtils, ImmutableType type, Filer filer) {
        this.typeUtils = typeUtils;
        this.type = type;
        this.filer = filer;
    }

    public void generate() {
        try {
            JavaFile.builder((String)this.type.getPackageName(), (TypeSpec)this.generateProps()).indent("    ").build().writeTo(this.filer);
        }
        catch (IOException ex) {
            throw new GeneratorException(String.format("Cannot generate props class for '%s'", this.type.getName()), ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TypeSpec generateProps() {
        TypeSpec.Builder builder;
        this.typeBuilder = builder = TypeSpec.classBuilder((ClassName)this.type.getPropsClassName()).addModifiers(new Modifier[]{Modifier.PUBLIC});
        try {
            this.addConstructor();
            for (ImmutableProp prop : this.type.getProps().values()) {
                this.addProp(prop);
            }
        }
        finally {
            this.typeBuilder = null;
        }
        return builder.build();
    }

    private void addConstructor() {
        this.typeBuilder.addMethod(MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PRIVATE}).build());
    }

    private void addProp(ImmutableProp prop) {
        String action;
        ClassName rawClassName;
        if (prop.isList()) {
            rawClassName = prop.isAssociation() ? Constants.REFERENCE_LIST_CLASS_NAME : Constants.SCALAR_LIST_CLASS_NAME;
            action = prop.isAssociation() ? "referenceList" : "scalarList";
        } else {
            rawClassName = prop.isAssociation() ? Constants.REFERENCE_CLASS_NAME : Constants.SCALAR_CLASS_NAME;
            action = prop.isAssociation() ? "reference" : "scalar";
        }
        FieldSpec.Builder builder = FieldSpec.builder((TypeName)ParameterizedTypeName.get((ClassName)rawClassName, (TypeName[])new TypeName[]{this.type.getClassName(), prop.getElementTypeName().box()}), (String)Strings.upper(prop.getName()), (Modifier[])new Modifier[]{Modifier.PUBLIC, Modifier.STATIC, Modifier.FINAL}).initializer("\n    $T.$L($T.get($T.class).getProp($L))", new Object[]{Constants.TYPED_PROP_CLASS_NAME, action, Constants.RUNTIME_TYPE_CLASS_NAME, this.type.getClassName(), Integer.toString(prop.getId())});
        this.typeBuilder.addField(builder.build());
    }
}

