/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.apt;

import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Filer;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import org.babyfish.jimmer.apt.TypeUtils;
import org.babyfish.jimmer.apt.generator.DraftGenerator;
import org.babyfish.jimmer.apt.generator.FetcherGenerator;
import org.babyfish.jimmer.apt.generator.PropsGenerator;
import org.babyfish.jimmer.apt.generator.TableGenerator;
import org.babyfish.jimmer.apt.meta.ImmutableType;
import org.babyfish.jimmer.apt.meta.MetaException;

@SupportedAnnotationTypes(value={"org.babyfish.jimmer.Immutable", "org.babyfish.jimmer.sql.Entity", "org.babyfish.jimmer.sql.MappedSuperclass"})
@SupportedSourceVersion(value=SourceVersion.RELEASE_8)
public class ImmutableProcessor
extends AbstractProcessor {
    private TypeUtils typeUtils;
    private Filer filer;
    private String[] includes = null;
    private String[] excludes = null;

    @Override
    public synchronized void init(ProcessingEnvironment processingEnv) {
        super.init(processingEnv);
        String includes = processingEnv.getOptions().get("jimmer.source.includes");
        String excludes = processingEnv.getOptions().get("jimmer.source.excludes");
        if (includes != null && !includes.isEmpty()) {
            this.includes = includes.trim().split("\\s*,\\s*");
        }
        if (excludes != null && !excludes.isEmpty()) {
            this.excludes = excludes.trim().split("\\s*,\\s*");
        }
        this.typeUtils = new TypeUtils(processingEnv.getElementUtils(), processingEnv.getTypeUtils());
        this.filer = processingEnv.getFiler();
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        for (Element element : roundEnv.getRootElements()) {
            boolean matched;
            if (!(element instanceof TypeElement)) continue;
            TypeElement typeElement = (TypeElement)element;
            String qualifiedName = typeElement.getQualifiedName().toString();
            if (this.includes != null) {
                matched = false;
                for (String include : this.includes) {
                    if (!qualifiedName.startsWith(include)) continue;
                    matched = true;
                    break;
                }
                if (!matched) continue;
            }
            if (this.excludes != null) {
                matched = false;
                for (String exclude : this.excludes) {
                    if (!qualifiedName.startsWith(exclude)) continue;
                    matched = true;
                    break;
                }
                if (matched) continue;
            }
            if (!this.typeUtils.isImmutable(typeElement)) continue;
            if (typeElement.getKind() != ElementKind.INTERFACE) {
                throw new MetaException("Illegal class \"" + qualifiedName + "\", immutable type must be interface");
            }
            ImmutableType immutableType = this.typeUtils.getImmutableType(typeElement);
            new DraftGenerator(this.typeUtils, immutableType, this.filer).generate();
            new PropsGenerator(this.typeUtils, immutableType, this.filer).generate();
            if (!immutableType.isEntity()) continue;
            new TableGenerator(this.typeUtils, immutableType, false, this.filer).generate();
            new TableGenerator(this.typeUtils, immutableType, true, this.filer).generate();
            new FetcherGenerator(this.typeUtils, immutableType, this.filer).generate();
        }
        return true;
    }
}

