/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.apt.generator;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import javax.lang.model.element.Modifier;
import org.babyfish.jimmer.apt.TypeUtils;
import org.babyfish.jimmer.apt.generator.Constants;
import org.babyfish.jimmer.apt.generator.DraftImplGenerator;
import org.babyfish.jimmer.apt.generator.ImplGenerator;
import org.babyfish.jimmer.apt.generator.ImplementorGenerator;
import org.babyfish.jimmer.apt.meta.ImmutableProp;
import org.babyfish.jimmer.apt.meta.ImmutableType;
import org.babyfish.jimmer.meta.ImmutablePropCategory;
import org.babyfish.jimmer.runtime.Internal;
import org.babyfish.jimmer.sql.Key;

public class ProducerGenerator {
    private TypeUtils typeUtils;
    private ImmutableType type;
    private TypeSpec.Builder typeBuilder;

    ProducerGenerator(TypeUtils typeUtils, ImmutableType type) {
        this.typeUtils = typeUtils;
        this.type = type;
    }

    public void generate(TypeSpec.Builder parentBuilder) {
        this.typeBuilder = TypeSpec.classBuilder((String)"Producer");
        this.typeBuilder.modifiers.add(Modifier.PUBLIC);
        this.typeBuilder.modifiers.add(Modifier.STATIC);
        this.addInstance();
        this.addType();
        this.addConstructor();
        this.addProduce(false);
        this.addProduce(true);
        new ImplementorGenerator(this.type).generate(this.typeBuilder);
        new ImplGenerator(this.type).generate(this.typeBuilder);
        new DraftImplGenerator(this.type).generate(this.typeBuilder);
        parentBuilder.addType(this.typeBuilder.build());
    }

    private void addProduce(Boolean base) {
        ClassName baseType = this.type.getClassName();
        ClassName draftType = this.type.getDraftClassName();
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)"produce");
        builder.modifiers.add(Modifier.PUBLIC);
        if (base.booleanValue()) {
            builder.addParameter((TypeName)baseType, "base", new Modifier[0]);
        }
        builder.addParameter((TypeName)ParameterizedTypeName.get((ClassName)Constants.DRAFT_CONSUMER_CLASS_NAME, (TypeName[])new TypeName[]{draftType}), "block", new Modifier[0]);
        builder.returns((TypeName)baseType);
        if (base.booleanValue()) {
            builder.addCode("return ($T)$T.produce(TYPE, base, block);", new Object[]{baseType, Internal.class});
        } else {
            builder.addCode("return produce(null, block);", new Object[0]);
        }
        this.typeBuilder.addMethod(builder.build());
    }

    private void addInstance() {
        FieldSpec.Builder builder = FieldSpec.builder((TypeName)this.type.getProducerClassName(), (String)"INSTANCE", (Modifier[])new Modifier[]{Modifier.STATIC, Modifier.FINAL});
        builder.initializer("new $T()", new Object[]{this.type.getProducerClassName()});
        this.typeBuilder.addField(builder.build());
    }

    private void addType() {
        CodeBlock.Builder builder = CodeBlock.builder().add("$T\n", new Object[]{Constants.RUNTIME_TYPE_CLASS_NAME}).indent().add(".newBuilder(\n", new Object[0]).indent().add("$T.class,\n", new Object[]{this.type.getClassName()});
        if (this.type.getSuperType() != null) {
            builder.add("$T.Producer.TYPE,\n", new Object[]{this.type.getSuperType().getDraftClassName()});
        } else {
            builder.add("null,\n", new Object[0]);
        }
        builder.add("(ctx, base) -> new $T(ctx, ($T)base)\n", new Object[]{this.type.getDraftImplClassName(), this.type.getClassName()}).unindent().add(")\n", new Object[0]);
        for (ImmutableProp prop : this.type.getDeclaredProps().values()) {
            ImmutablePropCategory category = prop.isList() ? (prop.isAssociation() ? ImmutablePropCategory.ENTITY_LIST : ImmutablePropCategory.SCALAR_LIST) : (prop.isAssociation() ? ImmutablePropCategory.REFERENCE : ImmutablePropCategory.SCALAR);
            if (prop == this.type.getIdProp()) {
                builder.add(".id($S, $T.class)\n", new Object[]{prop.getName(), prop.getElementTypeName()});
                continue;
            }
            if (prop == this.type.getVersionProp()) {
                builder.add(".version($S)\n", new Object[]{prop.getName()});
                continue;
            }
            if (prop.getAnnotation(Key.class) != null && !prop.isAssociation()) {
                builder.add(".key($S, $T.class)\n", new Object[]{prop.getName(), prop.getElementTypeName()});
                continue;
            }
            if (prop.getAnnotation(Key.class) != null && prop.isAssociation()) {
                builder.add(".keyReference($S, $T.class, $L)\n", new Object[]{prop.getName(), prop.getElementTypeName(), prop.isNullable() ? "true" : "false"});
                continue;
            }
            if (prop.getAssociationAnnotation() != null) {
                builder.add(".add($S, $T.class, $T.class, $L)\n", new Object[]{prop.getName(), prop.getAssociationAnnotation().annotationType(), prop.getElementTypeName(), prop.isNullable()});
                continue;
            }
            builder.add(".add($S, $T.$L, $T.class, $L)\n", new Object[]{prop.getName(), ImmutablePropCategory.class, category.name(), prop.getElementTypeName(), prop.isNullable()});
        }
        builder.add(".build()", new Object[0]).unindent();
        this.typeBuilder.addField(FieldSpec.builder((TypeName)Constants.RUNTIME_TYPE_CLASS_NAME, (String)"TYPE", (Modifier[])new Modifier[]{Modifier.PUBLIC, Modifier.STATIC, Modifier.FINAL}).initializer(builder.build()).build());
    }

    private void addConstructor() {
        MethodSpec.Builder builder = MethodSpec.constructorBuilder();
        builder.modifiers.add(Modifier.PRIVATE);
        this.typeBuilder.addMethod(builder.build());
    }
}

