/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.apt.meta;

import com.squareup.javapoet.ClassName;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.persistence.Embeddable;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Version;
import org.babyfish.jimmer.apt.TypeUtils;
import org.babyfish.jimmer.apt.meta.ImmutableProp;
import org.babyfish.jimmer.apt.meta.MetaException;
import org.babyfish.jimmer.meta.ModelException;

public class ImmutableType {
    private TypeElement typeElement;
    private boolean isEntity;
    private String packageName;
    private String name;
    private String qualifiedName;
    private Set<Modifier> modifiers;
    private ImmutableType superType;
    private Map<String, ImmutableProp> declaredProps;
    private Map<String, ImmutableProp> props;
    private ImmutableProp idProp;
    private ImmutableProp versionProp;
    private final ClassName className;
    private final ClassName draftClassName;
    private final ClassName producerClassName;
    private final ClassName implementorClassName;
    private final ClassName implClassName;
    private final ClassName draftImplClassName;
    private final ClassName tableClassName;
    private final ClassName tableExClassName;
    private final ClassName fetcherClassName;

    public ImmutableType(TypeUtils typeUtils, TypeElement typeElement) {
        ImmutableProp prop;
        this.typeElement = typeElement;
        boolean bl = this.isEntity = typeElement.getAnnotation(Entity.class) != null;
        if (typeElement.getAnnotation(Embeddable.class) != null) {
            throw new MetaException("Illegal type \"" + typeElement.getQualifiedName() + "\"@Embeddable is not supported");
        }
        this.packageName = ((PackageElement)typeElement.getEnclosingElement()).getQualifiedName().toString();
        this.name = typeElement.getSimpleName().toString();
        this.qualifiedName = typeElement.getQualifiedName().toString();
        this.modifiers = typeElement.getModifiers();
        TypeMirror superTypeMirror = null;
        for (TypeMirror typeMirror : typeElement.getInterfaces()) {
            if (!typeUtils.isImmutable(typeMirror)) continue;
            if (superTypeMirror != null) {
                throw new MetaException(String.format("'%s' inherits multiple Immutable interfaces", typeElement.getQualifiedName()));
            }
            superTypeMirror = typeMirror;
        }
        if (superTypeMirror != null) {
            this.superType = typeUtils.getImmutableType(superTypeMirror);
        }
        if (this.superType != null && this.superType.isEntity() && !this.isEntity) {
            throw new MetaException("Illegal type \"" + typeElement.getQualifiedName() + "\", it must be entity because its super type is entity");
        }
        LinkedHashMap<String, ImmutableProp> map = new LinkedHashMap<String, ImmutableProp>();
        for (ExecutableElement executableElement : ElementFilter.methodsIn(typeElement.getEnclosedElements())) {
            if (executableElement.getAnnotation(Id.class) == null) continue;
            prop = new ImmutableProp(typeUtils, executableElement);
            map.put(prop.getName(), prop);
        }
        for (ExecutableElement executableElement : ElementFilter.methodsIn(typeElement.getEnclosedElements())) {
            if (executableElement.getAnnotation(Id.class) != null) continue;
            prop = new ImmutableProp(typeUtils, executableElement);
            map.put(prop.getName(), prop);
        }
        this.declaredProps = Collections.unmodifiableMap(map);
        List list = this.declaredProps.values().stream().filter(it -> it.getAnnotation(Id.class) != null).collect(Collectors.toList());
        List versionProps = this.declaredProps.values().stream().filter(it -> it.getAnnotation(Version.class) != null).collect(Collectors.toList());
        if (this.superType != null) {
            if (!list.isEmpty()) {
                throw new MetaException("Illegal type \"" + typeElement.getQualifiedName() + "\", " + list.get(0) + "\" cannot be marked by @Id because id has been declared in super type");
            }
            if (!versionProps.isEmpty()) {
                throw new MetaException("Illegal type \"" + typeElement.getQualifiedName() + "\", " + versionProps.get(0) + "\" cannot be marked by @Version because version has been declared in super type");
            }
            this.idProp = this.superType.idProp;
            this.versionProp = this.superType.versionProp;
        }
        if (!this.isEntity) {
            if (!list.isEmpty()) {
                throw new MetaException("Illegal type \"" + typeElement.getQualifiedName() + "\", " + list.get(0) + "\" cannot be marked by @Id because current type is not entity");
            }
            if (!versionProps.isEmpty()) {
                throw new MetaException("Illegal type \"" + typeElement.getQualifiedName() + "\", " + versionProps.get(0) + "\" cannot be marked by @Version because current type is not entity");
            }
        } else {
            if (list.size() > 1) {
                throw new MetaException("Illegal type \"" + typeElement.getQualifiedName() + "\", multiple id properties are not supported, but both \"" + list.get(0) + "\" and \"" + list.get(1) + "\" is marked by @Id");
            }
            if (versionProps.size() > 1) {
                throw new MetaException("Illegal type \"" + typeElement.getQualifiedName() + "\", multiple id properties are not supported, but both \"" + versionProps.get(0) + "\" and \"" + versionProps.get(1) + "\" is marked by @Version");
            }
            if (this.idProp == null) {
                if (list.isEmpty()) {
                    throw new MetaException("Illegal type \"" + typeElement.getQualifiedName() + "\", entity type must have an id property");
                }
                this.idProp = (ImmutableProp)list.get(0);
            }
            if (this.idProp.isAssociation()) {
                throw new MetaException("Illegal property \"" + this.idProp + "\", association cannot be id property");
            }
            if (this.versionProp == null && !versionProps.isEmpty()) {
                this.versionProp = (ImmutableProp)versionProps.get(0);
                if (this.versionProp.isAssociation()) {
                    throw new MetaException("Illegal property \"" + versionProps + "\", association cannot be version property");
                }
            }
        }
        this.className = this.toClassName(null, new String[0]);
        this.draftClassName = this.toClassName(name -> name + "Draft", new String[0]);
        this.producerClassName = this.toClassName(name -> name + "Draft", "Producer");
        this.implementorClassName = this.toClassName(name -> name + "Draft", "Producer", "Implementor");
        this.implClassName = this.toClassName(name -> name + "Draft", "Producer", "Impl");
        this.draftImplClassName = this.toClassName(name -> name + "Draft", "Producer", "DraftImpl");
        this.tableClassName = this.toClassName(name -> name + "Table", new String[0]);
        this.tableExClassName = this.toClassName(name -> name + "TableEx", new String[0]);
        this.fetcherClassName = this.toClassName(name -> name + "Fetcher", new String[0]);
    }

    public TypeElement getTypeElement() {
        return this.typeElement;
    }

    public boolean isEntity() {
        return this.isEntity;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public String getName() {
        return this.name;
    }

    public String getQualifiedName() {
        return this.qualifiedName;
    }

    public Set<Modifier> getModifiers() {
        return this.modifiers;
    }

    public ImmutableType getSuperType() {
        return this.superType;
    }

    public Map<String, ImmutableProp> getDeclaredProps() {
        return this.declaredProps;
    }

    public Map<String, ImmutableProp> getProps() {
        Map<String, ImmutableProp> props = this.props;
        if (props == null) {
            if (this.superType == null) {
                props = this.declaredProps;
            } else {
                props = new LinkedHashMap<String, ImmutableProp>(this.superType.getProps());
                for (ImmutableProp declaredProp : this.declaredProps.values()) {
                    if (props.put(declaredProp.getName(), declaredProp) == null) continue;
                    throw new ModelException("The property \"" + declaredProp + "\" overrides property of super type, this is not allowed");
                }
            }
            this.props = props;
        }
        return props;
    }

    public ImmutableProp getIdProp() {
        return this.idProp;
    }

    public ImmutableProp getVersionProp() {
        return this.versionProp;
    }

    public ClassName getClassName() {
        return this.className;
    }

    public ClassName getDraftClassName() {
        return this.draftClassName;
    }

    public ClassName getProducerClassName() {
        return this.producerClassName;
    }

    public ClassName getImplementorClassName() {
        return this.implementorClassName;
    }

    public ClassName getImplClassName() {
        return this.implClassName;
    }

    public ClassName getDraftImplClassName() {
        return this.draftImplClassName;
    }

    public ClassName getTableClassName() {
        return this.tableClassName;
    }

    public ClassName getTableExClassName() {
        return this.tableExClassName;
    }

    public ClassName getFetcherClassName() {
        return this.fetcherClassName;
    }

    private ClassName toClassName(Function<String, String> transform, String ... moreSimpleNames) {
        return ClassName.get((String)this.packageName, (String)(transform != null ? transform.apply(this.name) : this.name), (String[])moreSimpleNames);
    }
}

