/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.apt.meta;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.Transient;
import javax.persistence.Version;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Null;
import org.babyfish.jimmer.Immutable;
import org.babyfish.jimmer.apt.TypeUtils;
import org.babyfish.jimmer.apt.meta.MetaException;
import org.babyfish.jimmer.sql.Key;
import org.jetbrains.annotations.Nullable;
import org.springframework.lang.NonNull;

public class ImmutableProp {
    private TypeElement declaringElement;
    private ExecutableElement executableElement;
    private String name;
    private String getterName;
    private String setterName;
    private String adderByName;
    private String loadedStateName;
    private TypeMirror returnType;
    private TypeName typeName;
    private TypeName draftTypeName;
    private TypeName elementTypeName;
    private TypeName draftElementTypeName;
    private TypeMirror elementType;
    private boolean isList;
    private boolean isAssociation;
    private boolean isNullable;
    private Annotation associationAnnotation;

    public ImmutableProp(TypeUtils typeUtils, ExecutableElement executableElement) {
        this.declaringElement = (TypeElement)executableElement.getEnclosingElement();
        this.executableElement = executableElement;
        this.getterName = executableElement.getSimpleName().toString();
        this.returnType = executableElement.getReturnType();
        if (this.returnType.getKind() == TypeKind.VOID) {
            throw new MetaException(String.format("'%s' cannot return void", executableElement));
        }
        if (!executableElement.getParameters().isEmpty()) {
            throw new MetaException(String.format("'%s' cannot have parameters", executableElement));
        }
        if (this.getterName.startsWith("is") && this.getterName.length() > 2 && Character.isUpperCase(this.getterName.charAt(2))) {
            this.name = this.getterName.substring(2, 3).toLowerCase() + this.getterName.substring(3);
            this.setterName = "set" + this.getterName.substring(2);
            this.adderByName = "addInto" + this.getterName.substring(2);
        } else if (this.getterName.startsWith("get") && this.getterName.length() > 3 && Character.isUpperCase(this.getterName.charAt(3))) {
            this.name = this.getterName.substring(3, 4).toLowerCase() + this.getterName.substring(4);
            this.setterName = "set" + this.getterName.substring(3);
            this.adderByName = "addInto" + this.getterName.substring(3);
        } else {
            this.name = this.getterName;
            this.setterName = "set" + this.getterName.substring(0, 1).toUpperCase() + this.getterName.substring(1);
            this.adderByName = "addInto" + this.getterName.substring(0, 1).toUpperCase() + this.getterName.substring(1);
        }
        this.loadedStateName = this.name + "Loaded";
        if (typeUtils.isCollection(this.returnType)) {
            if (!typeUtils.isListStrictly(this.returnType)) {
                throw new MetaException(String.format("The collection property '%s' must return 'java.util.List'", executableElement));
            }
            this.isList = true;
            List<? extends TypeMirror> typeArguments = ((DeclaredType)this.returnType).getTypeArguments();
            if (typeArguments.isEmpty()) {
                throw new MetaException(String.format("The return type of '%s' misses generic type", executableElement));
            }
            this.elementType = typeArguments.get(0);
        } else {
            this.elementType = this.returnType;
        }
        this.isAssociation = typeUtils.isImmutable(this.elementType);
        if (this.declaringElement.getAnnotation(Entity.class) != null && (this.isAssociation || this.isList) && !typeUtils.isEntity(this.elementType)) {
            throw new MetaException("Illegal property \"" + this + "\", association property of entity interface must reference to entity type");
        }
        this.initializeAssociationAnnotation();
        this.elementTypeName = TypeName.get((TypeMirror)this.elementType);
        this.typeName = this.isList ? ParameterizedTypeName.get((ClassName)ClassName.get(List.class), (TypeName[])new TypeName[]{this.elementTypeName}) : this.elementTypeName;
        this.draftElementTypeName = this.elementTypeName;
        if (this.isAssociation) {
            this.draftElementTypeName = ClassName.get((String)((ClassName)this.draftElementTypeName).packageName(), (String)(((ClassName)this.draftElementTypeName).simpleName() + "Draft"), (String[])new String[0]);
        }
        this.draftTypeName = this.isList ? ParameterizedTypeName.get((ClassName)ClassName.get(List.class), (TypeName[])new TypeName[]{this.draftElementTypeName}) : this.draftElementTypeName;
        this.isNullable = this.determineNullable();
    }

    public String getName() {
        return this.name;
    }

    public String getGetterName() {
        return this.getterName;
    }

    public String getSetterName() {
        return this.setterName;
    }

    public String getAdderByName() {
        return this.adderByName;
    }

    public String getLoadedStateName() {
        if (!this.isLoadedStateRequired()) {
            throw new IllegalStateException("The property \"" + this + "\" does not has loaded state");
        }
        return this.loadedStateName;
    }

    public TypeMirror getReturnType() {
        return this.returnType;
    }

    public TypeMirror getElementType() {
        return this.elementType;
    }

    public TypeName getTypeName() {
        return this.typeName;
    }

    public TypeName getDraftTypeName(boolean autoCreate) {
        if (this.isList && !autoCreate) {
            return this.typeName;
        }
        return this.draftTypeName;
    }

    public TypeName getElementTypeName() {
        return this.elementTypeName;
    }

    public TypeName getDraftElementTypeName() {
        return this.draftElementTypeName;
    }

    public boolean isList() {
        return this.isList;
    }

    public boolean isAssociation() {
        return this.isAssociation;
    }

    public boolean isNullable() {
        return this.isNullable;
    }

    public boolean isLoadedStateRequired() {
        return this.isNullable || this.typeName.isPrimitive();
    }

    public Class<?> getBoxType() {
        switch (this.returnType.getKind()) {
            case BOOLEAN: {
                return Boolean.class;
            }
            case CHAR: {
                return Character.class;
            }
            case BYTE: {
                return Byte.class;
            }
            case SHORT: {
                return Short.class;
            }
            case INT: {
                return Integer.class;
            }
            case LONG: {
                return Long.class;
            }
            case FLOAT: {
                return Float.class;
            }
            case DOUBLE: {
                return Double.class;
            }
        }
        return null;
    }

    public <A extends Annotation> A getAnnotation(Class<A> annotationType) {
        return this.executableElement.getAnnotation(annotationType);
    }

    public <A extends Annotation> A[] getAnnotations(Class<A> annotationType) {
        return this.executableElement.getAnnotationsByType(annotationType);
    }

    public Annotation getAssociationAnnotation() {
        return this.associationAnnotation;
    }

    public String toString() {
        return this.declaringElement.getQualifiedName().toString() + '.' + this.name;
    }

    private void initializeAssociationAnnotation() {
        Annotation firstSqlAnnotation;
        Transient trans = this.getAnnotation(Transient.class);
        JoinColumn[] joinColumns = (JoinColumn[])this.getAnnotations(JoinColumn.class);
        JoinTable joinTable = this.getAnnotation(JoinTable.class);
        Column column = this.getAnnotation(Column.class);
        Annotation[] storageAnnotations = (Annotation[])Arrays.stream(new Annotation[]{joinColumns.length == 0 ? null : joinColumns[0], joinTable, column}).filter(Objects::nonNull).toArray(Annotation[]::new);
        Id id = this.getAnnotation(Id.class);
        Version version = this.getAnnotation(Version.class);
        Key key = this.getAnnotation(Key.class);
        Annotation[] scalarAnnotations = (Annotation[])Arrays.stream(new Annotation[]{id, version, key}).filter(Objects::nonNull).toArray(Annotation[]::new);
        OneToOne oneToOne = this.getAnnotation(OneToOne.class);
        OneToMany oneToMany = this.getAnnotation(OneToMany.class);
        ManyToOne manyToOne = this.getAnnotation(ManyToOne.class);
        ManyToMany manyToMany = this.getAnnotation(ManyToMany.class);
        Annotation[] associationAnnotations = (Annotation[])Arrays.stream(new Annotation[]{oneToOne, oneToMany, manyToOne, manyToMany}).filter(Objects::nonNull).toArray(Annotation[]::new);
        Annotation annotation = firstSqlAnnotation = storageAnnotations.length != 0 ? storageAnnotations[0] : null;
        if (firstSqlAnnotation == null) {
            Annotation annotation2 = firstSqlAnnotation = scalarAnnotations.length != 0 ? scalarAnnotations[0] : null;
            if (firstSqlAnnotation == null && associationAnnotations.length != 0) {
                firstSqlAnnotation = associationAnnotations[0];
            }
        }
        if (trans != null) {
            if (firstSqlAnnotation != null) {
                throw new MetaException("Illegal property \"" + this + "\", it is marked by both @" + Transient.class.getName() + " and @" + firstSqlAnnotation.annotationType().getName());
            }
            return;
        }
        if (this.declaringElement.getAnnotation(Entity.class) == null) {
            if (firstSqlAnnotation != null) {
                throw new MetaException("Illegal property \"" + this + "\", it cannot be marked by @" + firstSqlAnnotation.annotationType().getName() + "because the current type is not entity");
            }
        } else if (this.isAssociation) {
            if (associationAnnotations.length == 0) {
                throw new MetaException("Illegal property \"" + this + "\", association property must be marked by one of these annotations: @OneToOne, @OneToMany, @ManyToOne or @ManyToMany");
            }
            if (associationAnnotations.length > 1) {
                throw new MetaException("Illegal property \"" + this + "\", it cannot be marked by both @" + associationAnnotations[0].annotationType().getName() + "and @" + associationAnnotations[1].annotationType().getName());
            }
            this.associationAnnotation = associationAnnotations[0];
            if (this.isList && (this.associationAnnotation instanceof OneToOne || this.associationAnnotation instanceof ManyToOne)) {
                throw new MetaException("Illegal property \"" + this + "\", list property cannot be marked by both @" + this.associationAnnotation.annotationType().getName());
            }
            if (!this.isList && (this.associationAnnotation instanceof OneToMany || this.associationAnnotation instanceof ManyToMany)) {
                throw new MetaException("Illegal property \"" + this + "\", reference property cannot be marked by both @" + this.associationAnnotation.annotationType().getName());
            }
            if (oneToOne != null && oneToOne.mappedBy().equals("")) {
                throw new MetaException("Illegal property \"" + this + "\", one-to-one property must be mapped by another reference property");
            }
            if (oneToMany != null && oneToMany.mappedBy().equals("")) {
                throw new MetaException("Illegal property \"" + this + "\", one-to-many property must be mapped by another reference property");
            }
            if ((oneToOne != null || oneToMany != null || manyToMany != null && !manyToMany.mappedBy().equals("")) && joinColumns.length != 0) {
                throw new MetaException("Illegal property \"" + this + "\", mapped property cannot be marked by @" + this.associationAnnotation.annotationType().getName());
            }
            if (column != null) {
                throw new MetaException("Illegal property \"" + this + "\", association property cannot be marked by @" + column.annotationType().getName());
            }
            if (joinColumns.length != 0 && joinTable != null) {
                throw new MetaException("Illegal property \"" + this + "\", it is marked by both @JoinColumn and @JoinTable");
            }
            if (joinColumns.length > 1) {
                throw new MetaException("Illegal property \"" + this + "\", multiple join columns is not supported");
            }
            if (Arrays.stream(joinColumns).anyMatch(it -> !it.referencedColumnName().isEmpty())) {
                throw new MetaException("Illegal property \"" + this + "\", the referenced column of join column is not supported");
            }
            if (scalarAnnotations.length != 0) {
                throw new MetaException("Illegal property \"" + this + "\", association property cannot be marked by @" + scalarAnnotations[0].annotationType().getName());
            }
            if (joinTable != null && joinTable.joinColumns().length > 1) {
                throw new MetaException("Illegal property \"" + this + "\", join table with multiple join columns is not supported");
            }
            if (joinTable != null && Arrays.stream(joinTable.joinColumns()).anyMatch(it -> !it.referencedColumnName().isEmpty())) {
                throw new MetaException("Illegal property \"" + this + "\", the referenced column of join column is not supported");
            }
            if (joinTable != null && joinTable.inverseJoinColumns().length > 1) {
                throw new MetaException("Illegal property \"" + this + "\", join table with multiple inverse join columns is not supported");
            }
            if (joinTable != null && Arrays.stream(joinTable.inverseJoinColumns()).anyMatch(it -> !it.referencedColumnName().isEmpty())) {
                throw new MetaException("Illegal property \"" + this + "\", the referenced column of inverse join column is not supported");
            }
        } else {
            if (associationAnnotations.length != 0) {
                throw new MetaException("Illegal property \"" + this + "\", scalar property cannot be marked by @" + associationAnnotations[0].annotationType().getName());
            }
            if (joinColumns.length != 0) {
                throw new MetaException("Illegal property \"" + this + "\", scalar property cannot be marked by @" + JoinColumn.class.getName());
            }
            if (joinTable != null) {
                throw new MetaException("Illegal property \"" + this + "\", scalar property cannot be marked by @" + JoinTable.class.getName());
            }
            if (scalarAnnotations.length > 1) {
                throw new MetaException("Illegal property \"" + this + "\", it is marked by both @" + storageAnnotations[0].annotationType().getName() + " @" + storageAnnotations[1].annotationType().getName());
            }
            if (scalarAnnotations.length != 0 && this.isNullable) {
                throw new MetaException("Illegal property \"" + this + "\", nullable property cannot be marked by @" + scalarAnnotations[0].annotationType().getName());
            }
            if (version != null && this.returnType.getKind() != TypeKind.INT) {
                throw new MetaException("Illegal property \"" + this + "\", it is marked by @" + Version.class.getName() + " but its type is not int");
            }
        }
    }

    private boolean determineNullable() {
        OneToOne oneToOne;
        ManyToOne manyToOne;
        AnnotationRef nullAnnotationRef;
        OneToOne oneToOne2;
        ManyToOne manyToOne2;
        AnnotationRef notNullAnnotationRef = Arrays.stream((NotNull[])this.getAnnotations(NotNull.class)).findFirst().map(it -> AnnotationRef.of((Annotation)it)).orElse(null);
        if (notNullAnnotationRef == null) {
            notNullAnnotationRef = AnnotationRef.of((Annotation)this.getAnnotation(NonNull.class));
        }
        if (notNullAnnotationRef == null) {
            notNullAnnotationRef = AnnotationRef.of((Annotation)this.getAnnotation(org.jetbrains.annotations.NotNull.class));
        }
        if (notNullAnnotationRef == null && this.getAnnotation(Id.class) != null) {
            notNullAnnotationRef = new AnnotationRef(Id.class);
        }
        if (notNullAnnotationRef == null && (manyToOne2 = this.getAnnotation(ManyToOne.class)) != null && !manyToOne2.optional()) {
            notNullAnnotationRef = new AnnotationRef(ManyToOne.class, "optional", false);
        }
        if (notNullAnnotationRef == null && (oneToOne2 = this.getAnnotation(OneToOne.class)) != null && !oneToOne2.optional()) {
            notNullAnnotationRef = new AnnotationRef(OneToOne.class, "optional", false);
        }
        if (notNullAnnotationRef == null) {
            notNullAnnotationRef = Arrays.stream((Column[])this.getAnnotations(Column.class)).filter(it -> !it.nullable()).findFirst().map(it -> new AnnotationRef(Column.class, "nullable", false)).orElse(null);
        }
        if (notNullAnnotationRef == null) {
            notNullAnnotationRef = Arrays.stream((JoinColumn[])this.getAnnotations(JoinColumn.class)).filter(it -> !it.nullable()).findFirst().map(it -> new AnnotationRef(JoinColumn.class, "nullable", false)).orElse(null);
        }
        if ((nullAnnotationRef = (AnnotationRef)Arrays.stream((Null[])this.getAnnotations(Null.class)).findFirst().map(it -> AnnotationRef.of((Annotation)it)).orElse(null)) == null) {
            nullAnnotationRef = AnnotationRef.of((Annotation)this.getAnnotation(org.springframework.lang.Nullable.class));
        }
        if (nullAnnotationRef == null) {
            nullAnnotationRef = AnnotationRef.of((Annotation)this.getAnnotation(Nullable.class));
        }
        if (nullAnnotationRef == null && (manyToOne = this.getAnnotation(ManyToOne.class)) != null && manyToOne.optional()) {
            nullAnnotationRef = new AnnotationRef(ManyToOne.class, "optional", true);
        }
        if (nullAnnotationRef == null && (oneToOne = this.getAnnotation(OneToOne.class)) != null && oneToOne.optional()) {
            nullAnnotationRef = new AnnotationRef(OneToOne.class, "optional", true);
        }
        if (nullAnnotationRef == null) {
            nullAnnotationRef = Arrays.stream((Column[])this.getAnnotations(Column.class)).filter(Column::nullable).findFirst().map(it -> new AnnotationRef(Column.class, "nullable", true)).orElse(null);
        }
        if (nullAnnotationRef == null) {
            nullAnnotationRef = Arrays.stream((JoinColumn[])this.getAnnotations(JoinColumn.class)).filter(JoinColumn::nullable).findFirst().map(it -> new AnnotationRef(JoinColumn.class, "nullable", true)).orElse(null);
        }
        if (notNullAnnotationRef != null && nullAnnotationRef != null) {
            throw new MetaException("Illegal property \"" + this + "\", its nullity is conflict because it is marked by both " + notNullAnnotationRef + " and " + nullAnnotationRef);
        }
        ImplicitNullable implicitNullable = this.getImplicitNullable();
        if (notNullAnnotationRef != null) {
            if (implicitNullable != null && implicitNullable.nullable) {
                throw new MetaException("Illegal property \"" + this + "\", it is marked by " + notNullAnnotationRef + ", but it is considered as nullable because " + implicitNullable.reason);
            }
            return false;
        }
        if (nullAnnotationRef != null) {
            if (implicitNullable != null && !implicitNullable.nullable) {
                throw new MetaException("Illegal property \"" + this + "\", it is marked by " + nullAnnotationRef + ", but it is considered as non-null because " + implicitNullable.reason);
            }
            return true;
        }
        if (implicitNullable != null) {
            return implicitNullable.nullable;
        }
        Immutable immutable = this.declaringElement.getAnnotation(Immutable.class);
        return immutable != null && immutable.value() == Immutable.Nullity.NULLABLE;
    }

    private ImplicitNullable getImplicitNullable() {
        if (this.isList) {
            return new ImplicitNullable(false, "it is list");
        }
        if (this.isAssociation) {
            if (this.getAnnotation(JoinTable.class) != null) {
                return new ImplicitNullable(true, "it's a many-to-one association base on middle table");
            }
            if (this.getAnnotation(OneToOne.class) != null) {
                return new ImplicitNullable(true, "it's a one-to-one association");
            }
        }
        if (this.typeName.isPrimitive()) {
            return new ImplicitNullable(false, "its type is primitive");
        }
        if (this.typeName.isBoxedPrimitive()) {
            return new ImplicitNullable(true, "its type is box type");
        }
        return null;
    }

    private static class AnnotationRef {
        private Class<? extends Annotation> annotationType;
        private Map<String, Object> valueMap;

        public static AnnotationRef of(Annotation annotation) {
            return annotation == null ? null : new AnnotationRef(annotation.annotationType());
        }

        public AnnotationRef(Class<? extends Annotation> annotationType) {
            this.annotationType = annotationType;
        }

        public AnnotationRef(Class<? extends Annotation> annotationType, String attrName, Object attrValue) {
            this.annotationType = annotationType;
            HashMap<String, Object> valueMap = new HashMap<String, Object>();
            valueMap.put(attrName, attrValue);
            this.valueMap = valueMap;
        }

        public AnnotationRef(Class<Annotation> annotationType, Map<String, Object> valueMap) {
            this.annotationType = annotationType;
            this.valueMap = valueMap;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append('@');
            builder.append(this.annotationType.getName());
            if (this.valueMap != null && !this.valueMap.isEmpty()) {
                builder.append('(');
                boolean addComma = false;
                for (Map.Entry<String, Object> e : this.valueMap.entrySet()) {
                    if (addComma) {
                        builder.append(", ");
                    } else {
                        addComma = true;
                    }
                    builder.append(e.getKey()).append('=').append(e.getValue());
                }
                builder.append(')');
            }
            return builder.toString();
        }
    }

    private static class ImplicitNullable {
        final boolean nullable;
        final String reason;

        ImplicitNullable(boolean nullable, String reason) {
            this.nullable = nullable;
            this.reason = reason;
        }

        public String toString() {
            return "ImplicitNullable{nullable=" + this.nullable + ", reason='" + this.reason + '\'' + '}';
        }
    }
}

