/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.apt.generator;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.io.IOException;
import javax.annotation.processing.Filer;
import javax.lang.model.element.Modifier;
import javax.persistence.criteria.JoinType;
import org.babyfish.jimmer.apt.GeneratorException;
import org.babyfish.jimmer.apt.TypeUtils;
import org.babyfish.jimmer.apt.generator.Constants;
import org.babyfish.jimmer.apt.meta.ImmutableProp;
import org.babyfish.jimmer.apt.meta.ImmutableType;

public class TableGenerator {
    private TypeUtils typeUtils;
    private ImmutableType type;
    private boolean isTableEx;
    private Filer filer;
    private TypeSpec.Builder typeBuilder;

    public TableGenerator(TypeUtils typeUtils, ImmutableType type, boolean isTableEx, Filer filer) {
        this.typeUtils = typeUtils;
        this.type = type;
        this.isTableEx = isTableEx;
        this.filer = filer;
    }

    public void generate() {
        try {
            JavaFile.builder((String)this.type.getPackageName(), (TypeSpec)this.generateTable()).indent("    ").build().writeTo(this.filer);
        }
        catch (IOException ex) {
            throw new GeneratorException(String.format("Cannot generate " + (this.isTableEx ? "tableEx" : "table") + "class for '%s'", this.type.getName()), ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TypeSpec generateTable() {
        TypeSpec.Builder oldTypeBuilder = this.typeBuilder;
        this.typeBuilder = TypeSpec.classBuilder((String)(this.isTableEx ? this.type.getTableExClassName().simpleName() : this.type.getTableClassName().simpleName())).addModifiers(new Modifier[]{Modifier.PUBLIC});
        if (this.isTableEx) {
            this.typeBuilder.superclass((TypeName)this.type.getTableClassName());
            this.typeBuilder.addSuperinterface((TypeName)ParameterizedTypeName.get((ClassName)Constants.QUERY_TABLE_EX_CLASS_NAME, (TypeName[])new TypeName[]{this.type.getClassName()}));
        } else {
            this.typeBuilder.superclass((TypeName)ParameterizedTypeName.get((ClassName)Constants.ABSTRACT_TABLE_WRAPPER_CLASS_NAME, (TypeName[])new TypeName[]{this.type.getClassName()}));
        }
        this.addConstructor();
        try {
            for (ImmutableProp prop : this.type.getProps().values()) {
                if (prop.isList() != this.isTableEx) continue;
                this.addProperty(prop, false);
                this.addProperty(prop, true);
            }
            TypeSpec typeSpec = this.typeBuilder.build();
            return typeSpec;
        }
        finally {
            this.typeBuilder = oldTypeBuilder;
        }
    }

    private void addConstructor() {
        MethodSpec.Builder builder = MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC});
        ParameterizedTypeName tableTypeName = this.isTableEx ? ParameterizedTypeName.get((ClassName)Constants.QUERY_TABLE_EX_CLASS_NAME, (TypeName[])new TypeName[]{this.type.getClassName()}) : ParameterizedTypeName.get((ClassName)Constants.TABLE_CLASS_NAME, (TypeName[])new TypeName[]{this.type.getClassName()});
        builder.addParameter((TypeName)tableTypeName, "table", new Modifier[0]).addStatement("super(table)", new Object[0]);
        this.typeBuilder.addMethod(builder.build());
    }

    private void addProperty(ImmutableProp prop, boolean withJoinType) {
        if (withJoinType && !prop.isAssociation()) {
            return;
        }
        Object returnType = prop.isAssociation() ? (this.isTableEx ? this.typeUtils.getImmutableType(prop.getElementType()).getTableExClassName() : this.typeUtils.getImmutableType(prop.getElementType()).getTableClassName()) : (prop.getTypeName().isPrimitive() ? ParameterizedTypeName.get((ClassName)Constants.PROP_NUMERIC_EXPRESSION_CLASS_NAME, (TypeName[])new TypeName[]{prop.getTypeName().box()}) : (this.typeUtils.isString(prop.getReturnType()) ? Constants.PROP_STRING_EXPRESSION_CLASS_NAME : (this.typeUtils.isNumber(prop.getReturnType()) ? ParameterizedTypeName.get((ClassName)Constants.PROP_NUMERIC_EXPRESSION_CLASS_NAME, (TypeName[])new TypeName[]{prop.getTypeName()}) : (this.typeUtils.isComparable(prop.getReturnType()) ? ParameterizedTypeName.get((ClassName)Constants.PROP_COMPARABLE_EXPRESSION_CLASS_NAME, (TypeName[])new TypeName[]{prop.getTypeName()}) : ParameterizedTypeName.get((ClassName)Constants.EXPRESSION_CLASS_NAME, (TypeName[])new TypeName[]{prop.getTypeName()})))));
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)prop.getName()).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)returnType);
        if (this.isTableEx && !prop.isList()) {
            builder.addAnnotation(Override.class);
        }
        if (withJoinType) {
            builder.addParameter(JoinType.class, "joinType", new Modifier[0]);
        }
        if (prop.isAssociation()) {
            if (withJoinType) {
                builder.addStatement("return join($S, joinType)", new Object[]{prop.getName()});
            } else {
                builder.addStatement("return join($S)", new Object[]{prop.getName()});
            }
        } else {
            builder.addStatement("return get($S)", new Object[]{prop.getName()});
        }
        this.typeBuilder.addMethod(builder.build());
    }
}

