/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.apt.generator;

import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.util.ArrayList;
import java.util.Collections;
import javax.lang.model.element.Modifier;
import javax.validation.constraints.Email;
import javax.validation.constraints.Pattern;
import org.babyfish.jimmer.CircularReferenceException;
import org.babyfish.jimmer.apt.generator.Constants;
import org.babyfish.jimmer.apt.generator.ValidationGenerator;
import org.babyfish.jimmer.apt.meta.ImmutableProp;
import org.babyfish.jimmer.apt.meta.ImmutableType;
import org.babyfish.jimmer.runtime.DraftContext;
import org.babyfish.jimmer.runtime.DraftSpi;
import org.babyfish.jimmer.runtime.ImmutableSpi;

public class DraftImplGenerator {
    private ImmutableType type;
    private ClassName draftSpiClassName;
    private TypeSpec.Builder typeBuilder;
    private static final String UNMODIFIED = "(__modified!= null ? __modified : __base)";

    public DraftImplGenerator(ImmutableType type) {
        this.type = type;
        this.draftSpiClassName = ClassName.get(DraftSpi.class);
    }

    public void generate(TypeSpec.Builder parentBuilder) {
        this.typeBuilder = TypeSpec.classBuilder((String)"DraftImpl").addModifiers(new Modifier[]{Modifier.PRIVATE, Modifier.STATIC}).superclass((TypeName)this.type.getImplementorClassName()).addSuperinterface((TypeName)this.draftSpiClassName).addSuperinterface((TypeName)this.type.getDraftClassName());
        this.addFields();
        this.addPatternFields();
        this.addConstructor();
        this.addReadonlyMethods();
        for (ImmutableProp prop : this.type.getProps().values()) {
            this.addGetter(prop);
            this.addCreator(prop);
            this.addSetter(prop);
            this.addUtilMethod(prop, false);
            this.addUtilMethod(prop, true);
        }
        this.addSet();
        this.addUnload();
        this.addDraftContext();
        this.addResolve();
        this.addModified();
        parentBuilder.addType(this.typeBuilder.build());
    }

    private void addFields() {
        this.typeBuilder.addField(FieldSpec.builder((TypeName)Constants.DRAFT_CONTEXT_CLASS_NAME, (String)"__ctx", (Modifier[])new Modifier[]{Modifier.PRIVATE}).build());
        this.typeBuilder.addField(FieldSpec.builder((TypeName)this.type.getImplementorClassName(), (String)"__base", (Modifier[])new Modifier[]{Modifier.PRIVATE}).build());
        this.typeBuilder.addField(FieldSpec.builder((TypeName)this.type.getImplClassName(), (String)"__modified", (Modifier[])new Modifier[]{Modifier.PRIVATE}).build());
        this.typeBuilder.addField(FieldSpec.builder(Boolean.TYPE, (String)"__resolving", (Modifier[])new Modifier[]{Modifier.PRIVATE}).build());
    }

    private void addPatternFields() {
        boolean hasEmail = false;
        for (ImmutableProp prop : this.type.getProps().values()) {
            Email[] emails = (Email[])prop.getAnnotations(Email.class);
            Pattern[] patterns = (Pattern[])prop.getAnnotations(Pattern.class);
            if (emails.length != 0) {
                hasEmail = true;
            }
            for (int i = 0; i < patterns.length; ++i) {
                int flags = 0;
                for (Pattern.Flag flag : patterns[i].flags()) {
                    flags |= flag.getValue();
                }
                FieldSpec.Builder builder = FieldSpec.builder(java.util.regex.Pattern.class, (String)Constants.regexpPatternFieldName(prop, i), (Modifier[])new Modifier[]{Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL}).initializer("$T.compile($S, $L)", new Object[]{java.util.regex.Pattern.class, patterns[i].regexp(), flags});
                this.typeBuilder.addField(builder.build());
            }
        }
        if (hasEmail) {
            FieldSpec.Builder builder = FieldSpec.builder(java.util.regex.Pattern.class, (String)"__email_pattern", (Modifier[])new Modifier[]{Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL}).initializer("$T.compile($S)", new Object[]{java.util.regex.Pattern.class, "^[^@]+@[^@]+$"});
            this.typeBuilder.addField(builder.build());
        }
    }

    private void addConstructor() {
        MethodSpec.Builder builder = MethodSpec.constructorBuilder().addParameter((TypeName)Constants.DRAFT_CONTEXT_CLASS_NAME, "ctx", new Modifier[0]).addParameter((TypeName)this.type.getClassName(), "base", new Modifier[0]).addStatement("$L = ctx", new Object[]{"__ctx"}).beginControlFlow("if (base != null)", new Object[0]).addStatement("$L = (Implementor)base", new Object[]{"__base"}).endControlFlow().beginControlFlow("else", new Object[0]).addStatement("$L = new Impl(null)", new Object[]{"__base"}).endControlFlow();
        this.typeBuilder.addMethod(builder.build());
    }

    private void addReadonlyMethods() {
        this.typeBuilder.addMethod(MethodSpec.methodBuilder((String)"__isLoaded").addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Override.class).addParameter(String.class, "prop", new Modifier[0]).returns(Boolean.TYPE).addCode("return $L.__isLoaded(prop);", new Object[]{UNMODIFIED}).build());
        this.typeBuilder.addMethod(MethodSpec.methodBuilder((String)"hashCode").addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Override.class).returns(Integer.TYPE).addCode("return $T.identityHashCode(this);", new Object[]{System.class}).build());
        this.typeBuilder.addMethod(MethodSpec.methodBuilder((String)"__hashCode").addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Override.class).addParameter(Boolean.TYPE, "shallow", new Modifier[0]).returns(Integer.TYPE).addCode("return $T.identityHashCode(this);", new Object[]{System.class}).build());
        this.typeBuilder.addMethod(MethodSpec.methodBuilder((String)"equals").addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Override.class).addParameter(Object.class, "obj", new Modifier[0]).returns(Boolean.TYPE).addCode("return this == obj;", new Object[0]).build());
        this.typeBuilder.addMethod(MethodSpec.methodBuilder((String)"__equals").addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Override.class).addParameter(Object.class, "obj", new Modifier[0]).addParameter(Boolean.TYPE, "shallow", new Modifier[0]).returns(Boolean.TYPE).addCode("return this == obj;", new Object[0]).build());
    }

    private void addGetter(ImmutableProp prop) {
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)prop.getGetterName()).addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Override.class).returns(prop.getDraftTypeName(false));
        if (prop.isList()) {
            builder.addCode("return $L.$L($L.$L(), $T.class, $L);", new Object[]{"__ctx", "toDraftList", UNMODIFIED, prop.getGetterName(), prop.getElementTypeName(), prop.isAssociation()});
        } else if (prop.isAssociation()) {
            builder.addCode("return $L.$L($L.$L());", new Object[]{"__ctx", "toDraftObject", UNMODIFIED, prop.getGetterName()});
        } else {
            builder.addCode("return $L.$L();", new Object[]{UNMODIFIED, prop.getGetterName()});
        }
        this.typeBuilder.addMethod(builder.build());
    }

    private void addCreator(ImmutableProp prop) {
        if (!prop.isAssociation() && !prop.isList()) {
            return;
        }
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)prop.getGetterName()).addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Override.class).addParameter(Boolean.TYPE, "autoCreate", new Modifier[0]).returns(prop.getDraftTypeName(true));
        builder.beginControlFlow("if (autoCreate && (!__isLoaded($S) || $L() == null))", new Object[]{prop.getName(), prop.getGetterName()});
        if (prop.isList()) {
            builder.addStatement("$L(new $T<>())", new Object[]{prop.getSetterName(), ArrayList.class});
        } else {
            builder.addStatement("$L($T.$L.produce(null, null))", new Object[]{prop.getSetterName(), prop.getDraftElementTypeName(), "$"});
        }
        builder.endControlFlow();
        if (prop.isList()) {
            builder.addCode("return $L.$L($L.$L(), $T.class, $L);", new Object[]{"__ctx", "toDraftList", UNMODIFIED, prop.getGetterName(), prop.getElementType(), prop.isAssociation()});
        } else {
            builder.addCode("return $L.$L($L.$L());", new Object[]{"__ctx", "toDraftObject", UNMODIFIED, prop.getGetterName()});
        }
        this.typeBuilder.addMethod(builder.build());
    }

    private void addSetter(ImmutableProp prop) {
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)prop.getSetterName()).addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Override.class).addParameter(prop.getTypeName(), prop.getName(), new Modifier[0]).returns((TypeName)this.type.getDraftClassName());
        new ValidationGenerator(prop, prop.getName(), builder).generate();
        builder.addStatement("$T modified = $L()", new Object[]{this.type.getImplClassName(), "__modified"});
        if (prop.isList()) {
            builder.addComment("Cannot use the shared instance 'Collections.EMPTY_LIST' ", new Object[0]).addComment("because DraftContext depends on identities of list objects", new Object[0]).addStatement("modified.$L = $L != $T.EMPTY_LIST ? $L : new $T<>()", new Object[]{prop.getName(), prop.getName(), Collections.class, prop.getName(), ArrayList.class});
        } else {
            builder.addStatement("modified.$L = $L", new Object[]{prop.getName(), prop.getName()});
        }
        if (prop.isLoadedStateRequired()) {
            builder.addStatement("modified.$L = true", new Object[]{prop.getLoadedStateName()});
        }
        builder.addStatement("return this", new Object[0]);
        this.typeBuilder.addMethod(builder.build());
    }

    private void addUtilMethod(ImmutableProp prop, boolean withBase) {
        if (!prop.isAssociation()) {
            return;
        }
        String methodName = prop.isList() ? prop.getAdderByName() : prop.getSetterName();
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)methodName).addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Override.class).returns((TypeName)this.type.getDraftClassName());
        if (withBase) {
            builder.addParameter(prop.getElementTypeName(), "base", new Modifier[0]);
        }
        ParameterizedTypeName consumerTypeName = ParameterizedTypeName.get((ClassName)Constants.DRAFT_CONSUMER_CLASS_NAME, (TypeName[])new TypeName[]{prop.getDraftElementTypeName()});
        builder.addParameter((TypeName)consumerTypeName, "block", new Modifier[0]);
        if (withBase) {
            if (prop.isList()) {
                builder.addStatement("$L(true).add(($T)$T.$L.produce(base, block))", new Object[]{prop.getGetterName(), prop.getDraftElementTypeName(), prop.getDraftElementTypeName(), "$"});
            } else {
                builder.addStatement("$L($T.$L.produce(base, block))", new Object[]{prop.getSetterName(), prop.getDraftElementTypeName(), "$"});
            }
        } else {
            builder.addStatement("$L(null, $L)", new Object[]{methodName, "block"});
        }
        builder.addStatement("return this", new Object[0]);
        this.typeBuilder.addMethod(builder.build());
    }

    private void addSet() {
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)"__set").addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(AnnotationSpec.builder(SuppressWarnings.class).addMember("value", "$S", new Object[]{"unchecked"}).build()).addAnnotation(Override.class).addParameter(String.class, "prop", new Modifier[0]).addParameter(Object.class, "value", new Modifier[0]);
        builder.beginControlFlow("switch (prop)", new Object[0]);
        for (ImmutableProp prop : this.type.getProps().values()) {
            TypeName castTo = prop.getBoxType();
            if (castTo == null) {
                castTo = prop.getTypeName();
            }
            builder.addStatement("case $S: $L(($T)value);break", new Object[]{prop.getName(), prop.getSetterName(), castTo});
        }
        builder.addStatement("default: throw new IllegalArgumentException($S + prop + $S)", new Object[]{"Illegal property name: \"", "\""});
        builder.endControlFlow();
        this.typeBuilder.addMethod(builder.build());
    }

    private void addUnload() {
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)"__unload").addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Override.class).addParameter(String.class, "prop", new Modifier[0]);
        builder.beginControlFlow("switch (prop)", new Object[0]);
        for (ImmutableProp prop : this.type.getProps().values()) {
            if (prop.isLoadedStateRequired()) {
                builder.addStatement("case $S: $L().$L = false", new Object[]{prop.getGetterName(), "__modified", prop.getLoadedStateName()});
                continue;
            }
            builder.addStatement("case $S: $L().$L = null", new Object[]{prop.getGetterName(), "__modified", prop.getName()});
        }
        builder.addStatement("default: throw new IllegalArgumentException($S + prop + $S)", new Object[]{"Illegal property name: \"", "\""});
        builder.endControlFlow();
        this.typeBuilder.addMethod(builder.build());
    }

    private void addDraftContext() {
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)"__draftContext").addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Override.class).returns(DraftContext.class).addStatement("return $L", new Object[]{"__ctx"});
        this.typeBuilder.addMethod(builder.build());
    }

    private void addResolve() {
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)"__resolve").addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Override.class).returns(Object.class);
        builder.beginControlFlow("if ($L)", new Object[]{"__resolving"}).addStatement("throw new $T()", new Object[]{CircularReferenceException.class}).endControlFlow();
        builder.addStatement("$L = true", new Object[]{"__resolving"}).beginControlFlow("try", new Object[0]);
        this.addResolveCode(builder);
        builder.endControlFlow().beginControlFlow("finally", new Object[0]).addStatement("$L = false", new Object[]{"__resolving"}).endControlFlow();
        this.typeBuilder.addMethod(builder.build());
    }

    private void addResolveCode(MethodSpec.Builder builder) {
        builder.addStatement("Implementor base = $L", new Object[]{"__base"}).addStatement("Impl modified = $L", new Object[]{"__modified"});
        if (this.type.getProps().values().stream().anyMatch(it -> it.isAssociation() || it.isList())) {
            builder.beginControlFlow("if (modified == null)", new Object[0]);
            for (ImmutableProp prop : this.type.getProps().values()) {
                if (!prop.isAssociation() && !prop.isList()) continue;
                builder.beginControlFlow("if (base.__isLoaded($S))", new Object[]{prop.getName()});
                builder.addStatement("$T oldValue = base.$L()", new Object[]{prop.getTypeName(), prop.getGetterName()});
                builder.addStatement("$T newValue = $L.$L(oldValue)", new Object[]{prop.getTypeName(), "__ctx", prop.isList() ? "resolveList" : "resolveObject"});
                if (prop.isList()) {
                    builder.beginControlFlow("if (oldValue != newValue)", new Object[0]);
                } else {
                    builder.beginControlFlow("if (!$T.equals(oldValue, newValue, true))", new Object[]{ImmutableSpi.class});
                }
                builder.addStatement("$L(newValue)", new Object[]{prop.getSetterName()});
                builder.endControlFlow();
                builder.endControlFlow();
            }
            builder.addStatement("modified = $L", new Object[]{"__modified"});
            builder.endControlFlow();
            builder.beginControlFlow("else", new Object[0]);
            for (ImmutableProp prop : this.type.getProps().values()) {
                if (!prop.isAssociation() && !prop.isList()) continue;
                builder.addStatement("modified.$L = $L.$L(modified.$L)", new Object[]{prop.getName(), "__ctx", prop.isList() ? "resolveList" : "resolveObject", prop.getName()});
            }
            builder.endControlFlow();
        }
        builder.beginControlFlow("if (modified == null || $T.equals(base, modified, true))", new Object[]{ImmutableSpi.class}).addStatement("return base", new Object[0]).endControlFlow().addStatement("return modified", new Object[0]);
    }

    private void addModified() {
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)"__modified").addModifiers(new Modifier[]{Modifier.PRIVATE}).returns((TypeName)this.type.getImplClassName()).addStatement("$T modified = $L", new Object[]{this.type.getImplClassName(), "__modified"}).beginControlFlow("if (modified == null)", new Object[0]).addStatement("modified = new $T($L)", new Object[]{this.type.getImplClassName(), "__base"}).addStatement("$L = modified", new Object[]{"__modified"}).endControlFlow().addStatement("return modified", new Object[0]);
        this.typeBuilder.addMethod(builder.build());
    }
}

