/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.apt;

import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Filer;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import org.babyfish.jimmer.apt.TypeUtils;
import org.babyfish.jimmer.apt.generator.DraftGenerator;
import org.babyfish.jimmer.apt.generator.FetcherGenerator;
import org.babyfish.jimmer.apt.generator.TableGenerator;
import org.babyfish.jimmer.apt.meta.ImmutableType;
import org.babyfish.jimmer.apt.meta.MetaException;

@SupportedAnnotationTypes(value={"org.babyfish.jimmer.Immutable", "javax.persistence.Entity"})
@SupportedSourceVersion(value=SourceVersion.RELEASE_8)
public class ImmutableProcessor
extends AbstractProcessor {
    private TypeUtils typeUtils;
    private Filer filer;

    @Override
    public synchronized void init(ProcessingEnvironment processingEnv) {
        super.init(processingEnv);
        this.typeUtils = new TypeUtils(processingEnv.getElementUtils(), processingEnv.getTypeUtils());
        this.filer = processingEnv.getFiler();
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        for (Element element : roundEnv.getRootElements()) {
            TypeElement typeElement;
            if (!(element instanceof TypeElement) || !this.typeUtils.isImmutable(typeElement = (TypeElement)element)) continue;
            if (typeElement.getKind() != ElementKind.INTERFACE) {
                throw new MetaException("Illegal class \"" + typeElement.getQualifiedName().toString() + "\", immutable type must be interface");
            }
            if (!this.typeUtils.isImmutable(typeElement)) continue;
            ImmutableType immutableType = this.typeUtils.getImmutableType(typeElement);
            new DraftGenerator(this.typeUtils, immutableType, this.filer).generate();
            if (!immutableType.isEntity()) continue;
            new TableGenerator(this.typeUtils, immutableType, false, this.filer).generate();
            new TableGenerator(this.typeUtils, immutableType, true, this.filer).generate();
            new FetcherGenerator(this.typeUtils, immutableType, this.filer).generate();
        }
        return true;
    }
}

