/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.springframework.orm.hibernate;

import javax.transaction.TransactionManager;
import org.babyfish.hibernate.XSession;
import org.babyfish.hibernate.context.spi.CurrentXSessionContext;
import org.babyfish.hibernate.internal.XSessionFactoryImplementor;
import org.babyfish.springframework.orm.hibernate.SpringJtaXSessionContext;
import org.hibernate.FlushMode;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.transaction.jta.platform.spi.JtaPlatform;
import org.springframework.core.Ordered;
import org.springframework.dao.DataAccessException;
import org.springframework.orm.hibernate4.SessionFactoryUtils;
import org.springframework.orm.hibernate4.SessionHolder;
import org.springframework.transaction.support.TransactionSynchronization;
import org.springframework.transaction.support.TransactionSynchronizationAdapter;
import org.springframework.transaction.support.TransactionSynchronizationManager;

public class SpringXSessionContext
implements CurrentXSessionContext {
    private static final long serialVersionUID = -441233267210779294L;
    private final SessionFactoryImplementor sessionFactory;
    private final CurrentXSessionContext jtaSessionContext;

    public SpringXSessionContext(XSessionFactoryImplementor sessionFactory) {
        this.sessionFactory = sessionFactory;
        JtaPlatform jtaPlatform = (JtaPlatform)sessionFactory.getServiceRegistry().getService(JtaPlatform.class);
        TransactionManager transactionManager = jtaPlatform.retrieveTransactionManager();
        this.jtaSessionContext = transactionManager != null ? new SpringJtaXSessionContext(sessionFactory) : null;
    }

    public XSession currentSession() throws HibernateException {
        Object value = TransactionSynchronizationManager.getResource((Object)this.sessionFactory);
        if (value instanceof XSession) {
            return (XSession)value;
        }
        if (value instanceof SessionHolder) {
            SessionHolder sessionHolder = (SessionHolder)value;
            XSession session = (XSession)sessionHolder.getSession();
            if (TransactionSynchronizationManager.isSynchronizationActive() && !sessionHolder.isSynchronizedWithTransaction()) {
                TransactionSynchronizationManager.registerSynchronization((TransactionSynchronization)new SpringSessionSynchronization(sessionHolder, (SessionFactory)this.sessionFactory));
                sessionHolder.setSynchronizedWithTransaction(true);
                FlushMode flushMode = session.getFlushMode();
                if (FlushMode.isManualFlushMode((FlushMode)flushMode) && !TransactionSynchronizationManager.isCurrentTransactionReadOnly()) {
                    session.setFlushMode(FlushMode.AUTO);
                    sessionHolder.setPreviousFlushMode(flushMode);
                }
            }
            return session;
        }
        if (this.jtaSessionContext != null) {
            XSession session = this.jtaSessionContext.currentSession();
            if (TransactionSynchronizationManager.isSynchronizationActive()) {
                TransactionSynchronizationManager.registerSynchronization((TransactionSynchronization)new SpringFlushSynchronization((Session)session));
            }
            return session;
        }
        throw new HibernateException("No Session found for current thread");
    }

    private static class SpringFlushSynchronization
    extends TransactionSynchronizationAdapter {
        private final Session session;

        public SpringFlushSynchronization(Session session) {
            this.session = session;
        }

        public void flush() {
            try {
                this.session.flush();
            }
            catch (HibernateException ex) {
                throw SessionFactoryUtils.convertHibernateAccessException((HibernateException)ex);
            }
        }

        public boolean equals(Object obj) {
            return obj instanceof SpringFlushSynchronization && this.session == ((SpringFlushSynchronization)((Object)obj)).session;
        }

        public int hashCode() {
            return this.session.hashCode();
        }
    }

    private static class SpringSessionSynchronization
    implements TransactionSynchronization,
    Ordered {
        private final SessionHolder sessionHolder;
        private final SessionFactory sessionFactory;
        private boolean holderActive = true;

        public SpringSessionSynchronization(SessionHolder sessionHolder, SessionFactory sessionFactory) {
            this.sessionHolder = sessionHolder;
            this.sessionFactory = sessionFactory;
        }

        private Session getCurrentSession() {
            return this.sessionHolder.getSession();
        }

        public int getOrder() {
            return 900;
        }

        public void suspend() {
            if (this.holderActive) {
                TransactionSynchronizationManager.unbindResource((Object)this.sessionFactory);
                this.getCurrentSession().disconnect();
            }
        }

        public void resume() {
            if (this.holderActive) {
                TransactionSynchronizationManager.bindResource((Object)this.sessionFactory, (Object)this.sessionHolder);
            }
        }

        public void flush() {
            try {
                this.getCurrentSession().flush();
            }
            catch (HibernateException ex) {
                throw SessionFactoryUtils.convertHibernateAccessException((HibernateException)ex);
            }
        }

        public void beforeCommit(boolean readOnly) throws DataAccessException {
            Session session;
            if (!readOnly && !FlushMode.isManualFlushMode((FlushMode)(session = this.getCurrentSession()).getFlushMode())) {
                try {
                    session.flush();
                }
                catch (HibernateException ex) {
                    throw SessionFactoryUtils.convertHibernateAccessException((HibernateException)ex);
                }
            }
        }

        public void beforeCompletion() {
            Session session = this.sessionHolder.getSession();
            if (this.sessionHolder.getPreviousFlushMode() != null) {
                session.setFlushMode(this.sessionHolder.getPreviousFlushMode());
            }
            session.disconnect();
        }

        public void afterCommit() {
        }

        public void afterCompletion(int status) {
            try {
                if (status != 0) {
                    this.sessionHolder.getSession().clear();
                }
            }
            finally {
                this.sessionHolder.setSynchronizedWithTransaction(false);
            }
        }
    }
}

