/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.springframework.orm.jpa.vendor;

import java.util.HashMap;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.spi.PersistenceProvider;
import org.babyfish.hibernate.dialect.Oracle10gDialect;
import org.babyfish.hibernate.ejb.HibernateXEntityManagerFactory;
import org.babyfish.hibernate.jpa.HibernatePersistenceProvider;
import org.babyfish.persistence.XEntityManager;
import org.hibernate.dialect.DB2Dialect;
import org.hibernate.dialect.DerbyDialect;
import org.hibernate.dialect.H2Dialect;
import org.hibernate.dialect.HSQLDialect;
import org.hibernate.dialect.InformixDialect;
import org.hibernate.dialect.MySQLDialect;
import org.hibernate.dialect.PostgreSQLDialect;
import org.hibernate.dialect.SQLServerDialect;
import org.hibernate.dialect.SybaseDialect;
import org.springframework.orm.jpa.JpaDialect;
import org.springframework.orm.jpa.vendor.AbstractJpaVendorAdapter;
import org.springframework.orm.jpa.vendor.Database;
import org.springframework.orm.jpa.vendor.HibernateJpaDialect;

public class HibernateJpaVendorAdapter
extends AbstractJpaVendorAdapter {
    private final PersistenceProvider persistenceProvider = new HibernatePersistenceProvider();
    private final JpaDialect jpaDialect = new HibernateJpaDialect();

    public PersistenceProvider getPersistenceProvider() {
        return this.persistenceProvider;
    }

    public String getPersistenceProviderRootPackage() {
        return "org.hibernate";
    }

    public Map<String, Object> getJpaPropertyMap() {
        Class<?> databaseDialectClass;
        HashMap<String, Object> jpaProperties = new HashMap<String, Object>();
        if (this.getDatabasePlatform() != null) {
            jpaProperties.put("hibernate.dialect", this.getDatabasePlatform());
        } else if (this.getDatabase() != null && (databaseDialectClass = this.determineDatabaseDialectClass(this.getDatabase())) != null) {
            jpaProperties.put("hibernate.dialect", databaseDialectClass.getName());
        }
        if (this.isGenerateDdl()) {
            jpaProperties.put("hibernate.hbm2ddl.auto", "update");
        }
        if (this.isShowSql()) {
            jpaProperties.put("hibernate.show_sql", "true");
        }
        return jpaProperties;
    }

    protected Class<?> determineDatabaseDialectClass(Database database) {
        switch (database) {
            case ORACLE: {
                return Oracle10gDialect.class;
            }
            case DB2: {
                return DB2Dialect.class;
            }
            case DERBY: {
                return DerbyDialect.class;
            }
            case H2: {
                return H2Dialect.class;
            }
            case HSQL: {
                return HSQLDialect.class;
            }
            case INFORMIX: {
                return InformixDialect.class;
            }
            case MYSQL: {
                return MySQLDialect.class;
            }
            case POSTGRESQL: {
                return PostgreSQLDialect.class;
            }
            case SQL_SERVER: {
                return SQLServerDialect.class;
            }
            case SYBASE: {
                return SybaseDialect.class;
            }
        }
        return null;
    }

    public JpaDialect getJpaDialect() {
        return this.jpaDialect;
    }

    public Class<? extends EntityManagerFactory> getEntityManagerFactoryInterface() {
        return HibernateXEntityManagerFactory.class;
    }

    public Class<? extends EntityManager> getEntityManagerInterface() {
        return XEntityManager.class;
    }
}

