/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.persistence.path.spi;

import java.util.Collection;
import org.babyfish.collection.LinkedHashMap;
import org.babyfish.collection.LinkedHashSet;
import org.babyfish.collection.MACollections;
import org.babyfish.collection.XOrderedMap;
import org.babyfish.persistence.path.QueryPath;
import org.babyfish.persistence.path.QueryPaths;
import org.babyfish.persistence.path.spi.PathPlanKey;

public class PathPlanKeyBuilder {
    private XOrderedMap<String, QueryPath[]> queryPathMap = new LinkedHashMap();
    private PathPlanKey key;

    public PathPlanKeyBuilder setQueryPaths(QueryPath ... queryPaths) {
        return this.setQueryPaths((String)null, queryPaths);
    }

    public PathPlanKeyBuilder setQueryPaths(String alias, QueryPath ... queryPaths) {
        return this.setQueryPaths(alias, (Collection<? extends QueryPath>)MACollections.wrap((Object[])queryPaths));
    }

    public PathPlanKeyBuilder setQueryPaths(Collection<? extends QueryPath> queryPaths) {
        return this.setQueryPaths(null, queryPaths);
    }

    public PathPlanKeyBuilder setQueryPaths(String alias, Collection<? extends QueryPath> queryPaths) {
        if (queryPaths == null || queryPaths.isEmpty()) {
            this.queryPathMap.remove((Object)alias);
        }
        LinkedHashSet set = new LinkedHashSet((queryPaths.size() * 4 + 2) / 3);
        for (QueryPath queryPath : queryPaths) {
            if (queryPath == null) continue;
            set.add((Object)QueryPaths.toStandard((QueryPath)queryPath));
        }
        this.queryPathMap.put((Object)alias, (Object)queryPaths.toArray(new QueryPath[set.size()]));
        this.key = null;
        return this;
    }

    public PathPlanKey build() {
        PathPlanKey key = this.key;
        if (key == null) {
            this.key = key = PathPlanKey.nullToNil(PathPlanKey.of(this.queryPathMap));
        }
        return PathPlanKey.nilToNull(key);
    }
}

